/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.codegen.classmodel;

import io.helidon.codegen.classmodel.ClassBase;
import io.helidon.codegen.classmodel.ClassModelException;
import io.helidon.codegen.classmodel.Content;
import io.helidon.codegen.classmodel.ContentBuilder;
import io.helidon.codegen.classmodel.ImportOrganizer;
import io.helidon.codegen.classmodel.InnerClass;
import io.helidon.codegen.classmodel.ModelWriter;
import io.helidon.common.types.AccessModifier;
import io.helidon.common.types.ElementKind;
import io.helidon.common.types.TypeName;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;

public final class ClassModel
extends ClassBase {
    public static final String PADDING_TOKEN = "<<padding>>";
    public static final String TYPE_TOKEN = "@";
    public static final String TYPE_TOKEN_PATTERN = "@name@";
    public static final String DEFAULT_PADDING = "    ";
    private final String packageName;
    private final String copyright;
    private final Content staticInitializer;
    private ImportOrganizer imports;

    private ClassModel(Builder builder) {
        super(builder);
        this.copyright = builder.copyright;
        this.packageName = builder.packageName;
        this.staticInitializer = builder.staticInitializer == null ? null : builder.staticInitializer.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public void write(Writer writer) throws IOException {
        this.write(writer, DEFAULT_PADDING);
    }

    public void write(Writer writer, String padding) throws IOException {
        ModelWriter innerWriter = new ModelWriter(writer, padding);
        this.writeComponent(innerWriter, Set.of(), this.imports, this.classType());
    }

    @Override
    void writeComponent(ModelWriter writer, Set<String> declaredTokens, ImportOrganizer imports, ElementKind classType) {
        if (this.copyright != null) {
            String[] lines = this.copyright.split("\n");
            if (lines.length > 1) {
                boolean applyFormatting;
                boolean bl = applyFormatting = !lines[0].startsWith("/*");
                if (applyFormatting) {
                    writer.write("/*\n");
                }
                for (String line : lines) {
                    if (applyFormatting) {
                        writer.write(" * " + line + "\n");
                        continue;
                    }
                    writer.write(line + "\n");
                }
                if (applyFormatting) {
                    writer.write(" */\n\n");
                }
            } else {
                if (!lines[0].startsWith("//")) {
                    writer.write("// ");
                }
                writer.write(lines[0] + "\n");
            }
            writer.writeSeparatorLine();
        }
        if (this.packageName != null && !this.packageName.isEmpty()) {
            writer.write("package " + this.packageName + ";\n\n");
        }
        imports.writeImports(writer);
        imports.writeStaticImports(writer);
        super.writeComponent(writer, declaredTokens, imports, classType);
        writer.writeSeparatorLine();
    }

    @Override
    void writePostConstantDeclaration(ModelWriter writer, Set<String> declaredTokens, ImportOrganizer imports, ElementKind classType) {
        if (this.staticInitializer == null) {
            return;
        }
        writer.increasePaddingLevel();
        writer.write("\n");
        writer.increasePaddingLevel();
        writer.writeLine("static {");
        this.staticInitializer.writeBody(writer, imports);
        writer.decreasePaddingLevel();
        writer.write("\n");
        writer.writeLine("}");
        writer.decreasePaddingLevel();
    }

    @Override
    public TypeName typeName() {
        return TypeName.create((String)(this.packageName + "." + this.name()));
    }

    public String toString() {
        return "ClassModel{packageName='" + this.packageName + "'name='" + this.name() + "'}";
    }

    @Override
    void addImports(ImportOrganizer.Builder builder) {
        super.addImports(builder);
        if (this.staticInitializer != null) {
            this.staticInitializer.addImports(builder);
        }
    }

    public static final class Builder
    extends ClassBase.Builder<Builder, ClassModel> {
        private Content.Builder staticInitializer;
        private String packageName = "";
        private String copyright;

        private Builder() {
        }

        public ClassModel build() {
            if (this.name() == null) {
                throw new ClassModelException("Class need to have name specified");
            }
            this.preBuild();
            ClassModel classModel = new ClassModel(this);
            ImportOrganizer.Builder importOrganizer = this.importOrganizer();
            classModel.addImports(importOrganizer);
            classModel.imports = importOrganizer.build();
            return classModel;
        }

        @Override
        public Builder accessModifier(AccessModifier accessModifier) {
            if (accessModifier == AccessModifier.PRIVATE) {
                throw new IllegalArgumentException("Outer class cannot be private!");
            }
            return (Builder)super.accessModifier(accessModifier);
        }

        public Builder packageName(String packageName) {
            this.packageName = packageName;
            this.importOrganizer().packageName(packageName);
            return this;
        }

        public Builder copyright(String copyright) {
            this.copyright = copyright;
            return this;
        }

        @Override
        public Builder name(String name) {
            this.importOrganizer().typeName(name);
            return (Builder)super.name(name);
        }

        @Override
        public Builder type(TypeName type) {
            this.packageName(type.packageName());
            this.name(type.className());
            return this;
        }

        public Builder staticInitializer(Consumer<ContentBuilder<?>> contentBuilder) {
            this.staticInitializer = this.staticInitializer == null ? Content.builder() : this.staticInitializer;
            contentBuilder.accept(this.staticInitializer);
            return this;
        }

        public Optional<ClassBase> find(TypeName typeName) {
            if (!typeName.packageName().equals(this.packageName)) {
                return Optional.empty();
            }
            if (typeName.classNameWithEnclosingNames().equals(this.name())) {
                return Optional.of(this.build());
            }
            List enclosingNames = typeName.enclosingNames();
            if (enclosingNames.isEmpty()) {
                return Optional.empty();
            }
            String topLevel = (String)enclosingNames.getFirst();
            if (!topLevel.equals(this.name())) {
                return Optional.empty();
            }
            Map<String, InnerClass> innerClasses = super.innerClasses();
            ClassBase inProgress = null;
            for (int i = 1; i < enclosingNames.size(); ++i) {
                String enclosingName = (String)enclosingNames.get(i);
                InnerClass found = innerClasses.get(enclosingName);
                if (found == null) {
                    return Optional.empty();
                }
                inProgress = found;
                innerClasses = inProgress.innerClassesMap();
            }
            if (inProgress == null) {
                return Optional.ofNullable((ClassBase)innerClasses.get(typeName.className()));
            }
            return Optional.ofNullable((ClassBase)inProgress.innerClassesMap().get(typeName.className()));
        }
    }
}

