/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.codegen.classmodel;

import java.io.IOException;
import java.io.Writer;

class ModelWriter
extends Writer {
    private final Writer delegate;
    private final String padding;
    private String currentPadding = "";
    private int paddingLevel = 0;
    private boolean firstWrite = true;

    ModelWriter(Writer delegate, String padding) {
        this.delegate = delegate;
        this.padding = padding;
    }

    void increasePaddingLevel() {
        ++this.paddingLevel;
        this.currentPadding = this.padding.repeat(this.paddingLevel);
    }

    void decreasePaddingLevel() {
        --this.paddingLevel;
        this.currentPadding = this.padding.repeat(this.paddingLevel);
    }

    void writeLine(String str) throws IOException {
        this.write(str);
        this.write("\n");
    }

    void writeSeparatorLine() throws IOException {
        this.delegate.write("\n");
    }

    @Override
    public void write(String str) throws IOException {
        if (this.firstWrite) {
            this.delegate.write(this.currentPadding);
            this.firstWrite = false;
        }
        String padded = str.replaceAll("\n", "\n" + this.currentPadding);
        padded = padded.replaceAll("<<padding>>", this.padding);
        this.delegate.write(padded);
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        this.delegate.write(cbuf, off, len);
    }

    @Override
    public void flush() throws IOException {
        this.delegate.flush();
    }

    @Override
    public void close() throws IOException {
        this.delegate.close();
    }
}

