/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.codegen.classmodel;

import io.helidon.codegen.classmodel.AnnotatedComponent;
import io.helidon.codegen.classmodel.ClassType;
import io.helidon.codegen.classmodel.Content;
import io.helidon.codegen.classmodel.ContentBuilder;
import io.helidon.codegen.classmodel.ImportOrganizer;
import io.helidon.codegen.classmodel.Javadoc;
import io.helidon.codegen.classmodel.ModelWriter;
import io.helidon.codegen.classmodel.Parameter;
import io.helidon.codegen.classmodel.Throws;
import io.helidon.codegen.classmodel.Type;
import io.helidon.common.types.AccessModifier;
import io.helidon.common.types.TypeName;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;

public abstract class Executable
extends AnnotatedComponent {
    private final Content content;
    private final List<Parameter> parameters;
    private final List<Type> exceptions;

    Executable(Builder<?, ?> builder) {
        super((AnnotatedComponent.Builder<?, ?>)builder);
        this.content = builder.contentBuilder.build();
        this.parameters = List.copyOf(builder.parameters.values());
        this.exceptions = List.copyOf(builder.exceptions);
    }

    @Override
    void addImports(ImportOrganizer.Builder imports) {
        super.addImports(imports);
        this.parameters.forEach(parameter -> parameter.addImports(imports));
        this.content.addImports(imports);
        this.exceptions.forEach(exc -> exc.addImports(imports));
    }

    void writeThrows(ModelWriter writer, Set<String> declaredTokens, ImportOrganizer imports, ClassType classType) throws IOException {
        if (!this.exceptions().isEmpty()) {
            writer.write(" throws ");
            boolean first = true;
            for (Type exception : this.exceptions()) {
                if (first) {
                    first = false;
                } else {
                    writer.write(", ");
                }
                exception.writeComponent(writer, declaredTokens, imports, classType);
            }
        }
    }

    void writeBody(ModelWriter writer, ImportOrganizer imports) throws IOException {
        writer.increasePaddingLevel();
        writer.write("\n");
        this.content.writeBody(writer, imports);
        writer.decreasePaddingLevel();
        writer.write("\n");
    }

    List<Parameter> parameters() {
        return this.parameters;
    }

    List<Type> exceptions() {
        return this.exceptions;
    }

    boolean hasBody() {
        return this.content.hasBody();
    }

    public static abstract class Builder<B extends Builder<B, T>, T extends Executable>
    extends AnnotatedComponent.Builder<B, T>
    implements ContentBuilder<B> {
        private final Map<String, Parameter> parameters = new LinkedHashMap<String, Parameter>();
        private final Set<Type> exceptions = new LinkedHashSet<Type>();
        private final Content.Builder contentBuilder = Content.builder();

        Builder() {
        }

        @Override
        public B javadoc(Javadoc javadoc) {
            return (B)((Builder)super.javadoc(javadoc));
        }

        @Override
        public B addJavadocTag(String tag, String description) {
            return (B)((Builder)super.addJavadocTag(tag, description));
        }

        @Override
        public B accessModifier(AccessModifier accessModifier) {
            return (B)((Builder)super.accessModifier(accessModifier));
        }

        @Override
        public B content(List<String> content) {
            this.contentBuilder.content((List)content);
            return (B)((Builder)this.identity());
        }

        @Override
        public B addContent(String line) {
            this.contentBuilder.addContent(line);
            return (B)((Builder)this.identity());
        }

        @Override
        public B addContent(TypeName typeName) {
            this.contentBuilder.addContent(typeName);
            return (B)((Builder)this.identity());
        }

        @Override
        public B addTypeToContent(String typeName) {
            this.contentBuilder.addTypeToContent(typeName);
            return (B)((Builder)this.identity());
        }

        @Override
        public B padContent() {
            this.contentBuilder.padContent();
            return (B)((Builder)this.identity());
        }

        @Override
        public B padContent(int repetition) {
            this.contentBuilder.padContent(repetition);
            return (B)((Builder)this.identity());
        }

        @Override
        public B increaseContentPadding() {
            this.contentBuilder.increaseContentPadding();
            return (B)((Builder)this.identity());
        }

        @Override
        public B decreaseContentPadding() {
            this.contentBuilder.decreaseContentPadding();
            return (B)((Builder)this.identity());
        }

        @Override
        public B clearContent() {
            this.contentBuilder.clearContent();
            return (B)((Builder)this.identity());
        }

        public B addParameter(Consumer<Parameter.Builder> consumer) {
            Parameter.Builder builder = Parameter.builder();
            consumer.accept(builder);
            return this.addParameter(builder.build());
        }

        public B addParameter(Parameter parameter) {
            this.parameters.put(parameter.name(), parameter);
            return (B)((Builder)this.addJavadocParameter(parameter.name(), parameter.description()));
        }

        public B addParameter(Supplier<Parameter> supplier) {
            Parameter parameter = supplier.get();
            this.parameters.put(parameter.name(), parameter);
            return (B)((Builder)this.addJavadocParameter(parameter.name(), parameter.description()));
        }

        public B addThrows(TypeName exception, String description) {
            Objects.requireNonNull(exception);
            Objects.requireNonNull(description);
            return this.addThrows((Throws.Builder ex) -> ex.type(exception).description(description));
        }

        public B addThrows(Consumer<Throws.Builder> consumer) {
            Objects.requireNonNull(consumer);
            Throws.Builder builder = Throws.builder();
            consumer.accept(builder);
            return this.addThrows((Supplier<Throws>)((Object)builder));
        }

        public B addThrows(Supplier<Throws> supplier) {
            Objects.requireNonNull(supplier);
            return this.addThrows(supplier.get());
        }

        public B addThrows(Throws exception) {
            Objects.requireNonNull(exception);
            this.exceptions.add(exception.type());
            return (B)((Builder)this.addJavadocThrows(exception.type().fqTypeName(), exception.description()));
        }

        @Override
        public B generateJavadoc(boolean generateJavadoc) {
            return (B)((Builder)super.generateJavadoc(generateJavadoc));
        }

        Map<String, Parameter> parameters() {
            return this.parameters;
        }
    }
}

