/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.codegen.apt;

import io.helidon.codegen.Codegen;
import io.helidon.codegen.CodegenContext;
import io.helidon.codegen.CodegenEvent;
import io.helidon.codegen.CodegenException;
import io.helidon.codegen.Option;
import io.helidon.codegen.apt.AptContext;
import io.helidon.codegen.apt.AptContextImpl;
import io.helidon.codegen.apt.AptModuleFactory;
import io.helidon.codegen.apt.AptTypeFactory;
import io.helidon.codegen.apt.AptTypeInfoFactory;
import io.helidon.common.types.Annotation;
import io.helidon.common.types.ModuleTypeInfo;
import io.helidon.common.types.TypeInfo;
import io.helidon.common.types.TypeName;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ModuleElement;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;

public final class AptProcessor
extends AbstractProcessor {
    private static final TypeName GENERATOR = TypeName.create(AptProcessor.class);
    private AptContextImpl ctx;
    private Codegen codegen;

    @Deprecated
    public AptProcessor() {
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        return Set.of("*");
    }

    @Override
    public Set<String> getSupportedOptions() {
        return Codegen.supportedOptions().stream().map(Option::name).collect(Collectors.toUnmodifiableSet());
    }

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.ctx = AptContextImpl.create(processingEnv, Codegen.supportedOptions());
        this.codegen = Codegen.create((CodegenContext)this.ctx, (TypeName)GENERATOR);
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        this.ctx.resetCache();
        Thread thread = Thread.currentThread();
        ClassLoader previousClassloader = thread.getContextClassLoader();
        thread.setContextClassLoader(AptProcessor.class.getClassLoader());
        try {
            boolean bl = this.doProcess(annotations, roundEnv);
            return bl;
        }
        catch (CodegenException e) {
            Object originatingElement = e.originatingElement().orElse(null);
            if (originatingElement instanceof Element) {
                Element element = originatingElement;
                this.processingEnv.getMessager().printError(e.getMessage(), element);
            } else if (originatingElement instanceof TypeName) {
                TypeName typeName = originatingElement;
                this.processingEnv.getMessager().printError(e.getMessage() + ", source: " + typeName.fqName());
            } else if (originatingElement != null) {
                this.processingEnv.getMessager().printError(e.getMessage() + ", source: " + String.valueOf(originatingElement));
            }
            throw e;
        }
        finally {
            thread.setContextClassLoader(previousClassloader);
        }
    }

    private boolean doProcess(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        this.ctx.logger().log(System.Logger.Level.TRACE, "Process annotations: " + String.valueOf(annotations) + ", processing over: " + roundEnv.processingOver());
        if (roundEnv.processingOver()) {
            this.codegen.processingOver();
            this.ctx.filer().manifest().write();
            return annotations.isEmpty();
        }
        Set<UsedAnnotation> usedAnnotations = this.usedAnnotations(annotations);
        if (usedAnnotations.isEmpty()) {
            this.codegen.process(List.of(), List.of());
            return annotations.isEmpty();
        }
        ArrayList<TypeInfo> allTypes = new ArrayList<TypeInfo>();
        ArrayList<ModuleTypeInfo> allModules = new ArrayList<ModuleTypeInfo>();
        this.discoverTypes(usedAnnotations, roundEnv, allTypes, allModules);
        this.codegen.process(allTypes, allModules);
        return usedAnnotations.stream().map(UsedAnnotation::annotationElement).collect(Collectors.toSet()).equals(annotations);
    }

    private Set<UsedAnnotation> usedAnnotations(Set<? extends TypeElement> annotations) {
        Predicate<TypeName> typePredicate = this.typePredicate(this.codegen.supportedAnnotations(), this.codegen.supportedAnnotationPackagePrefixes());
        Predicate<TypeName> metaPredicate = this.typePredicate(this.codegen.supportedMetaAnnotations(), Set.of());
        HashSet<UsedAnnotation> result = new HashSet<UsedAnnotation>();
        for (TypeElement typeElement : annotations) {
            TypeName typeName = TypeName.create((String)typeElement.getQualifiedName().toString());
            HashSet<TypeName> supportedAnnotations = new HashSet<TypeName>();
            if (typePredicate.test(typeName)) {
                supportedAnnotations.add(typeName);
            }
            this.addSupportedAnnotations(metaPredicate, supportedAnnotations, typeName);
            if (supportedAnnotations.isEmpty()) continue;
            result.add(new UsedAnnotation(typeName, typeElement, supportedAnnotations));
        }
        return result;
    }

    private Predicate<TypeName> typePredicate(Set<TypeName> typeNames, Set<String> prefixes) {
        return typeName -> {
            if (typeNames.contains(typeName)) {
                return true;
            }
            String packagePrefix = typeName.packageName() + ".";
            for (String prefix : prefixes) {
                if (!packagePrefix.startsWith(prefix)) continue;
                return true;
            }
            return false;
        };
    }

    private void addSupportedAnnotations(Predicate<TypeName> typeNamePredicate, Set<TypeName> supportedAnnotations, TypeName annotationType) {
        Optional<TypeInfo> foundInfo = AptTypeInfoFactory.create((AptContext)this.ctx, annotationType);
        if (foundInfo.isPresent()) {
            TypeInfo annotationInfo = foundInfo.get();
            List annotations = annotationInfo.annotations();
            for (Annotation annotation : annotations) {
                TypeName typeName = annotation.typeName();
                if (!typeNamePredicate.test(typeName) || !supportedAnnotations.add(typeName)) continue;
                this.addSupportedAnnotations(typeNamePredicate, supportedAnnotations, typeName);
            }
        }
    }

    private void discoverTypes(Set<UsedAnnotation> annotations, RoundEnvironment roundEnv, List<TypeInfo> allTypes, List<ModuleTypeInfo> allModules) {
        HashMap<TypeName, TypeElement> types = new HashMap<TypeName, TypeElement>();
        HashMap<String, ModuleElement> modules = new HashMap<String, ModuleElement>();
        for (UsedAnnotation annotation : annotations) {
            TypeElement annotationElement = annotation.annotationElement();
            Set<? extends Element> elementsAnnotatedWith = roundEnv.getElementsAnnotatedWith(annotationElement);
            block7: for (Element element2 : elementsAnnotatedWith) {
                ElementKind kind = element2.getKind();
                switch (kind) {
                    case ENUM: 
                    case INTERFACE: 
                    case CLASS: 
                    case ANNOTATION_TYPE: 
                    case RECORD: {
                        this.addType(types, element2, element2, annotationElement);
                        continue block7;
                    }
                    case ENUM_CONSTANT: 
                    case CONSTRUCTOR: 
                    case METHOD: 
                    case FIELD: 
                    case STATIC_INIT: 
                    case INSTANCE_INIT: 
                    case RECORD_COMPONENT: {
                        this.addType(types, element2.getEnclosingElement(), element2, annotationElement);
                        continue block7;
                    }
                    case PARAMETER: {
                        this.addType(types, element2.getEnclosingElement().getEnclosingElement(), element2, annotationElement);
                        continue block7;
                    }
                    case MODULE: {
                        this.addModule(modules, element2);
                        continue block7;
                    }
                }
                this.ctx.logger().log(System.Logger.Level.TRACE, "Ignoring annotated element, not supported: " + String.valueOf(element2) + ", kind: " + String.valueOf((Object)kind));
            }
        }
        types.values().stream().flatMap(element -> {
            Optional<TypeInfo> typeInfo = AptTypeInfoFactory.create((AptContext)this.ctx, element);
            if (typeInfo.isEmpty()) {
                this.ctx.logger().log(((CodegenEvent.Builder)((CodegenEvent.Builder)((CodegenEvent.Builder)CodegenEvent.builder().level(System.Logger.Level.WARNING)).message("Could not create TypeInfo for annotated type.")).addObject(element)).build());
            }
            return typeInfo.stream();
        }).forEach(allTypes::add);
        modules.values().stream().map(element -> AptModuleFactory.create(this.ctx, element)).forEach(allModules::add);
    }

    private void addModule(Map<String, ModuleElement> modules, Element element) {
        ModuleElement me = (ModuleElement)element;
        modules.putIfAbsent(me.getQualifiedName().toString(), me);
    }

    private void addType(Map<TypeName, TypeElement> types, Element typeElement, Element processedElement, TypeElement annotation) {
        Optional<TypeName> typeName = AptTypeFactory.createTypeName(typeElement);
        if (typeName.isPresent()) {
            types.putIfAbsent(typeName.get(), (TypeElement)typeElement);
        } else {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.MANDATORY_WARNING, "Could not create TypeName for annotated type. Annotation: " + String.valueOf(annotation), processedElement);
        }
    }

    private record UsedAnnotation(TypeName annotationType, TypeElement annotationElement, Set<TypeName> supportedAnnotations) {
    }
}

