/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.codegen.apt;

import io.helidon.common.types.TypeName;
import io.helidon.common.types.TypeNames;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.IntersectionType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.WildcardType;

@Deprecated(forRemoval=true, since="4.2.0")
public final class AptTypeFactory {
    private static final Pattern NESTED_TYPES = Pattern.compile("(?<!\\$)\\$(?!\\$)");

    private AptTypeFactory() {
    }

    public static Optional<TypeName> createTypeName(DeclaredType type) {
        return AptTypeFactory.createTypeName(type.asElement());
    }

    public static Optional<TypeName> createTypeName(TypeMirror typeMirror) {
        return AptTypeFactory.createTypeName(new HashSet<TypeMirror>(), typeMirror);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Optional<TypeName> createTypeName(Set<TypeMirror> inProgress, TypeMirror typeMirror) {
        TypeKind kind = typeMirror.getKind();
        if (kind.isPrimitive()) {
            Class<Comparable<Boolean>> type = switch (kind) {
                case TypeKind.BOOLEAN -> Boolean.TYPE;
                case TypeKind.BYTE -> Byte.TYPE;
                case TypeKind.SHORT -> Short.TYPE;
                case TypeKind.INT -> Integer.TYPE;
                case TypeKind.LONG -> Long.TYPE;
                case TypeKind.CHAR -> Character.TYPE;
                case TypeKind.FLOAT -> Float.TYPE;
                case TypeKind.DOUBLE -> Double.TYPE;
                default -> throw new IllegalStateException("Unknown primitive type: " + String.valueOf((Object)kind));
            };
            return Optional.of(TypeName.create(type));
        }
        switch (kind) {
            case VOID: {
                return Optional.of(TypeName.create(Void.TYPE));
            }
            case TYPEVAR: {
                if (!inProgress.add(typeMirror)) {
                    return Optional.empty();
                }
                try {
                    TypeName.Builder builder = TypeName.builder((TypeName)TypeName.createFromGenericDeclaration((String)typeMirror.toString()));
                    TypeVariable typeVar = (TypeVariable)typeMirror;
                    AptTypeFactory.handleBounds(inProgress, typeVar.getUpperBound(), arg_0 -> ((TypeName.Builder)builder).addUpperBound(arg_0));
                    AptTypeFactory.handleBounds(inProgress, typeVar.getLowerBound(), arg_0 -> ((TypeName.Builder)builder).addLowerBound(arg_0));
                    Optional<TypeName> optional = Optional.of(builder.build());
                    return optional;
                }
                finally {
                    inProgress.remove(typeMirror);
                }
            }
            case WILDCARD: {
                WildcardType vt = (WildcardType)typeMirror;
                TypeName.Builder builder = (TypeName.Builder)((TypeName.Builder)((TypeName.Builder)TypeName.builder().generic(true)).wildcard(true)).className("?");
                AptTypeFactory.handleBounds(inProgress, vt.getExtendsBound(), arg_0 -> ((TypeName.Builder)builder).addUpperBound(arg_0));
                AptTypeFactory.handleBounds(inProgress, vt.getSuperBound(), arg_0 -> ((TypeName.Builder)builder).addLowerBound(arg_0));
                return Optional.of(builder.build());
            }
            case ERROR: {
                return Optional.of(TypeName.create((String)typeMirror.toString()));
            }
            case NONE: {
                return Optional.empty();
            }
        }
        if (typeMirror instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)typeMirror;
            return Optional.of(((TypeName.Builder)TypeName.builder((TypeName)AptTypeFactory.createTypeName(inProgress, arrayType.getComponentType()).orElseThrow()).array(true)).build());
        }
        if (typeMirror instanceof DeclaredType) {
            DeclaredType declaredType = (DeclaredType)typeMirror;
            List typeParams = declaredType.getTypeArguments().stream().map(it -> AptTypeFactory.createTypeName(inProgress, it)).flatMap(Optional::stream).collect(Collectors.toList());
            TypeName result = AptTypeFactory.createTypeName(inProgress, declaredType.asElement()).orElse(null);
            if (typeParams.isEmpty() || result == null) {
                return Optional.ofNullable(result);
            }
            if (!inProgress.add(typeMirror)) {
                return Optional.empty();
            }
            return Optional.of(((TypeName.Builder)TypeName.builder((TypeName)result).typeArguments(typeParams)).build());
        }
        throw new IllegalStateException("Unknown type mirror: " + String.valueOf(typeMirror));
    }

    private static void handleBounds(Set<TypeMirror> processed, TypeMirror boundMirror, Consumer<TypeName> boundHandler) {
        if (boundMirror == null) {
            return;
        }
        if (boundMirror.getKind() != TypeKind.NULL) {
            if (boundMirror.getKind() == TypeKind.INTERSECTION) {
                IntersectionType it = (IntersectionType)boundMirror;
                it.getBounds().stream().filter(Predicate.not(processed::equals)).map(typeMirror -> AptTypeFactory.createTypeName(processed, typeMirror)).flatMap(Optional::stream).filter(Predicate.not(arg_0 -> ((TypeName)TypeNames.OBJECT).equals(arg_0))).forEach(boundHandler);
            } else {
                AptTypeFactory.createTypeName(processed, boundMirror).filter(Predicate.not(arg_0 -> ((TypeName)TypeNames.OBJECT).equals(arg_0))).ifPresent(boundHandler);
            }
        }
    }

    public static Optional<TypeName> createTypeName(TypeElement element, TypeMirror mirror) {
        List<String> typeParameters;
        Optional<TypeName> result = AptTypeFactory.createTypeName(new HashSet<TypeMirror>(), mirror);
        if (result.isEmpty()) {
            return result;
        }
        TypeName mirrorName = result.get();
        int typeArgumentSize = mirrorName.typeArguments().size();
        if (typeArgumentSize > (typeParameters = element.getTypeParameters().stream().map((Function<TypeParameterElement, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, toString(), (Ljavax/lang/model/element/TypeParameterElement;)Ljava/lang/String;)()).toList()).size()) {
            throw new IllegalStateException("Found " + typeArgumentSize + " type arguments, but only " + typeParameters.size() + " type parameters on: " + String.valueOf(mirror));
        }
        return Optional.of(((TypeName.Builder)TypeName.builder((TypeName)mirrorName).typeParameters(typeParameters)).build());
    }

    public static Optional<TypeName> createTypeName(Element type) {
        return AptTypeFactory.createTypeName(new HashSet<TypeMirror>(), type);
    }

    private static Optional<TypeName> createTypeName(Set<TypeMirror> processed, Element type) {
        String packageName;
        Element enclosing;
        if (type instanceof VariableElement) {
            return AptTypeFactory.createTypeName(processed, type.asType());
        }
        if (type instanceof ExecutableElement) {
            ExecutableElement ee = (ExecutableElement)type;
            return AptTypeFactory.createTypeName(processed, ee.getReturnType());
        }
        if (type.getKind() == ElementKind.TYPE_PARAMETER) {
            TypeMirror mirror = type.asType();
            return AptTypeFactory.createTypeName(processed, mirror);
        }
        List<String> classNames = new ArrayList<String>();
        String simpleName = type.getSimpleName().toString();
        String[] split = NESTED_TYPES.split(simpleName);
        if (split.length > 1) {
            classNames.addAll(Arrays.asList(split).subList(0, split.length - 1));
            simpleName = split[split.length - 1];
        }
        for (enclosing = type.getEnclosingElement(); enclosing != null && ElementKind.PACKAGE != enclosing.getKind(); enclosing = enclosing.getEnclosingElement()) {
            if (enclosing.getKind() != ElementKind.CLASS && enclosing.getKind() != ElementKind.INTERFACE && enclosing.getKind() != ElementKind.ANNOTATION_TYPE && enclosing.getKind() != ElementKind.RECORD) continue;
            classNames.add(enclosing.getSimpleName().toString());
        }
        Collections.reverse(classNames);
        while (enclosing != null && enclosing.getKind() != ElementKind.PACKAGE) {
            enclosing = enclosing.getEnclosingElement();
        }
        String string = packageName = enclosing == null ? "" : ((PackageElement)enclosing).getQualifiedName().toString();
        if (!packageName.isEmpty() && Character.isUpperCase(packageName.charAt(0))) {
            classNames = List.of(packageName.split("\\."));
            packageName = "";
        }
        return Optional.of(((TypeName.Builder)((TypeName.Builder)((TypeName.Builder)TypeName.builder().packageName(packageName)).className(simpleName)).enclosingNames(classNames)).build());
    }
}

