/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.codegen.apt;

import io.helidon.codegen.CodegenException;
import io.helidon.codegen.CodegenOptions;
import io.helidon.codegen.Option;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.processing.ProcessingEnvironment;

class AptOptions
implements CodegenOptions {
    private final ProcessingEnvironment aptEnv;

    AptOptions(ProcessingEnvironment aptEnv) {
        this.aptEnv = aptEnv;
    }

    static CodegenOptions create(ProcessingEnvironment env) {
        return new AptOptions(env);
    }

    public Optional<String> option(String option) {
        return Optional.ofNullable(this.aptEnv.getOptions().get(option));
    }

    public void validate(Set<Option<?>> permittedOptions) {
        Set helidonOptions = this.aptEnv.getOptions().keySet().stream().filter(it -> it.startsWith("helidon.")).collect(Collectors.toSet());
        permittedOptions.stream().map(Option::name).forEach(helidonOptions::remove);
        helidonOptions.remove(CODEGEN_SCOPE.name());
        helidonOptions.remove(CODEGEN_MODULE.name());
        helidonOptions.remove(CODEGEN_PACKAGE.name());
        helidonOptions.remove(INDENT_TYPE.name());
        helidonOptions.remove(INDENT_COUNT.name());
        helidonOptions.remove(CREATE_META_INF_SERVICES.name());
        if (!helidonOptions.isEmpty()) {
            throw new CodegenException("Unrecognized/unsupported Helidon option configured: " + String.valueOf(helidonOptions));
        }
    }
}

