/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.builder.processor;

import io.helidon.builder.processor.AnnotationDataOption;
import io.helidon.builder.processor.FactoryMethods;
import io.helidon.builder.processor.TypeHandlerList;
import io.helidon.builder.processor.TypeHandlerMap;
import io.helidon.builder.processor.TypeHandlerOptional;
import io.helidon.builder.processor.TypeHandlerSet;
import io.helidon.builder.processor.TypeHandlerSupplier;
import io.helidon.builder.processor.Types;
import io.helidon.common.processor.classmodel.Field;
import io.helidon.common.processor.classmodel.InnerClass;
import io.helidon.common.processor.classmodel.Javadoc;
import io.helidon.common.processor.classmodel.Method;
import io.helidon.common.processor.classmodel.Parameter;
import io.helidon.common.types.AccessModifier;
import io.helidon.common.types.TypeName;
import io.helidon.common.types.TypeNames;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;

class TypeHandler {
    private final String name;
    private final String getterName;
    private final String setterName;
    private final TypeName declaredType;

    TypeHandler(String name, String getterName, String setterName, TypeName declaredType) {
        this.name = name;
        this.getterName = getterName;
        this.setterName = setterName;
        this.declaredType = declaredType;
    }

    static TypeHandler create(String name, String getterName, String setterName, TypeName returnType, boolean sameGeneric) {
        if (TypeNames.OPTIONAL.equals((Object)returnType)) {
            return new TypeHandlerOptional(name, getterName, setterName, returnType);
        }
        if (TypeNames.SUPPLIER.equals((Object)returnType)) {
            return new TypeHandlerSupplier(name, getterName, setterName, returnType);
        }
        if (TypeNames.SET.equals((Object)returnType)) {
            return new TypeHandlerSet(name, getterName, setterName, returnType);
        }
        if (TypeNames.LIST.equals((Object)returnType)) {
            return new TypeHandlerList(name, getterName, setterName, returnType);
        }
        if (TypeNames.MAP.equals((Object)returnType)) {
            return new TypeHandlerMap(name, getterName, setterName, returnType, sameGeneric);
        }
        return new TypeHandler(name, getterName, setterName, returnType);
    }

    static AccessModifier setterAccessModifier(AnnotationDataOption configured) {
        return configured.accessModifier();
    }

    static TypeName toWildcard(TypeName typeName) {
        if (typeName.wildcard()) {
            return typeName;
        }
        if (typeName.equals((Object)TypeNames.STRING)) {
            return typeName;
        }
        if (typeName.typeArguments().isEmpty()) {
            return ((TypeName.Builder)TypeName.builder((TypeName)typeName).wildcard(true)).build();
        }
        return typeName;
    }

    protected static TypeName collectionImplType(TypeName typeName) {
        TypeName genericTypeName = typeName.genericTypeName();
        if (genericTypeName.equals((Object)TypeNames.MAP)) {
            return Types.LINKED_HASH_MAP_TYPE;
        }
        if (genericTypeName.equals((Object)TypeNames.LIST)) {
            return Types.ARRAY_LIST_TYPE;
        }
        return Types.LINKED_HASH_SET_TYPE;
    }

    public String toString() {
        return this.declaredType.fqName() + " " + this.name;
    }

    TypeName builderGetterType(boolean required, boolean hasDefault) {
        if (this.builderGetterOptional(required, hasDefault)) {
            if (this.declaredType().isOptional()) {
                return this.declaredType();
            }
            return ((TypeName.Builder)TypeName.builder((TypeName)TypeNames.OPTIONAL).addTypeArgument(this.declaredType().boxed())).build();
        }
        return this.declaredType();
    }

    String generateBuilderGetter(boolean required, boolean hasDefault) {
        if (this.builderGetterOptional(required, hasDefault)) {
            return "@java.util.Optional@.ofNullable(" + this.name + ")";
        }
        return this.name;
    }

    Field.Builder fieldDeclaration(AnnotationDataOption configured, boolean isBuilder, boolean alwaysFinal) {
        Field.Builder builder = ((Field.Builder)Field.builder().name(this.name)).isFinal(alwaysFinal || !isBuilder);
        if (isBuilder && configured.required()) {
            builder.type(this.declaredType.boxed());
        } else {
            builder.type(this.declaredType);
        }
        if (isBuilder && configured.hasDefault()) {
            builder.defaultValueContent(configured.defaultValue());
        }
        return builder;
    }

    String toDefaultValue(String defaultValue) {
        TypeName typeName = this.actualType();
        if (Types.STRING_TYPE.equals((Object)typeName)) {
            return "\"" + defaultValue + "\"";
        }
        if (Types.DURATION_TYPE.equals((Object)typeName)) {
            return "@java.time.Duration@.parse(\"" + defaultValue + "\")";
        }
        if (Types.CHAR_ARRAY_TYPE.equals((Object)typeName)) {
            return "\"" + defaultValue + "\".toCharArray()";
        }
        if (typeName.primitive()) {
            if (typeName.fqName().equals("char")) {
                return "'" + defaultValue + "'";
            }
            return defaultValue;
        }
        if (typeName.name().startsWith("java.")) {
            return defaultValue;
        }
        return "@" + typeName.genericTypeName().fqName() + "@." + defaultValue;
    }

    String toDefaultValue(List<String> defaultValues, List<Integer> defaultInts, List<Long> defaultLongs, List<Double> defaultDoubles, List<Boolean> defaultBooleans, String defaultCode, AnnotationDataOption.DefaultMethod defaultMethod) {
        if (defaultCode != null) {
            return defaultCode;
        }
        if (defaultMethod != null) {
            return this.toDefaultFromMethod(defaultMethod);
        }
        return this.toDefaultValue(defaultValues, defaultInts, defaultLongs, defaultDoubles, defaultBooleans);
    }

    String toDefaultValue(List<String> defaultValues, List<Integer> defaultInts, List<Long> defaultLongs, List<Double> defaultDoubles, List<Boolean> defaultBooleans) {
        if (defaultValues != null) {
            String string = this.singleDefault(defaultValues);
            return this.toDefaultValue(string);
        }
        if (defaultInts != null) {
            return String.valueOf(this.singleDefault(defaultInts));
        }
        if (defaultLongs != null) {
            return String.valueOf(this.singleDefault(defaultLongs)) + "L";
        }
        if (defaultDoubles != null) {
            return String.valueOf(this.singleDefault(defaultDoubles));
        }
        if (defaultBooleans != null) {
            return String.valueOf(this.singleDefault(defaultBooleans));
        }
        return null;
    }

    protected String toDefaultFromMethod(AnnotationDataOption.DefaultMethod defaultMethod) {
        return "@" + defaultMethod.type().fqName() + "@." + defaultMethod.method() + "()";
    }

    TypeName declaredType() {
        return this.declaredType;
    }

    TypeName actualType() {
        return this.declaredType;
    }

    String name() {
        return this.name;
    }

    String getterName() {
        return this.getterName;
    }

    String setterName() {
        return this.setterName;
    }

    void generateFromConfig(Method.Builder method, AnnotationDataOption configured, FactoryMethods factoryMethods) {
        method.add(this.configGet(configured));
        String fqName = this.actualType().fqName();
        if (fqName.endsWith(".Builder")) {
            if (configured.hasDefault()) {
                method.addLine(".as(Config.class).ifPresent(" + this.name() + "::config);");
            } else {
                int lastDot = fqName.lastIndexOf(46);
                String builderMethod = fqName.substring(0, lastDot) + ".builder()";
                method.addLine(".map(" + builderMethod + "::config).ifPresent(this::" + this.setterName() + ");");
            }
        } else {
            this.generateFromConfig(method, factoryMethods);
            method.addLine(".ifPresent(this::" + this.setterName() + ");");
        }
    }

    String configGet(AnnotationDataOption configured) {
        if (configured.configMerge().booleanValue()) {
            return "config";
        }
        return "config.get(\"" + configured.configKey() + "\")";
    }

    String generateFromConfig(FactoryMethods factoryMethods) {
        if (this.actualType().fqName().equals("char[]")) {
            return ".asString().as(String::toCharArray)";
        }
        TypeName boxed = this.actualType().boxed();
        return factoryMethods.createFromConfig().map(it -> ".map(" + it.typeWithFactoryMethod().genericTypeName().fqName() + "::" + it.createMethodName() + ")").orElseGet(() -> ".as(" + boxed.fqName() + ".class)");
    }

    void generateFromConfig(Method.Builder method, FactoryMethods factoryMethods) {
        if (this.actualType().fqName().equals("char[]")) {
            ((Method.Builder)((Method.Builder)method.add(".asString().as(")).typeName(String.class)).add("::toCharArray)");
            return;
        }
        Optional<FactoryMethods.FactoryMethod> fromConfig = factoryMethods.createFromConfig();
        if (fromConfig.isPresent()) {
            FactoryMethods.FactoryMethod factoryMethod = fromConfig.get();
            ((Method.Builder)((Method.Builder)method.add(".map(")).typeName(factoryMethod.typeWithFactoryMethod().genericTypeName())).add("::" + factoryMethod.createMethodName() + ")");
        } else {
            TypeName boxed = this.actualType().boxed();
            ((Method.Builder)((Method.Builder)method.add(".as(")).typeName(boxed)).add(".class)");
        }
    }

    TypeName argumentTypeName() {
        return this.declaredType();
    }

    void setters(InnerClass.Builder classBuilder, AnnotationDataOption configured, FactoryMethods factoryMethod, TypeName returnType, Javadoc blueprintJavadoc) {
        String fqName;
        this.declaredSetter(classBuilder, configured, returnType, blueprintJavadoc);
        if (this.actualType().equals((Object)Types.CHAR_ARRAY_TYPE)) {
            this.charArraySetter(classBuilder, configured, returnType, blueprintJavadoc);
        }
        if (factoryMethod.createTargetType().isPresent()) {
            this.factorySetter(classBuilder, configured, returnType, blueprintJavadoc, factoryMethod.createTargetType().get());
        }
        if (factoryMethod.builder().isPresent()) {
            this.factorySetterConsumer(classBuilder, configured, returnType, blueprintJavadoc, factoryMethod.builder().get());
            this.factorySetterSupplier(classBuilder, configured, returnType, blueprintJavadoc);
        }
        if ((fqName = this.actualType().fqName()).endsWith(".Builder")) {
            this.setterConsumer(classBuilder, configured, returnType, blueprintJavadoc);
        }
    }

    void setterConsumer(InnerClass.Builder classBuilder, AnnotationDataOption configured, TypeName returnType, Javadoc blueprintJavadoc) {
        String argumentName = "consumer";
        ArrayList<String> paramLines = new ArrayList<String>();
        paramLines.add("consumer of builder for");
        paramLines.addAll(blueprintJavadoc.returnDescription());
        Javadoc javadoc = this.setterJavadoc(blueprintJavadoc).addParameter(argumentName, paramLines).build();
        TypeName argumentType = ((TypeName.Builder)((TypeName.Builder)TypeName.builder().type(Consumer.class)).addTypeArgument(this.actualType())).build();
        Method.Builder builder = (Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)Method.builder().name(this.setterName())).returnType(returnType).update(it -> configured.annotations().forEach(x$0 -> {
            Method.Builder cfr_ignored_0 = (Method.Builder)it.addAnnotation(x$0);
        }))).addParameter(param -> ((Parameter.Builder)param.name(argumentName)).type(argumentType))).javadoc(javadoc)).accessModifier(TypeHandler.setterAccessModifier(configured))).typeName(Objects.class)).addLine(".requireNonNull(" + argumentName + ");")).add("var builder = ");
        if (configured.hasDefault()) {
            builder.addLine("this." + this.name() + ";");
        } else {
            String fqName = this.actualType().fqName();
            int lastDot = fqName.lastIndexOf(46);
            String builderMethod = fqName.substring(0, lastDot) + ".builder()";
            builder.addLine(builderMethod + ";");
        }
        ((Method.Builder)((Method.Builder)builder.addLine("consumer.accept(builder);")).addLine("this." + this.name() + "(builder);")).addLine("return self();");
        classBuilder.addMethod(builder);
    }

    protected Javadoc.Builder setterJavadoc(Javadoc blueprintJavadoc) {
        return Javadoc.builder((Javadoc)blueprintJavadoc).addTag("see", "#" + this.getterName() + "()").returnDescription("updated builder instance");
    }

    protected void charArraySetter(InnerClass.Builder classBuilder, AnnotationDataOption configured, TypeName returnType, Javadoc blueprintJavadoc) {
        classBuilder.addMethod(builder -> ((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)builder.name(this.setterName())).returnType(returnType).javadoc(this.setterJavadoc(blueprintJavadoc).addParameter(this.name(), blueprintJavadoc.returnDescription()).build())).returnType(returnType).addParameter(param -> ((Parameter.Builder)param.name(this.name())).type(Types.STRING_TYPE))).accessModifier(TypeHandler.setterAccessModifier(configured))).update(it -> configured.annotations().forEach(x$0 -> {
            Method.Builder cfr_ignored_0 = (Method.Builder)it.addAnnotation(x$0);
        }))).typeName(Objects.class)).addLine(".requireNonNull(" + this.name() + ");")).addLine("this." + this.name() + " = " + this.name() + ".toCharArray();")).addLine("return self();"));
    }

    boolean builderGetterOptional(boolean required, boolean hasDefault) {
        if (this.declaredType().isList() || this.declaredType().isMap() || this.declaredType().isSet()) {
            return false;
        }
        if (this.declaredType().isOptional()) {
            return true;
        }
        if (!required && this.declaredType().primitive()) {
            return false;
        }
        return !hasDefault;
    }

    protected void declaredSetter(InnerClass.Builder classBuilder, AnnotationDataOption configured, TypeName returnType, Javadoc blueprintJavadoc) {
        Method.Builder builder = (Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)Method.builder().name(this.setterName())).returnType(returnType).javadoc(this.setterJavadoc(blueprintJavadoc).addParameter(this.name(), blueprintJavadoc.returnDescription()).build())).returnType(returnType).update(it -> configured.annotations().forEach(x$0 -> {
            Method.Builder cfr_ignored_0 = (Method.Builder)it.addAnnotation(x$0);
        }))).addParameter(param -> ((Parameter.Builder)param.name(this.name())).type(this.argumentTypeName()))).accessModifier(TypeHandler.setterAccessModifier(configured));
        if (!this.declaredType.primitive()) {
            ((Method.Builder)builder.typeName(Objects.class)).addLine(".requireNonNull(" + this.name() + ");");
        }
        ((Method.Builder)builder.addLine("this." + this.name() + " = " + this.name() + ";")).addLine("return self();");
        classBuilder.addMethod(builder);
    }

    private <T> T singleDefault(List<T> defaultValues) {
        if (defaultValues.isEmpty()) {
            throw new IllegalArgumentException("Default values configured for " + this.name() + " are empty, one value is expected.");
        }
        if (defaultValues.size() > 1) {
            throw new IllegalArgumentException("Default values configured for " + this.name() + " contain more than one value, exactly one value is expected.");
        }
        return defaultValues.get(0);
    }

    private void factorySetterConsumer(InnerClass.Builder classBuilder, AnnotationDataOption configured, TypeName returnType, Javadoc blueprintJavadoc, FactoryMethods.FactoryMethod factoryMethod) {
        TypeName builderType = factoryMethod.factoryMethodReturnType().className().equals("Builder") ? factoryMethod.factoryMethodReturnType() : (factoryMethod.factoryMethodReturnType().className().endsWith(".Builder") ? factoryMethod.factoryMethodReturnType() : TypeName.create((String)(factoryMethod.factoryMethodReturnType().fqName() + ".Builder")));
        String argumentName = "consumer";
        ArrayList<String> paramLines = new ArrayList<String>();
        paramLines.add("consumer of builder for");
        paramLines.addAll(blueprintJavadoc.returnDescription());
        Javadoc javadoc = this.setterJavadoc(blueprintJavadoc).addParameter(argumentName, paramLines).build();
        TypeName argumentType = ((TypeName.Builder)((TypeName.Builder)TypeName.builder().type(Consumer.class)).addTypeArgument(builderType)).build();
        Method.Builder builder = (Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)Method.builder().name(this.setterName())).returnType(returnType).update(it -> configured.annotations().forEach(x$0 -> {
            Method.Builder cfr_ignored_0 = (Method.Builder)it.addAnnotation(x$0);
        }))).addParameter(param -> ((Parameter.Builder)param.name(argumentName)).type(argumentType))).accessModifier(TypeHandler.setterAccessModifier(configured))).javadoc(javadoc)).typeName(Objects.class)).addLine(".requireNonNull(" + argumentName + ");")).add("var builder = ")).typeName(factoryMethod.typeWithFactoryMethod().genericTypeName())).addLine("." + factoryMethod.createMethodName() + "();")).addLine("consumer.accept(builder);")).addLine("this." + this.name() + "(builder.build());")).addLine("return self();");
        classBuilder.addMethod(builder);
    }

    private void factorySetterSupplier(InnerClass.Builder classBuilder, AnnotationDataOption configured, TypeName returnType, Javadoc blueprintJavadoc) {
        TypeName supplierType = this.actualType();
        if (!supplierType.wildcard()) {
            supplierType = ((TypeName.Builder)TypeName.builder((TypeName)supplierType).wildcard(true)).build();
        }
        supplierType = ((TypeName.Builder)TypeName.builder((TypeName)TypeNames.SUPPLIER).addTypeArgument(supplierType)).build();
        String argumentName = "supplier";
        ArrayList<String> paramLines = new ArrayList<String>();
        paramLines.add("supplier of");
        paramLines.addAll(blueprintJavadoc.returnDescription());
        Javadoc javadoc = this.setterJavadoc(blueprintJavadoc).addParameter(argumentName, paramLines).build();
        TypeName argumentType = supplierType;
        Method.Builder builder = (Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)Method.builder().name(this.setterName())).returnType(returnType).update(it -> configured.annotations().forEach(x$0 -> {
            Method.Builder cfr_ignored_0 = (Method.Builder)it.addAnnotation(x$0);
        }))).addParameter(param -> ((Parameter.Builder)param.name(argumentName)).type(argumentType))).accessModifier(TypeHandler.setterAccessModifier(configured))).javadoc(javadoc)).typeName(Objects.class)).addLine(".requireNonNull(" + argumentName + ");")).addLine("this." + this.name() + "(" + argumentName + ".get());")).addLine("return self();");
        classBuilder.addMethod(builder);
    }

    private void factorySetter(InnerClass.Builder classBuilder, AnnotationDataOption configured, TypeName returnType, Javadoc blueprintJavadoc, FactoryMethods.FactoryMethod factoryMethod) {
        String argumentName = this.name() + "Config";
        Method.Builder builder = (Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)Method.builder().name(this.setterName())).returnType(returnType).javadoc(this.setterJavadoc(blueprintJavadoc).addParameter(argumentName, blueprintJavadoc.returnDescription()).build())).update(it -> configured.annotations().forEach(x$0 -> {
            Method.Builder cfr_ignored_0 = (Method.Builder)it.addAnnotation(x$0);
        }))).addParameter(param -> ((Parameter.Builder)param.name(argumentName)).type(factoryMethod.argumentType()))).accessModifier(TypeHandler.setterAccessModifier(configured))).typeName(Objects.class)).addLine(".requireNonNull(" + argumentName + ");")).add("this." + this.name() + " = ")).typeName(factoryMethod.typeWithFactoryMethod().genericTypeName())).addLine("." + factoryMethod.createMethodName() + "(" + argumentName + ");")).addLine("return self();");
        classBuilder.addMethod(builder);
    }

    static class OneTypeHandler
    extends TypeHandler {
        private final TypeName actualType;

        OneTypeHandler(String name, String getterName, String setterName, TypeName declaredType) {
            super(name, getterName, setterName, declaredType);
            this.actualType = declaredType.typeArguments().isEmpty() ? Types.STRING_TYPE : (TypeName)declaredType.typeArguments().get(0);
        }

        @Override
        TypeName actualType() {
            return this.actualType;
        }
    }
}

