/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.builder.codegen;

import io.helidon.builder.codegen.Types;
import io.helidon.builder.codegen.Utils;
import io.helidon.codegen.ElementInfoPredicates;
import io.helidon.common.Errors;
import io.helidon.common.types.AccessModifier;
import io.helidon.common.types.Annotation;
import io.helidon.common.types.TypeInfo;
import io.helidon.common.types.TypeName;
import io.helidon.common.types.TypedElementInfo;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;

abstract class ValidationTask {
    ValidationTask() {
    }

    static boolean doesImplement(TypeInfo validatedType, TypeName implementedInterface) {
        if (validatedType.interfaceTypeInfo().stream().anyMatch(it -> it.typeName().equals((Object)implementedInterface))) {
            return true;
        }
        return validatedType.superTypeInfo().map(it -> ValidationTask.doesImplement(it, implementedInterface)).orElse(false);
    }

    abstract void validate(Errors.Collector var1);

    private static void validateImplements(Errors.Collector errors, TypeInfo validatedType, TypeName implementedInterface, String message) {
        if (!ValidationTask.doesImplement(validatedType, implementedInterface)) {
            errors.fatal((Object)validatedType.typeName(), message);
        }
    }

    private static void validateFactoryMethod(Errors.Collector errors, TypeInfo validatedType, TypeName returnType, String methodName, TypeName argument, String message) {
        if (validatedType.elementInfo().stream().filter(ElementInfoPredicates::isMethod).filter(ElementInfoPredicates::isStatic).filter(ElementInfoPredicates.elementName((String)methodName)).filter(it -> Utils.typesEqual(returnType, it.typeName())).filter(it -> {
            List args = it.parameterArguments();
            if (argument == null) {
                return args.isEmpty();
            }
            if (args.size() != 1) {
                return false;
            }
            TypedElementInfo typedElementInfo = (TypedElementInfo)args.getFirst();
            return Utils.typesEqual(argument, typedElementInfo.typeName());
        }).findFirst().isEmpty()) {
            errors.fatal((Object)validatedType.typeName(), message);
        }
    }

    private static class ValidateBuilderMethod
    extends ValidationTask {
        private final TypeName configObjectType;
        private final TypeInfo runtimeTypeInfo;
        private final TypeName configObjectBuilder;

        ValidateBuilderMethod(TypeName configObjectType, TypeInfo runtimeTypeInfo, TypeName configObjectBuilder) {
            this.configObjectType = configObjectType;
            this.runtimeTypeInfo = runtimeTypeInfo;
            this.configObjectBuilder = configObjectBuilder;
        }

        @Override
        public void validate(Errors.Collector errors) {
            ValidationTask.validateFactoryMethod(errors, this.runtimeTypeInfo, this.configObjectBuilder, "builder", null, "As " + this.configObjectType.fqName() + " implements " + Types.PROTOTYPE_FACTORY.classNameWithEnclosingNames() + "<" + this.runtimeTypeInfo.typeName().fqName() + ">, the runtime type must implement the following method:\nstatic " + this.configObjectType.className() + ".Builder builder() {\n  return " + this.configObjectType.className() + ".builder();\n}");
        }
    }

    private static class ValidateCreateWithConsumerMethod
    extends ValidationTask {
        private final TypeName configObjectType;
        private final TypeInfo runtimeTypeInfo;

        ValidateCreateWithConsumerMethod(TypeName configObjectType, TypeInfo runtimeTypeInfo) {
            this.configObjectType = configObjectType;
            this.runtimeTypeInfo = runtimeTypeInfo;
        }

        @Override
        public void validate(Errors.Collector errors) {
            TypeName consumerArgument = ((TypeName.Builder)((TypeName.Builder)TypeName.builder().type(Consumer.class)).addTypeArgument(TypeName.create((String)(this.configObjectType.fqName() + ".Builder")))).build();
            ValidationTask.validateFactoryMethod(errors, this.runtimeTypeInfo, this.runtimeTypeInfo.typeName(), "create", consumerArgument, "As " + this.configObjectType.fqName() + " implements " + Types.PROTOTYPE_FACTORY.classNameWithEnclosingNames() + "<" + this.runtimeTypeInfo.typeName().resolvedName() + ">, the type " + this.runtimeTypeInfo.typeName().className() + " must implement the following method:\nstatic " + this.runtimeTypeInfo.typeName().className() + " create(" + consumerArgument.resolvedName() + " consumer) {\n  return builder().update(consumer).build();}");
        }
    }

    private static class ValidateCreateMethod
    extends ValidationTask {
        private final TypeName configObjectType;
        private final TypeInfo runtimeTypeInfo;

        ValidateCreateMethod(TypeName configObjectType, TypeInfo runtimeTypeInfo) {
            this.configObjectType = configObjectType;
            this.runtimeTypeInfo = runtimeTypeInfo;
        }

        @Override
        public void validate(Errors.Collector errors) {
            String fqName = this.runtimeTypeInfo.typeName().genericTypeName().fqName();
            ValidationTask.validateFactoryMethod(errors, this.runtimeTypeInfo, this.runtimeTypeInfo.typeName(), "create", this.configObjectType, "As " + fqName + " is created by a blueprint of " + this.configObjectType.className() + ", the type must implement the following method:\nstatic " + this.runtimeTypeInfo.typeName().classNameWithTypes() + " create(" + this.configObjectType.classNameWithTypes() + ");");
        }
    }

    static class ValidateBlueprintExtendsFactory
    extends ValidationTask {
        private final List<ValidationTask> nestedValidators;
        private final TypeName configObjectType;
        private final TypeInfo blueprintInfo;
        private final TypeInfo runtimeTypeInfo;

        ValidateBlueprintExtendsFactory(TypeName configObjectType, TypeInfo blueprintInfo, TypeInfo runtimeTypeInfo) {
            this.configObjectType = configObjectType;
            this.blueprintInfo = blueprintInfo;
            this.runtimeTypeInfo = runtimeTypeInfo;
            TypeName configObjectBuilder = ((TypeName.Builder)((TypeName.Builder)((TypeName.Builder)TypeName.builder().packageName(configObjectType.packageName())).enclosingNames(List.of(configObjectType.className()))).className("Builder")).build();
            this.nestedValidators = List.of(new ValidateBuilderMethod(configObjectType, runtimeTypeInfo, configObjectBuilder), new ValidateConfiguredType(runtimeTypeInfo, configObjectType));
        }

        @Override
        public void validate(Errors.Collector errors) {
            ValidationTask.validateImplements(errors, this.runtimeTypeInfo, ((TypeName.Builder)TypeName.builder((TypeName)Types.RUNTIME_API).addTypeArgument(this.configObjectType.boxed())).build(), "As " + this.blueprintInfo.typeName().fqName() + " implements " + Types.PROTOTYPE_FACTORY.classNameWithEnclosingNames() + "<" + this.runtimeTypeInfo.typeName().fqName() + ">, the runtime type must implement(or extend) interface " + Types.RUNTIME_API.fqName() + "<" + this.configObjectType.className() + ">");
            for (ValidationTask nestedValidator : this.nestedValidators) {
                nestedValidator.validate(errors);
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ValidateBlueprintExtendsFactory that = (ValidateBlueprintExtendsFactory)o;
            return Objects.equals(this.blueprintInfo, that.blueprintInfo) && Objects.equals(this.runtimeTypeInfo, that.runtimeTypeInfo);
        }

        public int hashCode() {
            return Objects.hash(this.blueprintInfo, this.runtimeTypeInfo);
        }
    }

    static class ValidateBlueprint
    extends ValidationTask {
        private final TypeInfo blueprint;

        ValidateBlueprint(TypeInfo blueprint) {
            this.blueprint = blueprint;
        }

        @Override
        public void validate(Errors.Collector errors) {
            Annotation configured;
            String value;
            if (this.blueprint.accessModifier() == AccessModifier.PUBLIC) {
                errors.fatal((Object)this.blueprint.typeName(), this.blueprint.typeName().fqName() + " is defined as public, it must be package local");
            }
            if (this.blueprint.hasAnnotation(Types.PROTOTYPE_CONFIGURED) && this.blueprint.hasAnnotation(Types.PROTOTYPE_PROVIDES) && (value = (configured = this.blueprint.annotation(Types.PROTOTYPE_CONFIGURED)).stringValue().orElse("")).isEmpty()) {
                errors.fatal((Object)this.blueprint.typeName(), this.blueprint.typeName().fqName() + " is marked as @Configured and @Provides, yet it does not define a configuration key");
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ValidateBlueprint that = (ValidateBlueprint)o;
            return Objects.equals(this.blueprint.typeName(), that.blueprint.typeName());
        }

        public int hashCode() {
            return Objects.hash(this.blueprint.typeName());
        }
    }

    private static class ValidateImplements
    extends ValidationTask {
        private final TypeInfo typeInfo;
        private final TypeName requiredInterface;
        private final String message;

        ValidateImplements(TypeInfo typeInfo, TypeName requiredInterface, String message) {
            this.typeInfo = typeInfo;
            this.requiredInterface = requiredInterface;
            this.message = message;
        }

        @Override
        void validate(Errors.Collector errors) {
            ValidationTask.validateImplements(errors, this.typeInfo, this.requiredInterface, this.message);
        }
    }

    static class ValidateConfiguredType
    extends ValidationTask {
        private final TypeInfo runtimeTypeInfo;
        private final List<ValidationTask> nestedValidators;

        ValidateConfiguredType(TypeInfo runtimeTypeInfo, TypeName configObjectType) {
            this.runtimeTypeInfo = runtimeTypeInfo;
            TypeName configObjectWithTypeParams = ((TypeName.Builder)TypeName.builder((TypeName)configObjectType).typeArguments(runtimeTypeInfo.typeName().typeArguments())).build();
            TypeName configuredTypeInterface = ((TypeName.Builder)TypeName.builder((TypeName)Types.RUNTIME_API).addTypeArgument(configObjectType)).build();
            this.nestedValidators = List.of(new ValidateCreateMethod(configObjectWithTypeParams, runtimeTypeInfo), new ValidateCreateWithConsumerMethod(configObjectWithTypeParams, runtimeTypeInfo), new ValidateImplements(runtimeTypeInfo, configuredTypeInterface, "Type created as a factory " + configObjectType.className() + " must implement " + Types.RUNTIME_API.classNameWithEnclosingNames() + "<" + configObjectWithTypeParams.classNameWithTypes() + ">"));
        }

        @Override
        public void validate(Errors.Collector errors) {
            for (ValidationTask nestedValidator : this.nestedValidators) {
                nestedValidator.validate(errors);
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ValidateConfiguredType that = (ValidateConfiguredType)o;
            return Objects.equals(this.runtimeTypeInfo, that.runtimeTypeInfo);
        }

        public int hashCode() {
            return Objects.hash(this.runtimeTypeInfo);
        }
    }
}

