/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.builder.codegen;

import io.helidon.builder.codegen.GeneratedMethod;
import io.helidon.builder.codegen.OptionHandler;
import io.helidon.builder.codegen.OptionInfo;
import io.helidon.codegen.classmodel.ClassBase;
import io.helidon.codegen.classmodel.ContentBuilder;
import io.helidon.codegen.classmodel.Javadoc;
import io.helidon.codegen.classmodel.Method;
import io.helidon.common.types.ResolvedType;
import io.helidon.common.types.TypeName;
import io.helidon.common.types.TypeNames;
import io.helidon.common.types.TypedElementInfo;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;

final class Utils {
    private Utils() {
    }

    static List<OptionInfo> options(List<OptionHandler> options) {
        return options.stream().map(OptionHandler::option).collect(Collectors.toUnmodifiableList());
    }

    static void addGeneratedMethod(ClassBase.Builder<?, ?> classModel, GeneratedMethod generatedMethod) {
        TypedElementInfo methodInfo = generatedMethod.method();
        Optional<Javadoc> javadoc = generatedMethod.javadoc();
        Consumer<ContentBuilder<?>> contentBuilder = generatedMethod.contentBuilder();
        classModel.addMethod(method -> {
            method.from(methodInfo).update(contentBuilder::accept);
            javadoc.ifPresent(arg_0 -> ((Method.Builder)method).javadoc(arg_0));
        });
    }

    static TypeName toWildcard(TypeName typeName) {
        if (typeName.wildcard()) {
            return typeName;
        }
        if (typeName.generic()) {
            return ((TypeName.Builder)((TypeName.Builder)TypeName.builder().className(typeName.className())).wildcard(true)).build();
        }
        if (TypeNames.STRING.equals((Object)typeName) || typeName.unboxed().primitive() || typeName.array()) {
            return typeName;
        }
        return ((TypeName.Builder)TypeName.builder((TypeName)typeName).wildcard(true)).build();
    }

    static TypeName builderReturnType() {
        return TypeName.createFromGenericDeclaration((String)"BUILDER");
    }

    static String deCapitalize(String string) {
        if (string.isBlank()) {
            return string;
        }
        return Character.toLowerCase(string.charAt(0)) + string.substring(1);
    }

    static TypeName prototypeBuilderType(TypeName prototypeType) {
        return ((TypeName.Builder)((TypeName.Builder)((TypeName.Builder)TypeName.builder().packageName(prototypeType.packageName())).className("Builder")).addEnclosingName(prototypeType.className())).build();
    }

    static TypeName realType(TypeName declaredType) {
        if (declaredType.isOptional() || declaredType.isList() || declaredType.isSet() || declaredType.isSupplier()) {
            return (TypeName)declaredType.typeArguments().getFirst();
        }
        if (declaredType.isMap()) {
            return (TypeName)declaredType.typeArguments().get(1);
        }
        return declaredType;
    }

    static boolean typesEqual(TypeName first, TypeName second) {
        TypeName usedFirst = first;
        TypeName usedSecond = second;
        if (first.packageName().isEmpty()) {
            usedSecond = ((TypeName.Builder)TypeName.builder((TypeName)second).packageName("")).build();
        } else if (second.packageName().isEmpty()) {
            usedFirst = ((TypeName.Builder)TypeName.builder((TypeName)first).packageName("")).build();
        }
        return usedFirst.equals((Object)usedSecond);
    }

    static boolean resolvedTypesEqual(TypeName first, TypeName second) {
        TypeName usedFirst = first;
        TypeName usedSecond = second;
        if (first.packageName().isEmpty()) {
            usedSecond = ((TypeName.Builder)TypeName.builder((TypeName)second).packageName("")).build();
        } else if (second.packageName().isEmpty()) {
            usedFirst = ((TypeName.Builder)TypeName.builder((TypeName)first).packageName("")).build();
        }
        return ResolvedType.create((TypeName)usedFirst).equals((Object)ResolvedType.create((TypeName)usedSecond));
    }
}

