/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.builder.codegen;

import io.helidon.builder.codegen.FactoryMethod;
import io.helidon.builder.codegen.GeneratedMethod;
import io.helidon.builder.codegen.OptionBuilder;
import io.helidon.builder.codegen.OptionConfigured;
import io.helidon.builder.codegen.OptionInfo;
import io.helidon.builder.codegen.OptionSingular;
import io.helidon.builder.codegen.PrototypeInfo;
import io.helidon.builder.codegen.RuntimeTypeInfo;
import io.helidon.builder.codegen.TypeHandlerContainer;
import io.helidon.builder.codegen.Types;
import io.helidon.builder.codegen.Utils;
import io.helidon.builder.codegen.spi.BuilderCodegenExtension;
import io.helidon.codegen.CodegenUtil;
import io.helidon.codegen.classmodel.ClassBase;
import io.helidon.codegen.classmodel.ContentBuilder;
import io.helidon.codegen.classmodel.Field;
import io.helidon.codegen.classmodel.Javadoc;
import io.helidon.codegen.classmodel.Method;
import io.helidon.codegen.classmodel.TypeArgument;
import io.helidon.common.types.ElementKind;
import io.helidon.common.types.TypeName;
import io.helidon.common.types.TypeNames;
import io.helidon.common.types.TypedElementInfo;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;

class TypeHandlerMap
extends TypeHandlerContainer {
    private static final TypeName SAME_GENERIC_TYPE = TypeName.createFromGenericDeclaration((String)"TYPE");
    private final boolean sameGeneric;
    private final TypeName keyType;
    private final TypeName valueType;

    TypeHandlerMap(List<BuilderCodegenExtension> extensions, PrototypeInfo prototypeInfo, OptionInfo option) {
        super(extensions, prototypeInfo, option, (TypeName)option.declaredType().typeArguments().get(1));
        this.sameGeneric = option.sameGeneric();
        this.keyType = (TypeName)option.declaredType().typeArguments().get(0);
        this.valueType = (TypeName)option.declaredType().typeArguments().get(1);
    }

    @Override
    public void generateFromConfig(Method.Builder method, OptionConfigured optionConfigured) {
        String optionName = this.option().name();
        if (TypeNames.STRING.equals((Object)this.keyType) && TypeNames.STRING.equals((Object)this.valueType)) {
            method.addContentLine(this.configGet(optionConfigured) + ".detach().asMap().ifPresent(this::" + optionName + ");");
        } else if (optionConfigured.traverse()) {
            ((Method.Builder)((Method.Builder)method.addContent(this.configGet(optionConfigured) + ".detach().traverse().filter(")).addContent(Types.COMMON_CONFIG)).addContent("::hasValue).forEach(node -> " + optionName + ".put(node.get(\"name\").asString().orElse(node.key().toString()), node");
            this.generateFromConfig((ContentBuilder<?>)method);
            method.addContentLine(".get()));");
        } else {
            method.addContent(this.configGet(optionConfigured) + ".asNodeList().ifPresent(nodes -> nodes.forEach(node -> " + optionName + ".put(node.get(\"name\").asString().orElse(node.name()), node");
            if (optionConfigured.factoryMethod().isPresent()) {
                this.generateFromConfig((ContentBuilder<?>)method, optionConfigured.factoryMethod().get());
            } else {
                this.generateFromConfig((ContentBuilder<?>)method);
            }
            method.addContentLine(".get())));");
        }
    }

    @Override
    GeneratedMethod prepareBuilderSetter(Javadoc getterJavadoc) {
        TypeName returnType = Utils.builderReturnType();
        String name = this.option().name();
        Javadoc javadoc = Javadoc.builder((Javadoc)this.setterJavadoc(getterJavadoc, name, "")).add("\nThis method replaces all values with the new ones.").build();
        TypedElementInfo.Builder method = (TypedElementInfo.Builder)((TypedElementInfo.Builder)((TypedElementInfo.Builder)((TypedElementInfo.Builder)((TypedElementInfo.Builder)((TypedElementInfo.Builder)TypedElementInfo.builder().kind(ElementKind.METHOD)).accessModifier(this.option().accessModifier())).typeName(returnType)).elementName(this.option().setterName())).update(this::deprecation)).update(it -> this.option().annotations().forEach(arg_0 -> ((TypedElementInfo.Builder)it).addAnnotation(arg_0)));
        method.addParameterArgument(param -> ((TypedElementInfo.Builder)((TypedElementInfo.Builder)param.kind(ElementKind.PARAMETER)).typeName(this.typeOfMap(this.keyType, this.valueType))).elementName(name));
        Consumer<ContentBuilder<?>> contentConsumer = it -> {
            it.addContent(Objects.class).addContentLine(".requireNonNull(" + name + ");");
            it.addContentLine("this." + name + ".clear();").addContentLine("this." + name + ".putAll(" + name + ");");
            this.extraSetterContent((ContentBuilder<?>)it);
            it.addContentLine("return self();");
        };
        return ((GeneratedMethod.Builder)((GeneratedMethod.Builder)((GeneratedMethod.Builder)GeneratedMethod.builder().method(method.build())).javadoc(javadoc)).contentBuilder(contentConsumer)).build();
    }

    @Override
    Optional<GeneratedMethod> prepareBuilderAddCollection(Javadoc getterJavadoc) {
        TypeName returnType = Utils.builderReturnType();
        String name = this.option().name();
        Javadoc javadoc = Javadoc.builder((Javadoc)this.setterJavadoc(getterJavadoc, name, "")).add("\nThis method keeps existing values, then puts all new values into the map.").build();
        TypedElementInfo.Builder method = (TypedElementInfo.Builder)((TypedElementInfo.Builder)((TypedElementInfo.Builder)((TypedElementInfo.Builder)((TypedElementInfo.Builder)((TypedElementInfo.Builder)TypedElementInfo.builder().kind(ElementKind.METHOD)).accessModifier(this.option().accessModifier())).typeName(returnType)).elementName("add" + CodegenUtil.capitalize((String)name))).update(this::deprecation)).update(it -> this.option().annotations().forEach(arg_0 -> ((TypedElementInfo.Builder)it).addAnnotation(arg_0)));
        method.addParameterArgument(param -> ((TypedElementInfo.Builder)((TypedElementInfo.Builder)param.kind(ElementKind.PARAMETER)).typeName(this.typeOfMap(this.keyType, this.valueType))).elementName(name));
        Consumer<ContentBuilder<?>> contentConsumer = it -> {
            it.addContent(Objects.class).addContentLine(".requireNonNull(" + name + ");").addContentLine("this." + name + ".putAll(" + name + ");");
            this.extraSetterContent((ContentBuilder<?>)it);
            it.addContentLine("return self();");
        };
        return Optional.ofNullable(((GeneratedMethod.Builder)((GeneratedMethod.Builder)((GeneratedMethod.Builder)GeneratedMethod.builder().method(method.build())).javadoc(javadoc)).contentBuilder(contentConsumer)).build());
    }

    @Override
    Optional<GeneratedMethod> prepareBuilderSingularAdd(Javadoc getterJavadoc) {
        if (this.option().singular().isEmpty()) {
            return Optional.empty();
        }
        OptionSingular singular = this.option().singular().get();
        String singularName = singular.name();
        String methodName = singular.methodName();
        TypeName returnType = Utils.builderReturnType();
        String name = this.option().name();
        Javadoc setterJavadoc = ((Javadoc.Builder)Javadoc.builder((Javadoc)this.setterJavadoc(getterJavadoc, "key", "")).add("\nThis method adds a new value to the map, or replaces it if the key already exists.").parameters(Map.of()).addParameter("key", "key to add or replace").addParameter(singularName, "new value for the key").update(it -> {
            if (this.sameGeneric) {
                it.addGenericArgument("TYPE", "The key and value has to use the same generic type.");
            }
        })).build();
        TypedElementInfo.Builder method = (TypedElementInfo.Builder)((TypedElementInfo.Builder)((TypedElementInfo.Builder)((TypedElementInfo.Builder)((TypedElementInfo.Builder)((TypedElementInfo.Builder)TypedElementInfo.builder().kind(ElementKind.METHOD)).accessModifier(this.option().accessModifier())).typeName(returnType)).elementName(methodName)).update(this::deprecation)).update(it -> this.option().annotations().forEach(arg_0 -> ((TypedElementInfo.Builder)it).addAnnotation(arg_0)));
        if (this.sameGeneric) {
            this.sameGenericArgs(method, this.keyType, singularName, this.type());
        } else {
            ((TypedElementInfo.Builder)method.addParameterArgument(param -> ((TypedElementInfo.Builder)((TypedElementInfo.Builder)param.kind(ElementKind.PARAMETER)).typeName(this.keyType)).elementName("key"))).addParameterArgument(param -> ((TypedElementInfo.Builder)((TypedElementInfo.Builder)param.kind(ElementKind.PARAMETER)).typeName(this.type())).elementName(singularName));
        }
        Consumer<ContentBuilder<?>> contentConsumer = it -> {
            it.addContent(Objects.class).addContentLine(".requireNonNull(key);").addContent(Objects.class).addContentLine(".requireNonNull(" + singularName + ");").addContent("this." + name + ".put(key, ");
            this.secondArgToPut((ContentBuilder<?>)it, this.type(), singularName);
            it.addContentLine(");");
            this.extraAdderContent((ContentBuilder<?>)it);
            it.addContentLine("return self();");
        };
        return Optional.ofNullable(((GeneratedMethod.Builder)((GeneratedMethod.Builder)((GeneratedMethod.Builder)GeneratedMethod.builder().method(method.build())).contentBuilder(contentConsumer)).javadoc(setterJavadoc)).build());
    }

    @Override
    Optional<GeneratedMethod> prepareBuilderSingularAddToMapValue(Javadoc getterJavadoc) {
        if (this.option().singular().isEmpty()) {
            return Optional.empty();
        }
        if (!this.valueType.isSet() && !this.valueType.isList()) {
            return Optional.empty();
        }
        OptionSingular singular = this.option().singular().get();
        String singularName = singular.name();
        String methodName = "add" + CodegenUtil.capitalize((String)singularName);
        TypeName returnType = Utils.builderReturnType();
        TypeName valueParamType = (TypeName)this.type().typeArguments().getFirst();
        Javadoc setterJavadoc = Javadoc.builder((Javadoc)this.setterJavadoc(getterJavadoc, "key", "")).add("\nThis method adds a new value to the map value, or creates a new value.").parameters(Map.of()).addParameter("key", "key to add value for").addParameter(singularName, "value to add to the map values").build();
        TypedElementInfo.Builder method = (TypedElementInfo.Builder)((TypedElementInfo.Builder)((TypedElementInfo.Builder)((TypedElementInfo.Builder)((TypedElementInfo.Builder)((TypedElementInfo.Builder)TypedElementInfo.builder().kind(ElementKind.METHOD)).accessModifier(this.option().accessModifier())).typeName(returnType)).elementName(methodName)).update(this::deprecation)).update(it -> this.option().annotations().forEach(arg_0 -> ((TypedElementInfo.Builder)it).addAnnotation(arg_0)));
        if (this.sameGeneric) {
            this.sameGenericArgs(method, this.keyType, singularName, valueParamType);
        } else {
            ((TypedElementInfo.Builder)method.addParameterArgument(param -> ((TypedElementInfo.Builder)((TypedElementInfo.Builder)param.kind(ElementKind.PARAMETER)).typeName(this.keyType)).elementName("key"))).addParameterArgument(param -> ((TypedElementInfo.Builder)((TypedElementInfo.Builder)param.kind(ElementKind.PARAMETER)).typeName(valueParamType)).elementName(singularName));
        }
        Consumer<ContentBuilder<?>> contentConsumer = it -> {
            it.addContent(Objects.class).addContentLine(".requireNonNull(key);").addContent(Objects.class).addContentLine(".requireNonNull(" + singularName + ");").addContentLine("this." + this.option().name() + ".compute(key, (k, v) -> {").addContent("v = v == null ? new ").addContent(this.containerValueTypeImpl()).addContent("<>() : new ").addContent(this.containerValueTypeImpl()).addContentLine("<>(v);").addContentLine("v.add(" + singularName + ");").addContentLine("return v;").decreaseContentPadding().addContentLine("});");
            this.extraAdderContent((ContentBuilder<?>)it);
            it.addContentLine("return self();");
        };
        return Optional.ofNullable(((GeneratedMethod.Builder)((GeneratedMethod.Builder)((GeneratedMethod.Builder)GeneratedMethod.builder().method(method.build())).contentBuilder(contentConsumer)).javadoc(setterJavadoc)).build());
    }

    @Override
    Optional<GeneratedMethod> prepareBuilderSingularAddToMapValues(Javadoc getterJavadoc) {
        if (this.option().singular().isEmpty()) {
            return Optional.empty();
        }
        if (!this.valueType.isSet() && !this.valueType.isList()) {
            return Optional.empty();
        }
        String methodName = "add" + CodegenUtil.capitalize((String)this.option().name());
        TypeName returnType = Utils.builderReturnType();
        String name = this.option().name();
        Javadoc setterJavadoc = Javadoc.builder((Javadoc)this.setterJavadoc(getterJavadoc, "key", "")).add("\nThis method adds new values to the map values, or creates a new mapping.").parameters(Map.of()).addParameter("key", "key to add value for").addParameter(name, "values to add to the map values").build();
        TypedElementInfo.Builder method = (TypedElementInfo.Builder)((TypedElementInfo.Builder)((TypedElementInfo.Builder)((TypedElementInfo.Builder)((TypedElementInfo.Builder)((TypedElementInfo.Builder)TypedElementInfo.builder().kind(ElementKind.METHOD)).accessModifier(this.option().accessModifier())).typeName(returnType)).elementName(methodName)).update(this::deprecation)).update(it -> this.option().annotations().forEach(arg_0 -> ((TypedElementInfo.Builder)it).addAnnotation(arg_0)));
        if (this.sameGeneric) {
            this.sameGenericArgs(method, this.keyType, name, this.type());
        } else {
            ((TypedElementInfo.Builder)method.addParameterArgument(param -> ((TypedElementInfo.Builder)((TypedElementInfo.Builder)param.kind(ElementKind.PARAMETER)).typeName(this.keyType)).elementName("key"))).addParameterArgument(param -> ((TypedElementInfo.Builder)((TypedElementInfo.Builder)param.kind(ElementKind.PARAMETER)).typeName(this.type())).elementName(name));
        }
        Consumer<ContentBuilder<?>> contentConsumer = it -> {
            it.addContent(Objects.class).addContentLine(".requireNonNull(key);").addContent(Objects.class).addContentLine(".requireNonNull(" + name + ");").addContentLine("this." + this.option().name() + ".compute(key, (k, v) -> {").addContent("v = v == null ? new ").addContent(this.containerValueTypeImpl()).addContent("<>() : new ").addContent(this.containerValueTypeImpl()).addContentLine("<>(v);").addContentLine("v.addAll(" + name + ");").addContentLine("return v;").decreaseContentPadding().addContentLine("});");
            this.extraAdderContent((ContentBuilder<?>)it);
            it.addContentLine("return self();");
        };
        return Optional.ofNullable(((GeneratedMethod.Builder)((GeneratedMethod.Builder)((GeneratedMethod.Builder)GeneratedMethod.builder().method(method.build())).contentBuilder(contentConsumer)).javadoc(setterJavadoc)).build());
    }

    @Override
    Optional<GeneratedMethod> prepareBuilderSingularAddConsumer(Javadoc getterJavadoc) {
        if (this.option().singular().isEmpty() || this.option().builderInfo().isEmpty() && this.option().runtimeType().isEmpty()) {
            return Optional.empty();
        }
        OptionSingular singular = this.option().singular().get();
        String methodName = singular.methodName();
        TypeName returnType = Utils.builderReturnType();
        if (this.option().runtimeType().isPresent()) {
            RuntimeTypeInfo rti = this.option().runtimeType().get();
            OptionBuilder optionBuilder = rti.optionBuilder();
            Optional<FactoryMethod> factoryMethod = rti.factoryMethod();
            Javadoc setterJavadoc = Javadoc.builder((Javadoc)this.setterJavadoc(getterJavadoc, "key", "")).add("\nThis method adds a new value to the map, or replaces it if the key already exists.").parameters(Map.of()).addParameter("key", "key to add or replace").addParameter("consumer", "consumer of builder for new value").build();
            TypeName paramType = ((TypeName.Builder)((TypeName.Builder)TypeName.builder().type(Consumer.class)).addTypeArgument(optionBuilder.builderType())).build();
            TypedElementInfo.Builder method = (TypedElementInfo.Builder)((TypedElementInfo.Builder)((TypedElementInfo.Builder)((TypedElementInfo.Builder)((TypedElementInfo.Builder)((TypedElementInfo.Builder)TypedElementInfo.builder().kind(ElementKind.METHOD)).accessModifier(this.option().accessModifier())).typeName(returnType)).elementName(methodName)).update(this::deprecation)).update(it -> this.option().annotations().forEach(arg_0 -> ((TypedElementInfo.Builder)it).addAnnotation(arg_0)));
            ((TypedElementInfo.Builder)method.addParameterArgument(param -> ((TypedElementInfo.Builder)((TypedElementInfo.Builder)param.kind(ElementKind.PARAMETER)).typeName(this.keyType)).elementName("key"))).addParameterArgument(param -> ((TypedElementInfo.Builder)((TypedElementInfo.Builder)param.kind(ElementKind.PARAMETER)).typeName(paramType)).elementName("consumer"));
            Consumer<ContentBuilder<?>> contentConsumer = it -> {
                it.addContent(Objects.class).addContentLine(".requireNonNull(consumer);").addContent("var builder = ");
                if (optionBuilder.builderMethodName().equals("<init>")) {
                    it.addContent("new ").addContent(optionBuilder.builderType()).addContentLine("();");
                } else {
                    it.addContent(optionBuilder.builderMethodType()).addContentLine("." + optionBuilder.builderMethodName() + "();");
                }
                it.addContentLine("consumer.accept(builder);").addContent("this." + methodName + "(key, ");
                factoryMethod.ifPresent(fm -> it.addContent(fm.declaringType().genericTypeName()).addContent(".").addContent(fm.methodName()).addContent("("));
                it.addContent("builder.").addContent(optionBuilder.buildMethodName()).addContent("()");
                factoryMethod.ifPresent(f -> it.addContent(")"));
                it.addContentLine(");");
                it.addContentLine("return self();");
            };
            return Optional.of(((GeneratedMethod.Builder)((GeneratedMethod.Builder)((GeneratedMethod.Builder)GeneratedMethod.builder().method(method.build())).javadoc(setterJavadoc)).contentBuilder(contentConsumer)).build());
        }
        OptionBuilder optionBuilder = this.option().builderInfo().get();
        Javadoc setterJavadoc = Javadoc.builder((Javadoc)this.setterJavadoc(getterJavadoc, "key", "")).add("\nThis method adds a new value to the map, or replaces it if the key already exists.").parameters(Map.of()).addParameter("key", "key to add or replace").addParameter("consumer", "consumer of builder for new value").build();
        TypeName paramType = ((TypeName.Builder)((TypeName.Builder)TypeName.builder().type(Consumer.class)).addTypeArgument(optionBuilder.builderType())).build();
        TypedElementInfo.Builder method = (TypedElementInfo.Builder)((TypedElementInfo.Builder)((TypedElementInfo.Builder)((TypedElementInfo.Builder)((TypedElementInfo.Builder)((TypedElementInfo.Builder)TypedElementInfo.builder().kind(ElementKind.METHOD)).accessModifier(this.option().accessModifier())).typeName(returnType)).elementName(methodName)).update(this::deprecation)).update(it -> this.option().annotations().forEach(arg_0 -> ((TypedElementInfo.Builder)it).addAnnotation(arg_0)));
        ((TypedElementInfo.Builder)method.addParameterArgument(param -> ((TypedElementInfo.Builder)((TypedElementInfo.Builder)param.kind(ElementKind.PARAMETER)).typeName(this.keyType)).elementName("key"))).addParameterArgument(param -> ((TypedElementInfo.Builder)((TypedElementInfo.Builder)param.kind(ElementKind.PARAMETER)).typeName(paramType)).elementName("consumer"));
        Consumer<ContentBuilder<?>> contentConsumer = it -> {
            it.addContent(Objects.class).addContentLine(".requireNonNull(consumer);").addContent("var builder = ");
            if (optionBuilder.builderMethodName().equals("<init>")) {
                it.addContent("new ").addContent(optionBuilder.builderType()).addContentLine("();");
            } else {
                it.addContent(optionBuilder.builderMethodType()).addContentLine("." + optionBuilder.builderMethodName() + "();");
            }
            it.addContentLine("consumer.accept(builder);").addContent("this." + methodName + "(key, ");
            it.addContent("builder.").addContent(optionBuilder.buildMethodName()).addContent("()");
            it.addContentLine(");");
            it.addContentLine("return self();");
        };
        return Optional.of(((GeneratedMethod.Builder)((GeneratedMethod.Builder)((GeneratedMethod.Builder)GeneratedMethod.builder().method(method.build())).javadoc(setterJavadoc)).contentBuilder(contentConsumer)).build());
    }

    @Override
    void addFields(ClassBase.Builder<?, ?> classBuilder, boolean isBuilder) {
        Field.Builder builder = super.field(isBuilder);
        if (isBuilder && this.option().defaultValue().isEmpty()) {
            builder.addContent("new ").addContent(Types.LINKED_HASH_MAP).addContent("<>()");
        }
        classBuilder.addField(builder.build());
    }

    private TypeName containerValueTypeImpl() {
        if (this.valueType.isList()) {
            return Types.ARRAY_LIST;
        }
        if (this.valueType.isSet()) {
            return Types.LINKED_HASH_SET;
        }
        if (this.valueType.isMap()) {
            return Types.LINKED_HASH_MAP;
        }
        return this.valueType;
    }

    private TypeName typeOfMap(TypeName keyType, TypeName valueType) {
        return ((TypeName.Builder)((TypeName.Builder)TypeName.builder((TypeName)TypeNames.MAP).addTypeArgument(Utils.toWildcard(keyType))).addTypeArgument(Utils.toWildcard(valueType))).build();
    }

    private void sameGenericArgs(TypedElementInfo.Builder method, TypeName keyType, String value, TypeName valueType) {
        TypeName resolvedValueType;
        TypeName resolvedKeyType;
        TypeName genericTypeBase;
        if (keyType.typeArguments().isEmpty()) {
            genericTypeBase = keyType;
            resolvedKeyType = SAME_GENERIC_TYPE;
        } else if (keyType.typeArguments().size() == 1) {
            TypeName typeArg = (TypeName)keyType.typeArguments().getFirst();
            genericTypeBase = typeArg.wildcard() ? (typeArg.generic() ? TypeNames.OBJECT : ((TypeName.Builder)TypeName.builder((TypeName)typeArg).wildcard(false)).build()) : typeArg;
            resolvedKeyType = ((TypeName.Builder)TypeName.builder((TypeName)keyType).typeArguments(List.of(SAME_GENERIC_TYPE))).build();
        } else {
            throw new IllegalArgumentException("Property " + this.option().name() + " with type " + this.option().declaredType().fqName() + " is annotated with @SameGeneric, yet the key generic type cannot be determined. Either the key must be a simple type, or a type with one type argument.");
        }
        method.addTypeParameter((TypeName)TypeArgument.builder().token("TYPE").bound(genericTypeBase).description("Type to correctly map key and value").build());
        if (valueType.typeArguments().isEmpty()) {
            if (!genericTypeBase.equals((Object)valueType)) {
                throw new IllegalArgumentException("Property " + this.option().name() + " with type " + this.option().declaredType().fqName() + " is annotated with @SameGeneric, yet the type of value is not the same as type found on key: " + genericTypeBase.fqName());
            }
            resolvedValueType = SAME_GENERIC_TYPE;
        } else if (valueType.typeArguments().size() == 1) {
            if (!genericTypeBase.equals(valueType.typeArguments().getFirst())) {
                throw new IllegalArgumentException("Property " + this.option().name() + " with type " + this.option().declaredType().fqName() + " is annotated with @SameGeneric, yet type of value is not the same as type found on key: " + genericTypeBase.fqName());
            }
            resolvedValueType = ((TypeName.Builder)TypeName.builder((TypeName)valueType).typeArguments(List.of(SAME_GENERIC_TYPE))).build();
        } else {
            throw new IllegalArgumentException("Property " + this.option().name() + " with type " + this.option().declaredType().fqName() + " is annotated with @SameGeneric, yet the value generic type cannot be determined. Either the value must be a simple type, or a type with one type argument.");
        }
        ((TypedElementInfo.Builder)method.addParameterArgument(param -> ((TypedElementInfo.Builder)((TypedElementInfo.Builder)((TypedElementInfo.Builder)param.elementName("key")).kind(ElementKind.PARAMETER)).typeName(resolvedKeyType)).description("key to add or replace"))).addParameterArgument(param -> ((TypedElementInfo.Builder)((TypedElementInfo.Builder)((TypedElementInfo.Builder)param.elementName(value)).kind(ElementKind.PARAMETER)).typeName(resolvedValueType)).description("new value for the key"));
    }

    private void secondArgToPut(ContentBuilder<?> contentBuilder, TypeName typeName, String singularName) {
        TypeName genericTypeName = typeName.genericTypeName();
        if (genericTypeName.equals((Object)TypeNames.LIST)) {
            contentBuilder.addContent(List.class).addContent(".copyOf(" + singularName + ")");
        } else if (genericTypeName.equals((Object)TypeNames.SET)) {
            contentBuilder.addContent(Set.class).addContent(".copyOf(" + singularName + ")");
        } else if (genericTypeName.equals((Object)TypeNames.MAP)) {
            contentBuilder.addContent(Map.class).addContent(".copyOf(" + singularName + ")");
        } else {
            contentBuilder.addContent(singularName);
        }
    }
}

