/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.builder.codegen;

import io.helidon.builder.codegen.FactoryMethod;
import io.helidon.builder.codegen.GeneratedMethod;
import io.helidon.builder.codegen.OptionBuilder;
import io.helidon.builder.codegen.OptionConfigured;
import io.helidon.builder.codegen.OptionInfo;
import io.helidon.builder.codegen.OptionSingular;
import io.helidon.builder.codegen.PrototypeInfo;
import io.helidon.builder.codegen.RuntimeTypeInfo;
import io.helidon.builder.codegen.TypeHandlerContainer;
import io.helidon.builder.codegen.Utils;
import io.helidon.builder.codegen.spi.BuilderCodegenExtension;
import io.helidon.codegen.CodegenUtil;
import io.helidon.codegen.classmodel.ClassBase;
import io.helidon.codegen.classmodel.ContentBuilder;
import io.helidon.codegen.classmodel.Field;
import io.helidon.codegen.classmodel.Javadoc;
import io.helidon.codegen.classmodel.Method;
import io.helidon.common.types.ElementKind;
import io.helidon.common.types.TypeName;
import io.helidon.common.types.TypeNames;
import io.helidon.common.types.TypedElementInfo;
import java.io.File;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.regex.Pattern;

abstract class TypeHandlerCollection
extends TypeHandlerContainer {
    private static final Set<TypeName> BUILT_IN_MAPPERS = Set.of(TypeNames.STRING, TypeNames.BOXED_BOOLEAN, TypeNames.BOXED_BYTE, TypeNames.BOXED_SHORT, TypeNames.BOXED_INT, TypeNames.BOXED_LONG, TypeNames.BOXED_CHAR, TypeNames.BOXED_FLOAT, TypeNames.BOXED_DOUBLE, TypeNames.BOXED_VOID, TypeName.create(BigDecimal.class), TypeName.create(BigInteger.class), TypeName.create(Pattern.class), TypeName.create(Class.class), TypeName.create(Duration.class), TypeName.create(Period.class), TypeName.create(LocalDate.class), TypeName.create(LocalDateTime.class), TypeName.create(LocalTime.class), TypeName.create(ZonedDateTime.class), TypeName.create(ZoneId.class), TypeName.create(ZoneOffset.class), TypeName.create(Instant.class), TypeName.create(OffsetTime.class), TypeName.create(OffsetDateTime.class), TypeName.create(YearMonth.class), TypeName.create(File.class), TypeName.create(Path.class), TypeName.create(Charset.class), TypeName.create(URI.class), TypeName.create(URL.class), TypeName.create(UUID.class));
    private final TypeName collectionType;
    private final TypeName collectionImplType;
    private final Consumer<ContentBuilder<?>> collector;
    private final Optional<Consumer<ContentBuilder<?>>> configMapper;

    TypeHandlerCollection(List<BuilderCodegenExtension> extensions, PrototypeInfo prototypeInfo, OptionInfo option, TypeName collectionType, TypeName collectionImplType, Consumer<ContentBuilder<?>> collector, Optional<Consumer<ContentBuilder<?>>> configMapper) {
        super(extensions, prototypeInfo, option, TypeHandlerCollection.firstTypeArgument(option));
        this.collectionType = collectionType;
        this.collectionImplType = collectionImplType;
        this.collector = collector;
        this.configMapper = configMapper;
    }

    @Override
    public void addFields(ClassBase.Builder<?, ?> classBuilder, boolean isBuilder) {
        Field.Builder builder = super.field(isBuilder);
        builder.isFinal(true);
        if (isBuilder && this.option().defaultValue().isEmpty()) {
            this.newCollectionInstanceWithoutParams((ContentBuilder<?>)builder);
            builder.addContent("()");
        }
        classBuilder.addField(builder.build());
    }

    @Override
    public void generateFromConfig(Method.Builder method, OptionConfigured optionConfigured) {
        if (this.option().provider().isPresent()) {
            return;
        }
        TypeName actualType = this.type().genericTypeName();
        String setterName = this.option().setterName();
        Optional<FactoryMethod> factoryMethod = optionConfigured.factoryMethod();
        if (factoryMethod.isPresent()) {
            FactoryMethod fm = factoryMethod.get();
            TypeName returnType = fm.returnType();
            boolean mapList = returnType.isList() || returnType.isSet() ? false : Utils.typesEqual(actualType, returnType);
            if (mapList) {
                ((Method.Builder)((Method.Builder)((Method.Builder)method.addContent(this.configGet(optionConfigured))).addContent(".asList(")).update(it -> this.generateMapListFromConfig((ContentBuilder<?>)it, fm))).addContentLine(").ifPresent(this::" + setterName + ");");
            } else {
                method.addContent(this.configGet(optionConfigured));
                this.generateFromConfig((ContentBuilder<?>)method, fm);
                method.addContentLine(".ifPresent(this::" + setterName + ");");
            }
        } else if (BUILT_IN_MAPPERS.contains(actualType)) {
            ((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)method.addContent(this.configGet(optionConfigured))).addContent(".asList(")).addContent(actualType.genericTypeName())).addContent(".class")).addContent(")");
            this.configMapper.ifPresent(it -> it.accept(method));
            if (this.type().typeArguments().isEmpty()) {
                ((Method.Builder)((Method.Builder)method.addContent(".ifPresent(this::")).addContent(setterName)).addContentLine(");");
            } else {
                ((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)method.addContent(".ifPresent(it -> this.")).addContent(setterName)).addContent("((")).addContent(this.collectionType)).addContentLine(")it));");
            }
        } else {
            method.addContent(this.configGet(optionConfigured) + ".asNodeList().map(nodeList -> nodeList.stream().map(cfg -> cfg");
            this.generateFromConfig((ContentBuilder<?>)method);
            method.addContent(".get()).");
            this.collector.accept((ContentBuilder<?>)method);
            method.addContent(").ifPresent(this::" + setterName + ");");
        }
    }

    void generateMapListFromConfig(ContentBuilder<?> content, FactoryMethod factoryMethod) {
        TypeName declaringType = factoryMethod.declaringType();
        String methodName = factoryMethod.methodName();
        content.addContent(declaringType.genericTypeName()).addContent("::").addContent(methodName);
    }

    protected abstract String decoratorSetMethodName();

    protected abstract String decoratorAddMethodName();

    @Override
    GeneratedMethod prepareBuilderSetter(Javadoc getterJavadoc) {
        TypeName returnType = Utils.builderReturnType();
        String name = this.option().name();
        TypedElementInfo.Builder method = (TypedElementInfo.Builder)((TypedElementInfo.Builder)((TypedElementInfo.Builder)((TypedElementInfo.Builder)((TypedElementInfo.Builder)((TypedElementInfo.Builder)TypedElementInfo.builder().kind(ElementKind.METHOD)).accessModifier(this.option().accessModifier())).typeName(returnType)).elementName(this.option().setterName())).update(this::deprecation)).update(it -> this.option().annotations().forEach(arg_0 -> ((TypedElementInfo.Builder)it).addAnnotation(arg_0)));
        method.addParameterArgument(param -> ((TypedElementInfo.Builder)((TypedElementInfo.Builder)param.kind(ElementKind.PARAMETER)).typeName(this.asTypeArgument(this.collectionType))).elementName(name));
        Consumer<ContentBuilder<?>> contentConsumer = it -> {
            it.addContent(Objects.class).addContentLine(".requireNonNull(" + name + ");");
            this.option().decorator().ifPresent(decorator -> it.addContent("new ").addContent(decorator).addContent("().").addContent(this.decoratorSetMethodName()).addContent("(this, ").addContent(name).addContentLine(");"));
            this.extraSetterContent((ContentBuilder<?>)it);
            it.addContentLine("this." + name + ".clear();").addContentLine("this." + name + ".addAll(" + name + ");").addContentLine("return self();");
        };
        return ((GeneratedMethod.Builder)((GeneratedMethod.Builder)((GeneratedMethod.Builder)GeneratedMethod.builder().method(method.build())).javadoc(this.setterJavadoc(getterJavadoc, name, ""))).contentBuilder(contentConsumer)).build();
    }

    @Override
    Optional<GeneratedMethod> prepareBuilderAddCollection(Javadoc getterJavadoc) {
        TypeName returnType = Utils.builderReturnType();
        String name = this.option().name();
        TypedElementInfo.Builder method = (TypedElementInfo.Builder)((TypedElementInfo.Builder)((TypedElementInfo.Builder)((TypedElementInfo.Builder)((TypedElementInfo.Builder)((TypedElementInfo.Builder)TypedElementInfo.builder().kind(ElementKind.METHOD)).accessModifier(this.option().accessModifier())).typeName(returnType)).elementName("add" + CodegenUtil.capitalize((String)this.option().name()))).update(this::deprecation)).update(it -> this.option().annotations().forEach(arg_0 -> ((TypedElementInfo.Builder)it).addAnnotation(arg_0)));
        method.addParameterArgument(param -> ((TypedElementInfo.Builder)((TypedElementInfo.Builder)param.kind(ElementKind.PARAMETER)).typeName(this.asTypeArgument(this.collectionType))).elementName(name));
        Consumer<ContentBuilder<?>> contentConsumer = it -> {
            it.addContent(Objects.class).addContentLine(".requireNonNull(" + name + ");");
            this.extraSetterContent((ContentBuilder<?>)it);
            this.option().decorator().ifPresent(decorator -> it.addContent("new ").addContent(decorator).addContent("().").addContent(this.decoratorAddMethodName()).addContent("(this, ").addContent(name).addContentLine(");"));
            it.addContentLine("this." + name + ".addAll(" + name + ");").addContentLine("return self();");
        };
        return Optional.of(((GeneratedMethod.Builder)((GeneratedMethod.Builder)((GeneratedMethod.Builder)GeneratedMethod.builder().method(method.build())).javadoc(this.setterJavadoc(getterJavadoc, name, ""))).contentBuilder(contentConsumer)).build());
    }

    @Override
    Optional<GeneratedMethod> prepareBuilderSingularAdd(Javadoc getterJavadoc) {
        if (this.option().singular().isEmpty()) {
            return Optional.empty();
        }
        TypeName returnType = Utils.builderReturnType();
        String name = this.option().name();
        OptionSingular optionSingular = this.option().singular().get();
        String methodName = optionSingular.methodName();
        String singularName = optionSingular.name();
        Javadoc setterJavadoc = this.setterJavadoc(getterJavadoc, singularName, "add single ");
        TypedElementInfo.Builder method = (TypedElementInfo.Builder)((TypedElementInfo.Builder)((TypedElementInfo.Builder)((TypedElementInfo.Builder)((TypedElementInfo.Builder)((TypedElementInfo.Builder)TypedElementInfo.builder().kind(ElementKind.METHOD)).accessModifier(this.option().accessModifier())).typeName(returnType)).elementName(methodName)).update(this::deprecation)).update(it -> this.option().annotations().forEach(arg_0 -> ((TypedElementInfo.Builder)it).addAnnotation(arg_0)));
        method.addParameterArgument(param -> ((TypedElementInfo.Builder)((TypedElementInfo.Builder)param.kind(ElementKind.PARAMETER)).typeName(this.type())).elementName(singularName));
        Consumer<ContentBuilder<?>> contentConsumer = it -> {
            it.addContent(Objects.class).addContentLine(".requireNonNull(" + singularName + ");");
            this.option().decorator().ifPresent(decorator -> it.addContent("new ").addContent(decorator).addContent("().decorate(this, ").addContent(singularName).addContentLine(");"));
            it.addContentLine("this." + name + ".add(" + singularName + ");");
            this.extraAdderContent((ContentBuilder<?>)it);
            it.addContentLine("return self();");
        };
        return Optional.ofNullable(((GeneratedMethod.Builder)((GeneratedMethod.Builder)((GeneratedMethod.Builder)GeneratedMethod.builder().method(method.build())).javadoc(setterJavadoc)).contentBuilder(contentConsumer)).build());
    }

    @Override
    Optional<GeneratedMethod> prepareBuilderSingularAddConsumer(Javadoc getterJavadoc) {
        if (this.option().singular().isEmpty() || this.option().builderInfo().isEmpty()) {
            return Optional.empty();
        }
        TypeName returnType = Utils.builderReturnType();
        OptionSingular optionSingular = this.option().singular().get();
        String methodName = optionSingular.methodName();
        OptionBuilder optionBuilder = this.option().builderInfo().get();
        TypeName builderType = optionBuilder.builderType();
        String builderMethod = optionBuilder.builderMethodName();
        String buildMethod = optionBuilder.buildMethodName();
        TypeName paramType = ((TypeName.Builder)((TypeName.Builder)TypeName.builder().type(Consumer.class)).addTypeArgument(builderType)).build();
        String paramName = "consumer";
        Javadoc setterJavadoc = this.setterJavadoc(getterJavadoc, paramName, "consumer of builder for ");
        TypedElementInfo.Builder method = (TypedElementInfo.Builder)((TypedElementInfo.Builder)((TypedElementInfo.Builder)((TypedElementInfo.Builder)((TypedElementInfo.Builder)((TypedElementInfo.Builder)TypedElementInfo.builder().kind(ElementKind.METHOD)).accessModifier(this.option().accessModifier())).typeName(returnType)).elementName(methodName)).update(this::deprecation)).update(it -> this.option().annotations().forEach(arg_0 -> ((TypedElementInfo.Builder)it).addAnnotation(arg_0)));
        method.addParameterArgument(param -> ((TypedElementInfo.Builder)((TypedElementInfo.Builder)param.kind(ElementKind.PARAMETER)).typeName(paramType)).elementName(paramName));
        Consumer<ContentBuilder<?>> contentConsumer = it -> {
            it.addContent(Objects.class).addContentLine(".requireNonNull(" + paramName + ");");
            it.addContent("var builder = ");
            if (optionBuilder.builderMethodName().equals("<init>")) {
                it.addContent("new ").addContent(builderType).addContentLine("();");
            } else {
                it.addContent(this.type()).addContentLine("." + builderMethod + "();");
            }
            it.addContentLine("consumer.accept(builder);").addContentLine("this." + methodName + "(builder." + buildMethod + "());").addContentLine("return self();");
        };
        return Optional.ofNullable(((GeneratedMethod.Builder)((GeneratedMethod.Builder)((GeneratedMethod.Builder)GeneratedMethod.builder().method(method.build())).javadoc(setterJavadoc)).contentBuilder(contentConsumer)).build());
    }

    @Override
    Optional<GeneratedMethod> prepareBuilderClear(Javadoc getterJavadoc) {
        TypeName returnType = Utils.builderReturnType();
        String name = this.option().name();
        Javadoc javadoc = Javadoc.builder((Javadoc)this.setterJavadoc(getterJavadoc, "ignore", "")).content(List.of("Clear all " + name + ".")).parameters(Map.of()).build();
        TypedElementInfo.Builder method = (TypedElementInfo.Builder)((TypedElementInfo.Builder)((TypedElementInfo.Builder)((TypedElementInfo.Builder)((TypedElementInfo.Builder)((TypedElementInfo.Builder)TypedElementInfo.builder().kind(ElementKind.METHOD)).accessModifier(this.option().accessModifier())).typeName(returnType)).elementName("clear" + CodegenUtil.capitalize((String)this.option().name()))).update(this::deprecation)).update(it -> this.option().annotations().forEach(arg_0 -> ((TypedElementInfo.Builder)it).addAnnotation(arg_0)));
        Consumer<ContentBuilder<?>> contentConsumer = it -> {
            this.option().decorator().ifPresent(decorator -> it.addContent("new ").addContent(decorator).addContent("().").addContent(this.decoratorSetMethodName()).addContent("(this, ").addContent(this.collectionType).addContentLine(".of());"));
            this.extraSetterContent((ContentBuilder<?>)it);
            it.addContentLine("this." + name + ".clear();").addContentLine("return self();");
        };
        return Optional.of(((GeneratedMethod.Builder)((GeneratedMethod.Builder)((GeneratedMethod.Builder)GeneratedMethod.builder().method(method.build())).javadoc(javadoc)).contentBuilder(contentConsumer)).build());
    }

    @Override
    Optional<GeneratedMethod> prepareSetterPrototypeOfRuntimeType(Javadoc getterJavadoc) {
        if (this.option().runtimeType().isEmpty()) {
            return Optional.empty();
        }
        RuntimeTypeInfo rti = this.option().runtimeType().get();
        Optional<FactoryMethod> factoryMethod = rti.factoryMethod();
        if (factoryMethod.isEmpty()) {
            return Optional.empty();
        }
        FactoryMethod fm = factoryMethod.get();
        if (!Utils.resolvedTypesEqual(fm.returnType(), this.option().declaredType())) {
            return Optional.empty();
        }
        OptionBuilder optionBuilder = rti.optionBuilder();
        String optionName = this.option().name();
        Javadoc javadoc = this.setterJavadoc(getterJavadoc, optionName, "prototype of ");
        TypeName paramType = optionBuilder.builderMethodType();
        TypedElementInfo.Builder method = (TypedElementInfo.Builder)((TypedElementInfo.Builder)((TypedElementInfo.Builder)((TypedElementInfo.Builder)((TypedElementInfo.Builder)((TypedElementInfo.Builder)TypedElementInfo.builder().kind(ElementKind.METHOD)).accessModifier(this.option().accessModifier())).typeName(Utils.builderReturnType())).elementName(this.option().setterName())).update(this::deprecation)).update(it -> this.option().annotations().forEach(arg_0 -> ((TypedElementInfo.Builder)it).addAnnotation(arg_0)));
        method.addParameterArgument(param -> ((TypedElementInfo.Builder)((TypedElementInfo.Builder)param.kind(ElementKind.PARAMETER)).typeName(paramType)).elementName(optionName));
        Consumer<ContentBuilder<?>> contentConsumer = it -> {
            it.addContent(Objects.class).addContentLine(".requireNonNull(" + optionName + ");").addContent(this.option().setterName()).addContent("(");
            it.addContent(fm.declaringType().genericTypeName()).addContent(".").addContent(fm.methodName()).addContent("(").addContent(optionName).addContent(")");
            it.addContentLine(");");
            it.addContentLine("return self();");
        };
        return Optional.of(((GeneratedMethod.Builder)((GeneratedMethod.Builder)((GeneratedMethod.Builder)GeneratedMethod.builder().method(method.build())).javadoc(javadoc)).contentBuilder(contentConsumer)).build());
    }

    private void newCollectionInstanceWithoutParams(ContentBuilder<?> content) {
        content.addContent("new ").addContent(this.collectionImplType.genericTypeName()).addContent("<>");
    }
}

