/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.builder.codegen;

import io.helidon.builder.api.Prototype;
import io.helidon.builder.codegen.DeprecatedFactoryMethod;
import io.helidon.builder.codegen.FactoryMethod;
import io.helidon.builder.codegen.GeneratedMethod;
import io.helidon.builder.codegen.PrototypeConfigured;
import io.helidon.builder.codegen.PrototypeConstant;
import io.helidon.builder.codegen.RuntimeTypeInfo;
import io.helidon.codegen.classmodel.Javadoc;
import io.helidon.common.Errors;
import io.helidon.common.types.AccessModifier;
import io.helidon.common.types.Annotated;
import io.helidon.common.types.Annotation;
import io.helidon.common.types.TypeInfo;
import io.helidon.common.types.TypeName;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;

public interface PrototypeInfo
extends Prototype.Api,
Annotated {
    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(PrototypeInfo instance) {
        return (Builder)PrototypeInfo.builder().from(instance);
    }

    public TypeInfo blueprint();

    public Optional<TypeName> runtimeType();

    public Javadoc javadoc();

    public Javadoc builderBaseJavadoc();

    public Javadoc builderJavadoc();

    public Optional<TypeName> builderDecorator();

    public TypeName prototypeType();

    public Predicate<String> defaultMethodsPredicate();

    public AccessModifier accessModifier();

    public AccessModifier builderAccessModifier();

    public boolean createEmptyCreate();

    public boolean recordStyle();

    public Optional<PrototypeConfigured> configured();

    public boolean registrySupport();

    public boolean detachBlueprint();

    public Optional<TypeName> superPrototype();

    public Set<TypeName> superTypes();

    public Set<TypeName> providerProvides();

    public List<PrototypeConstant> constants();

    public List<GeneratedMethod> prototypeMethods();

    public List<GeneratedMethod> builderMethods();

    @Deprecated(since="4.4.0", forRemoval=true)
    public List<DeprecatedFactoryMethod> deprecatedFactoryMethods();

    public List<GeneratedMethod> prototypeFactories();

    public List<FactoryMethod> configFactories();

    public List<RuntimeTypeInfo> runtimeTypeFactories();

    public static class Builder
    extends BuilderBase<Builder, PrototypeInfo>
    implements io.helidon.common.Builder<Builder, PrototypeInfo> {
        private Builder() {
        }

        public PrototypeInfo buildPrototype() {
            this.preBuildPrototype();
            this.validatePrototype();
            return new BuilderBase.PrototypeInfoImpl(this);
        }

        public PrototypeInfo build() {
            return this.buildPrototype();
        }
    }

    public static abstract class BuilderBase<BUILDER extends BuilderBase<BUILDER, PROTOTYPE>, PROTOTYPE extends PrototypeInfo>
    implements Prototype.Builder<BUILDER, PROTOTYPE> {
        private final List<DeprecatedFactoryMethod> deprecatedFactoryMethods = new ArrayList<DeprecatedFactoryMethod>();
        private final List<FactoryMethod> configFactories = new ArrayList<FactoryMethod>();
        private final List<GeneratedMethod> builderMethods = new ArrayList<GeneratedMethod>();
        private final List<GeneratedMethod> prototypeFactories = new ArrayList<GeneratedMethod>();
        private final List<GeneratedMethod> prototypeMethods = new ArrayList<GeneratedMethod>();
        private final List<PrototypeConstant> constants = new ArrayList<PrototypeConstant>();
        private final List<RuntimeTypeInfo> runtimeTypeFactories = new ArrayList<RuntimeTypeInfo>();
        private final List<Annotation> annotations = new ArrayList<Annotation>();
        private final List<Annotation> inheritedAnnotations = new ArrayList<Annotation>();
        private final Set<TypeName> providerProvides = new LinkedHashSet<TypeName>();
        private final Set<TypeName> superTypes = new LinkedHashSet<TypeName>();
        private AccessModifier accessModifier = AccessModifier.PUBLIC;
        private AccessModifier builderAccessModifier = AccessModifier.PUBLIC;
        private boolean createEmptyCreate = true;
        private boolean detachBlueprint = false;
        private boolean isAnnotationsMutated;
        private boolean isBuilderMethodsMutated;
        private boolean isConfigFactoriesMutated;
        private boolean isConstantsMutated;
        private boolean isDeprecatedFactoryMethodsMutated;
        private boolean isInheritedAnnotationsMutated;
        private boolean isPrototypeFactoriesMutated;
        private boolean isPrototypeMethodsMutated;
        private boolean isProviderProvidesMutated;
        private boolean isRuntimeTypeFactoriesMutated;
        private boolean isSuperTypesMutated;
        private boolean recordStyle = true;
        private boolean registrySupport;
        private Javadoc builderBaseJavadoc;
        private Javadoc builderJavadoc;
        private Javadoc javadoc;
        private Predicate<String> defaultMethodsPredicate = it -> false;
        private PrototypeConfigured configured;
        private TypeInfo blueprint;
        private TypeName builderDecorator;
        private TypeName prototypeType;
        private TypeName runtimeType;
        private TypeName superPrototype;

        protected BuilderBase() {
        }

        public BUILDER from(PrototypeInfo prototype) {
            this.blueprint(prototype.blueprint());
            this.runtimeType(prototype.runtimeType());
            this.javadoc(prototype.javadoc());
            this.builderBaseJavadoc(prototype.builderBaseJavadoc());
            this.builderJavadoc(prototype.builderJavadoc());
            this.builderDecorator(prototype.builderDecorator());
            this.prototypeType(prototype.prototypeType());
            this.defaultMethodsPredicate(prototype.defaultMethodsPredicate());
            this.accessModifier(prototype.accessModifier());
            this.builderAccessModifier(prototype.builderAccessModifier());
            this.createEmptyCreate(prototype.createEmptyCreate());
            this.recordStyle(prototype.recordStyle());
            this.configured(prototype.configured());
            this.registrySupport(prototype.registrySupport());
            this.detachBlueprint(prototype.detachBlueprint());
            this.superPrototype(prototype.superPrototype());
            if (!this.isSuperTypesMutated) {
                this.superTypes.clear();
            }
            this.addSuperTypes(prototype.superTypes());
            if (!this.isProviderProvidesMutated) {
                this.providerProvides.clear();
            }
            this.addProviderProvides(prototype.providerProvides());
            if (!this.isConstantsMutated) {
                this.constants.clear();
            }
            this.addConstants(prototype.constants());
            if (!this.isPrototypeMethodsMutated) {
                this.prototypeMethods.clear();
            }
            this.addPrototypeMethods(prototype.prototypeMethods());
            if (!this.isBuilderMethodsMutated) {
                this.builderMethods.clear();
            }
            this.addBuilderMethods(prototype.builderMethods());
            if (!this.isDeprecatedFactoryMethodsMutated) {
                this.deprecatedFactoryMethods.clear();
            }
            this.addDeprecatedFactoryMethods(prototype.deprecatedFactoryMethods());
            if (!this.isPrototypeFactoriesMutated) {
                this.prototypeFactories.clear();
            }
            this.addPrototypeFactories(prototype.prototypeFactories());
            if (!this.isConfigFactoriesMutated) {
                this.configFactories.clear();
            }
            this.addConfigFactories(prototype.configFactories());
            if (!this.isRuntimeTypeFactoriesMutated) {
                this.runtimeTypeFactories.clear();
            }
            this.addRuntimeTypeFactories(prototype.runtimeTypeFactories());
            if (!this.isAnnotationsMutated) {
                this.annotations.clear();
            }
            this.addAnnotations(prototype.annotations());
            if (!this.isInheritedAnnotationsMutated) {
                this.inheritedAnnotations.clear();
            }
            this.addInheritedAnnotations(prototype.inheritedAnnotations());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER from(BuilderBase<?, ?> builder) {
            builder.blueprint().ifPresent(this::blueprint);
            builder.runtimeType().ifPresent(this::runtimeType);
            builder.javadoc().ifPresent(this::javadoc);
            builder.builderBaseJavadoc().ifPresent(this::builderBaseJavadoc);
            builder.builderJavadoc().ifPresent(this::builderJavadoc);
            builder.builderDecorator().ifPresent(this::builderDecorator);
            builder.prototypeType().ifPresent(this::prototypeType);
            this.defaultMethodsPredicate(builder.defaultMethodsPredicate());
            this.accessModifier(builder.accessModifier());
            this.builderAccessModifier(builder.builderAccessModifier());
            this.createEmptyCreate(builder.createEmptyCreate());
            this.recordStyle(builder.recordStyle());
            builder.configured().ifPresent(this::configured);
            this.registrySupport(builder.registrySupport());
            this.detachBlueprint(builder.detachBlueprint());
            builder.superPrototype().ifPresent(this::superPrototype);
            if (this.isSuperTypesMutated) {
                if (builder.isSuperTypesMutated) {
                    this.addSuperTypes(builder.superTypes());
                }
            } else {
                this.superTypes(builder.superTypes());
            }
            if (this.isProviderProvidesMutated) {
                if (builder.isProviderProvidesMutated) {
                    this.addProviderProvides(builder.providerProvides());
                }
            } else {
                this.providerProvides(builder.providerProvides());
            }
            if (this.isConstantsMutated) {
                if (builder.isConstantsMutated) {
                    this.addConstants(builder.constants());
                }
            } else {
                this.constants(builder.constants());
            }
            if (this.isPrototypeMethodsMutated) {
                if (builder.isPrototypeMethodsMutated) {
                    this.addPrototypeMethods(builder.prototypeMethods());
                }
            } else {
                this.prototypeMethods(builder.prototypeMethods());
            }
            if (this.isBuilderMethodsMutated) {
                if (builder.isBuilderMethodsMutated) {
                    this.addBuilderMethods(builder.builderMethods());
                }
            } else {
                this.builderMethods(builder.builderMethods());
            }
            if (this.isDeprecatedFactoryMethodsMutated) {
                if (builder.isDeprecatedFactoryMethodsMutated) {
                    this.addDeprecatedFactoryMethods(builder.deprecatedFactoryMethods());
                }
            } else {
                this.deprecatedFactoryMethods(builder.deprecatedFactoryMethods());
            }
            if (this.isPrototypeFactoriesMutated) {
                if (builder.isPrototypeFactoriesMutated) {
                    this.addPrototypeFactories(builder.prototypeFactories());
                }
            } else {
                this.prototypeFactories(builder.prototypeFactories());
            }
            if (this.isConfigFactoriesMutated) {
                if (builder.isConfigFactoriesMutated) {
                    this.addConfigFactories(builder.configFactories());
                }
            } else {
                this.configFactories(builder.configFactories());
            }
            if (this.isRuntimeTypeFactoriesMutated) {
                if (builder.isRuntimeTypeFactoriesMutated) {
                    this.addRuntimeTypeFactories(builder.runtimeTypeFactories());
                }
            } else {
                this.runtimeTypeFactories(builder.runtimeTypeFactories());
            }
            if (this.isAnnotationsMutated) {
                if (builder.isAnnotationsMutated) {
                    this.addAnnotations(builder.annotations());
                }
            } else {
                this.annotations(builder.annotations());
            }
            if (this.isInheritedAnnotationsMutated) {
                if (builder.isInheritedAnnotationsMutated) {
                    this.addInheritedAnnotations(builder.inheritedAnnotations());
                }
            } else {
                this.inheritedAnnotations(builder.inheritedAnnotations());
            }
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER blueprint(TypeInfo blueprint) {
            Objects.requireNonNull(blueprint);
            this.blueprint = blueprint;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER blueprint(Consumer<TypeInfo.Builder> consumer) {
            Objects.requireNonNull(consumer);
            TypeInfo.Builder builder = TypeInfo.builder();
            consumer.accept(builder);
            this.blueprint(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER blueprint(Supplier<? extends TypeInfo> supplier) {
            Objects.requireNonNull(supplier);
            this.blueprint(supplier.get());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearRuntimeType() {
            this.runtimeType = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER runtimeType(TypeName runtimeType) {
            Objects.requireNonNull(runtimeType);
            this.runtimeType = runtimeType;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER runtimeType(Consumer<TypeName.Builder> consumer) {
            Objects.requireNonNull(consumer);
            TypeName.Builder builder = TypeName.builder();
            consumer.accept(builder);
            this.runtimeType(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER runtimeType(Supplier<? extends TypeName> supplier) {
            Objects.requireNonNull(supplier);
            this.runtimeType(supplier.get());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER javadoc(Javadoc javadoc) {
            Objects.requireNonNull(javadoc);
            this.javadoc = javadoc;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER javadoc(Consumer<Javadoc.Builder> consumer) {
            Objects.requireNonNull(consumer);
            Javadoc.Builder builder = Javadoc.builder();
            consumer.accept(builder);
            this.javadoc(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER javadoc(Supplier<? extends Javadoc> supplier) {
            Objects.requireNonNull(supplier);
            this.javadoc(supplier.get());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER builderBaseJavadoc(Javadoc builderBaseJavadoc) {
            Objects.requireNonNull(builderBaseJavadoc);
            this.builderBaseJavadoc = builderBaseJavadoc;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER builderBaseJavadoc(Consumer<Javadoc.Builder> consumer) {
            Objects.requireNonNull(consumer);
            Javadoc.Builder builder = Javadoc.builder();
            consumer.accept(builder);
            this.builderBaseJavadoc(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER builderBaseJavadoc(Supplier<? extends Javadoc> supplier) {
            Objects.requireNonNull(supplier);
            this.builderBaseJavadoc(supplier.get());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER builderJavadoc(Javadoc builderJavadoc) {
            Objects.requireNonNull(builderJavadoc);
            this.builderJavadoc = builderJavadoc;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER builderJavadoc(Consumer<Javadoc.Builder> consumer) {
            Objects.requireNonNull(consumer);
            Javadoc.Builder builder = Javadoc.builder();
            consumer.accept(builder);
            this.builderJavadoc(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER builderJavadoc(Supplier<? extends Javadoc> supplier) {
            Objects.requireNonNull(supplier);
            this.builderJavadoc(supplier.get());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearBuilderDecorator() {
            this.builderDecorator = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER builderDecorator(TypeName builderDecorator) {
            Objects.requireNonNull(builderDecorator);
            this.builderDecorator = builderDecorator;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER builderDecorator(Consumer<TypeName.Builder> consumer) {
            Objects.requireNonNull(consumer);
            TypeName.Builder builder = TypeName.builder();
            consumer.accept(builder);
            this.builderDecorator(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER builderDecorator(Supplier<? extends TypeName> supplier) {
            Objects.requireNonNull(supplier);
            this.builderDecorator(supplier.get());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER prototypeType(TypeName prototypeType) {
            Objects.requireNonNull(prototypeType);
            this.prototypeType = prototypeType;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER prototypeType(Consumer<TypeName.Builder> consumer) {
            Objects.requireNonNull(consumer);
            TypeName.Builder builder = TypeName.builder();
            consumer.accept(builder);
            this.prototypeType(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER prototypeType(Supplier<? extends TypeName> supplier) {
            Objects.requireNonNull(supplier);
            this.prototypeType(supplier.get());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER defaultMethodsPredicate(Predicate<String> defaultMethodsPredicate) {
            Objects.requireNonNull(defaultMethodsPredicate);
            this.defaultMethodsPredicate = defaultMethodsPredicate;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER accessModifier(AccessModifier accessModifier) {
            Objects.requireNonNull(accessModifier);
            this.accessModifier = accessModifier;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER builderAccessModifier(AccessModifier builderAccessModifier) {
            Objects.requireNonNull(builderAccessModifier);
            this.builderAccessModifier = builderAccessModifier;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER createEmptyCreate(boolean createEmptyCreate) {
            this.createEmptyCreate = createEmptyCreate;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER recordStyle(boolean recordStyle) {
            this.recordStyle = recordStyle;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearConfigured() {
            this.configured = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER configured(PrototypeConfigured configured) {
            Objects.requireNonNull(configured);
            this.configured = configured;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER configured(Consumer<PrototypeConfigured.Builder> consumer) {
            Objects.requireNonNull(consumer);
            PrototypeConfigured.Builder builder = PrototypeConfigured.builder();
            consumer.accept(builder);
            this.configured(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER configured(Supplier<? extends PrototypeConfigured> supplier) {
            Objects.requireNonNull(supplier);
            this.configured(supplier.get());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER registrySupport(boolean registrySupport) {
            this.registrySupport = registrySupport;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER detachBlueprint(boolean detachBlueprint) {
            this.detachBlueprint = detachBlueprint;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearSuperPrototype() {
            this.superPrototype = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER superPrototype(TypeName superPrototype) {
            Objects.requireNonNull(superPrototype);
            this.superPrototype = superPrototype;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER superPrototype(Consumer<TypeName.Builder> consumer) {
            Objects.requireNonNull(consumer);
            TypeName.Builder builder = TypeName.builder();
            consumer.accept(builder);
            this.superPrototype(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER superPrototype(Supplier<? extends TypeName> supplier) {
            Objects.requireNonNull(supplier);
            this.superPrototype(supplier.get());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearSuperTypes() {
            this.isSuperTypesMutated = true;
            this.superTypes.clear();
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER superTypes(Set<? extends TypeName> superTypes) {
            Objects.requireNonNull(superTypes);
            this.isSuperTypesMutated = true;
            this.superTypes.clear();
            this.superTypes.addAll(superTypes);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addSuperTypes(Set<? extends TypeName> superTypes) {
            Objects.requireNonNull(superTypes);
            this.isSuperTypesMutated = true;
            this.superTypes.addAll(superTypes);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addSuperType(TypeName superType) {
            Objects.requireNonNull(superType);
            this.superTypes.add(superType);
            this.isSuperTypesMutated = true;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addSuperType(Consumer<TypeName.Builder> consumer) {
            Objects.requireNonNull(consumer);
            TypeName.Builder builder = TypeName.builder();
            consumer.accept(builder);
            this.addSuperType(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearProviderProvides() {
            this.isProviderProvidesMutated = true;
            this.providerProvides.clear();
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER providerProvides(Set<? extends TypeName> providerProvides) {
            Objects.requireNonNull(providerProvides);
            this.isProviderProvidesMutated = true;
            this.providerProvides.clear();
            this.providerProvides.addAll(providerProvides);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addProviderProvides(Set<? extends TypeName> providerProvides) {
            Objects.requireNonNull(providerProvides);
            this.isProviderProvidesMutated = true;
            this.providerProvides.addAll(providerProvides);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addProviderProvide(TypeName providerProvide) {
            Objects.requireNonNull(providerProvide);
            this.providerProvides.add(providerProvide);
            this.isProviderProvidesMutated = true;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addProviderProvide(Consumer<TypeName.Builder> consumer) {
            Objects.requireNonNull(consumer);
            TypeName.Builder builder = TypeName.builder();
            consumer.accept(builder);
            this.addProviderProvide(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearConstants() {
            this.isConstantsMutated = true;
            this.constants.clear();
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER constants(List<? extends PrototypeConstant> constants) {
            Objects.requireNonNull(constants);
            this.isConstantsMutated = true;
            this.constants.clear();
            this.constants.addAll(constants);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addConstants(List<? extends PrototypeConstant> constants) {
            Objects.requireNonNull(constants);
            this.isConstantsMutated = true;
            this.constants.addAll(constants);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addConstant(PrototypeConstant constant) {
            Objects.requireNonNull(constant);
            this.constants.add(constant);
            this.isConstantsMutated = true;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addConstant(Consumer<PrototypeConstant.Builder> consumer) {
            Objects.requireNonNull(consumer);
            PrototypeConstant.Builder builder = PrototypeConstant.builder();
            consumer.accept(builder);
            this.addConstant(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearPrototypeMethods() {
            this.isPrototypeMethodsMutated = true;
            this.prototypeMethods.clear();
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER prototypeMethods(List<? extends GeneratedMethod> prototypeMethods) {
            Objects.requireNonNull(prototypeMethods);
            this.isPrototypeMethodsMutated = true;
            this.prototypeMethods.clear();
            this.prototypeMethods.addAll(prototypeMethods);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addPrototypeMethods(List<? extends GeneratedMethod> prototypeMethods) {
            Objects.requireNonNull(prototypeMethods);
            this.isPrototypeMethodsMutated = true;
            this.prototypeMethods.addAll(prototypeMethods);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addPrototypeMethod(GeneratedMethod prototypeMethod) {
            Objects.requireNonNull(prototypeMethod);
            this.prototypeMethods.add(prototypeMethod);
            this.isPrototypeMethodsMutated = true;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addPrototypeMethod(Consumer<GeneratedMethod.Builder> consumer) {
            Objects.requireNonNull(consumer);
            GeneratedMethod.Builder builder = GeneratedMethod.builder();
            consumer.accept(builder);
            this.addPrototypeMethod(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearBuilderMethods() {
            this.isBuilderMethodsMutated = true;
            this.builderMethods.clear();
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER builderMethods(List<? extends GeneratedMethod> builderMethods) {
            Objects.requireNonNull(builderMethods);
            this.isBuilderMethodsMutated = true;
            this.builderMethods.clear();
            this.builderMethods.addAll(builderMethods);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addBuilderMethods(List<? extends GeneratedMethod> builderMethods) {
            Objects.requireNonNull(builderMethods);
            this.isBuilderMethodsMutated = true;
            this.builderMethods.addAll(builderMethods);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addBuilderMethod(GeneratedMethod builderMethod) {
            Objects.requireNonNull(builderMethod);
            this.builderMethods.add(builderMethod);
            this.isBuilderMethodsMutated = true;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addBuilderMethod(Consumer<GeneratedMethod.Builder> consumer) {
            Objects.requireNonNull(consumer);
            GeneratedMethod.Builder builder = GeneratedMethod.builder();
            consumer.accept(builder);
            this.addBuilderMethod(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        @Deprecated(since="4.4.0", forRemoval=true)
        public BUILDER clearDeprecatedFactoryMethods() {
            this.isDeprecatedFactoryMethodsMutated = true;
            this.deprecatedFactoryMethods.clear();
            return (BUILDER)((BuilderBase)this.self());
        }

        @Deprecated(since="4.4.0", forRemoval=true)
        public BUILDER deprecatedFactoryMethods(List<? extends DeprecatedFactoryMethod> deprecatedFactoryMethods) {
            Objects.requireNonNull(deprecatedFactoryMethods);
            this.isDeprecatedFactoryMethodsMutated = true;
            this.deprecatedFactoryMethods.clear();
            this.deprecatedFactoryMethods.addAll(deprecatedFactoryMethods);
            return (BUILDER)((BuilderBase)this.self());
        }

        @Deprecated(since="4.4.0", forRemoval=true)
        public BUILDER addDeprecatedFactoryMethods(List<? extends DeprecatedFactoryMethod> deprecatedFactoryMethods) {
            Objects.requireNonNull(deprecatedFactoryMethods);
            this.isDeprecatedFactoryMethodsMutated = true;
            this.deprecatedFactoryMethods.addAll(deprecatedFactoryMethods);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearPrototypeFactories() {
            this.isPrototypeFactoriesMutated = true;
            this.prototypeFactories.clear();
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER prototypeFactories(List<? extends GeneratedMethod> prototypeFactories) {
            Objects.requireNonNull(prototypeFactories);
            this.isPrototypeFactoriesMutated = true;
            this.prototypeFactories.clear();
            this.prototypeFactories.addAll(prototypeFactories);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addPrototypeFactories(List<? extends GeneratedMethod> prototypeFactories) {
            Objects.requireNonNull(prototypeFactories);
            this.isPrototypeFactoriesMutated = true;
            this.prototypeFactories.addAll(prototypeFactories);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addPrototypeFactory(GeneratedMethod prototypeFactory) {
            Objects.requireNonNull(prototypeFactory);
            this.prototypeFactories.add(prototypeFactory);
            this.isPrototypeFactoriesMutated = true;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addPrototypeFactory(Consumer<GeneratedMethod.Builder> consumer) {
            Objects.requireNonNull(consumer);
            GeneratedMethod.Builder builder = GeneratedMethod.builder();
            consumer.accept(builder);
            this.addPrototypeFactory(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearConfigFactories() {
            this.isConfigFactoriesMutated = true;
            this.configFactories.clear();
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER configFactories(List<? extends FactoryMethod> configFactories) {
            Objects.requireNonNull(configFactories);
            this.isConfigFactoriesMutated = true;
            this.configFactories.clear();
            this.configFactories.addAll(configFactories);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addConfigFactories(List<? extends FactoryMethod> configFactories) {
            Objects.requireNonNull(configFactories);
            this.isConfigFactoriesMutated = true;
            this.configFactories.addAll(configFactories);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addConfigFactory(FactoryMethod configFactory) {
            Objects.requireNonNull(configFactory);
            this.configFactories.add(configFactory);
            this.isConfigFactoriesMutated = true;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addConfigFactory(Consumer<FactoryMethod.Builder> consumer) {
            Objects.requireNonNull(consumer);
            FactoryMethod.Builder builder = FactoryMethod.builder();
            consumer.accept(builder);
            this.addConfigFactory(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearRuntimeTypeFactories() {
            this.isRuntimeTypeFactoriesMutated = true;
            this.runtimeTypeFactories.clear();
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER runtimeTypeFactories(List<? extends RuntimeTypeInfo> runtimeTypeFactories) {
            Objects.requireNonNull(runtimeTypeFactories);
            this.isRuntimeTypeFactoriesMutated = true;
            this.runtimeTypeFactories.clear();
            this.runtimeTypeFactories.addAll(runtimeTypeFactories);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addRuntimeTypeFactories(List<? extends RuntimeTypeInfo> runtimeTypeFactories) {
            Objects.requireNonNull(runtimeTypeFactories);
            this.isRuntimeTypeFactoriesMutated = true;
            this.runtimeTypeFactories.addAll(runtimeTypeFactories);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addRuntimeTypeFactory(RuntimeTypeInfo runtimeTypeFactory) {
            Objects.requireNonNull(runtimeTypeFactory);
            this.runtimeTypeFactories.add(runtimeTypeFactory);
            this.isRuntimeTypeFactoriesMutated = true;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addRuntimeTypeFactory(Consumer<RuntimeTypeInfo.Builder> consumer) {
            Objects.requireNonNull(consumer);
            RuntimeTypeInfo.Builder builder = RuntimeTypeInfo.builder();
            consumer.accept(builder);
            this.addRuntimeTypeFactory(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearAnnotations() {
            this.isAnnotationsMutated = true;
            this.annotations.clear();
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER annotations(List<? extends Annotation> annotations) {
            Objects.requireNonNull(annotations);
            this.isAnnotationsMutated = true;
            this.annotations.clear();
            this.annotations.addAll(annotations);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addAnnotations(List<? extends Annotation> annotations) {
            Objects.requireNonNull(annotations);
            this.isAnnotationsMutated = true;
            this.annotations.addAll(annotations);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addAnnotation(Annotation annotation) {
            Objects.requireNonNull(annotation);
            this.annotations.add(annotation);
            this.isAnnotationsMutated = true;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addAnnotation(Consumer<Annotation.Builder> consumer) {
            Objects.requireNonNull(consumer);
            Annotation.Builder builder = Annotation.builder();
            consumer.accept(builder);
            this.addAnnotation(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearInheritedAnnotations() {
            this.isInheritedAnnotationsMutated = true;
            this.inheritedAnnotations.clear();
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER inheritedAnnotations(List<? extends Annotation> inheritedAnnotations) {
            Objects.requireNonNull(inheritedAnnotations);
            this.isInheritedAnnotationsMutated = true;
            this.inheritedAnnotations.clear();
            this.inheritedAnnotations.addAll(inheritedAnnotations);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addInheritedAnnotations(List<? extends Annotation> inheritedAnnotations) {
            Objects.requireNonNull(inheritedAnnotations);
            this.isInheritedAnnotationsMutated = true;
            this.inheritedAnnotations.addAll(inheritedAnnotations);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addInheritedAnnotation(Annotation inheritedAnnotation) {
            Objects.requireNonNull(inheritedAnnotation);
            this.inheritedAnnotations.add(inheritedAnnotation);
            this.isInheritedAnnotationsMutated = true;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addInheritedAnnotation(Consumer<Annotation.Builder> consumer) {
            Objects.requireNonNull(consumer);
            Annotation.Builder builder = Annotation.builder();
            consumer.accept(builder);
            this.addInheritedAnnotation(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public Optional<TypeInfo> blueprint() {
            return Optional.ofNullable(this.blueprint);
        }

        public Optional<TypeName> runtimeType() {
            return Optional.ofNullable(this.runtimeType);
        }

        public Optional<Javadoc> javadoc() {
            return Optional.ofNullable(this.javadoc);
        }

        public Optional<Javadoc> builderBaseJavadoc() {
            return Optional.ofNullable(this.builderBaseJavadoc);
        }

        public Optional<Javadoc> builderJavadoc() {
            return Optional.ofNullable(this.builderJavadoc);
        }

        public Optional<TypeName> builderDecorator() {
            return Optional.ofNullable(this.builderDecorator);
        }

        public Optional<TypeName> prototypeType() {
            return Optional.ofNullable(this.prototypeType);
        }

        public Predicate<String> defaultMethodsPredicate() {
            return this.defaultMethodsPredicate;
        }

        public AccessModifier accessModifier() {
            return this.accessModifier;
        }

        public AccessModifier builderAccessModifier() {
            return this.builderAccessModifier;
        }

        public boolean createEmptyCreate() {
            return this.createEmptyCreate;
        }

        public boolean recordStyle() {
            return this.recordStyle;
        }

        public Optional<PrototypeConfigured> configured() {
            return Optional.ofNullable(this.configured);
        }

        public boolean registrySupport() {
            return this.registrySupport;
        }

        public boolean detachBlueprint() {
            return this.detachBlueprint;
        }

        public Optional<TypeName> superPrototype() {
            return Optional.ofNullable(this.superPrototype);
        }

        public Set<TypeName> superTypes() {
            return this.superTypes;
        }

        public Set<TypeName> providerProvides() {
            return this.providerProvides;
        }

        public List<PrototypeConstant> constants() {
            return this.constants;
        }

        public List<GeneratedMethod> prototypeMethods() {
            return this.prototypeMethods;
        }

        public List<GeneratedMethod> builderMethods() {
            return this.builderMethods;
        }

        @Deprecated(since="4.4.0", forRemoval=true)
        public List<DeprecatedFactoryMethod> deprecatedFactoryMethods() {
            return this.deprecatedFactoryMethods;
        }

        public List<GeneratedMethod> prototypeFactories() {
            return this.prototypeFactories;
        }

        public List<FactoryMethod> configFactories() {
            return this.configFactories;
        }

        public List<RuntimeTypeInfo> runtimeTypeFactories() {
            return this.runtimeTypeFactories;
        }

        public List<Annotation> annotations() {
            return this.annotations;
        }

        public List<Annotation> inheritedAnnotations() {
            return this.inheritedAnnotations;
        }

        public String toString() {
            return "PrototypeInfoBuilder{blueprint=" + String.valueOf(this.blueprint) + ",runtimeType=" + String.valueOf(this.runtimeType) + ",javadoc=" + String.valueOf(this.javadoc) + ",builderBaseJavadoc=" + String.valueOf(this.builderBaseJavadoc) + ",builderJavadoc=" + String.valueOf(this.builderJavadoc) + ",builderDecorator=" + String.valueOf(this.builderDecorator) + ",prototypeType=" + String.valueOf(this.prototypeType) + ",defaultMethodsPredicate=" + String.valueOf(this.defaultMethodsPredicate) + ",accessModifier=" + String.valueOf(this.accessModifier) + ",builderAccessModifier=" + String.valueOf(this.builderAccessModifier) + ",createEmptyCreate=" + this.createEmptyCreate + ",recordStyle=" + this.recordStyle + ",configured=" + String.valueOf(this.configured) + ",registrySupport=" + this.registrySupport + ",detachBlueprint=" + this.detachBlueprint + ",superPrototype=" + String.valueOf(this.superPrototype) + ",superTypes=" + String.valueOf(this.superTypes) + ",providerProvides=" + String.valueOf(this.providerProvides) + ",constants=" + String.valueOf(this.constants) + ",prototypeMethods=" + String.valueOf(this.prototypeMethods) + ",builderMethods=" + String.valueOf(this.builderMethods) + ",deprecatedFactoryMethods=" + String.valueOf(this.deprecatedFactoryMethods) + ",prototypeFactories=" + String.valueOf(this.prototypeFactories) + ",configFactories=" + String.valueOf(this.configFactories) + ",runtimeTypeFactories=" + String.valueOf(this.runtimeTypeFactories) + ",annotations=" + String.valueOf(this.annotations) + ",inheritedAnnotations=" + String.valueOf(this.inheritedAnnotations) + "}";
        }

        protected void preBuildPrototype() {
        }

        protected void validatePrototype() {
            Errors.Collector collector = Errors.collector();
            if (this.blueprint == null) {
                collector.fatal(this.getClass(), "Property \"blueprint\" must not be null, but not set");
            }
            if (this.javadoc == null) {
                collector.fatal(this.getClass(), "Property \"javadoc\" must not be null, but not set");
            }
            if (this.builderBaseJavadoc == null) {
                collector.fatal(this.getClass(), "Property \"builderBaseJavadoc\" must not be null, but not set");
            }
            if (this.builderJavadoc == null) {
                collector.fatal(this.getClass(), "Property \"builderJavadoc\" must not be null, but not set");
            }
            if (this.prototypeType == null) {
                collector.fatal(this.getClass(), "Property \"prototypeType\" must not be null, but not set");
            }
            collector.collect().checkValid();
        }

        BUILDER runtimeType(Optional<? extends TypeName> runtimeType) {
            Objects.requireNonNull(runtimeType);
            this.runtimeType = runtimeType.map(TypeName.class::cast).orElse(this.runtimeType);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER builderDecorator(Optional<? extends TypeName> builderDecorator) {
            Objects.requireNonNull(builderDecorator);
            this.builderDecorator = builderDecorator.map(TypeName.class::cast).orElse(this.builderDecorator);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER configured(Optional<? extends PrototypeConfigured> configured) {
            Objects.requireNonNull(configured);
            this.configured = configured.map(PrototypeConfigured.class::cast).orElse(this.configured);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER superPrototype(Optional<? extends TypeName> superPrototype) {
            Objects.requireNonNull(superPrototype);
            this.superPrototype = superPrototype.map(TypeName.class::cast).orElse(this.superPrototype);
            return (BUILDER)((BuilderBase)this.self());
        }

        protected static class PrototypeInfoImpl
        implements PrototypeInfo {
            private final AccessModifier accessModifier;
            private final AccessModifier builderAccessModifier;
            private final boolean createEmptyCreate;
            private final boolean detachBlueprint;
            private final boolean recordStyle;
            private final boolean registrySupport;
            private final Javadoc builderBaseJavadoc;
            private final Javadoc builderJavadoc;
            private final Javadoc javadoc;
            private final List<DeprecatedFactoryMethod> deprecatedFactoryMethods;
            private final List<FactoryMethod> configFactories;
            private final List<GeneratedMethod> builderMethods;
            private final List<GeneratedMethod> prototypeFactories;
            private final List<GeneratedMethod> prototypeMethods;
            private final List<PrototypeConstant> constants;
            private final List<RuntimeTypeInfo> runtimeTypeFactories;
            private final List<Annotation> annotations;
            private final List<Annotation> inheritedAnnotations;
            private final Optional<PrototypeConfigured> configured;
            private final Optional<TypeName> builderDecorator;
            private final Optional<TypeName> runtimeType;
            private final Optional<TypeName> superPrototype;
            private final Predicate<String> defaultMethodsPredicate;
            private final Set<TypeName> providerProvides;
            private final Set<TypeName> superTypes;
            private final TypeInfo blueprint;
            private final TypeName prototypeType;

            protected PrototypeInfoImpl(BuilderBase<?, ?> builder) {
                this.blueprint = builder.blueprint().get();
                this.runtimeType = builder.runtimeType().map(Function.identity());
                this.javadoc = builder.javadoc().get();
                this.builderBaseJavadoc = builder.builderBaseJavadoc().get();
                this.builderJavadoc = builder.builderJavadoc().get();
                this.builderDecorator = builder.builderDecorator().map(Function.identity());
                this.prototypeType = builder.prototypeType().get();
                this.defaultMethodsPredicate = builder.defaultMethodsPredicate();
                this.accessModifier = builder.accessModifier();
                this.builderAccessModifier = builder.builderAccessModifier();
                this.createEmptyCreate = builder.createEmptyCreate();
                this.recordStyle = builder.recordStyle();
                this.configured = builder.configured().map(Function.identity());
                this.registrySupport = builder.registrySupport();
                this.detachBlueprint = builder.detachBlueprint();
                this.superPrototype = builder.superPrototype().map(Function.identity());
                this.superTypes = Collections.unmodifiableSet(new LinkedHashSet<TypeName>(builder.superTypes()));
                this.providerProvides = Collections.unmodifiableSet(new LinkedHashSet<TypeName>(builder.providerProvides()));
                this.constants = List.copyOf(builder.constants());
                this.prototypeMethods = List.copyOf(builder.prototypeMethods());
                this.builderMethods = List.copyOf(builder.builderMethods());
                this.deprecatedFactoryMethods = List.copyOf(builder.deprecatedFactoryMethods());
                this.prototypeFactories = List.copyOf(builder.prototypeFactories());
                this.configFactories = List.copyOf(builder.configFactories());
                this.runtimeTypeFactories = List.copyOf(builder.runtimeTypeFactories());
                this.annotations = List.copyOf(builder.annotations());
                this.inheritedAnnotations = List.copyOf(builder.inheritedAnnotations());
            }

            @Override
            public TypeInfo blueprint() {
                return this.blueprint;
            }

            @Override
            public Optional<TypeName> runtimeType() {
                return this.runtimeType;
            }

            @Override
            public Javadoc javadoc() {
                return this.javadoc;
            }

            @Override
            public Javadoc builderBaseJavadoc() {
                return this.builderBaseJavadoc;
            }

            @Override
            public Javadoc builderJavadoc() {
                return this.builderJavadoc;
            }

            @Override
            public Optional<TypeName> builderDecorator() {
                return this.builderDecorator;
            }

            @Override
            public TypeName prototypeType() {
                return this.prototypeType;
            }

            @Override
            public Predicate<String> defaultMethodsPredicate() {
                return this.defaultMethodsPredicate;
            }

            @Override
            public AccessModifier accessModifier() {
                return this.accessModifier;
            }

            @Override
            public AccessModifier builderAccessModifier() {
                return this.builderAccessModifier;
            }

            @Override
            public boolean createEmptyCreate() {
                return this.createEmptyCreate;
            }

            @Override
            public boolean recordStyle() {
                return this.recordStyle;
            }

            @Override
            public Optional<PrototypeConfigured> configured() {
                return this.configured;
            }

            @Override
            public boolean registrySupport() {
                return this.registrySupport;
            }

            @Override
            public boolean detachBlueprint() {
                return this.detachBlueprint;
            }

            @Override
            public Optional<TypeName> superPrototype() {
                return this.superPrototype;
            }

            @Override
            public Set<TypeName> superTypes() {
                return this.superTypes;
            }

            @Override
            public Set<TypeName> providerProvides() {
                return this.providerProvides;
            }

            @Override
            public List<PrototypeConstant> constants() {
                return this.constants;
            }

            @Override
            public List<GeneratedMethod> prototypeMethods() {
                return this.prototypeMethods;
            }

            @Override
            public List<GeneratedMethod> builderMethods() {
                return this.builderMethods;
            }

            @Override
            public List<DeprecatedFactoryMethod> deprecatedFactoryMethods() {
                return this.deprecatedFactoryMethods;
            }

            @Override
            public List<GeneratedMethod> prototypeFactories() {
                return this.prototypeFactories;
            }

            @Override
            public List<FactoryMethod> configFactories() {
                return this.configFactories;
            }

            @Override
            public List<RuntimeTypeInfo> runtimeTypeFactories() {
                return this.runtimeTypeFactories;
            }

            public List<Annotation> annotations() {
                return this.annotations;
            }

            public List<Annotation> inheritedAnnotations() {
                return this.inheritedAnnotations;
            }

            public String toString() {
                return "PrototypeInfo{blueprint=" + String.valueOf(this.blueprint) + ",runtimeType=" + String.valueOf(this.runtimeType) + ",javadoc=" + String.valueOf(this.javadoc) + ",builderBaseJavadoc=" + String.valueOf(this.builderBaseJavadoc) + ",builderJavadoc=" + String.valueOf(this.builderJavadoc) + ",builderDecorator=" + String.valueOf(this.builderDecorator) + ",prototypeType=" + String.valueOf(this.prototypeType) + ",defaultMethodsPredicate=" + String.valueOf(this.defaultMethodsPredicate) + ",accessModifier=" + String.valueOf(this.accessModifier) + ",builderAccessModifier=" + String.valueOf(this.builderAccessModifier) + ",createEmptyCreate=" + this.createEmptyCreate + ",recordStyle=" + this.recordStyle + ",configured=" + String.valueOf(this.configured) + ",registrySupport=" + this.registrySupport + ",detachBlueprint=" + this.detachBlueprint + ",superPrototype=" + String.valueOf(this.superPrototype) + ",superTypes=" + String.valueOf(this.superTypes) + ",providerProvides=" + String.valueOf(this.providerProvides) + ",constants=" + String.valueOf(this.constants) + ",prototypeMethods=" + String.valueOf(this.prototypeMethods) + ",builderMethods=" + String.valueOf(this.builderMethods) + ",deprecatedFactoryMethods=" + String.valueOf(this.deprecatedFactoryMethods) + ",prototypeFactories=" + String.valueOf(this.prototypeFactories) + ",configFactories=" + String.valueOf(this.configFactories) + ",runtimeTypeFactories=" + String.valueOf(this.runtimeTypeFactories) + ",annotations=" + String.valueOf(this.annotations) + ",inheritedAnnotations=" + String.valueOf(this.inheritedAnnotations) + "}";
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof PrototypeInfo)) {
                    return false;
                }
                PrototypeInfo other = (PrototypeInfo)o;
                return Objects.equals(this.blueprint, other.blueprint()) && Objects.equals(this.runtimeType, other.runtimeType()) && Objects.equals(this.javadoc, other.javadoc()) && Objects.equals(this.builderBaseJavadoc, other.builderBaseJavadoc()) && Objects.equals(this.builderJavadoc, other.builderJavadoc()) && Objects.equals(this.builderDecorator, other.builderDecorator()) && Objects.equals(this.prototypeType, other.prototypeType()) && Objects.equals(this.defaultMethodsPredicate, other.defaultMethodsPredicate()) && Objects.equals(this.accessModifier, other.accessModifier()) && Objects.equals(this.builderAccessModifier, other.builderAccessModifier()) && this.createEmptyCreate == other.createEmptyCreate() && this.recordStyle == other.recordStyle() && Objects.equals(this.configured, other.configured()) && this.registrySupport == other.registrySupport() && this.detachBlueprint == other.detachBlueprint() && Objects.equals(this.superPrototype, other.superPrototype()) && Objects.equals(this.superTypes, other.superTypes()) && Objects.equals(this.providerProvides, other.providerProvides()) && Objects.equals(this.constants, other.constants()) && Objects.equals(this.prototypeMethods, other.prototypeMethods()) && Objects.equals(this.builderMethods, other.builderMethods()) && Objects.equals(this.deprecatedFactoryMethods, other.deprecatedFactoryMethods()) && Objects.equals(this.prototypeFactories, other.prototypeFactories()) && Objects.equals(this.configFactories, other.configFactories()) && Objects.equals(this.runtimeTypeFactories, other.runtimeTypeFactories()) && Objects.equals(this.annotations, other.annotations()) && Objects.equals(this.inheritedAnnotations, other.inheritedAnnotations());
            }

            public int hashCode() {
                return Objects.hash(this.blueprint, this.runtimeType, this.javadoc, this.builderBaseJavadoc, this.builderJavadoc, this.builderDecorator, this.prototypeType, this.defaultMethodsPredicate, this.accessModifier, this.builderAccessModifier, this.createEmptyCreate, this.recordStyle, this.configured, this.registrySupport, this.detachBlueprint, this.superPrototype, this.superTypes, this.providerProvides, this.constants, this.prototypeMethods, this.builderMethods, this.deprecatedFactoryMethods, this.prototypeFactories, this.configFactories, this.runtimeTypeFactories, this.annotations, this.inheritedAnnotations);
            }
        }
    }
}

