/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.builder.codegen;

import io.helidon.builder.api.Prototype;
import io.helidon.codegen.classmodel.ContentBuilder;
import io.helidon.codegen.classmodel.Javadoc;
import io.helidon.common.Errors;
import io.helidon.common.types.TypeName;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;

public interface PrototypeConstant
extends Prototype.Api {
    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(PrototypeConstant instance) {
        return (Builder)PrototypeConstant.builder().from(instance);
    }

    public String name();

    public TypeName type();

    public Javadoc javadoc();

    public Consumer<ContentBuilder<?>> content();

    public static class Builder
    extends BuilderBase<Builder, PrototypeConstant>
    implements io.helidon.common.Builder<Builder, PrototypeConstant> {
        private Builder() {
        }

        public PrototypeConstant buildPrototype() {
            this.preBuildPrototype();
            this.validatePrototype();
            return new BuilderBase.PrototypeConstantImpl(this);
        }

        public PrototypeConstant build() {
            return this.buildPrototype();
        }
    }

    public static abstract class BuilderBase<BUILDER extends BuilderBase<BUILDER, PROTOTYPE>, PROTOTYPE extends PrototypeConstant>
    implements Prototype.Builder<BUILDER, PROTOTYPE> {
        private Consumer<ContentBuilder<?>> content;
        private Javadoc javadoc;
        private String name;
        private TypeName type;

        protected BuilderBase() {
        }

        public BUILDER from(PrototypeConstant prototype) {
            this.name(prototype.name());
            this.type(prototype.type());
            this.javadoc(prototype.javadoc());
            this.content(prototype.content());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER from(BuilderBase<?, ?> builder) {
            builder.name().ifPresent(this::name);
            builder.type().ifPresent(this::type);
            builder.javadoc().ifPresent(this::javadoc);
            builder.content().ifPresent(this::content);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER name(String name) {
            Objects.requireNonNull(name);
            this.name = name;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER type(TypeName type) {
            Objects.requireNonNull(type);
            this.type = type;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER type(Consumer<TypeName.Builder> consumer) {
            Objects.requireNonNull(consumer);
            TypeName.Builder builder = TypeName.builder();
            consumer.accept(builder);
            this.type(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER type(Supplier<? extends TypeName> supplier) {
            Objects.requireNonNull(supplier);
            this.type(supplier.get());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER javadoc(Javadoc javadoc) {
            Objects.requireNonNull(javadoc);
            this.javadoc = javadoc;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER javadoc(Consumer<Javadoc.Builder> consumer) {
            Objects.requireNonNull(consumer);
            Javadoc.Builder builder = Javadoc.builder();
            consumer.accept(builder);
            this.javadoc(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER javadoc(Supplier<? extends Javadoc> supplier) {
            Objects.requireNonNull(supplier);
            this.javadoc(supplier.get());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER content(Consumer<ContentBuilder<?>> content) {
            Objects.requireNonNull(content);
            this.content = content;
            return (BUILDER)((BuilderBase)this.self());
        }

        public Optional<String> name() {
            return Optional.ofNullable(this.name);
        }

        public Optional<TypeName> type() {
            return Optional.ofNullable(this.type);
        }

        public Optional<Javadoc> javadoc() {
            return Optional.ofNullable(this.javadoc);
        }

        public Optional<Consumer<ContentBuilder<?>>> content() {
            return Optional.ofNullable(this.content);
        }

        public String toString() {
            return "PrototypeConstantBuilder{name=" + this.name + ",type=" + String.valueOf(this.type) + ",javadoc=" + String.valueOf(this.javadoc) + ",content=" + String.valueOf(this.content) + "}";
        }

        protected void preBuildPrototype() {
        }

        protected void validatePrototype() {
            Errors.Collector collector = Errors.collector();
            if (this.name == null) {
                collector.fatal(this.getClass(), "Property \"name\" must not be null, but not set");
            }
            if (this.type == null) {
                collector.fatal(this.getClass(), "Property \"type\" must not be null, but not set");
            }
            if (this.javadoc == null) {
                collector.fatal(this.getClass(), "Property \"javadoc\" must not be null, but not set");
            }
            if (this.content == null) {
                collector.fatal(this.getClass(), "Property \"content\" must not be null, but not set");
            }
            collector.collect().checkValid();
        }

        protected static class PrototypeConstantImpl
        implements PrototypeConstant {
            private final Consumer<ContentBuilder<?>> content;
            private final Javadoc javadoc;
            private final String name;
            private final TypeName type;

            protected PrototypeConstantImpl(BuilderBase<?, ?> builder) {
                this.name = builder.name().get();
                this.type = builder.type().get();
                this.javadoc = builder.javadoc().get();
                this.content = builder.content().get();
            }

            @Override
            public String name() {
                return this.name;
            }

            @Override
            public TypeName type() {
                return this.type;
            }

            @Override
            public Javadoc javadoc() {
                return this.javadoc;
            }

            @Override
            public Consumer<ContentBuilder<?>> content() {
                return this.content;
            }

            public String toString() {
                return "PrototypeConstant{name=" + this.name + ",type=" + String.valueOf(this.type) + ",javadoc=" + String.valueOf(this.javadoc) + ",content=" + String.valueOf(this.content) + "}";
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof PrototypeConstant)) {
                    return false;
                }
                PrototypeConstant other = (PrototypeConstant)o;
                return Objects.equals(this.name, other.name()) && Objects.equals(this.type, other.type()) && Objects.equals(this.javadoc, other.javadoc()) && Objects.equals(this.content, other.content());
            }

            public int hashCode() {
                return Objects.hash(this.name, this.type, this.javadoc, this.content);
            }
        }
    }
}

