/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.builder.codegen;

import io.helidon.builder.api.Prototype;
import io.helidon.common.types.AccessModifier;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;

public interface PrototypeConfigured
extends Prototype.Api {
    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(PrototypeConfigured instance) {
        return (Builder)PrototypeConfigured.builder().from(instance);
    }

    public static PrototypeConfigured create() {
        return PrototypeConfigured.builder().buildPrototype();
    }

    public AccessModifier createAccessModifier();

    public boolean root();

    public Optional<String> key();

    public static class Builder
    extends BuilderBase<Builder, PrototypeConfigured>
    implements io.helidon.common.Builder<Builder, PrototypeConfigured> {
        private Builder() {
        }

        public PrototypeConfigured buildPrototype() {
            this.preBuildPrototype();
            this.validatePrototype();
            return new BuilderBase.PrototypeConfiguredImpl(this);
        }

        public PrototypeConfigured build() {
            return this.buildPrototype();
        }
    }

    public static abstract class BuilderBase<BUILDER extends BuilderBase<BUILDER, PROTOTYPE>, PROTOTYPE extends PrototypeConfigured>
    implements Prototype.Builder<BUILDER, PROTOTYPE> {
        private AccessModifier createAccessModifier = AccessModifier.PUBLIC;
        private boolean root = true;
        private String key;

        protected BuilderBase() {
        }

        public BUILDER from(PrototypeConfigured prototype) {
            this.createAccessModifier(prototype.createAccessModifier());
            this.root(prototype.root());
            this.key(prototype.key());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER from(BuilderBase<?, ?> builder) {
            this.createAccessModifier(builder.createAccessModifier());
            this.root(builder.root());
            builder.key().ifPresent(this::key);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER createAccessModifier(AccessModifier createAccessModifier) {
            Objects.requireNonNull(createAccessModifier);
            this.createAccessModifier = createAccessModifier;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER root(boolean root) {
            this.root = root;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearKey() {
            this.key = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER key(String key) {
            Objects.requireNonNull(key);
            this.key = key;
            return (BUILDER)((BuilderBase)this.self());
        }

        public AccessModifier createAccessModifier() {
            return this.createAccessModifier;
        }

        public boolean root() {
            return this.root;
        }

        public Optional<String> key() {
            return Optional.ofNullable(this.key);
        }

        public String toString() {
            return "PrototypeConfiguredBuilder{createAccessModifier=" + String.valueOf(this.createAccessModifier) + ",root=" + this.root + ",key=" + this.key + "}";
        }

        protected void preBuildPrototype() {
        }

        protected void validatePrototype() {
        }

        BUILDER key(Optional<String> key) {
            Objects.requireNonNull(key);
            this.key = key.orElse(this.key);
            return (BUILDER)((BuilderBase)this.self());
        }

        protected static class PrototypeConfiguredImpl
        implements PrototypeConfigured {
            private final AccessModifier createAccessModifier;
            private final boolean root;
            private final Optional<String> key;

            protected PrototypeConfiguredImpl(BuilderBase<?, ?> builder) {
                this.createAccessModifier = builder.createAccessModifier();
                this.root = builder.root();
                this.key = builder.key().map(Function.identity());
            }

            @Override
            public AccessModifier createAccessModifier() {
                return this.createAccessModifier;
            }

            @Override
            public boolean root() {
                return this.root;
            }

            @Override
            public Optional<String> key() {
                return this.key;
            }

            public String toString() {
                return "PrototypeConfigured{createAccessModifier=" + String.valueOf(this.createAccessModifier) + ",root=" + this.root + ",key=" + String.valueOf(this.key) + "}";
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof PrototypeConfigured)) {
                    return false;
                }
                PrototypeConfigured other = (PrototypeConfigured)o;
                return Objects.equals(this.createAccessModifier, other.createAccessModifier()) && this.root == other.root() && Objects.equals(this.key, other.key());
            }

            public int hashCode() {
                return Objects.hash(this.createAccessModifier, this.root, this.key);
            }
        }
    }
}

