/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.builder.codegen;

import io.helidon.builder.api.Prototype;
import io.helidon.builder.codegen.OptionAllowedValue;
import io.helidon.builder.codegen.OptionBuilder;
import io.helidon.builder.codegen.OptionConfigured;
import io.helidon.builder.codegen.OptionDeprecation;
import io.helidon.builder.codegen.OptionProvider;
import io.helidon.builder.codegen.OptionSingular;
import io.helidon.builder.codegen.RuntimeTypeInfo;
import io.helidon.codegen.classmodel.ContentBuilder;
import io.helidon.common.Errors;
import io.helidon.common.types.AccessModifier;
import io.helidon.common.types.Annotated;
import io.helidon.common.types.Annotation;
import io.helidon.common.types.TypeInfo;
import io.helidon.common.types.TypeName;
import io.helidon.common.types.TypedElementInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public interface OptionInfo
extends Prototype.Api,
Annotated {
    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(OptionInfo instance) {
        return (Builder)OptionInfo.builder().from(instance);
    }

    public Optional<TypedElementInfo> interfaceMethod();

    public Optional<TypeInfo> declaringType();

    public String name();

    public String getterName();

    public String setterName();

    public TypeName declaredType();

    public Optional<TypeName> decorator();

    public boolean includeInToString();

    public boolean includeInEqualsAndHashCode();

    public boolean confidential();

    public boolean registryService();

    public boolean sameGeneric();

    public boolean required();

    public boolean builderOptionOnly();

    public List<Annotation> qualifiers();

    public List<OptionAllowedValue> allowedValues();

    public Optional<Consumer<ContentBuilder<?>>> defaultValue();

    public Optional<OptionConfigured> configured();

    public Optional<OptionDeprecation> deprecation();

    public Optional<OptionProvider> provider();

    public Optional<OptionSingular> singular();

    public AccessModifier accessModifier();

    public Optional<OptionBuilder> builderInfo();

    public Optional<RuntimeTypeInfo> runtimeType();

    public Optional<String> description();

    public Optional<String> paramDescription();

    public static class Builder
    extends BuilderBase<Builder, OptionInfo>
    implements io.helidon.common.Builder<Builder, OptionInfo> {
        private Builder() {
        }

        public OptionInfo buildPrototype() {
            this.preBuildPrototype();
            this.validatePrototype();
            return new BuilderBase.OptionInfoImpl(this);
        }

        public OptionInfo build() {
            return this.buildPrototype();
        }
    }

    public static abstract class BuilderBase<BUILDER extends BuilderBase<BUILDER, PROTOTYPE>, PROTOTYPE extends OptionInfo>
    implements Prototype.Builder<BUILDER, PROTOTYPE> {
        private final List<OptionAllowedValue> allowedValues = new ArrayList<OptionAllowedValue>();
        private final List<Annotation> annotations = new ArrayList<Annotation>();
        private final List<Annotation> inheritedAnnotations = new ArrayList<Annotation>();
        private final List<Annotation> qualifiers = new ArrayList<Annotation>();
        private AccessModifier accessModifier = AccessModifier.PUBLIC;
        private boolean builderOptionOnly;
        private boolean confidential = false;
        private boolean includeInEqualsAndHashCode = true;
        private boolean includeInToString = true;
        private boolean isAllowedValuesMutated;
        private boolean isAnnotationsMutated;
        private boolean isInheritedAnnotationsMutated;
        private boolean isQualifiersMutated;
        private boolean registryService = false;
        private boolean required;
        private boolean sameGeneric = false;
        private Consumer<ContentBuilder<?>> defaultValue;
        private OptionBuilder builderInfo;
        private OptionConfigured configured;
        private OptionDeprecation deprecation;
        private OptionProvider provider;
        private OptionSingular singular;
        private RuntimeTypeInfo runtimeType;
        private String description;
        private String getterName;
        private String name;
        private String paramDescription;
        private String setterName;
        private TypedElementInfo interfaceMethod;
        private TypeInfo declaringType;
        private TypeName declaredType;
        private TypeName decorator;

        protected BuilderBase() {
        }

        public BUILDER from(OptionInfo prototype) {
            this.interfaceMethod(prototype.interfaceMethod());
            this.declaringType(prototype.declaringType());
            this.name(prototype.name());
            this.getterName(prototype.getterName());
            this.setterName(prototype.setterName());
            this.declaredType(prototype.declaredType());
            this.decorator(prototype.decorator());
            this.includeInToString(prototype.includeInToString());
            this.includeInEqualsAndHashCode(prototype.includeInEqualsAndHashCode());
            this.confidential(prototype.confidential());
            this.registryService(prototype.registryService());
            this.sameGeneric(prototype.sameGeneric());
            this.required(prototype.required());
            this.builderOptionOnly(prototype.builderOptionOnly());
            if (!this.isQualifiersMutated) {
                this.qualifiers.clear();
            }
            this.addQualifiers(prototype.qualifiers());
            if (!this.isAllowedValuesMutated) {
                this.allowedValues.clear();
            }
            this.addAllowedValues(prototype.allowedValues());
            this.defaultValue(prototype.defaultValue());
            this.configured(prototype.configured());
            this.deprecation(prototype.deprecation());
            this.provider(prototype.provider());
            this.singular(prototype.singular());
            this.accessModifier(prototype.accessModifier());
            this.builderInfo(prototype.builderInfo());
            this.runtimeType(prototype.runtimeType());
            this.description(prototype.description());
            this.paramDescription(prototype.paramDescription());
            if (!this.isAnnotationsMutated) {
                this.annotations.clear();
            }
            this.addAnnotations(prototype.annotations());
            if (!this.isInheritedAnnotationsMutated) {
                this.inheritedAnnotations.clear();
            }
            this.addInheritedAnnotations(prototype.inheritedAnnotations());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER from(BuilderBase<?, ?> builder) {
            builder.interfaceMethod().ifPresent(this::interfaceMethod);
            builder.declaringType().ifPresent(this::declaringType);
            builder.name().ifPresent(this::name);
            builder.getterName().ifPresent(this::getterName);
            builder.setterName().ifPresent(this::setterName);
            builder.declaredType().ifPresent(this::declaredType);
            builder.decorator().ifPresent(this::decorator);
            this.includeInToString(builder.includeInToString());
            this.includeInEqualsAndHashCode(builder.includeInEqualsAndHashCode());
            this.confidential(builder.confidential());
            this.registryService(builder.registryService());
            this.sameGeneric(builder.sameGeneric());
            this.required(builder.required());
            this.builderOptionOnly(builder.builderOptionOnly());
            if (this.isQualifiersMutated) {
                if (builder.isQualifiersMutated) {
                    this.addQualifiers(builder.qualifiers());
                }
            } else {
                this.qualifiers(builder.qualifiers());
            }
            if (this.isAllowedValuesMutated) {
                if (builder.isAllowedValuesMutated) {
                    this.addAllowedValues(builder.allowedValues());
                }
            } else {
                this.allowedValues(builder.allowedValues());
            }
            builder.defaultValue().ifPresent(this::defaultValue);
            builder.configured().ifPresent(this::configured);
            builder.deprecation().ifPresent(this::deprecation);
            builder.provider().ifPresent(this::provider);
            builder.singular().ifPresent(this::singular);
            this.accessModifier(builder.accessModifier());
            builder.builderInfo().ifPresent(this::builderInfo);
            builder.runtimeType().ifPresent(this::runtimeType);
            builder.description().ifPresent(this::description);
            builder.paramDescription().ifPresent(this::paramDescription);
            if (this.isAnnotationsMutated) {
                if (builder.isAnnotationsMutated) {
                    this.addAnnotations(builder.annotations());
                }
            } else {
                this.annotations(builder.annotations());
            }
            if (this.isInheritedAnnotationsMutated) {
                if (builder.isInheritedAnnotationsMutated) {
                    this.addInheritedAnnotations(builder.inheritedAnnotations());
                }
            } else {
                this.inheritedAnnotations(builder.inheritedAnnotations());
            }
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearInterfaceMethod() {
            this.interfaceMethod = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER interfaceMethod(TypedElementInfo interfaceMethod) {
            Objects.requireNonNull(interfaceMethod);
            this.interfaceMethod = interfaceMethod;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER interfaceMethod(Consumer<TypedElementInfo.Builder> consumer) {
            Objects.requireNonNull(consumer);
            TypedElementInfo.Builder builder = TypedElementInfo.builder();
            consumer.accept(builder);
            this.interfaceMethod(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER interfaceMethod(Supplier<? extends TypedElementInfo> supplier) {
            Objects.requireNonNull(supplier);
            this.interfaceMethod(supplier.get());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearDeclaringType() {
            this.declaringType = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER declaringType(TypeInfo declaringType) {
            Objects.requireNonNull(declaringType);
            this.declaringType = declaringType;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER declaringType(Consumer<TypeInfo.Builder> consumer) {
            Objects.requireNonNull(consumer);
            TypeInfo.Builder builder = TypeInfo.builder();
            consumer.accept(builder);
            this.declaringType(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER declaringType(Supplier<? extends TypeInfo> supplier) {
            Objects.requireNonNull(supplier);
            this.declaringType(supplier.get());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER name(String name) {
            Objects.requireNonNull(name);
            this.name = name;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER getterName(String getterName) {
            Objects.requireNonNull(getterName);
            this.getterName = getterName;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER setterName(String setterName) {
            Objects.requireNonNull(setterName);
            this.setterName = setterName;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER declaredType(TypeName declaredType) {
            Objects.requireNonNull(declaredType);
            this.declaredType = declaredType;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER declaredType(Consumer<TypeName.Builder> consumer) {
            Objects.requireNonNull(consumer);
            TypeName.Builder builder = TypeName.builder();
            consumer.accept(builder);
            this.declaredType(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER declaredType(Supplier<? extends TypeName> supplier) {
            Objects.requireNonNull(supplier);
            this.declaredType(supplier.get());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearDecorator() {
            this.decorator = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER decorator(TypeName decorator) {
            Objects.requireNonNull(decorator);
            this.decorator = decorator;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER decorator(Consumer<TypeName.Builder> consumer) {
            Objects.requireNonNull(consumer);
            TypeName.Builder builder = TypeName.builder();
            consumer.accept(builder);
            this.decorator(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER decorator(Supplier<? extends TypeName> supplier) {
            Objects.requireNonNull(supplier);
            this.decorator(supplier.get());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER includeInToString(boolean includeInToString) {
            this.includeInToString = includeInToString;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER includeInEqualsAndHashCode(boolean includeInEqualsAndHashCode) {
            this.includeInEqualsAndHashCode = includeInEqualsAndHashCode;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER confidential(boolean confidential) {
            this.confidential = confidential;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER registryService(boolean registryService) {
            this.registryService = registryService;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER sameGeneric(boolean sameGeneric) {
            this.sameGeneric = sameGeneric;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER required(boolean required) {
            this.required = required;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER builderOptionOnly(boolean builderOptionOnly) {
            this.builderOptionOnly = builderOptionOnly;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearQualifiers() {
            this.isQualifiersMutated = true;
            this.qualifiers.clear();
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER qualifiers(List<? extends Annotation> qualifiers) {
            Objects.requireNonNull(qualifiers);
            this.isQualifiersMutated = true;
            this.qualifiers.clear();
            this.qualifiers.addAll(qualifiers);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addQualifiers(List<? extends Annotation> qualifiers) {
            Objects.requireNonNull(qualifiers);
            this.isQualifiersMutated = true;
            this.qualifiers.addAll(qualifiers);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addQualifier(Annotation qualifier) {
            Objects.requireNonNull(qualifier);
            this.qualifiers.add(qualifier);
            this.isQualifiersMutated = true;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addQualifier(Consumer<Annotation.Builder> consumer) {
            Objects.requireNonNull(consumer);
            Annotation.Builder builder = Annotation.builder();
            consumer.accept(builder);
            this.addQualifier(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearAllowedValues() {
            this.isAllowedValuesMutated = true;
            this.allowedValues.clear();
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER allowedValues(List<? extends OptionAllowedValue> allowedValues) {
            Objects.requireNonNull(allowedValues);
            this.isAllowedValuesMutated = true;
            this.allowedValues.clear();
            this.allowedValues.addAll(allowedValues);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addAllowedValues(List<? extends OptionAllowedValue> allowedValues) {
            Objects.requireNonNull(allowedValues);
            this.isAllowedValuesMutated = true;
            this.allowedValues.addAll(allowedValues);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addAllowedValue(OptionAllowedValue allowedValue) {
            Objects.requireNonNull(allowedValue);
            this.allowedValues.add(allowedValue);
            this.isAllowedValuesMutated = true;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addAllowedValue(Consumer<OptionAllowedValue.Builder> consumer) {
            Objects.requireNonNull(consumer);
            OptionAllowedValue.Builder builder = OptionAllowedValue.builder();
            consumer.accept(builder);
            this.addAllowedValue(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearDefaultValue() {
            this.defaultValue = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER defaultValue(Consumer<ContentBuilder<?>> defaultValue) {
            Objects.requireNonNull(defaultValue);
            this.defaultValue = defaultValue;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearConfigured() {
            this.configured = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER configured(OptionConfigured configured) {
            Objects.requireNonNull(configured);
            this.configured = configured;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER configured(Consumer<OptionConfigured.Builder> consumer) {
            Objects.requireNonNull(consumer);
            OptionConfigured.Builder builder = OptionConfigured.builder();
            consumer.accept(builder);
            this.configured(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER configured(Supplier<? extends OptionConfigured> supplier) {
            Objects.requireNonNull(supplier);
            this.configured(supplier.get());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearDeprecation() {
            this.deprecation = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER deprecation(OptionDeprecation deprecation) {
            Objects.requireNonNull(deprecation);
            this.deprecation = deprecation;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER deprecation(Consumer<OptionDeprecation.Builder> consumer) {
            Objects.requireNonNull(consumer);
            OptionDeprecation.Builder builder = OptionDeprecation.builder();
            consumer.accept(builder);
            this.deprecation(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER deprecation(Supplier<? extends OptionDeprecation> supplier) {
            Objects.requireNonNull(supplier);
            this.deprecation(supplier.get());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearProvider() {
            this.provider = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER provider(OptionProvider provider) {
            Objects.requireNonNull(provider);
            this.provider = provider;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER provider(Consumer<OptionProvider.Builder> consumer) {
            Objects.requireNonNull(consumer);
            OptionProvider.Builder builder = OptionProvider.builder();
            consumer.accept(builder);
            this.provider(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER provider(Supplier<? extends OptionProvider> supplier) {
            Objects.requireNonNull(supplier);
            this.provider(supplier.get());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearSingular() {
            this.singular = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER singular(OptionSingular singular) {
            Objects.requireNonNull(singular);
            this.singular = singular;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER singular(Consumer<OptionSingular.Builder> consumer) {
            Objects.requireNonNull(consumer);
            OptionSingular.Builder builder = OptionSingular.builder();
            consumer.accept(builder);
            this.singular(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER singular(Supplier<? extends OptionSingular> supplier) {
            Objects.requireNonNull(supplier);
            this.singular(supplier.get());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER accessModifier(AccessModifier accessModifier) {
            Objects.requireNonNull(accessModifier);
            this.accessModifier = accessModifier;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearBuilderInfo() {
            this.builderInfo = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER builderInfo(OptionBuilder builderInfo) {
            Objects.requireNonNull(builderInfo);
            this.builderInfo = builderInfo;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER builderInfo(Consumer<OptionBuilder.Builder> consumer) {
            Objects.requireNonNull(consumer);
            OptionBuilder.Builder builder = OptionBuilder.builder();
            consumer.accept(builder);
            this.builderInfo(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER builderInfo(Supplier<? extends OptionBuilder> supplier) {
            Objects.requireNonNull(supplier);
            this.builderInfo(supplier.get());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearRuntimeType() {
            this.runtimeType = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER runtimeType(RuntimeTypeInfo runtimeType) {
            Objects.requireNonNull(runtimeType);
            this.runtimeType = runtimeType;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER runtimeType(Consumer<RuntimeTypeInfo.Builder> consumer) {
            Objects.requireNonNull(consumer);
            RuntimeTypeInfo.Builder builder = RuntimeTypeInfo.builder();
            consumer.accept(builder);
            this.runtimeType(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER runtimeType(Supplier<? extends RuntimeTypeInfo> supplier) {
            Objects.requireNonNull(supplier);
            this.runtimeType(supplier.get());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearDescription() {
            this.description = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER description(String description) {
            Objects.requireNonNull(description);
            this.description = description;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearParamDescription() {
            this.paramDescription = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER paramDescription(String paramDescription) {
            Objects.requireNonNull(paramDescription);
            this.paramDescription = paramDescription;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearAnnotations() {
            this.isAnnotationsMutated = true;
            this.annotations.clear();
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER annotations(List<? extends Annotation> annotations) {
            Objects.requireNonNull(annotations);
            this.isAnnotationsMutated = true;
            this.annotations.clear();
            this.annotations.addAll(annotations);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addAnnotations(List<? extends Annotation> annotations) {
            Objects.requireNonNull(annotations);
            this.isAnnotationsMutated = true;
            this.annotations.addAll(annotations);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addAnnotation(Annotation annotation) {
            Objects.requireNonNull(annotation);
            this.annotations.add(annotation);
            this.isAnnotationsMutated = true;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addAnnotation(Consumer<Annotation.Builder> consumer) {
            Objects.requireNonNull(consumer);
            Annotation.Builder builder = Annotation.builder();
            consumer.accept(builder);
            this.addAnnotation(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearInheritedAnnotations() {
            this.isInheritedAnnotationsMutated = true;
            this.inheritedAnnotations.clear();
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER inheritedAnnotations(List<? extends Annotation> inheritedAnnotations) {
            Objects.requireNonNull(inheritedAnnotations);
            this.isInheritedAnnotationsMutated = true;
            this.inheritedAnnotations.clear();
            this.inheritedAnnotations.addAll(inheritedAnnotations);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addInheritedAnnotations(List<? extends Annotation> inheritedAnnotations) {
            Objects.requireNonNull(inheritedAnnotations);
            this.isInheritedAnnotationsMutated = true;
            this.inheritedAnnotations.addAll(inheritedAnnotations);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addInheritedAnnotation(Annotation inheritedAnnotation) {
            Objects.requireNonNull(inheritedAnnotation);
            this.inheritedAnnotations.add(inheritedAnnotation);
            this.isInheritedAnnotationsMutated = true;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addInheritedAnnotation(Consumer<Annotation.Builder> consumer) {
            Objects.requireNonNull(consumer);
            Annotation.Builder builder = Annotation.builder();
            consumer.accept(builder);
            this.addInheritedAnnotation(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public Optional<TypedElementInfo> interfaceMethod() {
            return Optional.ofNullable(this.interfaceMethod);
        }

        public Optional<TypeInfo> declaringType() {
            return Optional.ofNullable(this.declaringType);
        }

        public Optional<String> name() {
            return Optional.ofNullable(this.name);
        }

        public Optional<String> getterName() {
            return Optional.ofNullable(this.getterName);
        }

        public Optional<String> setterName() {
            return Optional.ofNullable(this.setterName);
        }

        public Optional<TypeName> declaredType() {
            return Optional.ofNullable(this.declaredType);
        }

        public Optional<TypeName> decorator() {
            return Optional.ofNullable(this.decorator);
        }

        public boolean includeInToString() {
            return this.includeInToString;
        }

        public boolean includeInEqualsAndHashCode() {
            return this.includeInEqualsAndHashCode;
        }

        public boolean confidential() {
            return this.confidential;
        }

        public boolean registryService() {
            return this.registryService;
        }

        public boolean sameGeneric() {
            return this.sameGeneric;
        }

        public boolean required() {
            return this.required;
        }

        public boolean builderOptionOnly() {
            return this.builderOptionOnly;
        }

        public List<Annotation> qualifiers() {
            return this.qualifiers;
        }

        public List<OptionAllowedValue> allowedValues() {
            return this.allowedValues;
        }

        public Optional<Consumer<ContentBuilder<?>>> defaultValue() {
            return Optional.ofNullable(this.defaultValue);
        }

        public Optional<OptionConfigured> configured() {
            return Optional.ofNullable(this.configured);
        }

        public Optional<OptionDeprecation> deprecation() {
            return Optional.ofNullable(this.deprecation);
        }

        public Optional<OptionProvider> provider() {
            return Optional.ofNullable(this.provider);
        }

        public Optional<OptionSingular> singular() {
            return Optional.ofNullable(this.singular);
        }

        public AccessModifier accessModifier() {
            return this.accessModifier;
        }

        public Optional<OptionBuilder> builderInfo() {
            return Optional.ofNullable(this.builderInfo);
        }

        public Optional<RuntimeTypeInfo> runtimeType() {
            return Optional.ofNullable(this.runtimeType);
        }

        public Optional<String> description() {
            return Optional.ofNullable(this.description);
        }

        public Optional<String> paramDescription() {
            return Optional.ofNullable(this.paramDescription);
        }

        public List<Annotation> annotations() {
            return this.annotations;
        }

        public List<Annotation> inheritedAnnotations() {
            return this.inheritedAnnotations;
        }

        public String toString() {
            return "OptionInfoBuilder{interfaceMethod=" + String.valueOf(this.interfaceMethod) + ",declaringType=" + String.valueOf(this.declaringType) + ",name=" + this.name + ",getterName=" + this.getterName + ",setterName=" + this.setterName + ",declaredType=" + String.valueOf(this.declaredType) + ",decorator=" + String.valueOf(this.decorator) + ",includeInToString=" + this.includeInToString + ",includeInEqualsAndHashCode=" + this.includeInEqualsAndHashCode + ",confidential=" + this.confidential + ",registryService=" + this.registryService + ",sameGeneric=" + this.sameGeneric + ",required=" + this.required + ",builderOptionOnly=" + this.builderOptionOnly + ",qualifiers=" + String.valueOf(this.qualifiers) + ",allowedValues=" + String.valueOf(this.allowedValues) + ",defaultValue=" + String.valueOf(this.defaultValue) + ",configured=" + String.valueOf(this.configured) + ",deprecation=" + String.valueOf(this.deprecation) + ",provider=" + String.valueOf(this.provider) + ",singular=" + String.valueOf(this.singular) + ",accessModifier=" + String.valueOf(this.accessModifier) + ",builderInfo=" + String.valueOf(this.builderInfo) + ",runtimeType=" + String.valueOf(this.runtimeType) + ",description=" + this.description + ",paramDescription=" + this.paramDescription + ",annotations=" + String.valueOf(this.annotations) + ",inheritedAnnotations=" + String.valueOf(this.inheritedAnnotations) + "}";
        }

        protected void preBuildPrototype() {
        }

        protected void validatePrototype() {
            Errors.Collector collector = Errors.collector();
            if (this.name == null) {
                collector.fatal(this.getClass(), "Property \"name\" must not be null, but not set");
            }
            if (this.getterName == null) {
                collector.fatal(this.getClass(), "Property \"getterName\" must not be null, but not set");
            }
            if (this.setterName == null) {
                collector.fatal(this.getClass(), "Property \"setterName\" must not be null, but not set");
            }
            if (this.declaredType == null) {
                collector.fatal(this.getClass(), "Property \"declaredType\" must not be null, but not set");
            }
            collector.collect().checkValid();
        }

        BUILDER interfaceMethod(Optional<? extends TypedElementInfo> interfaceMethod) {
            Objects.requireNonNull(interfaceMethod);
            this.interfaceMethod = interfaceMethod.map(TypedElementInfo.class::cast).orElse(this.interfaceMethod);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER declaringType(Optional<? extends TypeInfo> declaringType) {
            Objects.requireNonNull(declaringType);
            this.declaringType = declaringType.map(TypeInfo.class::cast).orElse(this.declaringType);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER decorator(Optional<? extends TypeName> decorator) {
            Objects.requireNonNull(decorator);
            this.decorator = decorator.map(TypeName.class::cast).orElse(this.decorator);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER defaultValue(Optional<Consumer<ContentBuilder<?>>> defaultValue) {
            Objects.requireNonNull(defaultValue);
            this.defaultValue = defaultValue.map(Consumer.class::cast).orElse(this.defaultValue);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER configured(Optional<? extends OptionConfigured> configured) {
            Objects.requireNonNull(configured);
            this.configured = configured.map(OptionConfigured.class::cast).orElse(this.configured);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER deprecation(Optional<? extends OptionDeprecation> deprecation) {
            Objects.requireNonNull(deprecation);
            this.deprecation = deprecation.map(OptionDeprecation.class::cast).orElse(this.deprecation);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER provider(Optional<? extends OptionProvider> provider) {
            Objects.requireNonNull(provider);
            this.provider = provider.map(OptionProvider.class::cast).orElse(this.provider);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER singular(Optional<? extends OptionSingular> singular) {
            Objects.requireNonNull(singular);
            this.singular = singular.map(OptionSingular.class::cast).orElse(this.singular);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER builderInfo(Optional<? extends OptionBuilder> builderInfo) {
            Objects.requireNonNull(builderInfo);
            this.builderInfo = builderInfo.map(OptionBuilder.class::cast).orElse(this.builderInfo);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER runtimeType(Optional<? extends RuntimeTypeInfo> runtimeType) {
            Objects.requireNonNull(runtimeType);
            this.runtimeType = runtimeType.map(RuntimeTypeInfo.class::cast).orElse(this.runtimeType);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER description(Optional<String> description) {
            Objects.requireNonNull(description);
            this.description = description.orElse(this.description);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER paramDescription(Optional<String> paramDescription) {
            Objects.requireNonNull(paramDescription);
            this.paramDescription = paramDescription.orElse(this.paramDescription);
            return (BUILDER)((BuilderBase)this.self());
        }

        protected static class OptionInfoImpl
        implements OptionInfo {
            private final AccessModifier accessModifier;
            private final boolean builderOptionOnly;
            private final boolean confidential;
            private final boolean includeInEqualsAndHashCode;
            private final boolean includeInToString;
            private final boolean registryService;
            private final boolean required;
            private final boolean sameGeneric;
            private final List<OptionAllowedValue> allowedValues;
            private final List<Annotation> annotations;
            private final List<Annotation> inheritedAnnotations;
            private final List<Annotation> qualifiers;
            private final Optional<OptionBuilder> builderInfo;
            private final Optional<OptionConfigured> configured;
            private final Optional<OptionDeprecation> deprecation;
            private final Optional<OptionProvider> provider;
            private final Optional<OptionSingular> singular;
            private final Optional<RuntimeTypeInfo> runtimeType;
            private final Optional<TypeInfo> declaringType;
            private final Optional<TypeName> decorator;
            private final Optional<TypedElementInfo> interfaceMethod;
            private final Optional<String> description;
            private final Optional<String> paramDescription;
            private final Optional<Consumer<ContentBuilder<?>>> defaultValue;
            private final String getterName;
            private final String name;
            private final String setterName;
            private final TypeName declaredType;

            protected OptionInfoImpl(BuilderBase<?, ?> builder) {
                this.interfaceMethod = builder.interfaceMethod().map(Function.identity());
                this.declaringType = builder.declaringType().map(Function.identity());
                this.name = builder.name().get();
                this.getterName = builder.getterName().get();
                this.setterName = builder.setterName().get();
                this.declaredType = builder.declaredType().get();
                this.decorator = builder.decorator().map(Function.identity());
                this.includeInToString = builder.includeInToString();
                this.includeInEqualsAndHashCode = builder.includeInEqualsAndHashCode();
                this.confidential = builder.confidential();
                this.registryService = builder.registryService();
                this.sameGeneric = builder.sameGeneric();
                this.required = builder.required();
                this.builderOptionOnly = builder.builderOptionOnly();
                this.qualifiers = List.copyOf(builder.qualifiers());
                this.allowedValues = List.copyOf(builder.allowedValues());
                this.defaultValue = builder.defaultValue().map(Function.identity());
                this.configured = builder.configured().map(Function.identity());
                this.deprecation = builder.deprecation().map(Function.identity());
                this.provider = builder.provider().map(Function.identity());
                this.singular = builder.singular().map(Function.identity());
                this.accessModifier = builder.accessModifier();
                this.builderInfo = builder.builderInfo().map(Function.identity());
                this.runtimeType = builder.runtimeType().map(Function.identity());
                this.description = builder.description().map(Function.identity());
                this.paramDescription = builder.paramDescription().map(Function.identity());
                this.annotations = List.copyOf(builder.annotations());
                this.inheritedAnnotations = List.copyOf(builder.inheritedAnnotations());
            }

            @Override
            public Optional<TypedElementInfo> interfaceMethod() {
                return this.interfaceMethod;
            }

            @Override
            public Optional<TypeInfo> declaringType() {
                return this.declaringType;
            }

            @Override
            public String name() {
                return this.name;
            }

            @Override
            public String getterName() {
                return this.getterName;
            }

            @Override
            public String setterName() {
                return this.setterName;
            }

            @Override
            public TypeName declaredType() {
                return this.declaredType;
            }

            @Override
            public Optional<TypeName> decorator() {
                return this.decorator;
            }

            @Override
            public boolean includeInToString() {
                return this.includeInToString;
            }

            @Override
            public boolean includeInEqualsAndHashCode() {
                return this.includeInEqualsAndHashCode;
            }

            @Override
            public boolean confidential() {
                return this.confidential;
            }

            @Override
            public boolean registryService() {
                return this.registryService;
            }

            @Override
            public boolean sameGeneric() {
                return this.sameGeneric;
            }

            @Override
            public boolean required() {
                return this.required;
            }

            @Override
            public boolean builderOptionOnly() {
                return this.builderOptionOnly;
            }

            @Override
            public List<Annotation> qualifiers() {
                return this.qualifiers;
            }

            @Override
            public List<OptionAllowedValue> allowedValues() {
                return this.allowedValues;
            }

            @Override
            public Optional<Consumer<ContentBuilder<?>>> defaultValue() {
                return this.defaultValue;
            }

            @Override
            public Optional<OptionConfigured> configured() {
                return this.configured;
            }

            @Override
            public Optional<OptionDeprecation> deprecation() {
                return this.deprecation;
            }

            @Override
            public Optional<OptionProvider> provider() {
                return this.provider;
            }

            @Override
            public Optional<OptionSingular> singular() {
                return this.singular;
            }

            @Override
            public AccessModifier accessModifier() {
                return this.accessModifier;
            }

            @Override
            public Optional<OptionBuilder> builderInfo() {
                return this.builderInfo;
            }

            @Override
            public Optional<RuntimeTypeInfo> runtimeType() {
                return this.runtimeType;
            }

            @Override
            public Optional<String> description() {
                return this.description;
            }

            @Override
            public Optional<String> paramDescription() {
                return this.paramDescription;
            }

            public List<Annotation> annotations() {
                return this.annotations;
            }

            public List<Annotation> inheritedAnnotations() {
                return this.inheritedAnnotations;
            }

            public String toString() {
                return "OptionInfo{interfaceMethod=" + String.valueOf(this.interfaceMethod) + ",declaringType=" + String.valueOf(this.declaringType) + ",name=" + this.name + ",getterName=" + this.getterName + ",setterName=" + this.setterName + ",declaredType=" + String.valueOf(this.declaredType) + ",decorator=" + String.valueOf(this.decorator) + ",includeInToString=" + this.includeInToString + ",includeInEqualsAndHashCode=" + this.includeInEqualsAndHashCode + ",confidential=" + this.confidential + ",registryService=" + this.registryService + ",sameGeneric=" + this.sameGeneric + ",required=" + this.required + ",builderOptionOnly=" + this.builderOptionOnly + ",qualifiers=" + String.valueOf(this.qualifiers) + ",allowedValues=" + String.valueOf(this.allowedValues) + ",defaultValue=" + String.valueOf(this.defaultValue) + ",configured=" + String.valueOf(this.configured) + ",deprecation=" + String.valueOf(this.deprecation) + ",provider=" + String.valueOf(this.provider) + ",singular=" + String.valueOf(this.singular) + ",accessModifier=" + String.valueOf(this.accessModifier) + ",builderInfo=" + String.valueOf(this.builderInfo) + ",runtimeType=" + String.valueOf(this.runtimeType) + ",description=" + String.valueOf(this.description) + ",paramDescription=" + String.valueOf(this.paramDescription) + ",annotations=" + String.valueOf(this.annotations) + ",inheritedAnnotations=" + String.valueOf(this.inheritedAnnotations) + "}";
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof OptionInfo)) {
                    return false;
                }
                OptionInfo other = (OptionInfo)o;
                return Objects.equals(this.interfaceMethod, other.interfaceMethod()) && Objects.equals(this.declaringType, other.declaringType()) && Objects.equals(this.name, other.name()) && Objects.equals(this.getterName, other.getterName()) && Objects.equals(this.setterName, other.setterName()) && Objects.equals(this.declaredType, other.declaredType()) && Objects.equals(this.decorator, other.decorator()) && this.includeInToString == other.includeInToString() && this.includeInEqualsAndHashCode == other.includeInEqualsAndHashCode() && this.confidential == other.confidential() && this.registryService == other.registryService() && this.sameGeneric == other.sameGeneric() && this.required == other.required() && this.builderOptionOnly == other.builderOptionOnly() && Objects.equals(this.qualifiers, other.qualifiers()) && Objects.equals(this.allowedValues, other.allowedValues()) && Objects.equals(this.defaultValue, other.defaultValue()) && Objects.equals(this.configured, other.configured()) && Objects.equals(this.deprecation, other.deprecation()) && Objects.equals(this.provider, other.provider()) && Objects.equals(this.singular, other.singular()) && Objects.equals(this.accessModifier, other.accessModifier()) && Objects.equals(this.builderInfo, other.builderInfo()) && Objects.equals(this.runtimeType, other.runtimeType()) && Objects.equals(this.description, other.description()) && Objects.equals(this.paramDescription, other.paramDescription()) && Objects.equals(this.annotations, other.annotations()) && Objects.equals(this.inheritedAnnotations, other.inheritedAnnotations());
            }

            public int hashCode() {
                return Objects.hash(this.interfaceMethod, this.declaringType, this.name, this.getterName, this.setterName, this.declaredType, this.decorator, this.includeInToString, this.includeInEqualsAndHashCode, this.confidential, this.registryService, this.sameGeneric, this.required, this.builderOptionOnly, this.qualifiers, this.allowedValues, this.defaultValue, this.configured, this.deprecation, this.provider, this.singular, this.accessModifier, this.builderInfo, this.runtimeType, this.description, this.paramDescription, this.annotations, this.inheritedAnnotations);
            }
        }
    }
}

