/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.builder.codegen;

import io.helidon.builder.api.Prototype;
import io.helidon.common.Errors;
import java.util.Objects;
import java.util.Optional;

public interface OptionAllowedValue
extends Prototype.Api {
    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(OptionAllowedValue instance) {
        return (Builder)OptionAllowedValue.builder().from(instance);
    }

    public String value();

    public String description();

    public static class Builder
    extends BuilderBase<Builder, OptionAllowedValue>
    implements io.helidon.common.Builder<Builder, OptionAllowedValue> {
        private Builder() {
        }

        public OptionAllowedValue buildPrototype() {
            this.preBuildPrototype();
            this.validatePrototype();
            return new BuilderBase.OptionAllowedValueImpl(this);
        }

        public OptionAllowedValue build() {
            return this.buildPrototype();
        }
    }

    public static abstract class BuilderBase<BUILDER extends BuilderBase<BUILDER, PROTOTYPE>, PROTOTYPE extends OptionAllowedValue>
    implements Prototype.Builder<BUILDER, PROTOTYPE> {
        private String description;
        private String value;

        protected BuilderBase() {
        }

        public BUILDER from(OptionAllowedValue prototype) {
            this.value(prototype.value());
            this.description(prototype.description());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER from(BuilderBase<?, ?> builder) {
            builder.value().ifPresent(this::value);
            builder.description().ifPresent(this::description);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER value(String value) {
            Objects.requireNonNull(value);
            this.value = value;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER description(String description) {
            Objects.requireNonNull(description);
            this.description = description;
            return (BUILDER)((BuilderBase)this.self());
        }

        public Optional<String> value() {
            return Optional.ofNullable(this.value);
        }

        public Optional<String> description() {
            return Optional.ofNullable(this.description);
        }

        public String toString() {
            return "OptionAllowedValueBuilder{value=" + this.value + ",description=" + this.description + "}";
        }

        protected void preBuildPrototype() {
        }

        protected void validatePrototype() {
            Errors.Collector collector = Errors.collector();
            if (this.value == null) {
                collector.fatal(this.getClass(), "Property \"value\" must not be null, but not set");
            }
            if (this.description == null) {
                collector.fatal(this.getClass(), "Property \"description\" must not be null, but not set");
            }
            collector.collect().checkValid();
        }

        protected static class OptionAllowedValueImpl
        implements OptionAllowedValue {
            private final String description;
            private final String value;

            protected OptionAllowedValueImpl(BuilderBase<?, ?> builder) {
                this.value = builder.value().get();
                this.description = builder.description().get();
            }

            @Override
            public String value() {
                return this.value;
            }

            @Override
            public String description() {
                return this.description;
            }

            public String toString() {
                return "OptionAllowedValue{value=" + this.value + ",description=" + this.description + "}";
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof OptionAllowedValue)) {
                    return false;
                }
                OptionAllowedValue other = (OptionAllowedValue)o;
                return Objects.equals(this.value, other.value()) && Objects.equals(this.description, other.description());
            }

            public int hashCode() {
                return Objects.hash(this.value, this.description);
            }
        }
    }
}

