/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.builder.codegen;

import io.helidon.builder.codegen.GeneratedMethod;
import io.helidon.builder.codegen.Utils;
import io.helidon.codegen.CodegenException;
import io.helidon.codegen.classmodel.ContentBuilder;
import io.helidon.codegen.classmodel.Javadoc;
import io.helidon.common.types.AccessModifier;
import io.helidon.common.types.Annotation;
import io.helidon.common.types.Modifier;
import io.helidon.common.types.TypeName;
import io.helidon.common.types.TypeNames;
import io.helidon.common.types.TypedElementInfo;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;

class GeneratedMethods {
    private GeneratedMethods() {
    }

    public static GeneratedMethod createPrototypeMethod(TypeName declaringType, TypedElementInfo referencedMethod, List<Annotation> annotations, TypedElementInfo defaultMethodOnBlueprint) {
        return GeneratedMethods.prototypeMethodBuilder(declaringType, referencedMethod, annotations, referencedMethod.description().filter(Predicate.not(String::isBlank)).or(() -> ((TypedElementInfo)defaultMethodOnBlueprint).description()).orElse(null));
    }

    static GeneratedMethod createPrototypeMethod(TypeName declaringType, TypedElementInfo referenceMethod, List<Annotation> annotations) {
        return GeneratedMethods.prototypeMethodBuilder(declaringType, referenceMethod, annotations, referenceMethod.description().orElse(null));
    }

    static GeneratedMethod createFactoryMethod(TypeName declaringType, TypedElementInfo referenceMethod, List<Annotation> annotations) {
        TypedElementInfo newOne = ((TypedElementInfo.Builder)((TypedElementInfo.Builder)((TypedElementInfo.Builder)((TypedElementInfo.Builder)((TypedElementInfo.Builder)TypedElementInfo.builder().from(referenceMethod)).clearEnclosingType()).accessModifier(AccessModifier.PUBLIC)).annotations(annotations)).elementModifiers(Set.of(Modifier.STATIC))).build();
        List<String> paramNames = referenceMethod.parameterArguments().stream().map(TypedElementInfo::elementName).toList();
        Consumer<ContentBuilder<?>> content = cb -> {
            if (!newOne.typeName().equals((Object)TypeNames.PRIMITIVE_VOID)) {
                cb.addContent("return ");
            }
            cb.addContent(declaringType).addContent(".").addContent(referenceMethod.elementName()).addContent("(");
            cb.addContent(String.join((CharSequence)", ", paramNames));
            cb.addContentLine(");");
        };
        return ((GeneratedMethod.Builder)((GeneratedMethod.Builder)((GeneratedMethod.Builder)GeneratedMethod.builder().method(newOne)).contentBuilder(content)).update(it -> referenceMethod.description().map(Javadoc::parse).ifPresent(it::javadoc))).build();
    }

    static GeneratedMethod createBuilderMethod(TypeName declaringType, TypedElementInfo referenceMethod, List<Annotation> annotations) {
        List list = referenceMethod.parameterArguments();
        if (list.isEmpty()) {
            throw new CodegenException("Custom builder method must have at least one parameter - the builder base itself", (Object)referenceMethod);
        }
        ArrayList newList = new ArrayList(list);
        newList.removeFirst();
        List<String> paramNames = newList.stream().map(TypedElementInfo::elementName).toList();
        Javadoc javadoc = Javadoc.parse((String)referenceMethod.description().orElse(""));
        Map originalParamsJavadoc = javadoc.parameters();
        LinkedHashMap<String, List> newParamsJavadoc = new LinkedHashMap<String, List>();
        for (String paramName : paramNames) {
            List doc = (List)originalParamsJavadoc.get(paramName);
            if (doc == null) continue;
            newParamsJavadoc.put(paramName, doc);
        }
        Javadoc newJavadoc = Javadoc.builder().from(javadoc).parameters(newParamsJavadoc).returnDescription("updated builder instance").build();
        TypedElementInfo newOne = ((TypedElementInfo.Builder)((TypedElementInfo.Builder)((TypedElementInfo.Builder)((TypedElementInfo.Builder)((TypedElementInfo.Builder)((TypedElementInfo.Builder)((TypedElementInfo.Builder)((TypedElementInfo.Builder)TypedElementInfo.builder().from(referenceMethod)).typeName(Utils.builderReturnType())).clearEnclosingType()).parameterArguments(newList)).accessModifier(AccessModifier.PUBLIC)).annotations(annotations)).clearModifiers()).elementModifiers(Set.of())).build();
        Consumer<ContentBuilder<?>> content = cb -> {
            cb.addContent(declaringType).addContent(".").addContent(referenceMethod.elementName()).addContent("(this");
            if (!paramNames.isEmpty()) {
                cb.addContent(", ");
            }
            cb.addContent(String.join((CharSequence)", ", paramNames));
            cb.addContentLine(");").addContentLine("return self();");
        };
        return ((GeneratedMethod.Builder)((GeneratedMethod.Builder)((GeneratedMethod.Builder)GeneratedMethod.builder().javadoc(newJavadoc)).method(newOne)).contentBuilder(content)).build();
    }

    private static GeneratedMethod prototypeMethodBuilder(TypeName declaringType, TypedElementInfo referenceMethod, List<Annotation> annotations, String description) {
        List list = referenceMethod.parameterArguments();
        if (list.isEmpty()) {
            throw new CodegenException("Custom prototype method must have at least one parameter - the prototype itself", (Object)referenceMethod);
        }
        ArrayList newList = new ArrayList(list);
        newList.removeFirst();
        List<String> paramNames = newList.stream().map(TypedElementInfo::elementName).toList();
        TypedElementInfo newOne = ((TypedElementInfo.Builder)((TypedElementInfo.Builder)((TypedElementInfo.Builder)((TypedElementInfo.Builder)((TypedElementInfo.Builder)((TypedElementInfo.Builder)((TypedElementInfo.Builder)TypedElementInfo.builder().from(referenceMethod)).clearEnclosingType()).parameterArguments(newList)).accessModifier(AccessModifier.PUBLIC)).annotations(annotations)).clearModifiers()).elementModifiers(Set.of(Modifier.DEFAULT))).build();
        Consumer<ContentBuilder<?>> content = cb -> {
            if (!newOne.typeName().equals((Object)TypeNames.PRIMITIVE_VOID)) {
                cb.addContent("return ");
            }
            cb.addContent(declaringType).addContent(".").addContent(referenceMethod.elementName()).addContent("(this");
            if (!paramNames.isEmpty()) {
                cb.addContent(", ");
            }
            cb.addContent(String.join((CharSequence)", ", paramNames));
            cb.addContentLine(");");
        };
        GeneratedMethod.Builder gmb = (GeneratedMethod.Builder)((GeneratedMethod.Builder)GeneratedMethod.builder().method(newOne)).contentBuilder(content);
        if (description != null && !description.isBlank()) {
            Javadoc javadoc = Javadoc.parse((String)description);
            Map originalParamsJavadoc = javadoc.parameters();
            LinkedHashMap<String, List> newParamsJavadoc = new LinkedHashMap<String, List>();
            for (String paramName : paramNames) {
                List doc = (List)originalParamsJavadoc.get(paramName);
                if (doc == null) continue;
                newParamsJavadoc.put(paramName, doc);
            }
            Javadoc newJavadoc = Javadoc.builder().from(javadoc).parameters(newParamsJavadoc).build();
            gmb.javadoc(newJavadoc);
        }
        return gmb.build();
    }
}

