/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.builder.codegen;

import io.helidon.builder.codegen.BuilderCodegen;
import io.helidon.builder.codegen.GeneratedMethod;
import io.helidon.builder.codegen.OptionAllowedValue;
import io.helidon.builder.codegen.OptionConfigured;
import io.helidon.builder.codegen.OptionHandler;
import io.helidon.builder.codegen.OptionInfo;
import io.helidon.builder.codegen.OptionMethodType;
import io.helidon.builder.codegen.OptionProvider;
import io.helidon.builder.codegen.PrototypeInfo;
import io.helidon.builder.codegen.TypeHandler;
import io.helidon.builder.codegen.Types;
import io.helidon.builder.codegen.Utils;
import io.helidon.builder.codegen.spi.BuilderCodegenExtension;
import io.helidon.codegen.CodegenUtil;
import io.helidon.codegen.classmodel.ClassBase;
import io.helidon.codegen.classmodel.ClassModel;
import io.helidon.codegen.classmodel.Constructor;
import io.helidon.codegen.classmodel.ContentBuilder;
import io.helidon.codegen.classmodel.Field;
import io.helidon.codegen.classmodel.InnerClass;
import io.helidon.codegen.classmodel.Javadoc;
import io.helidon.codegen.classmodel.Method;
import io.helidon.codegen.classmodel.Parameter;
import io.helidon.codegen.classmodel.TypeArgument;
import io.helidon.common.Errors;
import io.helidon.common.types.AccessModifier;
import io.helidon.common.types.Annotations;
import io.helidon.common.types.TypeName;
import io.helidon.common.types.TypeNames;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;

final class GenerateAbstractBuilder {
    private static final String SERVICE_REGISTRY_CONFIG_KEY = "service-registry";
    private static final TypeName OPTIONAL_COMMON_CONFIG = ((TypeName.Builder)TypeName.builder((TypeName)TypeNames.OPTIONAL).addTypeArgument(Types.COMMON_CONFIG)).build();

    private GenerateAbstractBuilder() {
    }

    static void generate(List<BuilderCodegenExtension> extensions, ClassModel.Builder classModel, PrototypeInfo prototypeInfo, List<TypeArgument> typeArguments, List<TypeName> typeArgumentNames, List<OptionHandler> options, List<BuilderCodegen.NewDefault> newDefaults) {
        Optional<TypeName> superType = prototypeInfo.superPrototype();
        TypeName prototype = prototypeInfo.prototypeType();
        classModel.addInnerClass(builder -> {
            typeArguments.forEach(arg_0 -> ((InnerClass.Builder)builder).addGenericArgument(arg_0));
            ((InnerClass.Builder)((InnerClass.Builder)((InnerClass.Builder)((InnerClass.Builder)((InnerClass.Builder)((InnerClass.Builder)builder.name("BuilderBase")).isAbstract(true)).accessModifier(AccessModifier.PACKAGE_PRIVATE)).addGenericArgument(token -> token.token("BUILDER").bound(((TypeName.Builder)((TypeName.Builder)((TypeName.Builder)((TypeName.Builder)TypeName.builder().from(TypeName.create((String)(prototype.fqName() + ".BuilderBase")))).addTypeArguments(typeArgumentNames)).addTypeArgument(TypeName.createFromGenericDeclaration((String)"BUILDER"))).addTypeArgument(TypeName.createFromGenericDeclaration((String)"PROTOTYPE"))).build()))).addGenericArgument(token -> token.token("PROTOTYPE").bound(prototype))).javadoc(prototypeInfo.builderBaseJavadoc())).addConstructor(constructor -> GenerateAbstractBuilder.createConstructor(constructor, prototypeInfo, newDefaults));
            superType.ifPresent(type -> builder.superType(((TypeName.Builder)((TypeName.Builder)((TypeName.Builder)TypeName.builder().from(TypeName.create((String)(type.fqName() + ".BuilderBase")))).addTypeArgument(TypeName.createFromGenericDeclaration((String)"BUILDER"))).addTypeArgument(TypeName.createFromGenericDeclaration((String)"PROTOTYPE"))).build()));
            if (prototypeInfo.configured().isPresent() || GenerateAbstractBuilder.hasConfig(options)) {
                builder.addInterface(((TypeName.Builder)((TypeName.Builder)((TypeName.Builder)TypeName.builder().from(Types.CONFIG_CONFIGURED_BUILDER)).addTypeArgument(TypeName.createFromGenericDeclaration((String)"BUILDER"))).addTypeArgument(TypeName.createFromGenericDeclaration((String)"PROTOTYPE"))).build());
            } else {
                builder.addInterface(((TypeName.Builder)((TypeName.Builder)((TypeName.Builder)TypeName.builder().from(Types.PROTOTYPE_BUILDER)).addTypeArgument(TypeName.createFromGenericDeclaration((String)"BUILDER"))).addTypeArgument(TypeName.createFromGenericDeclaration((String)"PROTOTYPE"))).build());
            }
            GenerateAbstractBuilder.fields(builder, prototypeInfo, options, true);
            GenerateAbstractBuilder.fromInstanceMethod(builder, prototypeInfo, options, prototype);
            GenerateAbstractBuilder.fromBuilderMethod(builder, prototypeInfo, options, typeArgumentNames);
            GenerateAbstractBuilder.preBuildPrototypeMethod(extensions, builder, prototypeInfo, options);
            GenerateAbstractBuilder.validatePrototypeMethod(extensions, builder, prototypeInfo, options);
            GenerateAbstractBuilder.addCustomBuilderMethods(builder, prototypeInfo);
            GenerateAbstractBuilder.builderMethods(builder, prototypeInfo, options);
            GenerateAbstractBuilder.toString(builder, prototypeInfo, prototype.className() + "Builder", superType.isPresent(), options, true);
            GenerateAbstractBuilder.generatePrototypeImpl(extensions, builder, prototypeInfo, options, typeArguments, typeArgumentNames);
            extensions.forEach(it -> it.updateBuilderBase(prototypeInfo, Utils.options(options), (ClassBase.Builder<?, ?>)builder));
        });
    }

    static void buildRuntimeObjectMethod(InnerClass.Builder classBuilder, PrototypeInfo prototypeInfo, TypeName runtimeType, boolean isBuilder) {
        boolean hasRuntimeObject = !prototypeInfo.prototypeType().equals((Object)runtimeType);
        Method.Builder builder = (Method.Builder)((Method.Builder)((Method.Builder)Method.builder().name("build")).addAnnotation(Annotations.OVERRIDE)).returnType(runtimeType).addContent("return ");
        if (hasRuntimeObject) {
            builder.addContent(runtimeType.genericTypeName());
            if (isBuilder) {
                builder.addContentLine(".create(this.buildPrototype());");
            } else {
                builder.addContentLine(".create(this);");
            }
        } else if (isBuilder) {
            builder.addContentLine("build();");
        } else {
            builder.addContentLine("this;");
        }
        classBuilder.addMethod(builder);
        if (!isBuilder) {
            classBuilder.addMethod(method -> ((Method.Builder)((Method.Builder)method.name("get")).returnType(runtimeType).addAnnotation(Annotations.OVERRIDE)).addContentLine("return build();"));
        }
    }

    static boolean hasConfig(List<OptionHandler> properties) {
        return properties.stream().map(OptionHandler::option).anyMatch(GenerateAbstractBuilder::isConfigOption);
    }

    static boolean hasRequired(List<OptionHandler> properties) {
        return properties.stream().map(OptionHandler::option).anyMatch(OptionInfo::required);
    }

    static boolean hasAllowedValues(List<OptionHandler> properties) {
        return properties.stream().map(OptionHandler::option).anyMatch(it -> !it.allowedValues().isEmpty());
    }

    private static void addCustomBuilderMethods(InnerClass.Builder builder, PrototypeInfo prototypeInfo) {
        for (GeneratedMethod builderMethod : prototypeInfo.builderMethods()) {
            Utils.addGeneratedMethod(builder, builderMethod);
        }
    }

    private static void createConstructor(Constructor.Builder constructor, PrototypeInfo typeContext, List<BuilderCodegen.NewDefault> newDefaults) {
        ((Constructor.Builder)constructor.description("Protected to support extensibility.")).accessModifier(AccessModifier.PROTECTED);
        for (BuilderCodegen.NewDefault newDefault : newDefaults) {
            ((Constructor.Builder)((Constructor.Builder)((Constructor.Builder)constructor.addContent(newDefault.setterName())).addContent("(")).update(it -> newDefault.defaultValue().accept((ContentBuilder<?>)it))).addContentLine(");");
        }
    }

    private static void builderMethods(InnerClass.Builder classBuilder, PrototypeInfo prototypeInfo, List<OptionHandler> options) {
        if (prototypeInfo.configured().isPresent() || GenerateAbstractBuilder.hasConfig(options)) {
            GenerateAbstractBuilder.createConfigMethod(classBuilder, prototypeInfo, options);
        }
        for (OptionHandler optionHandler : options) {
            if (GenerateAbstractBuilder.isConfigOption(optionHandler.option())) continue;
            optionHandler.typeHandler().setters(classBuilder);
        }
        for (OptionHandler optionHandler : options) {
            optionHandler.typeHandler().optionMethod(OptionMethodType.BUILDER_GETTER).ifPresent(it -> Utils.addGeneratedMethod(classBuilder, it));
        }
    }

    private static void createConfigMethod(InnerClass.Builder classBuilder, PrototypeInfo prototypeInfo, List<OptionHandler> options) {
        Javadoc javadoc = Javadoc.builder().addLine("Update builder from configuration (node of this type).").addLine("If a value is present in configuration, it would override currently configured values.").build();
        classBuilder.addMethod(commonConfig -> ((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)commonConfig.name("config")).javadoc(Javadoc.builder((Javadoc)javadoc).addTag("deprecated", "use {@link #config(" + Types.CONFIG.fqName() + ")}").build())).returnType((TypeName)TypeArgument.create((String)"BUILDER"), "updated builder instance").addParameter(param -> ((Parameter.Builder)param.name("config")).type(Types.COMMON_CONFIG).description("configuration instance used to obtain values to update this builder"))).addAnnotation(Annotations.DEPRECATED)).addContent("return config(")).addContent(Types.CONFIG)).addContentLine(".config(config));"));
        Method.Builder builder = (Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)Method.builder().name("config")).javadoc(javadoc)).returnType((TypeName)TypeArgument.create((String)"BUILDER"), "updated builder instance").addParameter(param -> ((Parameter.Builder)param.name("config")).type(Types.CONFIG).description("configuration instance used to obtain values to update this builder"))).addAnnotation(Annotations.OVERRIDE)).addContent(Objects.class)).addContentLine(".requireNonNull(config);");
        if (prototypeInfo.superPrototype().isPresent()) {
            builder.addContentLine("super.config(config);");
        } else {
            builder.addContentLine("this.config = config;");
        }
        for (OptionHandler optionHandler : options) {
            OptionInfo option = optionHandler.option();
            if (!option.configured().isPresent() || !option.provider().isEmpty()) continue;
            OptionConfigured optionConfigured = option.configured().get();
            if (option.registryService()) {
                ((Method.Builder)((Method.Builder)((Method.Builder)builder.addContent("if (!config.get(")).addContentLiteral(optionConfigured.configKey() + ".service-registry")).addContentLine(").exists()) {")).increaseContentPadding();
            }
            optionHandler.typeHandler().generateFromConfig(builder, optionConfigured);
            if (!option.registryService()) continue;
            ((Method.Builder)builder.decreaseContentPadding()).addContentLine("}");
        }
        builder.addContentLine("return self();");
        classBuilder.addMethod(builder);
    }

    private static void fromInstanceMethod(InnerClass.Builder builder, PrototypeInfo prototypeInfo, List<OptionHandler> options, TypeName prototype) {
        Method.Builder methodBuilder = ((Method.Builder)((Method.Builder)((Method.Builder)Method.builder().name("from")).returnType((TypeName)TypeArgument.create((String)"BUILDER")).description("Update this builder from an existing prototype instance. This method disables automatic service discovery.")).addParameter(param -> ((Parameter.Builder)param.name("prototype")).type(prototype).description("existing prototype to update this builder from"))).returnType((TypeName)TypeArgument.create((String)"BUILDER"), "updated builder instance");
        prototypeInfo.superPrototype().ifPresent(it -> methodBuilder.addContentLine("super.from(prototype);"));
        for (OptionHandler optionHandler : options) {
            TypeHandler typeHandler = optionHandler.typeHandler();
            typeHandler.fromPrototypeAssignment((ContentBuilder<?>)methodBuilder);
        }
        methodBuilder.addContentLine("return self();");
        builder.addMethod(methodBuilder);
    }

    private static void fromBuilderMethod(InnerClass.Builder classBuilder, PrototypeInfo prototypeInfo, List<OptionHandler> options, List<TypeName> arguments) {
        TypeName prototype = prototypeInfo.prototypeType();
        TypeName parameterType = ((TypeName.Builder)((TypeName.Builder)((TypeName.Builder)((TypeName.Builder)TypeName.builder().from(TypeName.create((String)(prototype.fqName() + ".BuilderBase")))).addTypeArguments(arguments)).addTypeArgument(TypeName.createFromGenericDeclaration((String)"?"))).addTypeArgument(TypeName.createFromGenericDeclaration((String)"?"))).build();
        Method.Builder methodBuilder = (Method.Builder)((Method.Builder)((Method.Builder)Method.builder().name("from")).addParameter(param -> ((Parameter.Builder)param.name("builder")).type(parameterType).description("existing builder prototype to update this builder from"))).returnType((TypeName)TypeArgument.create((String)"BUILDER"), "updated builder instance").description("Update this builder from an existing prototype builder instance.");
        prototypeInfo.superPrototype().ifPresent(it -> methodBuilder.addContentLine("super.from(builder);"));
        for (OptionHandler optionHandler : options) {
            TypeHandler typeHandler = optionHandler.typeHandler();
            typeHandler.fromBuilderAssignment((ContentBuilder<?>)methodBuilder);
        }
        methodBuilder.addContentLine("return self();");
        classBuilder.addMethod(methodBuilder);
    }

    private static void fields(InnerClass.Builder classBuilder, PrototypeInfo prototypeInfo, List<OptionHandler> options, boolean isBuilder) {
        if (isBuilder && (prototypeInfo.configured().isPresent() || GenerateAbstractBuilder.hasConfig(options)) && prototypeInfo.superPrototype().isEmpty()) {
            classBuilder.addField(builder -> builder.type(Types.CONFIG).name("config"));
        }
        if (isBuilder && prototypeInfo.registrySupport()) {
            classBuilder.addField(builder -> builder.type(Types.SERVICE_REGISTRY).name("serviceRegistry"));
        }
        for (OptionHandler optionHandler : options) {
            if (!isBuilder && optionHandler.option().builderOptionOnly()) continue;
            OptionInfo option = optionHandler.option();
            if (isBuilder && !option.allowedValues().isEmpty()) {
                String allowedValues = option.allowedValues().stream().map(OptionAllowedValue::value).map(it -> "\"" + it + "\"").collect(Collectors.joining(", "));
                classBuilder.addField(it -> ((Field.Builder)((Field.Builder)it.isFinal(true).isStatic(true).name(option.name().toUpperCase(Locale.ROOT) + "_ALLOWED_VALUES")).type(((TypeName.Builder)TypeName.builder((TypeName)TypeNames.SET).addTypeArgument(TypeNames.STRING)).build()).addContent(Set.class)).addContent(".of(").addContent(allowedValues).addContent(")"));
            }
            if (!isBuilder || !GenerateAbstractBuilder.isConfigOption(option)) {
                optionHandler.typeHandler().fields((ClassBase.Builder<?, ?>)classBuilder, isBuilder);
            }
            if (isBuilder && option.provider().isPresent()) {
                OptionProvider provider = option.provider().get();
                classBuilder.addField(builder -> ((Field.Builder)builder.type(Boolean.TYPE).name(option.name() + "DiscoverServices")).defaultValue(String.valueOf(provider.discoverServices())));
            }
            if (isBuilder && option.registryService()) {
                classBuilder.addField(builder -> ((Field.Builder)builder.type(Boolean.TYPE).name(option.name() + "DiscoverServices")).defaultValue("true"));
            }
            if (!isBuilder || !option.declaredType().isList() && !option.declaredType().isSet()) continue;
            classBuilder.addField(builder -> ((Field.Builder)builder.type(Boolean.TYPE).name("is" + CodegenUtil.capitalize((String)option.name()) + "Mutated")).accessModifier(AccessModifier.PRIVATE));
        }
    }

    private static boolean isConfigOption(OptionInfo option) {
        TypeName type = option.declaredType();
        if (type.isOptional()) {
            type = (TypeName)type.typeArguments().getFirst();
        }
        return type.equals((Object)Types.COMMON_CONFIG) || type.equals((Object)Types.CONFIG);
    }

    private static void preBuildPrototypeMethod(List<BuilderCodegenExtension> extensions, InnerClass.Builder classBuilder, PrototypeInfo prototypeInfo, List<OptionHandler> options) {
        Method.Builder preBuildBuilder = (Method.Builder)((Method.Builder)((Method.Builder)Method.builder().name("preBuildPrototype")).accessModifier(AccessModifier.PROTECTED)).description("Handles providers and decorators.");
        boolean hasProvider = GenerateAbstractBuilder.hasProvider(options);
        boolean hasRegistryService = GenerateAbstractBuilder.hasRegistryService(options);
        if (hasProvider) {
            preBuildBuilder.addAnnotation(builder -> builder.type(SuppressWarnings.class).addParameter("value", (Object)"unchecked"));
        }
        prototypeInfo.superPrototype().ifPresent(it -> preBuildBuilder.addContentLine("super.preBuildPrototype();"));
        if (hasProvider || hasRegistryService) {
            boolean configured = prototypeInfo.configured().isPresent();
            if (configured && GenerateAbstractBuilder.hasConfiguredRegistryServiceOrProvider(options)) {
                ((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)preBuildBuilder.addContent("var config = config().map(")).addContent(Types.CONFIG)).addContent("::config).orElseGet(")).addContent(Types.CONFIG)).addContentLine("::empty);");
            }
            if (prototypeInfo.registrySupport() || hasRegistryService) {
                ((Method.Builder)((Method.Builder)preBuildBuilder.addContent("var registry = ")).addContent(Optional.class)).addContentLine(".ofNullable(this.serviceRegistry);");
            }
            for (OptionHandler optionHandler : options) {
                OptionInfo option = optionHandler.option();
                boolean optionConfigured = option.configured().isPresent();
                if (option.provider().isPresent()) {
                    OptionProvider optionProvider = option.provider().get();
                    TypeName providerType = optionProvider.providerType();
                    if (prototypeInfo.registrySupport()) {
                        GenerateAbstractBuilder.serviceRegistryPropertyDiscovery(preBuildBuilder, optionHandler, optionConfigured, providerType);
                        continue;
                    }
                    GenerateAbstractBuilder.serviceLoaderPropertyDiscovery(preBuildBuilder, optionHandler, optionConfigured, providerType);
                    continue;
                }
                if (!option.registryService()) continue;
                GenerateAbstractBuilder.serviceRegistryProperty(preBuildBuilder, optionHandler);
            }
        }
        if (prototypeInfo.builderDecorator().isPresent()) {
            ((Method.Builder)((Method.Builder)preBuildBuilder.addContent("new ")).addContent(prototypeInfo.builderDecorator().get())).addContentLine("().decorate(this);");
        }
        extensions.forEach(it -> it.updatePreBuildPrototype(prototypeInfo, Utils.options(options), preBuildBuilder));
        classBuilder.addMethod(preBuildBuilder);
    }

    private static boolean hasConfiguredRegistryServiceOrProvider(List<OptionHandler> options) {
        boolean configured = options.stream().map(OptionHandler::option).filter(OptionInfo::registryService).anyMatch(it -> it.configured().isPresent());
        if (configured) {
            return true;
        }
        return options.stream().map(OptionHandler::option).filter(it -> it.provider().isPresent()).anyMatch(it -> it.configured().isPresent());
    }

    private static boolean hasRegistryService(List<OptionHandler> options) {
        return options.stream().map(OptionHandler::option).anyMatch(OptionInfo::registryService);
    }

    private static boolean hasProvider(List<OptionHandler> options) {
        return options.stream().map(OptionHandler::option).anyMatch(it -> it.provider().isPresent());
    }

    private static void serviceLoaderPropertyDiscovery(Method.Builder preBuildBuilder, OptionHandler optionHandler, boolean propertyConfigured, TypeName providerType) {
        TypeHandler typeHandler = optionHandler.typeHandler();
        OptionInfo option = optionHandler.option();
        TypeName typeName = option.declaredType();
        if (propertyConfigured) {
            OptionConfigured configured = option.configured().get();
            if (typeName.isList() || typeName.isSet()) {
                ((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)preBuildBuilder.addContent("this.add")).addContent(CodegenUtil.capitalize((String)option.name()))).addContent("(")).addContent(Types.CONFIG_BUILDER_SUPPORT)).addContent(".discoverServices(config, \"")).addContent(configured.configKey())).addContent("\", ")).addContent(providerType.genericTypeName())).addContent(".class, ")).addContent(typeHandler.type().genericTypeName())).addContent(".class, ")).addContent(option.name())).addContent("DiscoverServices, ")).addContent(option.name())).addContentLine("));");
            } else {
                ((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)preBuildBuilder.addContent(Types.CONFIG_BUILDER_SUPPORT)).addContent(".discoverService(config, \"")).addContent(configured.configKey())).addContent("\", ")).addContent(providerType)).addContent(".class, ")).addContent(typeHandler.type().genericTypeName())).addContent(".class, ")).addContent(option.name())).addContent("DiscoverServices, ")).addContent(Optional.class)).addContent(".ofNullable(")).addContent(option.name())).addContent(")).ifPresent(this::")).addContent(option.setterName())).addContentLine(");");
            }
        } else if (typeName.isList() || typeName.isSet()) {
            ((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)preBuildBuilder.addContent("this.add")).addContent(CodegenUtil.capitalize((String)option.name()))).addContent("(")).addContent(Types.BUILDER_SUPPORT)).addContent(".discoverServices(")).addContent(providerType.genericTypeName())).addContent(".class, ")).addContent(option.name())).addContent("DiscoverServices, ")).addContent(option.name())).addContentLine("));");
        } else {
            ((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)preBuildBuilder.addContent(Types.BUILDER_SUPPORT)).addContent(".discoverService(")).addContent(providerType)).addContent(".class, ")).addContent(option.name())).addContent("DiscoverServices, ")).addContent(Optional.class)).addContent(".ofNullable(")).addContent(option.name())).addContent(")).ifPresent(this::")).addContent(option.setterName())).addContentLine(");");
        }
    }

    private static void serviceRegistryProperty(Method.Builder preBuildBuilder, OptionHandler optionHandler) {
        OptionInfo option = optionHandler.option();
        TypeName typeName = option.declaredType();
        String namedQualifierFromAnnotation = option.qualifiers().stream().filter(a -> a.typeName().equals((Object)Types.SERVICE_NAMED)).flatMap(annotation -> annotation.stringValue().stream()).map(s -> ".of(\"" + s + "\")").findFirst().orElse(".empty()");
        ((Method.Builder)((Method.Builder)preBuildBuilder.addContent("Optional<String> ")).addContent(option.name())).addContent("Qualifier = ");
        if (option.configured().isPresent()) {
            OptionConfigured optionConfigured = option.configured().get();
            ((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)preBuildBuilder.addContent("config.get(")).addContentLiteral(optionConfigured.configKey() + ".service-registry.named")).addContentLine(")")).increaseContentPadding()).addContentLine(".asString()")).addContent(".or(() -> ")).addContent(TypeNames.OPTIONAL)).addContent(namedQualifierFromAnnotation)).addContentLine(");")).decreaseContentPadding();
        } else {
            ((Method.Builder)((Method.Builder)preBuildBuilder.addContent(TypeNames.OPTIONAL)).addContent(namedQualifierFromAnnotation)).addContentLine(";");
        }
        if (typeName.isList()) {
            ((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)preBuildBuilder.addContent("this.add")).addContent(CodegenUtil.capitalize((String)option.name()))).addContent("(")).addContent(Types.REGISTRY_BUILDER_SUPPORT)).addContent(".serviceList(registry, ")).addContentCreate(optionHandler.typeHandler().type())).addContent(", ")).addContent(option.name())).addContent("DiscoverServices, ")).addContent(option.name())).addContentLine("Qualifier));");
        } else if (typeName.isSet()) {
            ((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)preBuildBuilder.addContent("this.add")).addContent(CodegenUtil.capitalize((String)option.name()))).addContent("(")).addContent(Types.REGISTRY_BUILDER_SUPPORT)).addContent(".serviceSet(registry, ")).addContentCreate(optionHandler.typeHandler().type())).addContent(", ")).addContent(option.name())).addContent("DiscoverServices, ")).addContent(option.name())).addContentLine("Qualifier));");
        } else {
            ((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)preBuildBuilder.addContent(Types.REGISTRY_BUILDER_SUPPORT)).addContent(".service(registry, ")).addContentCreate(optionHandler.typeHandler().type())).addContent(", ")).addContent(Optional.class)).addContent(".ofNullable(")).addContent(option.name())).addContent("), ")).addContent(option.name())).addContent("DiscoverServices, ")).addContent(option.name())).addContentLine("Qualifier)")).increaseContentPadding()).addContent(".ifPresent(this::")).addContent(option.setterName())).addContentLine(");")).decreaseContentPadding();
        }
    }

    private static void serviceRegistryPropertyDiscovery(Method.Builder preBuildBuilder, OptionHandler optionHandler, boolean propertyConfigured, TypeName providerType) {
        TypeHandler typeHandler = optionHandler.typeHandler();
        OptionInfo option = optionHandler.option();
        TypeName typeName = option.declaredType();
        if (propertyConfigured) {
            OptionConfigured configured = option.configured().get();
            if (typeName.isList() || typeName.isSet()) {
                ((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)preBuildBuilder.addContent("this.add")).addContent(CodegenUtil.capitalize((String)option.name()))).addContent("(")).addContent(Types.CONFIG_BUILDER_SUPPORT)).addContentLine(".discoverServices(config,")).increaseContentPadding()).increaseContentPadding()).increaseContentPadding()).addContent("\"")).addContent(configured.configKey())).addContentLine("\",")).addContentLine("registry,")).addContent(providerType.genericTypeName())).addContentLine(".class,")).addContent(typeHandler.type().genericTypeName())).addContentLine(".class,")).addContent(option.name())).addContentLine("DiscoverServices,")).addContent(option.name())).addContentLine("));")).decreaseContentPadding()).decreaseContentPadding()).decreaseContentPadding();
            } else {
                ((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)preBuildBuilder.addContent(Types.CONFIG_BUILDER_SUPPORT)).addContentLine(".discoverService(config,")).increaseContentPadding()).increaseContentPadding()).increaseContentPadding()).addContent("\"")).addContent(configured.configKey())).addContentLine("\",")).addContentLine("registry,")).addContent(providerType)).addContentLine(".class,")).addContent(typeHandler.type().genericTypeName())).addContentLine(".class,")).addContent(option.name())).addContentLine("DiscoverServices,")).addContent(Optional.class)).addContent(".ofNullable(")).addContent(option.name())).addContentLine("))")).decreaseContentPadding()).decreaseContentPadding()).addContent(".ifPresent(this::")).addContent(option.setterName())).addContentLine(");")).decreaseContentPadding();
            }
        } else if (typeName.isList()) {
            ((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)preBuildBuilder.addContent("this.add")).addContent(CodegenUtil.capitalize((String)option.name()))).addContent("(")).addContent(Types.REGISTRY_BUILDER_SUPPORT)).addContent(".serviceList(registry, ")).addContentCreate(typeHandler.type())).addContent(", ")).addContent(option.name())).addContentLine("DiscoverServices));");
        } else if (typeName.isSet()) {
            ((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)preBuildBuilder.addContent("this.add")).addContent(CodegenUtil.capitalize((String)option.name()))).addContent("(")).addContent(Types.REGISTRY_BUILDER_SUPPORT)).addContent(".serviceSet(registry, ")).addContentCreate(typeHandler.type())).addContent(", ")).addContent(option.name())).addContentLine("DiscoverServices));");
        } else {
            ((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)preBuildBuilder.addContent(Types.REGISTRY_BUILDER_SUPPORT)).addContent(".service(registry, ")).addContentCreate(typeHandler.type())).addContent(", ")).addContent(Optional.class)).addContent(".ofNullable(")).addContent(option.name())).addContent("), ")).addContent(option.name())).addContent("DiscoverServices).ifPresent(this::")).addContent(option.setterName())).addContentLine(");");
        }
    }

    private static void validatePrototypeMethod(List<BuilderCodegenExtension> extensions, InnerClass.Builder classBuilder, PrototypeInfo prototypeInfo, List<OptionHandler> options) {
        Method.Builder validateBuilder = (Method.Builder)((Method.Builder)((Method.Builder)Method.builder().name("validatePrototype")).accessModifier(AccessModifier.PROTECTED)).description("Validates required properties.");
        prototypeInfo.superPrototype().ifPresent(it -> validateBuilder.addContentLine("super.validatePrototype();"));
        if (GenerateAbstractBuilder.hasRequired(options) || GenerateAbstractBuilder.hasAllowedValues(options)) {
            GenerateAbstractBuilder.requiredValidation(validateBuilder, options);
        }
        extensions.forEach(it -> it.updateValidatePrototype(prototypeInfo, Utils.options(options), validateBuilder));
        classBuilder.addMethod(validateBuilder);
    }

    private static void requiredValidation(Method.Builder validateBuilder, List<OptionHandler> options) {
        ((Method.Builder)((Method.Builder)((Method.Builder)validateBuilder.addContent(Errors.Collector.class)).addContent(" collector = ")).addContent(Errors.class)).addContentLine(".collector();");
        for (OptionHandler optionHandler : options) {
            OptionInfo option = optionHandler.option();
            String propertyName = option.name();
            if (option.required() && option.defaultValue().isEmpty()) {
                ((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)validateBuilder.addContentLine("if (" + propertyName + " == null) {")).addContent("collector.fatal(getClass(), \"Property \\\"")).addContent(propertyName)).addContentLine("\\\" must not be null, but not set\");")).addContentLine("}");
            }
            if (option.allowedValues().isEmpty()) continue;
            String allowedValuesConstant = propertyName.toUpperCase(Locale.ROOT) + "_ALLOWED_VALUES";
            TypeName declaredType = option.declaredType();
            if (declaredType.isList() || declaredType.isSet()) {
                String single = "single" + CodegenUtil.capitalize((String)propertyName);
                validateBuilder.addContentLine("for (var " + single + " : " + propertyName + ") {");
                ((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)validateBuilder.addContentLine("if (!" + allowedValuesConstant + ".contains(String.valueOf(" + single + "))) {")).addContent("collector.fatal(getClass(), \"Property \\\"")).addContent(propertyName)).addContent("\\\" contains value that is not within allowed values. Configured: \\\"\" + " + single + " + \"\\\"")).addContentLine(", expected one of: \\\"\" + " + allowedValuesConstant + " + \"\\\"\");");
                validateBuilder.addContentLine("}");
                validateBuilder.addContentLine("}");
                continue;
            }
            validateBuilder.addContent("if (");
            if (!declaredType.primitive()) {
                validateBuilder.addContent(propertyName + " != null && ");
            }
            ((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)validateBuilder.addContentLine("!" + allowedValuesConstant + ".contains(String.valueOf(" + propertyName + "))) {")).addContent("collector.fatal(getClass(), \"Property \\\"")).addContent(propertyName)).addContent("\\\" value is not within allowed values. Configured: \\\"\" + " + propertyName + " + \"\\\"")).addContentLine(", expected one of: \\\"\" + " + allowedValuesConstant + " + \"\\\"\");");
            validateBuilder.addContentLine("}");
        }
        validateBuilder.addContentLine("collector.collect().checkValid();");
    }

    private static void generatePrototypeImpl(List<BuilderCodegenExtension> extensions, InnerClass.Builder classBuilder, PrototypeInfo prototypeInfo, List<OptionHandler> options, List<TypeArgument> typeArguments, List<TypeName> typeArgumentNames) {
        Optional<TypeName> superPrototype = prototypeInfo.superPrototype();
        TypeName prototype = prototypeInfo.prototypeType();
        String ifaceName = prototype.className();
        String implName = ifaceName + "Impl";
        classBuilder.addInnerClass(builder -> {
            typeArguments.forEach(arg_0 -> ((InnerClass.Builder)builder).addGenericArgument(arg_0));
            ((InnerClass.Builder)((InnerClass.Builder)builder.name(implName)).accessModifier(AccessModifier.PROTECTED)).isStatic(true).description("Generated implementation of the prototype, can be extended by descendant prototype implementations.");
            superPrototype.ifPresent(it -> builder.superType(TypeName.create((String)(it.className() + "Impl"))));
            builder.addInterface(prototype);
            if (prototypeInfo.runtimeType().isPresent()) {
                TypeName runtimeType = prototypeInfo.runtimeType().get();
                builder.addInterface(((TypeName.Builder)((TypeName.Builder)TypeName.builder().type(Supplier.class)).addTypeArgument(runtimeType)).build());
            }
            GenerateAbstractBuilder.fields(builder, prototypeInfo, options, false);
            builder.addConstructor(constructor -> {
                ((Constructor.Builder)((Constructor.Builder)constructor.description("Create an instance providing a builder.")).accessModifier(AccessModifier.PROTECTED)).addParameter(param -> ((Parameter.Builder)param.name("builder")).type(((TypeName.Builder)((TypeName.Builder)((TypeName.Builder)((TypeName.Builder)TypeName.builder().from(TypeName.create((String)(ifaceName + ".BuilderBase")))).addTypeArguments(typeArgumentNames)).addTypeArgument((TypeName)TypeArgument.create((String)"?"))).addTypeArgument((TypeName)TypeArgument.create((String)"?"))).build()).description("extending builder base of this prototype"));
                superPrototype.ifPresent(it -> constructor.addContentLine("super(builder);"));
                GenerateAbstractBuilder.implAssignToFields(constructor, options);
            });
            if (prototypeInfo.runtimeType().isPresent()) {
                GenerateAbstractBuilder.buildRuntimeObjectMethod(builder, prototypeInfo, prototypeInfo.runtimeType().get(), false);
            }
            BuilderCodegen.generateCustomPrototypeMethods(builder, prototypeInfo.prototypeMethods(), true);
            GenerateAbstractBuilder.implMethods(builder, options);
            GenerateAbstractBuilder.toString(builder, prototypeInfo, ifaceName, superPrototype.isPresent(), options, false);
            GenerateAbstractBuilder.hashCodeAndEquals(builder, options, ifaceName, superPrototype.isPresent());
            extensions.forEach(it -> it.updateImplementation(prototypeInfo, Utils.options(options), (ClassBase.Builder<?, ?>)builder));
        });
    }

    private static void hashCodeAndEquals(InnerClass.Builder classBuilder, List<OptionHandler> options, String ifaceName, boolean hasSuper) {
        List<OptionHandler> equalityFields = options.stream().filter(it -> it.option().includeInEqualsAndHashCode() && !it.option().builderOptionOnly()).toList();
        GenerateAbstractBuilder.equalsMethod(classBuilder, ifaceName, hasSuper, equalityFields);
        GenerateAbstractBuilder.hashCodeMethod(classBuilder, hasSuper, equalityFields);
    }

    private static void equalsMethod(InnerClass.Builder classBuilder, String ifaceName, boolean hasSuper, List<OptionHandler> equalityFields) {
        String newLine = "\n<<padding>><<padding>>&& ";
        Method.Builder method = (Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)Method.builder().name("equals")).returnType(TypeName.create(Boolean.TYPE)).addAnnotation(Annotations.OVERRIDE)).addParameter(param -> ((Parameter.Builder)param.name("o")).type(Object.class))).addContentLine("if (o == this) {")).addContentLine("return true;")).addContentLine("}")).addContentLine("if (!(o instanceof " + ifaceName + " other)) {")).addContentLine("return false;")).addContentLine("}");
        ((Method.Builder)method.addContent("return ")).increaseContentPadding();
        if (hasSuper) {
            method.addContent("super.equals(other)");
            if (!equalityFields.isEmpty()) {
                method.addContent(newLine);
            }
        }
        if (!hasSuper && equalityFields.isEmpty()) {
            method.addContent("true");
        } else {
            Iterator<OptionHandler> equalIterator = equalityFields.iterator();
            while (equalIterator.hasNext()) {
                OptionHandler field = equalIterator.next();
                OptionInfo option = field.option();
                TypeName type = option.declaredType();
                TypeName actualType = field.typeHandler().type();
                if (type.array()) {
                    ((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)method.addContent(Arrays.class)).addContent(".equals(")).addContent(option.name())).addContent(", other.")).addContent(option.getterName())).addContent("())");
                } else if (type.primitive()) {
                    ((Method.Builder)((Method.Builder)((Method.Builder)method.addContent(option.name())).addContent(" == other.")).addContent(option.getterName())).addContent("()");
                } else if (type.isOptional() && actualType.equals((Object)Types.CHAR_ARRAY)) {
                    ((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)method.addContent(Types.GENERATED_EQUALITY_UTIL)).addContent(".optionalCharArrayEquals(")).addContent(option.name())).addContent(", other.")).addContent(option.getterName())).addContent("())");
                } else {
                    ((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)method.addContent(Objects.class)).addContent(".equals(")).addContent(option.name())).addContent(", other.")).addContent(option.getterName())).addContent("())");
                }
                if (!equalIterator.hasNext()) continue;
                ((Method.Builder)method.addContentLine("")).addContent("&& ");
            }
        }
        method.addContentLine(";");
        classBuilder.addMethod(method);
    }

    private static void hashCodeMethod(InnerClass.Builder classBuilder, boolean hasSuper, List<OptionHandler> equalityFields) {
        Method.Builder method = (Method.Builder)((Method.Builder)Method.builder().name("hashCode")).returnType(TypeName.create(Integer.TYPE)).addAnnotation(Annotations.OVERRIDE);
        if (equalityFields.isEmpty()) {
            if (hasSuper) {
                method.addContentLine("return super.hashCode();");
            } else {
                method.addContentLine("return 1;");
            }
        } else {
            if (hasSuper) {
                ((Method.Builder)((Method.Builder)method.addContent("return 31 * super.hashCode() + ")).addContent(Objects.class)).addContent(".hash(");
            } else {
                ((Method.Builder)((Method.Builder)method.addContent("return ")).addContent(Objects.class)).addContent(".hash(");
            }
            ((Method.Builder)method.addContent(equalityFields.stream().filter(it -> !it.option().declaredType().isOptional() || !it.typeHandler().type().equals((Object)Types.CHAR_ARRAY)).map(OptionHandler::option).map(OptionInfo::name).collect(Collectors.joining(", ")))).addContent(")");
            for (OptionHandler field : equalityFields) {
                if (!field.option().declaredType().isOptional() || !field.typeHandler().type().equals((Object)Types.CHAR_ARRAY)) continue;
                ((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)method.addContent(" + 31 * ")).addContent(Types.GENERATED_EQUALITY_UTIL)).addContent(".optionalCharArrayHash(")).addContent(field.option().name())).addContent(")");
            }
            method.addContent(";");
        }
        classBuilder.addMethod(method);
    }

    private static void toString(InnerClass.Builder classBuilder, PrototypeInfo prototypeInfo, String typeName, boolean hasSuper, List<OptionHandler> options, boolean isBuilder) {
        if (!isBuilder && prototypeInfo.prototypeMethods().stream().map(GeneratedMethod::method).filter(it -> "toString".equals(it.elementName())).filter(it -> it.typeName().equals((Object)TypeNames.STRING)).anyMatch(it -> it.parameterArguments().isEmpty())) {
            return;
        }
        Method.Builder method = (Method.Builder)((Method.Builder)((Method.Builder)Method.builder().name("toString")).returnType(TypeName.create(String.class)).addAnnotation(Annotations.OVERRIDE)).addContent("return \"" + typeName);
        List<OptionHandler> toStringFields = options.stream().filter(it -> it.option().includeInToString() && (isBuilder || !it.option().builderOptionOnly())).toList();
        if (toStringFields.isEmpty()) {
            method.addContentLine("{};\"");
        } else {
            ((Method.Builder)((Method.Builder)((Method.Builder)method.addContentLine("{\"")).increaseContentPadding()).increaseContentPadding()).addContentLine(toStringFields.stream().map(it -> GenerateAbstractBuilder.toStringBody(it, isBuilder)).collect(Collectors.joining(" + \",\"\n")));
            if (hasSuper) {
                method.addContentLine("+ \"};\"");
            } else {
                method.addContent("+ \"}\"");
            }
        }
        if (hasSuper) {
            method.addContent("+ super.toString()");
        }
        method.addContentLine(";");
        classBuilder.addMethod(method);
    }

    private static String toStringBody(OptionHandler it, boolean isBuilder) {
        OptionInfo option = it.option();
        TypeName typeName = it.typeHandler().type();
        boolean secret = option.confidential() || it.typeHandler().type().equals((Object)Types.CHAR_ARRAY);
        String name = option.name();
        if (secret) {
            if (typeName.primitive() && !typeName.array()) {
                return "+ \"" + name + "=****\"";
            }
            if (!isBuilder && option.declaredType().isOptional()) {
                return "+ \"" + name + "=\" + (" + name + ".isPresent() ? \"****\" : \"null\")";
            }
            return "+ \"" + name + "=\" + (" + name + " == null ? \"null\" : \"****\")";
        }
        return "+ \"" + name + "=\" + " + name;
    }

    private static void implMethods(InnerClass.Builder classBuilder, List<OptionHandler> options) {
        for (OptionHandler optionHandler : options) {
            OptionInfo option = optionHandler.option();
            if (option.builderOptionOnly()) continue;
            optionHandler.typeHandler().optionMethod(OptionMethodType.IMPL_GETTER).ifPresent(it -> Utils.addGeneratedMethod(classBuilder, it));
        }
    }

    private static void implAssignToFields(Constructor.Builder constructor, List<OptionHandler> options) {
        for (OptionHandler optionHandler : options) {
            OptionInfo option = optionHandler.option();
            if (option.builderOptionOnly()) continue;
            String getterName = option.getterName();
            constructor.addContent("this." + option.name() + " = ");
            TypeName declaredType = option.declaredType();
            if (declaredType.isOptional() || declaredType.equals((Object)OPTIONAL_COMMON_CONFIG)) {
                ((Constructor.Builder)((Constructor.Builder)constructor.addContent("builder." + getterName + "().map(")).addContent(Function.class)).addContentLine(".identity());");
                continue;
            }
            if (declaredType.isList()) {
                ((Constructor.Builder)constructor.addContent(List.class)).addContentLine(".copyOf(builder." + getterName + "());");
                continue;
            }
            if (declaredType.isSet()) {
                ((Constructor.Builder)((Constructor.Builder)((Constructor.Builder)constructor.addContent(Collections.class)).addContent(".unmodifiableSet(new ")).addContent(LinkedHashSet.class)).addContentLine("<>(builder." + getterName + "()));");
                continue;
            }
            if (declaredType.isMap()) {
                ((Constructor.Builder)((Constructor.Builder)((Constructor.Builder)constructor.addContent(Collections.class)).addContent(".unmodifiableMap(new ")).addContent(LinkedHashMap.class)).addContentLine("<>(builder." + getterName + "()));");
                continue;
            }
            if (optionHandler.typeHandler().builderGetterOptional() && !declaredType.isOptional()) {
                constructor.addContentLine("builder." + getterName + "().get();");
                continue;
            }
            constructor.addContentLine("builder." + getterName + "();");
        }
    }

    private static String toHumanReadable(String name) {
        char[] nameChars;
        StringBuilder result = new StringBuilder();
        for (char nameChar : nameChars = name.toCharArray()) {
            if (Character.isUpperCase(nameChar)) {
                if (!result.isEmpty()) {
                    result.append(' ');
                }
                result.append(Character.toLowerCase(nameChar));
                continue;
            }
            result.append(nameChar);
        }
        return result.toString();
    }
}

