/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.builder.codegen;

import io.helidon.builder.codegen.DeprecatedFactoryMethod;
import io.helidon.builder.codegen.FactoryMethod;
import io.helidon.builder.codegen.GeneratedMethod;
import io.helidon.builder.codegen.GeneratedMethods;
import io.helidon.builder.codegen.OptionBuilder;
import io.helidon.builder.codegen.PrototypeConfigured;
import io.helidon.builder.codegen.PrototypeConstant;
import io.helidon.builder.codegen.PrototypeConstants;
import io.helidon.builder.codegen.PrototypeInfo;
import io.helidon.builder.codegen.RuntimeTypeInfo;
import io.helidon.builder.codegen.Types;
import io.helidon.builder.codegen.Utils;
import io.helidon.codegen.CodegenException;
import io.helidon.codegen.ElementInfoPredicates;
import io.helidon.codegen.RoundContext;
import io.helidon.codegen.classmodel.Javadoc;
import io.helidon.common.Errors;
import io.helidon.common.types.AccessModifier;
import io.helidon.common.types.Annotated;
import io.helidon.common.types.Annotation;
import io.helidon.common.types.Annotations;
import io.helidon.common.types.ElementSignature;
import io.helidon.common.types.Modifier;
import io.helidon.common.types.TypeInfo;
import io.helidon.common.types.TypeName;
import io.helidon.common.types.TypeNames;
import io.helidon.common.types.TypedElementInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;

final class FactoryPrototypeInfo {
    private static final String BLUEPRINT = "Blueprint";

    private FactoryPrototypeInfo() {
    }

    static PrototypeInfo create(RoundContext ctx, TypeInfo blueprint) {
        Annotation blueprintAnnotation = FactoryPrototypeInfo.blueprintAnnotation(blueprint);
        TypeName prototypeType = FactoryPrototypeInfo.generatedTypeName(blueprint);
        Javadoc blueprintJavadoc = Javadoc.parse((String)blueprint.description().orElse(""));
        Predicate<String> defaultMethodsPredicate = FactoryPrototypeInfo.defaultMethodsPredicate(blueprint);
        Optional<TypeName> superPrototype = FactoryPrototypeInfo.superPrototype(blueprint);
        PrototypeInfo.Builder prototype = (PrototypeInfo.Builder)((PrototypeInfo.Builder)((PrototypeInfo.Builder)((PrototypeInfo.Builder)((PrototypeInfo.Builder)((PrototypeInfo.Builder)((PrototypeInfo.Builder)((PrototypeInfo.Builder)((PrototypeInfo.Builder)((PrototypeInfo.Builder)((PrototypeInfo.Builder)((PrototypeInfo.Builder)((PrototypeInfo.Builder)((PrototypeInfo.Builder)((PrototypeInfo.Builder)PrototypeInfo.builder().blueprint(blueprint)).prototypeType(prototypeType)).detachBlueprint(blueprintAnnotation.booleanValue("detach").orElse(false))).annotations(FactoryPrototypeInfo.annotations((Annotated)blueprint))).defaultMethodsPredicate(defaultMethodsPredicate)).accessModifier(FactoryPrototypeInfo.prototypeAccessModifier(blueprintAnnotation))).builderAccessModifier(FactoryPrototypeInfo.builderAccessModifier(blueprintAnnotation))).createEmptyCreate(FactoryPrototypeInfo.createEmptyPublic(blueprintAnnotation))).recordStyle(FactoryPrototypeInfo.recordStyleAccessors(blueprintAnnotation))).registrySupport(FactoryPrototypeInfo.registrySupport(blueprint))).superPrototype(superPrototype)).providerProvides(FactoryPrototypeInfo.providerProvides(blueprint))).javadoc(FactoryPrototypeInfo.prototypeJavadoc(blueprint))).builderBaseJavadoc(FactoryPrototypeInfo.builderBaseJavadoc(blueprintJavadoc, prototypeType))).builderJavadoc(FactoryPrototypeInfo.builderJavadoc(blueprintJavadoc, prototypeType));
        FactoryPrototypeInfo.prototypeExtends(prototype, blueprint, superPrototype);
        FactoryPrototypeInfo.builderDecorator(blueprintAnnotation).ifPresent(prototype::builderDecorator);
        FactoryPrototypeInfo.configured(blueprint, blueprintAnnotation).ifPresent(prototype::configured);
        FactoryPrototypeInfo.runtimeType(blueprint).ifPresent(prototype::runtimeType);
        List<TypedElementInfo> defaultMethodsNotOptions = FactoryPrototypeInfo.defaultMethodsNotOptions(blueprint, defaultMethodsPredicate);
        FactoryPrototypeInfo.customMethodsTypeInfo(ctx, blueprint).ifPresent(it -> {
            Errors.Collector errors = Errors.collector();
            prototype.constants(FactoryPrototypeInfo.constants(it, errors));
            prototype.prototypeMethods(FactoryPrototypeInfo.customMethods(it, errors, Types.PROTOTYPE_PROTOTYPE_METHOD, (collector, customMethodsType, customMethod, annotations) -> FactoryPrototypeInfo.prototypeMethod(collector, customMethodsType, customMethod, annotations, defaultMethodsNotOptions)));
            prototype.builderMethods(FactoryPrototypeInfo.customMethods(it, errors, Types.PROTOTYPE_BUILDER_METHOD, FactoryPrototypeInfo::builderMethod));
            prototype.deprecatedFactoryMethods(FactoryPrototypeInfo.customMethods(it, errors, Types.PROTOTYPE_FACTORY_METHOD_DEPRECATED, FactoryPrototypeInfo::deprecatedFactory));
            prototype.prototypeFactories(FactoryPrototypeInfo.customMethods(it, errors, Types.PROTOTYPE_FACTORY_METHOD_PROTOTYPE, FactoryPrototypeInfo::prototypeFactory));
            prototype.configFactories(FactoryPrototypeInfo.customMethods(it, errors, Types.PROTOTYPE_FACTORY_METHOD_CONFIG, FactoryPrototypeInfo::configFactoryMethod));
            prototype.runtimeTypeFactories(FactoryPrototypeInfo.customMethods(it, errors, Types.PROTOTYPE_FACTORY_METHOD_RUNTIME_TYPE, FactoryPrototypeInfo::runtimeTypeFactory));
            Errors collected = errors.collect();
            if (collected.hasFatal()) {
                throw new CodegenException("Invalid custom methods or constants: " + String.valueOf(collected), it.originatingElementValue());
            }
        });
        FactoryPrototypeInfo.addBlueprintDeprecatedFactoryMethods(prototype, blueprint);
        FactoryPrototypeInfo.copyDefaultMethods(blueprint, prototype, defaultMethodsNotOptions);
        return prototype.build();
    }

    private static List<TypedElementInfo> defaultMethodsNotOptions(TypeInfo blueprint, Predicate<String> defaultMethodsPredicate) {
        return blueprint.elementInfo().stream().filter(ElementInfoPredicates::isMethod).filter(it -> it.elementModifiers().contains(Modifier.DEFAULT)).filter(Predicate.not(it -> defaultMethodsPredicate.test(it.elementName()))).filter(it -> !it.hasAnnotation(TypeName.create(Override.class))).toList();
    }

    private static void addBlueprintDeprecatedFactoryMethods(PrototypeInfo.Builder prototype, TypeInfo blueprint) {
        ArrayList<DeprecatedFactoryMethod> deprecatedFactoryMethods = new ArrayList<DeprecatedFactoryMethod>(prototype.deprecatedFactoryMethods());
        Errors.Collector errors = Errors.collector();
        deprecatedFactoryMethods.addAll(FactoryPrototypeInfo.customMethods(blueprint, errors, Types.PROTOTYPE_FACTORY_METHOD_DEPRECATED, FactoryPrototypeInfo::deprecatedFactory));
        Errors collected = errors.collect();
        if (collected.hasFatal()) {
            throw new CodegenException("Invalid custom methods or constants: " + String.valueOf(collected), blueprint.originatingElementValue());
        }
        prototype.deprecatedFactoryMethods(deprecatedFactoryMethods);
    }

    private static void copyDefaultMethods(TypeInfo blueprint, PrototypeInfo.Builder prototype, List<TypedElementInfo> defaultMethodsNotOptions) {
        if (defaultMethodsNotOptions.isEmpty()) {
            return;
        }
        if (prototype.detachBlueprint()) {
            throw new CodegenException("Default methods are not allowed on detached blueprints", defaultMethodsNotOptions.getFirst().originatingElementValue());
        }
        for (TypedElementInfo method : defaultMethodsNotOptions) {
            if (FactoryPrototypeInfo.isACustomMethod(prototype, method)) continue;
            prototype.addPrototypeMethod(m -> ((GeneratedMethod.Builder)((GeneratedMethod.Builder)m.method(newMethod -> ((TypedElementInfo.Builder)newMethod.from(method)).clearOriginatingElement())).javadoc(Javadoc.parse((String)method.description().orElse("")))).contentBuilder(content -> {
                if (!method.typeName().equals((Object)TypeNames.PRIMITIVE_VOID)) {
                    content.addContent("return ");
                }
                content.addContent(blueprint.typeName()).addContent(".super.").addContent(method.elementName()).addContent("(").addContent(method.parameterArguments().stream().map(TypedElementInfo::elementName).collect(Collectors.joining(", "))).addContentLine(");");
            }));
        }
    }

    private static boolean isACustomMethod(PrototypeInfo.Builder prototypeInfo, TypedElementInfo prototypeDefaultMethod) {
        ElementSignature signature = prototypeDefaultMethod.signature();
        for (GeneratedMethod prototypeMethod : prototypeInfo.prototypeMethods()) {
            if (!prototypeMethod.method().signature().equals((Object)signature)) continue;
            return true;
        }
        for (DeprecatedFactoryMethod deprecatedMethod : prototypeInfo.deprecatedFactoryMethods()) {
            if (!deprecatedMethod.method().signature().equals((Object)signature)) continue;
            return true;
        }
        return false;
    }

    private static Optional<TypeName> runtimeType(TypeInfo blueprint) {
        Optional<TypeInfo> factoryInterface = blueprint.interfaceTypeInfo().stream().filter(it -> Types.PROTOTYPE_FACTORY.equals((Object)it.typeName().genericTypeName())).findFirst();
        return factoryInterface.map(it -> (TypeName)it.typeName().typeArguments().getFirst());
    }

    private static Javadoc prototypeJavadoc(TypeInfo blueprint) {
        return blueprint.description().map(Javadoc::parse).orElseGet(() -> Javadoc.builder().add("Interface generated from blueprint {@code " + blueprint.typeName().fqName() + "}. Please add javadoc to blueprint, as it is currently missing.").build());
    }

    private static Javadoc builderBaseJavadoc(Javadoc blueprintJavadoc, TypeName prototypeType) {
        return ((Javadoc.Builder)((Javadoc.Builder)Javadoc.builder().add("Fluent API builder base for {@link " + prototypeType.className() + "}.").update(it -> blueprintJavadoc.parameters().forEach((arg_0, arg_1) -> ((Javadoc.Builder)it).addParameter(arg_0, arg_1)))).addParameter("<BUILDER>", "type of the builder extending this abstract builder").addParameter("<PROTOTYPE>", "type of the prototype interface that would be built by {@link #buildPrototype()}").update(it -> blueprintJavadoc.genericsTokens().forEach((key, lines) -> it.addParameter("<" + key + ">", lines)))).build();
    }

    private static Javadoc builderJavadoc(Javadoc blueprintJavadoc, TypeName prototypeType) {
        return ((Javadoc.Builder)Javadoc.builder().add("Fluent API builder for {@link " + prototypeType.className() + "}.").update(it -> blueprintJavadoc.parameters().forEach((arg_0, arg_1) -> ((Javadoc.Builder)it).addParameter(arg_0, arg_1)))).build();
    }

    private static GeneratedMethod builderMethod(Errors.Collector collector, TypeName typeName, TypedElementInfo referencedMethod, List<Annotation> annotations) {
        return GeneratedMethods.createBuilderMethod(typeName, referencedMethod, annotations);
    }

    private static DeprecatedFactoryMethod deprecatedFactory(Errors.Collector collector, TypeName typeName, TypedElementInfo referencedMethod, List<Annotation> annotations) {
        return ((DeprecatedFactoryMethod.Builder)((DeprecatedFactoryMethod.Builder)DeprecatedFactoryMethod.builder().declaringType(typeName)).method(referencedMethod)).build();
    }

    private static GeneratedMethod prototypeFactory(Errors.Collector collector, TypeName typeName, TypedElementInfo referencedMethod, List<Annotation> annotations) {
        return GeneratedMethods.createFactoryMethod(typeName, referencedMethod, annotations);
    }

    private static RuntimeTypeInfo runtimeTypeFactory(Errors.Collector collector, TypeName typeName, TypedElementInfo referencedMethod, List<Annotation> annotations) {
        String methodName = referencedMethod.elementName();
        if (referencedMethod.typeName().unboxed().equals((Object)TypeNames.PRIMITIVE_VOID)) {
            collector.fatal("@runtimeTypeFactoryMethods must not be void, but method " + typeName.fqName() + "." + methodName + " is");
        }
        TypeName runtimeType = referencedMethod.typeName();
        TypeName prototypeType = FactoryPrototypeInfo.paramType(collector, typeName, referencedMethod, "Runtime type");
        FactoryMethod.Builder methodBuilder = (FactoryMethod.Builder)((FactoryMethod.Builder)((FactoryMethod.Builder)((FactoryMethod.Builder)FactoryMethod.builder().declaringType(typeName)).methodName(methodName)).returnType(runtimeType)).parameterType(prototypeType);
        Annotation annotation = referencedMethod.annotation(Types.PROTOTYPE_FACTORY_METHOD_RUNTIME_TYPE);
        annotation.value().filter(Predicate.not(String::isBlank)).ifPresent(methodBuilder::optionName);
        OptionBuilder.Builder builder = (OptionBuilder.Builder)((OptionBuilder.Builder)OptionBuilder.builder().builderMethodType(prototypeType)).builderType(Utils.prototypeBuilderType(prototypeType));
        annotation.stringValue("builderMethodName").filter(Predicate.not("builder"::equals)).ifPresent(builder::builderMethodName);
        annotation.stringValue("buildMethodName").filter(Predicate.not("build"::equals)).ifPresent(builder::buildMethodName);
        annotation.typeValue("builderType").filter(Predicate.not(arg_0 -> ((TypeName)Types.PROTOTYPE_FACTORY_METHOD_RUNTIME_TYPE).equals(arg_0))).ifPresent(builder::builderType);
        annotation.typeValue("builderMethodType").filter(Predicate.not(arg_0 -> ((TypeName)Types.PROTOTYPE_FACTORY_METHOD_RUNTIME_TYPE).equals(arg_0))).ifPresent(builder::builderType);
        return ((RuntimeTypeInfo.Builder)((RuntimeTypeInfo.Builder)RuntimeTypeInfo.builder().factoryMethod((Supplier<FactoryMethod>)((Object)methodBuilder))).optionBuilder((Supplier<OptionBuilder>)((Object)builder))).build();
    }

    private static FactoryMethod configFactoryMethod(Errors.Collector collector, TypeName typeName, TypedElementInfo referencedMethod, List<Annotation> annotations) {
        FactoryMethod.Builder builder = (FactoryMethod.Builder)((FactoryMethod.Builder)((FactoryMethod.Builder)((FactoryMethod.Builder)FactoryMethod.builder().declaringType(typeName)).returnType(referencedMethod.typeName())).methodName(referencedMethod.elementName())).parameterType(FactoryPrototypeInfo.paramType(collector, typeName, referencedMethod, "Config"));
        referencedMethod.annotation(Types.PROTOTYPE_FACTORY_METHOD_CONFIG).stringValue().filter(Predicate.not(String::isBlank)).ifPresent(builder::optionName);
        return builder.build();
    }

    private static TypeName paramType(Errors.Collector collector, TypeName typeName, TypedElementInfo referencedMethod, String factoryType) {
        if (referencedMethod.parameterArguments().size() != 1) {
            collector.fatal(factoryType + " must have exactly one parameter, but method " + typeName.fqName() + "." + referencedMethod.elementName() + " has " + referencedMethod.parameterArguments().size());
        }
        return ((TypedElementInfo)referencedMethod.parameterArguments().getFirst()).typeName();
    }

    private static GeneratedMethod prototypeMethod(Errors.Collector collector, TypeName typeName, TypedElementInfo referencedMethod, List<Annotation> annotations, List<TypedElementInfo> defaultMethodsNotOptions) {
        ArrayList args = new ArrayList(referencedMethod.parameterArguments());
        if (!args.isEmpty()) {
            args.removeFirst();
        }
        TypedElementInfo tei = ((TypedElementInfo.Builder)TypedElementInfo.builder((TypedElementInfo)referencedMethod).parameterArguments(args)).build();
        ElementSignature generatedSignature = tei.signature();
        for (TypedElementInfo m : defaultMethodsNotOptions) {
            if (!m.signature().equals((Object)generatedSignature)) continue;
            ArrayList<Annotation> usedAnnotations = new ArrayList<Annotation>(annotations);
            if (Annotations.findFirst((TypeName)TypeName.create(Override.class), annotations).isEmpty()) {
                usedAnnotations.add(Annotations.OVERRIDE);
            }
            return GeneratedMethods.createPrototypeMethod(typeName, referencedMethod, usedAnnotations, m);
        }
        return GeneratedMethods.createPrototypeMethod(typeName, referencedMethod, annotations);
    }

    private static <T> List<? extends T> customMethods(TypeInfo customMethodsType, Errors.Collector errors, TypeName requiredAnnotation, CustomMethodProcessor<T> methodProcessor) {
        return customMethodsType.elementInfo().stream().filter(ElementInfoPredicates::isMethod).filter(ElementInfoPredicates::isStatic).filter(ElementInfoPredicates.hasAnnotation((TypeName)requiredAnnotation)).map(it -> {
            List<Annotation> annotations = FactoryPrototypeInfo.annotations((Annotated)it);
            return methodProcessor.process(errors, customMethodsType.typeName(), (TypedElementInfo)it, annotations);
        }).toList();
    }

    private static List<Annotation> annotations(Annotated it) {
        return it.findAnnotation(Types.PROTOTYPE_ANNOTATED).flatMap(Annotation::stringValues).orElseGet(List::of).stream().map(String::trim).filter(Predicate.not(String::isBlank)).map(io.helidon.codegen.classmodel.Annotation::parse).map(io.helidon.codegen.classmodel.Annotation::toTypesAnnotation).toList();
    }

    private static Optional<TypeInfo> customMethodsTypeInfo(RoundContext ctx, TypeInfo blueprint) {
        Optional<TypeInfo> response = blueprint.findAnnotation(Types.PROTOTYPE_CUSTOM_METHODS).map(it -> FactoryPrototypeInfo.customMethodsTypeInfo(ctx, blueprint, it));
        if (response.isPresent()) {
            return response;
        }
        for (TypeInfo typeInfo : blueprint.interfaceTypeInfo()) {
            response = typeInfo.findAnnotation(Types.PROTOTYPE_CUSTOM_METHODS).map(it -> FactoryPrototypeInfo.customMethodsTypeInfo(ctx, blueprint, it));
            if (!response.isPresent()) continue;
            return response;
        }
        return Optional.empty();
    }

    private static TypeInfo customMethodsTypeInfo(RoundContext ctx, TypeInfo blueprint, Annotation customMethodsAnnotation) {
        TypeName type = (TypeName)customMethodsAnnotation.typeValue().orElseThrow();
        return (TypeInfo)ctx.typeInfo(type).orElseThrow(() -> new CodegenException("No type found for @Prototype.CustomMethods annotation on " + String.valueOf(blueprint.typeName()) + ", type: " + type.fqName(), (Object)blueprint));
    }

    private static List<? extends PrototypeConstant> constants(TypeInfo customMethodsType, Errors.Collector errors) {
        return customMethodsType.elementInfo().stream().filter(ElementInfoPredicates::isField).filter(ElementInfoPredicates.hasAnnotation((TypeName)Types.PROTOTYPE_CONSTANT)).map(it -> {
            if (!it.elementModifiers().contains(Modifier.STATIC)) {
                errors.fatal(it, "A field annotated with @Prototype.Constant must be static, final, and at least package local. Field \"" + it.elementName() + "\" is not static.");
            }
            if (!it.elementModifiers().contains(Modifier.FINAL)) {
                errors.fatal(it, "A field annotated with @Prototype.Constant must be static, final, and at least package local. Field \"" + it.elementName() + "\" is not final.");
            }
            if (it.accessModifier() == AccessModifier.PRIVATE) {
                errors.fatal(it, "A field annotated with @Prototype.Constant must be static, final, and at least package local. Field \"" + it.elementName() + "\" is private.");
            }
            TypeName fieldType = it.typeName();
            String name = it.elementName();
            Javadoc javadoc = it.description().map(Javadoc::parse).orElseGet(() -> Javadoc.builder().add(fieldType.equals((Object)TypeNames.STRING) ? "Constant for {@value}." : "Code generated constant.").build());
            return PrototypeConstants.create(customMethodsType.typeName(), fieldType, name, javadoc);
        }).toList();
    }

    private static Optional<PrototypeConfigured> configured(TypeInfo blueprint, Annotation blueprintAnnotation) {
        return blueprint.findAnnotation(Types.PROTOTYPE_CONFIGURED).map(it -> FactoryPrototypeInfo.configured(blueprintAnnotation, it));
    }

    private static PrototypeConfigured configured(Annotation blueprintAnnotation, Annotation configuredAnnotation) {
        Optional<String> configKey = configuredAnnotation.stringValue().filter(Predicate.not(String::isBlank));
        PrototypeConfigured.Builder builder = PrototypeConfigured.builder();
        configKey.ifPresent(it -> {
            builder.key((String)it);
            builder.root(configuredAnnotation.booleanValue("root").orElse(true));
        });
        blueprintAnnotation.booleanValue("createFromConfigPublic").map(it -> it != false ? AccessModifier.PUBLIC : AccessModifier.PACKAGE_PRIVATE).ifPresent(builder::createAccessModifier);
        return builder.build();
    }

    private static void prototypeExtends(PrototypeInfo.Builder prototype, TypeInfo blueprint, Optional<TypeName> superPrototype) {
        boolean detachBlueprint = prototype.detachBlueprint();
        LinkedHashSet<TypeName> prototypeExtends = new LinkedHashSet<TypeName>();
        if (!detachBlueprint) {
            prototypeExtends.add(blueprint.typeName());
        }
        prototypeExtends.add(Types.PROTOTYPE_API);
        blueprint.findAnnotation(Types.PROTOTYPE_IMPLEMENT).flatMap(Annotation::stringValues).stream().flatMap(Collection::stream).map(TypeName::create).forEach(prototypeExtends::add);
        for (TypeInfo superInterface : blueprint.interfaceTypeInfo()) {
            if (superInterface.hasAnnotation(Types.PROTOTYPE_BLUEPRINT)) {
                TypeName superBlueprint = superInterface.typeName();
                String className = superBlueprint.className();
                TypeName toExtend = ((TypeName.Builder)((TypeName.Builder)TypeName.builder().packageName(superBlueprint.packageName())).className(className.substring(0, className.length() - 9))).build();
                prototypeExtends.add(toExtend);
                continue;
            }
            if (!detachBlueprint) continue;
            prototypeExtends.add(superInterface.typeName());
        }
        superPrototype.ifPresent(prototypeExtends::add);
        prototype.superTypes(prototypeExtends);
    }

    private static Set<TypeName> providerProvides(TypeInfo blueprint) {
        return blueprint.findAnnotation(Types.PROTOTYPE_PROVIDES).flatMap(Annotation::typeValues).map(it -> new LinkedHashSet(it)).orElseGet(Set::of);
    }

    private static boolean registrySupport(TypeInfo blueprint) {
        return blueprint.findAnnotation(Types.PROTOTYPE_SERVICE_REGISTRY).flatMap(Annotation::booleanValue).orElse(false);
    }

    private static boolean createEmptyPublic(Annotation blueprintAnnotation) {
        return blueprintAnnotation.booleanValue("createEmptyPublic").orElse(true);
    }

    private static AccessModifier builderAccessModifier(Annotation blueprintAnnotation) {
        return blueprintAnnotation.booleanValue("builderPublic").filter(it -> it == false).map(it -> AccessModifier.PROTECTED).orElse(AccessModifier.PUBLIC);
    }

    private static AccessModifier prototypeAccessModifier(Annotation blueprintAnnotation) {
        return blueprintAnnotation.booleanValue("isPublic").filter(it -> it == false).map(it -> AccessModifier.PACKAGE_PRIVATE).orElse(AccessModifier.PUBLIC);
    }

    private static Optional<TypeName> builderDecorator(Annotation blueprintAnnotation) {
        return blueprintAnnotation.getValue("decorator").map(TypeName::create).filter(Predicate.not(arg_0 -> ((TypeName)Types.PROTOTYPE_BUILDER_DECORATOR).equals(arg_0)));
    }

    private static Annotation blueprintAnnotation(TypeInfo blueprint) {
        return (Annotation)blueprint.findAnnotation(Types.PROTOTYPE_BLUEPRINT).orElseThrow(() -> new CodegenException("No @Prototype.Blueprint annotation found on " + String.valueOf(blueprint.typeName()), (Object)blueprint));
    }

    private static boolean recordStyleAccessors(Annotation blueprintAnnotation) {
        return blueprintAnnotation.booleanValue("beanStyle").orElse(false) == false;
    }

    private static Predicate<String> defaultMethodsPredicate(TypeInfo blueprint) {
        if (!blueprint.hasAnnotation(Types.PROTOTYPE_INCLUDE_DEFAULTS)) {
            return it -> false;
        }
        Set methodNames = blueprint.findAnnotation(Types.PROTOTYPE_INCLUDE_DEFAULTS).flatMap(Annotation::stringValues).stream().flatMap(Collection::stream).collect(Collectors.toSet());
        if (methodNames.isEmpty()) {
            return it -> true;
        }
        return methodNames::contains;
    }

    private static TypeName generatedTypeName(TypeInfo typeInfo) {
        String typeName = typeInfo.typeName().className();
        if (!typeName.endsWith(BLUEPRINT)) {
            throw new CodegenException("Blueprint interface name must end with Blueprint, this is invalid type: " + typeInfo.typeName().fqName(), (Object)typeInfo);
        }
        typeName = typeName.substring(0, typeName.length() - BLUEPRINT.length());
        return ((TypeName.Builder)((TypeName.Builder)TypeName.builder((TypeName)typeInfo.typeName()).enclosingNames(List.of())).className(typeName)).build();
    }

    private static Optional<TypeName> superPrototype(TypeInfo blueprint) {
        HashSet<TypeName> processedInterfaces = new HashSet<TypeName>();
        LinkedHashSet<TypeName> superPrototypes = new LinkedHashSet<TypeName>();
        FactoryPrototypeInfo.superPrototype(blueprint, superPrototypes, processedInterfaces);
        return superPrototypes.stream().findFirst();
    }

    private static void superPrototype(TypeInfo inProgress, Set<TypeName> superPrototypes, Set<TypeName> processedInterfaces) {
        List superInterfaces = inProgress.interfaceTypeInfo();
        for (TypeInfo superInterface : superInterfaces) {
            if (!processedInterfaces.add(superInterface.typeName())) continue;
            if (superInterface.hasAnnotation(Types.PROTOTYPE_BLUEPRINT)) {
                TypeName superBlueprint = superInterface.typeName();
                String className = superBlueprint.className();
                TypeName toExtend = ((TypeName.Builder)((TypeName.Builder)TypeName.builder().packageName(superBlueprint.packageName())).className(className.substring(0, className.length() - 9))).build();
                processedInterfaces.add(toExtend);
                superPrototypes.add(toExtend);
                if (superPrototypes.size() <= 1) continue;
                throw new CodegenException("A blueprint extends more than one other blueprint/prototype. Multiple inheritance is not supported in Java, so we cannot generate a builder extending more than one super-builder.", (Object)inProgress);
            }
            boolean found = false;
            for (TypeInfo anInterface : superInterface.interfaceTypeInfo()) {
                if (!anInterface.typeName().equals((Object)Types.PROTOTYPE_API)) continue;
                superPrototypes.add(superInterface.typeName());
                if (superPrototypes.size() > 1) {
                    throw new CodegenException("A blueprint extends more than one other blueprint/prototype. Multiple inheritance is not supported in Java, so we cannot generate a builder extending more than one super-builder.", (Object)inProgress);
                }
                found = true;
                break;
            }
            if (found) continue;
            FactoryPrototypeInfo.superPrototype(superInterface, superPrototypes, processedInterfaces);
        }
    }

    static interface CustomMethodProcessor<T> {
        public T process(Errors.Collector var1, TypeName var2, TypedElementInfo var3, List<Annotation> var4);
    }
}

