/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.builder.codegen;

import io.helidon.builder.codegen.Types;
import io.helidon.codegen.ElementInfoPredicates;
import io.helidon.common.types.Annotation;
import io.helidon.common.types.TypeInfo;
import io.helidon.common.types.TypeName;
import io.helidon.common.types.TypedElementInfo;
import java.util.Optional;
import java.util.function.Predicate;

record AnnotationDataConfigured(boolean configured, String rootPrefix, boolean isRoot, TypeName configType) {
    static AnnotationDataConfigured create(TypeInfo typeInfo) {
        boolean configured = false;
        boolean isRoot = false;
        String prefix = null;
        TypeName configType = Types.COMMON_CONFIG;
        if (typeInfo.hasAnnotation(Types.PROTOTYPE_CONFIGURED)) {
            configured = true;
            Annotation annotation = typeInfo.annotation(Types.PROTOTYPE_CONFIGURED);
            prefix = annotation.stringValue().orElse(null);
            if (prefix != null) {
                isRoot = annotation.booleanValue("root").orElse(true);
            }
            configType = AnnotationDataConfigured.configType(typeInfo).orElse(Types.COMMON_CONFIG);
        }
        return new AnnotationDataConfigured(configured, prefix, isRoot, configType);
    }

    private static Optional<TypeName> configType(TypeInfo typeInfo) {
        Optional<Object> typed = typeInfo.elementInfo().stream().filter(ElementInfoPredicates::isMethod).filter(Predicate.not(ElementInfoPredicates::isStatic)).filter(AnnotationDataConfigured::isConfigType).map(AnnotationDataConfigured::configType).findFirst();
        if (typed.isPresent()) {
            return typed;
        }
        typed = typeInfo.superTypeInfo().flatMap(AnnotationDataConfigured::configType);
        if (typed.isPresent()) {
            return typed;
        }
        for (TypeInfo info : typeInfo.interfaceTypeInfo()) {
            typed = AnnotationDataConfigured.configType(info);
            if (!typed.isPresent()) continue;
            return typed;
        }
        return Optional.empty();
    }

    private static boolean isConfigType(TypedElementInfo elementInfo) {
        boolean found;
        TypeName actualType = elementInfo.typeName();
        boolean bl = found = actualType.equals((Object)Types.CONFIG) || actualType.equals((Object)Types.COMMON_CONFIG);
        if (found) {
            return true;
        }
        if (actualType.isOptional() && actualType.typeArguments().size() == 1) {
            return (actualType = (TypeName)actualType.typeArguments().get(0)).equals((Object)Types.CONFIG) || actualType.equals((Object)Types.COMMON_CONFIG);
        }
        return false;
    }

    private static TypeName configType(TypedElementInfo elementInfo) {
        TypeName actualType = elementInfo.typeName();
        if (actualType.isOptional() && actualType.typeArguments().size() == 1 && ((actualType = (TypeName)actualType.typeArguments().getFirst()).equals((Object)Types.CONFIG) || actualType.equals((Object)Types.COMMON_CONFIG))) {
            return actualType;
        }
        return actualType;
    }
}

