/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.testing.integration;

import com.google.protobuf.ByteString;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.StatusRuntimeException;
import io.grpc.alts.ComputeEngineChannelBuilder;
import io.grpc.testing.integration.Messages;
import io.grpc.testing.integration.TestServiceGrpc;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class GrpclbLongLivedAffinityTestClient {
    private static final Logger logger = Logger.getLogger(GrpclbLongLivedAffinityTestClient.class.getName());
    private String target = "directpath-grpclb-with-pick-first-test.googleapis.com";
    private long rpcErrorBudgetIncreaseMinutes = 2L;
    private long affinityBreakageBudgetIncreaseMinutes = 90L;
    private long rpcIntermissionSeconds = 1L;
    private long totalTestSeconds = 60L;
    ManagedChannel channel;
    TestServiceGrpc.TestServiceBlockingStub blockingStub;

    public static void main(String[] args) throws Exception {
        final GrpclbLongLivedAffinityTestClient client = new GrpclbLongLivedAffinityTestClient();
        client.parseArgs(args);
        client.setUp();
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                try {
                    client.shutdown();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        try {
            client.run();
        }
        finally {
            client.shutdown();
        }
    }

    private void parseArgs(String[] args) {
        boolean usage = false;
        for (String arg : args) {
            if (!arg.startsWith("--")) {
                System.err.println("All arguments must start with '--': " + arg);
                usage = true;
                break;
            }
            String[] parts = arg.substring(2).split("=", 2);
            String key = parts[0];
            if ("help".equals(key)) {
                usage = true;
                break;
            }
            if (parts.length != 2) {
                System.err.println("All arguments must be of the form --arg=value");
                usage = true;
                break;
            }
            String value = parts[1];
            if ("target".equals(key)) {
                this.target = value;
                continue;
            }
            if ("rpc_error_budget_increase_minutes".equals(key)) {
                this.rpcErrorBudgetIncreaseMinutes = Long.parseLong(value);
                continue;
            }
            if ("affinity_breakage_budget_increase_minutes".equals(key)) {
                this.affinityBreakageBudgetIncreaseMinutes = Long.parseLong(value);
                continue;
            }
            if ("rpc_intermission_seconds".equals(key)) {
                this.rpcIntermissionSeconds = Long.parseLong(value);
                continue;
            }
            if ("total_test_seconds".equals(key)) {
                this.totalTestSeconds = Long.parseLong(value);
                continue;
            }
            System.err.println("Unknown argument: " + key);
            usage = true;
            break;
        }
        if (usage) {
            GrpclbLongLivedAffinityTestClient c = new GrpclbLongLivedAffinityTestClient();
            System.out.println("Usage: [ARGS...]\n\n  --target=TARGET          Server target.             Default " + c.target + "\n  --rpc_error_budget_increase_minutes=MINUTES         Default " + c.rpcErrorBudgetIncreaseMinutes + "\n  --affinity_breakage_budget_increase_minutes=MINUTES Default " + c.affinityBreakageBudgetIncreaseMinutes + "\n  --rpc_intermission_seconds=SECONDS                  Default " + c.rpcIntermissionSeconds + "\n  --total_test_seconds=SECONDS                        Default " + c.totalTestSeconds);
            System.exit(1);
        }
    }

    private void setUp() {
        this.channel = this.createChannel();
        this.blockingStub = TestServiceGrpc.newBlockingStub((Channel)this.channel);
    }

    private void shutdown() {
        try {
            if (this.channel != null) {
                this.channel.shutdownNow();
                this.channel.awaitTermination(1L, TimeUnit.SECONDS);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private void run() throws Exception {
        long startTimeMillis = System.currentTimeMillis();
        long endTimeMillis = startTimeMillis + TimeUnit.SECONDS.toMillis(this.totalTestSeconds);
        long rpcIntermissionMillis = TimeUnit.SECONDS.toMillis(this.rpcIntermissionSeconds);
        long rpcErrorBudgetIncreasePeriodMillis = TimeUnit.MINUTES.toMillis(this.rpcErrorBudgetIncreaseMinutes);
        long affinityBreakageBudgetIncreasePeriodMillis = TimeUnit.MINUTES.toMillis(this.affinityBreakageBudgetIncreaseMinutes);
        Messages.SimpleRequest request = Messages.SimpleRequest.newBuilder().setResponseSize(314159).setFillServerId(true).setPayload(Messages.Payload.newBuilder().setBody(ByteString.copyFrom((byte[])new byte[271828]))).build();
        String lastServerId = null;
        long rpcErrorBudget = 1L;
        long affinityBreakageBudget = 1L;
        long lastRpcErrorBudgetIncreaseTimeMillis = startTimeMillis;
        long lastAffinityBreakageBudgetIncreaseTimeMillis = startTimeMillis;
        logger.info("Test started");
        while (true) {
            block6: {
                try {
                    logger.info("Sending request");
                    Messages.SimpleResponse response = ((TestServiceGrpc.TestServiceBlockingStub)this.blockingStub.withDeadlineAfter(1L, TimeUnit.MINUTES)).unaryCall(request);
                    logger.info("Received response");
                    String serverId = response.getServerId();
                    if (lastServerId != null && !lastServerId.equals(serverId)) {
                        String msg = "Expected serverId " + lastServerId + ", but got " + serverId;
                        logger.warning(msg + ". affinityBreakageBudget=" + affinityBreakageBudget);
                        if (--affinityBreakageBudget < 0L) {
                            throw new AssertionError((Object)msg);
                        }
                    }
                }
                catch (StatusRuntimeException e) {
                    logger.log(Level.WARNING, "RPC error. rpcErrorBudget=" + rpcErrorBudget, e);
                    if (--rpcErrorBudget >= 0L) break block6;
                    throw e;
                }
            }
            Thread.sleep(rpcIntermissionMillis);
            long nowMillis = System.currentTimeMillis();
            if (nowMillis > endTimeMillis) break;
            if (nowMillis > lastRpcErrorBudgetIncreaseTimeMillis + rpcErrorBudgetIncreasePeriodMillis) {
                lastRpcErrorBudgetIncreaseTimeMillis = nowMillis;
                rpcErrorBudget = Math.min(20L, rpcErrorBudget + 1L);
                logger.info("rpcErrorBudget after refresh: " + rpcErrorBudget);
            }
            if (nowMillis <= lastAffinityBreakageBudgetIncreaseTimeMillis + affinityBreakageBudgetIncreasePeriodMillis) continue;
            lastAffinityBreakageBudgetIncreaseTimeMillis = nowMillis;
            affinityBreakageBudget = Math.min(3L, affinityBreakageBudget + 1L);
            logger.info("affinityBreakageBudget after refresh: " + affinityBreakageBudget);
        }
        logger.info("Time is up");
        logger.info("Test passed.");
    }

    private ManagedChannel createChannel() {
        return ComputeEngineChannelBuilder.forTarget((String)this.target).build();
    }
}

