/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.testing.integration;

import io.grpc.ConnectivityState;
import io.grpc.LoadBalancer;
import io.grpc.LoadBalancerProvider;
import io.grpc.LoadBalancerRegistry;
import io.grpc.Metadata;
import io.grpc.NameResolver;
import io.grpc.Status;
import io.grpc.internal.JsonUtil;
import io.grpc.util.ForwardingLoadBalancer;
import io.grpc.util.ForwardingLoadBalancerHelper;
import java.util.Map;
import javax.annotation.Nonnull;

public class RpcBehaviorLoadBalancerProvider
extends LoadBalancerProvider {
    public NameResolver.ConfigOrError parseLoadBalancingPolicyConfig(Map<String, ?> rawLoadBalancingPolicyConfig) {
        String rpcBehavior = JsonUtil.getString(rawLoadBalancingPolicyConfig, (String)"rpcBehavior");
        if (rpcBehavior == null) {
            return NameResolver.ConfigOrError.fromError((Status)Status.UNAVAILABLE.withDescription("no 'rpcBehavior' defined"));
        }
        return NameResolver.ConfigOrError.fromConfig((Object)new RpcBehaviorConfig(rpcBehavior));
    }

    public LoadBalancer newLoadBalancer(LoadBalancer.Helper helper) {
        RpcBehaviorHelper rpcBehaviorHelper = new RpcBehaviorHelper(helper);
        return new RpcBehaviorLoadBalancer(rpcBehaviorHelper, LoadBalancerRegistry.getDefaultRegistry().getProvider("round_robin").newLoadBalancer((LoadBalancer.Helper)rpcBehaviorHelper));
    }

    public boolean isAvailable() {
        return true;
    }

    public int getPriority() {
        return 5;
    }

    public String getPolicyName() {
        return "test.RpcBehaviorLoadBalancer";
    }

    static class RpcBehaviorPicker
    extends LoadBalancer.SubchannelPicker {
        private static final String RPC_BEHAVIOR_HEADER_KEY = "rpc-behavior";
        private final LoadBalancer.SubchannelPicker delegatePicker;
        private final String rpcBehavior;

        RpcBehaviorPicker(LoadBalancer.SubchannelPicker delegatePicker, String rpcBehavior) {
            this.delegatePicker = delegatePicker;
            this.rpcBehavior = rpcBehavior;
        }

        public LoadBalancer.PickResult pickSubchannel(LoadBalancer.PickSubchannelArgs args) {
            args.getHeaders().put(Metadata.Key.of((String)RPC_BEHAVIOR_HEADER_KEY, (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER), (Object)this.rpcBehavior);
            return this.delegatePicker.pickSubchannel(args);
        }
    }

    static class RpcBehaviorHelper
    extends ForwardingLoadBalancerHelper {
        private final LoadBalancer.Helper delegateHelper;
        private String rpcBehavior;

        RpcBehaviorHelper(LoadBalancer.Helper delegateHelper) {
            this.delegateHelper = delegateHelper;
        }

        void setRpcBehavior(String rpcBehavior) {
            this.rpcBehavior = rpcBehavior;
        }

        protected LoadBalancer.Helper delegate() {
            return this.delegateHelper;
        }

        public void updateBalancingState(@Nonnull ConnectivityState newState, @Nonnull LoadBalancer.SubchannelPicker newPicker) {
            this.delegateHelper.updateBalancingState(newState, (LoadBalancer.SubchannelPicker)new RpcBehaviorPicker(newPicker, this.rpcBehavior));
        }
    }

    static class RpcBehaviorLoadBalancer
    extends ForwardingLoadBalancer {
        private final RpcBehaviorHelper helper;
        private final LoadBalancer delegateLb;

        RpcBehaviorLoadBalancer(RpcBehaviorHelper helper, LoadBalancer delegateLb) {
            this.helper = helper;
            this.delegateLb = delegateLb;
        }

        protected LoadBalancer delegate() {
            return this.delegateLb;
        }

        public void handleResolvedAddresses(LoadBalancer.ResolvedAddresses resolvedAddresses) {
            this.helper.setRpcBehavior(((RpcBehaviorConfig)resolvedAddresses.getLoadBalancingPolicyConfig()).rpcBehavior);
            this.delegateLb.handleResolvedAddresses(resolvedAddresses);
        }
    }

    static class RpcBehaviorConfig {
        final String rpcBehavior;

        RpcBehaviorConfig(String rpcBehavior) {
            this.rpcBehavior = rpcBehavior;
        }
    }
}

