/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.testing.integration;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.io.Files;
import io.grpc.ManagedChannel;
import io.grpc.internal.GrpcUtil;
import io.grpc.internal.testing.TestUtils;
import io.grpc.netty.GrpcSslContexts;
import io.grpc.netty.NegotiationType;
import io.grpc.netty.NettyChannelBuilder;
import io.grpc.okhttp.OkHttpChannelBuilder;
import io.grpc.okhttp.internal.Platform;
import io.grpc.testing.integration.AbstractInteropTest;
import io.grpc.testing.integration.TestCases;
import io.grpc.testing.integration.Util;
import io.netty.handler.ssl.SslContext;
import java.io.File;
import java.io.FileInputStream;
import java.nio.charset.Charset;
import java.security.Provider;
import javax.net.ssl.SSLSocketFactory;

public class TestServiceClient {
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private String serverHost = "localhost";
    private String serverHostOverride;
    private int serverPort = 8080;
    private String testCase = "empty_unary";
    private boolean useTls = true;
    private boolean useTestCa;
    private boolean useOkHttp;
    private String defaultServiceAccount;
    private String serviceAccountKeyFile;
    private String oauthScope;
    private Tester tester = new Tester();

    public static void main(String[] args) throws Exception {
        Util.installConscryptIfAvailable();
        final TestServiceClient client = new TestServiceClient();
        client.parseArgs(args);
        client.setUp();
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                System.out.println("Shutting down");
                try {
                    client.tearDown();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        try {
            client.run();
        }
        finally {
            client.tearDown();
        }
        System.exit(0);
    }

    @VisibleForTesting
    void parseArgs(String[] args) {
        boolean usage = false;
        for (String arg : args) {
            if (!arg.startsWith("--")) {
                System.err.println("All arguments must start with '--': " + arg);
                usage = true;
                break;
            }
            String[] parts = arg.substring(2).split("=", 2);
            String key = parts[0];
            if ("help".equals(key)) {
                usage = true;
                break;
            }
            if (parts.length != 2) {
                System.err.println("All arguments must be of the form --arg=value");
                usage = true;
                break;
            }
            String value = parts[1];
            if ("server_host".equals(key)) {
                this.serverHost = value;
                continue;
            }
            if ("server_host_override".equals(key)) {
                this.serverHostOverride = value;
                continue;
            }
            if ("server_port".equals(key)) {
                this.serverPort = Integer.parseInt(value);
                continue;
            }
            if ("test_case".equals(key)) {
                this.testCase = value;
                continue;
            }
            if ("use_tls".equals(key)) {
                this.useTls = Boolean.parseBoolean(value);
                continue;
            }
            if ("use_test_ca".equals(key)) {
                this.useTestCa = Boolean.parseBoolean(value);
                continue;
            }
            if ("use_okhttp".equals(key)) {
                this.useOkHttp = Boolean.parseBoolean(value);
                continue;
            }
            if ("grpc_version".equals(key)) {
                if ("2".equals(value)) continue;
                System.err.println("Only grpc version 2 is supported");
                usage = true;
                break;
            }
            if ("default_service_account".equals(key)) {
                this.defaultServiceAccount = value;
                continue;
            }
            if ("service_account_key_file".equals(key)) {
                this.serviceAccountKeyFile = value;
                continue;
            }
            if ("oauth_scope".equals(key)) {
                this.oauthScope = value;
                continue;
            }
            System.err.println("Unknown argument: " + key);
            usage = true;
            break;
        }
        if (usage) {
            TestServiceClient c = new TestServiceClient();
            System.out.println("Usage: [ARGS...]\n\n  --server_host=HOST          Server to connect to. Default " + c.serverHost + "\n  --server_host_override=HOST Claimed identification expected of server.\n                              Defaults to server host\n  --server_port=PORT          Port to connect to. Default " + c.serverPort + "\n  --test_case=TESTCASE        Test case to run. Default " + c.testCase + "\n    Valid options:" + TestServiceClient.validTestCasesHelpText() + "\n  --use_tls=true|false        Whether to use TLS. Default " + c.useTls + "\n  --use_test_ca=true|false    Whether to trust our fake CA. Requires --use_tls=true \n                              to have effect. Default " + c.useTestCa + "\n  --use_okhttp=true|false     Whether to use OkHttp instead of Netty. Default " + c.useOkHttp + "\n  --default_service_account   Email of GCE default service account. Default " + c.defaultServiceAccount + "\n  --service_account_key_file  Path to service account json key file." + c.serviceAccountKeyFile + "\n  --oauth_scope               Scope for OAuth tokens. Default " + c.oauthScope);
            System.exit(1);
        }
    }

    @VisibleForTesting
    void setUp() {
        this.tester.setUp();
    }

    private synchronized void tearDown() {
        try {
            this.tester.tearDown();
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private void run() {
        System.out.println("Running test " + this.testCase);
        try {
            this.runTest(TestCases.fromString(this.testCase));
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        System.out.println("Test completed.");
    }

    private void runTest(TestCases testCase) throws Exception {
        switch (testCase) {
            case EMPTY_UNARY: {
                this.tester.emptyUnary();
                break;
            }
            case CACHEABLE_UNARY: {
                this.tester.cacheableUnary();
                break;
            }
            case LARGE_UNARY: {
                this.tester.largeUnary();
                break;
            }
            case CLIENT_COMPRESSED_UNARY: {
                this.tester.clientCompressedUnary();
                break;
            }
            case SERVER_COMPRESSED_UNARY: {
                this.tester.serverCompressedUnary();
                break;
            }
            case CLIENT_STREAMING: {
                this.tester.clientStreaming();
                break;
            }
            case CLIENT_COMPRESSED_STREAMING: {
                this.tester.clientCompressedStreaming();
                break;
            }
            case SERVER_STREAMING: {
                this.tester.serverStreaming();
                break;
            }
            case SERVER_COMPRESSED_STREAMING: {
                this.tester.serverCompressedStreaming();
                break;
            }
            case PING_PONG: {
                this.tester.pingPong();
                break;
            }
            case EMPTY_STREAM: {
                this.tester.emptyStream();
                break;
            }
            case COMPUTE_ENGINE_CREDS: {
                this.tester.computeEngineCreds(this.defaultServiceAccount, this.oauthScope);
                break;
            }
            case SERVICE_ACCOUNT_CREDS: {
                String jsonKey = Files.toString((File)new File(this.serviceAccountKeyFile), (Charset)UTF_8);
                FileInputStream credentialsStream = new FileInputStream(new File(this.serviceAccountKeyFile));
                this.tester.serviceAccountCreds(jsonKey, credentialsStream, this.oauthScope);
                break;
            }
            case JWT_TOKEN_CREDS: {
                FileInputStream credentialsStream = new FileInputStream(new File(this.serviceAccountKeyFile));
                this.tester.jwtTokenCreds(credentialsStream);
                break;
            }
            case OAUTH2_AUTH_TOKEN: {
                String jsonKey = Files.toString((File)new File(this.serviceAccountKeyFile), (Charset)UTF_8);
                FileInputStream credentialsStream = new FileInputStream(new File(this.serviceAccountKeyFile));
                this.tester.oauth2AuthToken(jsonKey, credentialsStream, this.oauthScope);
                break;
            }
            case PER_RPC_CREDS: {
                String jsonKey = Files.toString((File)new File(this.serviceAccountKeyFile), (Charset)UTF_8);
                FileInputStream credentialsStream = new FileInputStream(new File(this.serviceAccountKeyFile));
                this.tester.perRpcCreds(jsonKey, credentialsStream, this.oauthScope);
                break;
            }
            case CUSTOM_METADATA: {
                this.tester.customMetadata();
                break;
            }
            case STATUS_CODE_AND_MESSAGE: {
                this.tester.statusCodeAndMessage();
                break;
            }
            case UNIMPLEMENTED_METHOD: {
                this.tester.unimplementedMethod();
                break;
            }
            case UNIMPLEMENTED_SERVICE: {
                this.tester.unimplementedService();
                break;
            }
            case CANCEL_AFTER_BEGIN: {
                this.tester.cancelAfterBegin();
                break;
            }
            case CANCEL_AFTER_FIRST_RESPONSE: {
                this.tester.cancelAfterFirstResponse();
                break;
            }
            case TIMEOUT_ON_SLEEPING_SERVER: {
                this.tester.timeoutOnSleepingServer();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown test case: " + (Object)((Object)testCase));
            }
        }
    }

    private static String validTestCasesHelpText() {
        StringBuilder builder = new StringBuilder();
        for (TestCases testCase : TestCases.values()) {
            String strTestcase = testCase.name().toLowerCase();
            builder.append("\n      ").append(strTestcase).append(": ").append(testCase.description());
        }
        return builder.toString();
    }

    private class Tester
    extends AbstractInteropTest {
        private Tester() {
        }

        @Override
        protected ManagedChannel createChannel() {
            if (!TestServiceClient.this.useOkHttp) {
                SslContext sslContext = null;
                if (TestServiceClient.this.useTestCa) {
                    try {
                        sslContext = GrpcSslContexts.forClient().trustManager(TestUtils.loadCert((String)"ca.pem")).build();
                    }
                    catch (Exception ex) {
                        throw new RuntimeException(ex);
                    }
                }
                NettyChannelBuilder builder = NettyChannelBuilder.forAddress((String)TestServiceClient.this.serverHost, (int)TestServiceClient.this.serverPort).flowControlWindow(66560).negotiationType(TestServiceClient.this.useTls ? NegotiationType.TLS : NegotiationType.PLAINTEXT).sslContext(sslContext);
                if (TestServiceClient.this.serverHostOverride != null) {
                    builder.overrideAuthority(TestServiceClient.this.serverHostOverride);
                }
                return builder.build();
            }
            OkHttpChannelBuilder builder = OkHttpChannelBuilder.forAddress((String)TestServiceClient.this.serverHost, (int)TestServiceClient.this.serverPort);
            if (TestServiceClient.this.serverHostOverride != null) {
                builder.overrideAuthority(GrpcUtil.authorityFromHostAndPort((String)TestServiceClient.this.serverHostOverride, (int)TestServiceClient.this.serverPort));
            }
            if (TestServiceClient.this.useTls) {
                try {
                    SSLSocketFactory factory = TestServiceClient.this.useTestCa ? TestUtils.newSslSocketFactoryForCa((Provider)Platform.get().getProvider(), (File)TestUtils.loadCert((String)"ca.pem")) : (SSLSocketFactory)SSLSocketFactory.getDefault();
                    builder.sslSocketFactory(factory);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            } else {
                builder.usePlaintext(true);
            }
            return builder.build();
        }

        @Override
        protected boolean metricsExpected() {
            return false;
        }
    }
}

