/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.testing.integration;

import com.google.auth.Credentials;
import com.google.auth.oauth2.AccessToken;
import com.google.auth.oauth2.ComputeEngineCredentials;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.auth.oauth2.OAuth2Credentials;
import com.google.auth.oauth2.ServiceAccountCredentials;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.truth.ComparableSubject;
import com.google.common.truth.Truth;
import com.google.instrumentation.stats.RpcConstants;
import com.google.instrumentation.stats.StatsContextFactory;
import com.google.instrumentation.stats.TagValue;
import com.google.protobuf.BoolValue;
import com.google.protobuf.ByteString;
import com.google.protobuf.EmptyProtos;
import com.google.protobuf.Message;
import com.google.protobuf.MessageLite;
import io.grpc.BindableService;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.ClientInterceptors;
import io.grpc.ClientStreamTracer;
import io.grpc.Context;
import io.grpc.Grpc;
import io.grpc.ManagedChannel;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.Server;
import io.grpc.ServerCall;
import io.grpc.ServerInterceptor;
import io.grpc.ServerInterceptors;
import io.grpc.ServerStreamTracer;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.grpc.auth.MoreCallCredentials;
import io.grpc.internal.AbstractServerImplBuilder;
import io.grpc.internal.GrpcUtil;
import io.grpc.internal.TestingAccessor;
import io.grpc.internal.testing.StatsTestUtils;
import io.grpc.internal.testing.TestClientStreamTracer;
import io.grpc.internal.testing.TestServerStreamTracer;
import io.grpc.internal.testing.TestStreamTracer;
import io.grpc.protobuf.ProtoUtils;
import io.grpc.stub.AbstractStub;
import io.grpc.stub.ClientCallStreamObserver;
import io.grpc.stub.ClientCalls;
import io.grpc.stub.MetadataUtils;
import io.grpc.stub.StreamObserver;
import io.grpc.testing.StreamRecorder;
import io.grpc.testing.TestUtils;
import io.grpc.testing.integration.Messages;
import io.grpc.testing.integration.TestServiceGrpc;
import io.grpc.testing.integration.TestServiceImpl;
import io.grpc.testing.integration.UnimplementedServiceGrpc;
import io.grpc.testing.integration.Util;
import java.io.IOException;
import java.io.InputStream;
import java.net.SocketAddress;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public abstract class AbstractInteropTest {
    public static final int MAX_MESSAGE_SIZE = 0x1000000;
    public static final Metadata.Key<Messages.SimpleContext> METADATA_KEY = ProtoUtils.keyForProto((Message)Messages.SimpleContext.getDefaultInstance());
    private static final AtomicReference<ServerCall<?, ?>> serverCallCapture = new AtomicReference();
    private static final AtomicReference<Metadata> requestHeadersCapture = new AtomicReference();
    private static ScheduledExecutorService testServiceExecutor;
    private static Server server;
    private static final StatsTestUtils.FakeStatsContextFactory clientStatsCtxFactory;
    private static final StatsTestUtils.FakeStatsContextFactory serverStatsCtxFactory;
    private static final LinkedBlockingQueue<ServerStreamTracerInfo> serverStreamTracers;
    private static final ServerStreamTracer.Factory serverStreamTracerFactory;
    protected static final EmptyProtos.Empty EMPTY;
    protected ManagedChannel channel;
    protected TestServiceGrpc.TestServiceBlockingStub blockingStub;
    protected TestServiceGrpc.TestServiceStub asyncStub;
    private final LinkedBlockingQueue<TestClientStreamTracer> clientStreamTracers = new LinkedBlockingQueue();
    private final ClientStreamTracer.Factory clientStreamTracerFactory = new ClientStreamTracer.Factory(){

        public ClientStreamTracer newClientStreamTracer(CallOptions callOptions, Metadata headers) {
            TestClientStreamTracer tracer = new TestClientStreamTracer();
            AbstractInteropTest.this.clientStreamTracers.add(tracer);
            return tracer;
        }
    };
    private final ClientInterceptor tracerSetupInterceptor = new ClientInterceptor(){

        public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
            return next.newCall(method, callOptions.withStreamTracerFactory(AbstractInteropTest.this.clientStreamTracerFactory));
        }
    };

    protected static void startStaticServer(AbstractServerImplBuilder<?> builder, ServerInterceptor ... interceptors) {
        testServiceExecutor = Executors.newScheduledThreadPool(2);
        ImmutableList allInterceptors = ImmutableList.builder().add((Object)TestUtils.recordServerCallInterceptor(serverCallCapture)).add((Object)TestUtils.recordRequestHeadersInterceptor(requestHeadersCapture)).addAll(TestServiceImpl.interceptors()).add((Object[])interceptors).build();
        builder.addService(ServerInterceptors.intercept((BindableService)new TestServiceImpl(testServiceExecutor), (List)allInterceptors)).addStreamTracerFactory(serverStreamTracerFactory);
        TestingAccessor.setStatsContextFactory(builder, (StatsContextFactory)serverStatsCtxFactory);
        try {
            server = builder.build().start();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    protected static void stopStaticServer() {
        server.shutdownNow();
        testServiceExecutor.shutdown();
    }

    @VisibleForTesting
    static int getPort() {
        return server.getPort();
    }

    @Before
    public void setUp() {
        this.channel = this.createChannel();
        this.blockingStub = (TestServiceGrpc.TestServiceBlockingStub)TestServiceGrpc.newBlockingStub((Channel)this.channel).withInterceptors(new ClientInterceptor[]{this.tracerSetupInterceptor});
        this.asyncStub = (TestServiceGrpc.TestServiceStub)TestServiceGrpc.newStub((Channel)this.channel).withInterceptors(new ClientInterceptor[]{this.tracerSetupInterceptor});
        requestHeadersCapture.set(null);
        clientStatsCtxFactory.rolloverRecords();
        serverStatsCtxFactory.rolloverRecords();
        serverStreamTracers.clear();
    }

    @After
    public void tearDown() throws Exception {
        if (this.channel != null) {
            this.channel.shutdown();
        }
    }

    protected abstract ManagedChannel createChannel();

    protected final StatsContextFactory getClientStatsFactory() {
        return clientStatsCtxFactory;
    }

    protected boolean metricsExpected() {
        return true;
    }

    @Test(timeout=10000L)
    public void emptyUnary() throws Exception {
        Assert.assertEquals((Object)EMPTY, (Object)this.blockingStub.emptyCall(EMPTY));
    }

    public void cacheableUnary() {
        MethodDescriptor safeCacheableUnaryCallMethod = TestServiceGrpc.METHOD_CACHEABLE_UNARY_CALL.toBuilder().setSafe(true).build();
        Metadata.Key userIpKey = Metadata.Key.of((String)"x-user-ip", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
        Metadata metadata = new Metadata();
        metadata.put(userIpKey, (Object)"1.2.3.4");
        Channel channelWithUserIpKey = ClientInterceptors.intercept((Channel)this.channel, (ClientInterceptor[])new ClientInterceptor[]{MetadataUtils.newAttachHeadersInterceptor((Metadata)metadata)});
        Messages.SimpleRequest requests1And2 = Messages.SimpleRequest.newBuilder().setPayload(Messages.Payload.newBuilder().setBody(ByteString.copyFromUtf8((String)String.valueOf(System.nanoTime())))).build();
        Messages.SimpleRequest request3 = Messages.SimpleRequest.newBuilder().setPayload(Messages.Payload.newBuilder().setBody(ByteString.copyFromUtf8((String)String.valueOf(System.nanoTime())))).build();
        Messages.SimpleResponse response1 = (Messages.SimpleResponse)ClientCalls.blockingUnaryCall((Channel)channelWithUserIpKey, (MethodDescriptor)safeCacheableUnaryCallMethod, (CallOptions)CallOptions.DEFAULT, (Object)requests1And2);
        Messages.SimpleResponse response2 = (Messages.SimpleResponse)ClientCalls.blockingUnaryCall((Channel)channelWithUserIpKey, (MethodDescriptor)safeCacheableUnaryCallMethod, (CallOptions)CallOptions.DEFAULT, (Object)requests1And2);
        Messages.SimpleResponse response3 = (Messages.SimpleResponse)ClientCalls.blockingUnaryCall((Channel)channelWithUserIpKey, (MethodDescriptor)safeCacheableUnaryCallMethod, (CallOptions)CallOptions.DEFAULT, (Object)request3);
        Assert.assertEquals((Object)response1, (Object)response2);
        Assert.assertNotEquals((Object)response1, (Object)response3);
    }

    @Test(timeout=10000L)
    public void largeUnary() throws Exception {
        AbstractInteropTest.assumeEnoughMemory();
        Messages.SimpleRequest request = Messages.SimpleRequest.newBuilder().setResponseSize(314159).setResponseType(Messages.PayloadType.COMPRESSABLE).setPayload(Messages.Payload.newBuilder().setBody(ByteString.copyFrom((byte[])new byte[271828]))).build();
        Messages.SimpleResponse goldenResponse = Messages.SimpleResponse.newBuilder().setPayload(Messages.Payload.newBuilder().setType(Messages.PayloadType.COMPRESSABLE).setBody(ByteString.copyFrom((byte[])new byte[314159]))).build();
        Assert.assertEquals((Object)goldenResponse, (Object)this.blockingStub.unaryCall(request));
        if (this.metricsExpected()) {
            this.assertMetrics("grpc.testing.TestService/UnaryCall", Status.Code.OK, Collections.singleton(request), Collections.singleton(goldenResponse));
        }
    }

    public void clientCompressedUnary() throws Exception {
        AbstractInteropTest.assumeEnoughMemory();
        Messages.SimpleRequest expectCompressedRequest = Messages.SimpleRequest.newBuilder().setExpectCompressed(BoolValue.newBuilder().setValue(true)).setResponseSize(314159).setPayload(Messages.Payload.newBuilder().setBody(ByteString.copyFrom((byte[])new byte[271828]))).build();
        Messages.SimpleRequest expectUncompressedRequest = Messages.SimpleRequest.newBuilder().setExpectCompressed(BoolValue.newBuilder().setValue(false)).setResponseSize(314159).setPayload(Messages.Payload.newBuilder().setBody(ByteString.copyFrom((byte[])new byte[271828]))).build();
        Messages.SimpleResponse goldenResponse = Messages.SimpleResponse.newBuilder().setPayload(Messages.Payload.newBuilder().setBody(ByteString.copyFrom((byte[])new byte[314159]))).build();
        try {
            this.blockingStub.unaryCall(expectCompressedRequest);
            Assert.fail((String)"expected INVALID_ARGUMENT");
        }
        catch (StatusRuntimeException e) {
            Assert.assertEquals((Object)Status.INVALID_ARGUMENT.getCode(), (Object)e.getStatus().getCode());
        }
        if (this.metricsExpected()) {
            this.assertMetrics("grpc.testing.TestService/UnaryCall", Status.Code.INVALID_ARGUMENT);
        }
        Assert.assertEquals((Object)goldenResponse, (Object)((TestServiceGrpc.TestServiceBlockingStub)this.blockingStub.withCompression("gzip")).unaryCall(expectCompressedRequest));
        if (this.metricsExpected()) {
            this.assertMetrics("grpc.testing.TestService/UnaryCall", Status.Code.OK, Collections.singleton(expectCompressedRequest), Collections.singleton(goldenResponse));
        }
        Assert.assertEquals((Object)goldenResponse, (Object)this.blockingStub.unaryCall(expectUncompressedRequest));
        if (this.metricsExpected()) {
            this.assertMetrics("grpc.testing.TestService/UnaryCall", Status.Code.OK, Collections.singleton(expectUncompressedRequest), Collections.singleton(goldenResponse));
        }
    }

    @Test(timeout=10000L)
    public void serverCompressedUnary() throws Exception {
        AbstractInteropTest.assumeEnoughMemory();
        Messages.SimpleRequest responseShouldBeCompressed = Messages.SimpleRequest.newBuilder().setResponseCompressed(BoolValue.newBuilder().setValue(true)).setResponseSize(314159).setPayload(Messages.Payload.newBuilder().setBody(ByteString.copyFrom((byte[])new byte[271828]))).build();
        Messages.SimpleRequest responseShouldBeUncompressed = Messages.SimpleRequest.newBuilder().setResponseCompressed(BoolValue.newBuilder().setValue(false)).setResponseSize(314159).setPayload(Messages.Payload.newBuilder().setBody(ByteString.copyFrom((byte[])new byte[271828]))).build();
        Messages.SimpleResponse goldenResponse = Messages.SimpleResponse.newBuilder().setPayload(Messages.Payload.newBuilder().setBody(ByteString.copyFrom((byte[])new byte[314159]))).build();
        Assert.assertEquals((Object)goldenResponse, (Object)this.blockingStub.unaryCall(responseShouldBeCompressed));
        if (this.metricsExpected()) {
            this.assertMetrics("grpc.testing.TestService/UnaryCall", Status.Code.OK, Collections.singleton(responseShouldBeCompressed), Collections.singleton(goldenResponse));
        }
        Assert.assertEquals((Object)goldenResponse, (Object)this.blockingStub.unaryCall(responseShouldBeUncompressed));
        if (this.metricsExpected()) {
            this.assertMetrics("grpc.testing.TestService/UnaryCall", Status.Code.OK, Collections.singleton(responseShouldBeUncompressed), Collections.singleton(goldenResponse));
        }
    }

    @Test(timeout=10000L)
    public void serverStreaming() throws Exception {
        Messages.StreamingOutputCallRequest request = Messages.StreamingOutputCallRequest.newBuilder().setResponseType(Messages.PayloadType.COMPRESSABLE).addResponseParameters(Messages.ResponseParameters.newBuilder().setSize(31415)).addResponseParameters(Messages.ResponseParameters.newBuilder().setSize(9)).addResponseParameters(Messages.ResponseParameters.newBuilder().setSize(2653)).addResponseParameters(Messages.ResponseParameters.newBuilder().setSize(58979)).build();
        List<Messages.StreamingOutputCallResponse> goldenResponses = Arrays.asList(Messages.StreamingOutputCallResponse.newBuilder().setPayload(Messages.Payload.newBuilder().setType(Messages.PayloadType.COMPRESSABLE).setBody(ByteString.copyFrom((byte[])new byte[31415]))).build(), Messages.StreamingOutputCallResponse.newBuilder().setPayload(Messages.Payload.newBuilder().setType(Messages.PayloadType.COMPRESSABLE).setBody(ByteString.copyFrom((byte[])new byte[9]))).build(), Messages.StreamingOutputCallResponse.newBuilder().setPayload(Messages.Payload.newBuilder().setType(Messages.PayloadType.COMPRESSABLE).setBody(ByteString.copyFrom((byte[])new byte[2653]))).build(), Messages.StreamingOutputCallResponse.newBuilder().setPayload(Messages.Payload.newBuilder().setType(Messages.PayloadType.COMPRESSABLE).setBody(ByteString.copyFrom((byte[])new byte[58979]))).build());
        StreamRecorder recorder = StreamRecorder.create();
        this.asyncStub.streamingOutputCall(request, (StreamObserver<Messages.StreamingOutputCallResponse>)recorder);
        recorder.awaitCompletion();
        AbstractInteropTest.assertSuccess(recorder);
        Assert.assertEquals(goldenResponses, (Object)recorder.getValues());
    }

    @Test(timeout=10000L)
    public void clientStreaming() throws Exception {
        List<Messages.StreamingInputCallRequest> requests = Arrays.asList(Messages.StreamingInputCallRequest.newBuilder().setPayload(Messages.Payload.newBuilder().setBody(ByteString.copyFrom((byte[])new byte[27182]))).build(), Messages.StreamingInputCallRequest.newBuilder().setPayload(Messages.Payload.newBuilder().setBody(ByteString.copyFrom((byte[])new byte[8]))).build(), Messages.StreamingInputCallRequest.newBuilder().setPayload(Messages.Payload.newBuilder().setBody(ByteString.copyFrom((byte[])new byte[1828]))).build(), Messages.StreamingInputCallRequest.newBuilder().setPayload(Messages.Payload.newBuilder().setBody(ByteString.copyFrom((byte[])new byte[45904]))).build());
        Messages.StreamingInputCallResponse goldenResponse = Messages.StreamingInputCallResponse.newBuilder().setAggregatedPayloadSize(74922).build();
        StreamRecorder responseObserver = StreamRecorder.create();
        StreamObserver<Messages.StreamingInputCallRequest> requestObserver = this.asyncStub.streamingInputCall((StreamObserver<Messages.StreamingInputCallResponse>)responseObserver);
        for (Messages.StreamingInputCallRequest request : requests) {
            requestObserver.onNext((Object)request);
        }
        requestObserver.onCompleted();
        Assert.assertEquals((Object)goldenResponse, (Object)responseObserver.firstValue().get());
        responseObserver.awaitCompletion();
    }

    public void clientCompressedStreaming() throws Exception {
        Messages.StreamingInputCallRequest expectCompressedRequest = Messages.StreamingInputCallRequest.newBuilder().setExpectCompressed(BoolValue.newBuilder().setValue(true)).setPayload(Messages.Payload.newBuilder().setBody(ByteString.copyFrom((byte[])new byte[27182]))).build();
        Messages.StreamingInputCallRequest expectUncompressedRequest = Messages.StreamingInputCallRequest.newBuilder().setExpectCompressed(BoolValue.newBuilder().setValue(false)).setPayload(Messages.Payload.newBuilder().setBody(ByteString.copyFrom((byte[])new byte[45904]))).build();
        Messages.StreamingInputCallResponse goldenResponse = Messages.StreamingInputCallResponse.newBuilder().setAggregatedPayloadSize(73086).build();
        StreamRecorder responseObserver = StreamRecorder.create();
        StreamObserver<Messages.StreamingInputCallRequest> requestObserver = this.asyncStub.streamingInputCall((StreamObserver<Messages.StreamingInputCallResponse>)responseObserver);
        requestObserver.onNext((Object)expectCompressedRequest);
        responseObserver.awaitCompletion(this.operationTimeoutMillis(), TimeUnit.MILLISECONDS);
        Throwable e = responseObserver.getError();
        Assert.assertNotNull((String)"expected INVALID_ARGUMENT", (Object)e);
        Assert.assertEquals((Object)Status.INVALID_ARGUMENT.getCode(), (Object)Status.fromThrowable((Throwable)e).getCode());
        responseObserver = StreamRecorder.create();
        ClientCallStreamObserver clientCallStreamObserver = (ClientCallStreamObserver)((TestServiceGrpc.TestServiceStub)this.asyncStub.withCompression("gzip")).streamingInputCall((StreamObserver<Messages.StreamingInputCallResponse>)responseObserver);
        clientCallStreamObserver.setMessageCompression(true);
        clientCallStreamObserver.onNext((Object)expectCompressedRequest);
        clientCallStreamObserver.setMessageCompression(false);
        clientCallStreamObserver.onNext((Object)expectUncompressedRequest);
        clientCallStreamObserver.onCompleted();
        responseObserver.awaitCompletion();
        AbstractInteropTest.assertSuccess(responseObserver);
        Assert.assertEquals((Object)goldenResponse, (Object)responseObserver.firstValue().get());
    }

    public void serverCompressedStreaming() throws Exception {
        Messages.StreamingOutputCallRequest request = Messages.StreamingOutputCallRequest.newBuilder().addResponseParameters(Messages.ResponseParameters.newBuilder().setCompressed(BoolValue.newBuilder().setValue(true)).setSize(31415)).addResponseParameters(Messages.ResponseParameters.newBuilder().setCompressed(BoolValue.newBuilder().setValue(false)).setSize(92653)).build();
        List<Messages.StreamingOutputCallResponse> goldenResponses = Arrays.asList(Messages.StreamingOutputCallResponse.newBuilder().setPayload(Messages.Payload.newBuilder().setBody(ByteString.copyFrom((byte[])new byte[31415]))).build(), Messages.StreamingOutputCallResponse.newBuilder().setPayload(Messages.Payload.newBuilder().setBody(ByteString.copyFrom((byte[])new byte[92653]))).build());
        StreamRecorder recorder = StreamRecorder.create();
        this.asyncStub.streamingOutputCall(request, (StreamObserver<Messages.StreamingOutputCallResponse>)recorder);
        recorder.awaitCompletion();
        AbstractInteropTest.assertSuccess(recorder);
        Assert.assertEquals(goldenResponses, (Object)recorder.getValues());
    }

    @Test(timeout=10000L)
    public void pingPong() throws Exception {
        List<Messages.StreamingOutputCallRequest> requests = Arrays.asList(Messages.StreamingOutputCallRequest.newBuilder().addResponseParameters(Messages.ResponseParameters.newBuilder().setSize(31415)).setPayload(Messages.Payload.newBuilder().setBody(ByteString.copyFrom((byte[])new byte[27182]))).build(), Messages.StreamingOutputCallRequest.newBuilder().addResponseParameters(Messages.ResponseParameters.newBuilder().setSize(9)).setPayload(Messages.Payload.newBuilder().setBody(ByteString.copyFrom((byte[])new byte[8]))).build(), Messages.StreamingOutputCallRequest.newBuilder().addResponseParameters(Messages.ResponseParameters.newBuilder().setSize(2653)).setPayload(Messages.Payload.newBuilder().setBody(ByteString.copyFrom((byte[])new byte[1828]))).build(), Messages.StreamingOutputCallRequest.newBuilder().addResponseParameters(Messages.ResponseParameters.newBuilder().setSize(58979)).setPayload(Messages.Payload.newBuilder().setBody(ByteString.copyFrom((byte[])new byte[45904]))).build());
        List<Messages.StreamingOutputCallResponse> goldenResponses = Arrays.asList(Messages.StreamingOutputCallResponse.newBuilder().setPayload(Messages.Payload.newBuilder().setType(Messages.PayloadType.COMPRESSABLE).setBody(ByteString.copyFrom((byte[])new byte[31415]))).build(), Messages.StreamingOutputCallResponse.newBuilder().setPayload(Messages.Payload.newBuilder().setType(Messages.PayloadType.COMPRESSABLE).setBody(ByteString.copyFrom((byte[])new byte[9]))).build(), Messages.StreamingOutputCallResponse.newBuilder().setPayload(Messages.Payload.newBuilder().setType(Messages.PayloadType.COMPRESSABLE).setBody(ByteString.copyFrom((byte[])new byte[2653]))).build(), Messages.StreamingOutputCallResponse.newBuilder().setPayload(Messages.Payload.newBuilder().setType(Messages.PayloadType.COMPRESSABLE).setBody(ByteString.copyFrom((byte[])new byte[58979]))).build());
        final ArrayBlockingQueue queue = new ArrayBlockingQueue(5);
        StreamObserver<Messages.StreamingOutputCallRequest> requestObserver = this.asyncStub.fullDuplexCall(new StreamObserver<Messages.StreamingOutputCallResponse>(){

            public void onNext(Messages.StreamingOutputCallResponse response) {
                queue.add(response);
            }

            public void onError(Throwable t) {
                queue.add(t);
            }

            public void onCompleted() {
                queue.add("Completed");
            }
        });
        for (int i = 0; i < requests.size(); ++i) {
            Assert.assertNull(queue.peek());
            requestObserver.onNext((Object)requests.get(i));
            Assert.assertEquals((Object)goldenResponses.get(i), queue.poll(this.operationTimeoutMillis(), TimeUnit.MILLISECONDS));
        }
        requestObserver.onCompleted();
        Assert.assertEquals((Object)"Completed", queue.poll(this.operationTimeoutMillis(), TimeUnit.MILLISECONDS));
    }

    @Test(timeout=10000L)
    public void emptyStream() throws Exception {
        StreamRecorder responseObserver = StreamRecorder.create();
        StreamObserver<Messages.StreamingOutputCallRequest> requestObserver = this.asyncStub.fullDuplexCall((StreamObserver<Messages.StreamingOutputCallResponse>)responseObserver);
        requestObserver.onCompleted();
        responseObserver.awaitCompletion(this.operationTimeoutMillis(), TimeUnit.MILLISECONDS);
    }

    @Test(timeout=10000L)
    public void cancelAfterBegin() throws Exception {
        StreamRecorder responseObserver = StreamRecorder.create();
        StreamObserver<Messages.StreamingInputCallRequest> requestObserver = this.asyncStub.streamingInputCall((StreamObserver<Messages.StreamingInputCallResponse>)responseObserver);
        requestObserver.onError((Throwable)new RuntimeException());
        responseObserver.awaitCompletion();
        Assert.assertEquals(Arrays.asList(new Messages.StreamingInputCallResponse[0]), (Object)responseObserver.getValues());
        Assert.assertEquals((Object)Status.Code.CANCELLED, (Object)Status.fromThrowable((Throwable)responseObserver.getError()).getCode());
        if (this.metricsExpected()) {
            StatsTestUtils.MetricsRecord clientRecord = clientStatsCtxFactory.pollRecord(5L, TimeUnit.SECONDS);
            AbstractInteropTest.checkTags(clientRecord, false, "grpc.testing.TestService/StreamingInputCall", Status.CANCELLED.getCode());
        }
    }

    @Test(timeout=10000L)
    public void cancelAfterFirstResponse() throws Exception {
        Messages.StreamingOutputCallRequest request = Messages.StreamingOutputCallRequest.newBuilder().addResponseParameters(Messages.ResponseParameters.newBuilder().setSize(31415)).setPayload(Messages.Payload.newBuilder().setBody(ByteString.copyFrom((byte[])new byte[27182]))).build();
        Messages.StreamingOutputCallResponse goldenResponse = Messages.StreamingOutputCallResponse.newBuilder().setPayload(Messages.Payload.newBuilder().setType(Messages.PayloadType.COMPRESSABLE).setBody(ByteString.copyFrom((byte[])new byte[31415]))).build();
        StreamRecorder responseObserver = StreamRecorder.create();
        StreamObserver<Messages.StreamingOutputCallRequest> requestObserver = this.asyncStub.fullDuplexCall((StreamObserver<Messages.StreamingOutputCallResponse>)responseObserver);
        requestObserver.onNext((Object)request);
        Assert.assertEquals((Object)goldenResponse, (Object)responseObserver.firstValue().get());
        requestObserver.onError((Throwable)new RuntimeException());
        responseObserver.awaitCompletion(this.operationTimeoutMillis(), TimeUnit.MILLISECONDS);
        Assert.assertEquals((long)1L, (long)responseObserver.getValues().size());
        Assert.assertEquals((Object)Status.Code.CANCELLED, (Object)Status.fromThrowable((Throwable)responseObserver.getError()).getCode());
        if (this.metricsExpected()) {
            this.assertMetrics("grpc.testing.TestService/FullDuplexCall", Status.Code.CANCELLED);
        }
    }

    @Test(timeout=10000L)
    public void fullDuplexCallShouldSucceed() throws Exception {
        int ix;
        List<Integer> responseSizes = Arrays.asList(50, 100, 150, 200);
        Messages.StreamingOutputCallRequest.Builder streamingOutputBuilder = Messages.StreamingOutputCallRequest.newBuilder();
        streamingOutputBuilder.setResponseType(Messages.PayloadType.COMPRESSABLE);
        for (Integer size : responseSizes) {
            streamingOutputBuilder.addResponseParametersBuilder().setSize(size).setIntervalUs(0);
        }
        Messages.StreamingOutputCallRequest request = streamingOutputBuilder.build();
        StreamRecorder recorder = StreamRecorder.create();
        StreamObserver<Messages.StreamingOutputCallRequest> requestStream = this.asyncStub.fullDuplexCall((StreamObserver<Messages.StreamingOutputCallResponse>)recorder);
        int numRequests = 10;
        ArrayList<Messages.StreamingOutputCallRequest> requests = new ArrayList<Messages.StreamingOutputCallRequest>(10);
        for (ix = 10; ix > 0; --ix) {
            requests.add(request);
            requestStream.onNext((Object)request);
        }
        requestStream.onCompleted();
        recorder.awaitCompletion();
        AbstractInteropTest.assertSuccess(recorder);
        Assert.assertEquals((long)(responseSizes.size() * 10), (long)recorder.getValues().size());
        for (ix = 0; ix < recorder.getValues().size(); ++ix) {
            Messages.StreamingOutputCallResponse response = (Messages.StreamingOutputCallResponse)recorder.getValues().get(ix);
            Assert.assertEquals((Object)((Object)Messages.PayloadType.COMPRESSABLE), (Object)((Object)response.getPayload().getType()));
            int length = response.getPayload().getBody().size();
            int expectedSize = responseSizes.get(ix % responseSizes.size());
            Assert.assertEquals((String)("comparison failed at index " + ix), (long)expectedSize, (long)length);
        }
        if (this.metricsExpected()) {
            this.assertMetrics("grpc.testing.TestService/FullDuplexCall", Status.Code.OK, requests, recorder.getValues());
        }
    }

    @Test(timeout=10000L)
    public void halfDuplexCallShouldSucceed() throws Exception {
        int ix;
        List<Integer> responseSizes = Arrays.asList(50, 100, 150, 200);
        Messages.StreamingOutputCallRequest.Builder streamingOutputBuilder = Messages.StreamingOutputCallRequest.newBuilder();
        streamingOutputBuilder.setResponseType(Messages.PayloadType.COMPRESSABLE);
        for (Integer size : responseSizes) {
            streamingOutputBuilder.addResponseParametersBuilder().setSize(size).setIntervalUs(0);
        }
        Messages.StreamingOutputCallRequest request = streamingOutputBuilder.build();
        StreamRecorder recorder = StreamRecorder.create();
        StreamObserver<Messages.StreamingOutputCallRequest> requestStream = this.asyncStub.halfDuplexCall((StreamObserver<Messages.StreamingOutputCallResponse>)recorder);
        int numRequests = 10;
        ArrayList<Messages.StreamingOutputCallRequest> requests = new ArrayList<Messages.StreamingOutputCallRequest>(10);
        for (ix = 10; ix > 0; --ix) {
            requests.add(request);
            requestStream.onNext((Object)request);
        }
        requestStream.onCompleted();
        recorder.awaitCompletion();
        AbstractInteropTest.assertSuccess(recorder);
        Assert.assertEquals((long)(responseSizes.size() * 10), (long)recorder.getValues().size());
        for (ix = 0; ix < recorder.getValues().size(); ++ix) {
            Messages.StreamingOutputCallResponse response = (Messages.StreamingOutputCallResponse)recorder.getValues().get(ix);
            Assert.assertEquals((Object)((Object)Messages.PayloadType.COMPRESSABLE), (Object)((Object)response.getPayload().getType()));
            int length = response.getPayload().getBody().size();
            int expectedSize = responseSizes.get(ix % responseSizes.size());
            Assert.assertEquals((String)("comparison failed at index " + ix), (long)expectedSize, (long)length);
        }
    }

    @Test(timeout=10000L)
    public void serverStreamingShouldBeFlowControlled() throws Exception {
        Messages.StreamingOutputCallRequest request = Messages.StreamingOutputCallRequest.newBuilder().setResponseType(Messages.PayloadType.COMPRESSABLE).addResponseParameters(Messages.ResponseParameters.newBuilder().setSize(100000)).addResponseParameters(Messages.ResponseParameters.newBuilder().setSize(100001)).build();
        List<Messages.StreamingOutputCallResponse> goldenResponses = Arrays.asList(Messages.StreamingOutputCallResponse.newBuilder().setPayload(Messages.Payload.newBuilder().setType(Messages.PayloadType.COMPRESSABLE).setBody(ByteString.copyFrom((byte[])new byte[100000]))).build(), Messages.StreamingOutputCallResponse.newBuilder().setPayload(Messages.Payload.newBuilder().setType(Messages.PayloadType.COMPRESSABLE).setBody(ByteString.copyFrom((byte[])new byte[100001]))).build());
        long start = System.nanoTime();
        final ArrayBlockingQueue queue = new ArrayBlockingQueue(10);
        ClientCall call = this.channel.newCall(TestServiceGrpc.METHOD_STREAMING_OUTPUT_CALL, CallOptions.DEFAULT);
        call.start((ClientCall.Listener)new ClientCall.Listener<Messages.StreamingOutputCallResponse>(){

            public void onHeaders(Metadata headers) {
            }

            public void onMessage(Messages.StreamingOutputCallResponse message) {
                queue.add(message);
            }

            public void onClose(Status status, Metadata trailers) {
                queue.add(status);
            }
        }, new Metadata());
        call.sendMessage((Object)request);
        call.halfClose();
        call.request(1);
        Assert.assertEquals((Object)goldenResponses.get(0), queue.poll(this.operationTimeoutMillis(), TimeUnit.MILLISECONDS));
        long firstCallDuration = System.nanoTime() - start;
        Assert.assertNull(queue.poll(Math.max(firstCallDuration * 4L, 1000000L), TimeUnit.NANOSECONDS));
        call.request(1);
        Assert.assertEquals((Object)goldenResponses.get(1), queue.poll(this.operationTimeoutMillis(), TimeUnit.MILLISECONDS));
        Assert.assertEquals((Object)Status.OK, queue.poll(this.operationTimeoutMillis(), TimeUnit.MILLISECONDS));
    }

    @Test(timeout=30000L)
    public void veryLargeRequest() throws Exception {
        AbstractInteropTest.assumeEnoughMemory();
        Messages.SimpleRequest request = Messages.SimpleRequest.newBuilder().setPayload(Messages.Payload.newBuilder().setType(Messages.PayloadType.COMPRESSABLE).setBody(ByteString.copyFrom((byte[])new byte[this.unaryPayloadLength()]))).setResponseSize(10).setResponseType(Messages.PayloadType.COMPRESSABLE).build();
        Messages.SimpleResponse goldenResponse = Messages.SimpleResponse.newBuilder().setPayload(Messages.Payload.newBuilder().setType(Messages.PayloadType.COMPRESSABLE).setBody(ByteString.copyFrom((byte[])new byte[10]))).build();
        Assert.assertEquals((Object)goldenResponse, (Object)this.blockingStub.unaryCall(request));
    }

    @Test(timeout=30000L)
    public void veryLargeResponse() throws Exception {
        AbstractInteropTest.assumeEnoughMemory();
        Messages.SimpleRequest request = Messages.SimpleRequest.newBuilder().setResponseSize(this.unaryPayloadLength()).setResponseType(Messages.PayloadType.COMPRESSABLE).build();
        Messages.SimpleResponse goldenResponse = Messages.SimpleResponse.newBuilder().setPayload(Messages.Payload.newBuilder().setType(Messages.PayloadType.COMPRESSABLE).setBody(ByteString.copyFrom((byte[])new byte[this.unaryPayloadLength()]))).build();
        Assert.assertEquals((Object)goldenResponse, (Object)this.blockingStub.unaryCall(request));
    }

    @Test(timeout=10000L)
    public void exchangeMetadataUnaryCall() throws Exception {
        TestServiceGrpc.TestServiceBlockingStub stub = this.blockingStub;
        Metadata fixedHeaders = new Metadata();
        Messages.SimpleContext contextValue = Messages.SimpleContext.newBuilder().setValue("dog").build();
        fixedHeaders.put(METADATA_KEY, (Object)contextValue);
        stub = (TestServiceGrpc.TestServiceBlockingStub)MetadataUtils.attachHeaders((AbstractStub)stub, (Metadata)fixedHeaders);
        AtomicReference trailersCapture = new AtomicReference();
        AtomicReference headersCapture = new AtomicReference();
        stub = (TestServiceGrpc.TestServiceBlockingStub)MetadataUtils.captureMetadata((AbstractStub)stub, headersCapture, trailersCapture);
        Assert.assertNotNull((Object)stub.emptyCall(EMPTY));
        Assert.assertEquals((Object)contextValue, (Object)((Metadata)headersCapture.get()).get(METADATA_KEY));
        Assert.assertEquals((Object)contextValue, (Object)((Metadata)trailersCapture.get()).get(METADATA_KEY));
    }

    @Test(timeout=10000L)
    public void exchangeMetadataStreamingCall() throws Exception {
        TestServiceGrpc.TestServiceStub stub = this.asyncStub;
        Metadata fixedHeaders = new Metadata();
        Messages.SimpleContext contextValue = Messages.SimpleContext.newBuilder().setValue("dog").build();
        fixedHeaders.put(METADATA_KEY, (Object)contextValue);
        stub = (TestServiceGrpc.TestServiceStub)MetadataUtils.attachHeaders((AbstractStub)stub, (Metadata)fixedHeaders);
        AtomicReference trailersCapture = new AtomicReference();
        AtomicReference headersCapture = new AtomicReference();
        stub = (TestServiceGrpc.TestServiceStub)MetadataUtils.captureMetadata((AbstractStub)stub, headersCapture, trailersCapture);
        List<Integer> responseSizes = Arrays.asList(50, 100, 150, 200);
        Messages.StreamingOutputCallRequest.Builder streamingOutputBuilder = Messages.StreamingOutputCallRequest.newBuilder();
        streamingOutputBuilder.setResponseType(Messages.PayloadType.COMPRESSABLE);
        for (Integer size : responseSizes) {
            streamingOutputBuilder.addResponseParametersBuilder().setSize(size).setIntervalUs(0);
        }
        Messages.StreamingOutputCallRequest request = streamingOutputBuilder.build();
        StreamRecorder recorder = StreamRecorder.create();
        StreamObserver<Messages.StreamingOutputCallRequest> requestStream = stub.fullDuplexCall((StreamObserver<Messages.StreamingOutputCallResponse>)recorder);
        int numRequests = 10;
        ArrayList<Messages.StreamingOutputCallRequest> requests = new ArrayList<Messages.StreamingOutputCallRequest>(10);
        for (int ix = 10; ix > 0; --ix) {
            requests.add(request);
            requestStream.onNext((Object)request);
        }
        requestStream.onCompleted();
        recorder.awaitCompletion();
        AbstractInteropTest.assertSuccess(recorder);
        Assert.assertEquals((long)(responseSizes.size() * 10), (long)recorder.getValues().size());
        Assert.assertEquals((Object)contextValue, (Object)((Metadata)headersCapture.get()).get(METADATA_KEY));
        Assert.assertEquals((Object)contextValue, (Object)((Metadata)trailersCapture.get()).get(METADATA_KEY));
    }

    @Test(timeout=10000L)
    public void sendsTimeoutHeader() {
        long configuredTimeoutMinutes = 100L;
        TestServiceGrpc.TestServiceBlockingStub stub = (TestServiceGrpc.TestServiceBlockingStub)this.blockingStub.withDeadlineAfter(configuredTimeoutMinutes, TimeUnit.MINUTES);
        stub.emptyCall(EMPTY);
        long transferredTimeoutMinutes = TimeUnit.NANOSECONDS.toMinutes((Long)requestHeadersCapture.get().get(GrpcUtil.TIMEOUT_KEY));
        Assert.assertTrue((String)("configuredTimeoutMinutes=" + configuredTimeoutMinutes + ", transferredTimeoutMinutes=" + transferredTimeoutMinutes), (configuredTimeoutMinutes - transferredTimeoutMinutes >= 0L && configuredTimeoutMinutes - transferredTimeoutMinutes <= 1L ? 1 : 0) != 0);
    }

    @Test
    public void deadlineNotExceeded() {
        this.blockingStub.emptyCall(EmptyProtos.Empty.getDefaultInstance());
        ((TestServiceGrpc.TestServiceBlockingStub)this.blockingStub.withDeadlineAfter(10L, TimeUnit.SECONDS)).streamingOutputCall(Messages.StreamingOutputCallRequest.newBuilder().addResponseParameters(Messages.ResponseParameters.newBuilder().setIntervalUs(0)).build()).next();
    }

    @Test(timeout=10000L)
    public void deadlineExceeded() throws Exception {
        this.blockingStub.emptyCall(EmptyProtos.Empty.getDefaultInstance());
        TestServiceGrpc.TestServiceBlockingStub stub = (TestServiceGrpc.TestServiceBlockingStub)this.blockingStub.withDeadlineAfter(10L, TimeUnit.MILLISECONDS);
        Messages.StreamingOutputCallRequest request = Messages.StreamingOutputCallRequest.newBuilder().addResponseParameters(Messages.ResponseParameters.newBuilder().setIntervalUs(20000)).build();
        try {
            stub.streamingOutputCall(request).next();
            Assert.fail((String)"Expected deadline to be exceeded");
        }
        catch (StatusRuntimeException ex) {
            Assert.assertEquals((Object)Status.DEADLINE_EXCEEDED.getCode(), (Object)ex.getStatus().getCode());
        }
        if (this.metricsExpected()) {
            this.assertMetrics("grpc.testing.TestService/EmptyCall", Status.Code.OK);
            StatsTestUtils.MetricsRecord clientRecord = clientStatsCtxFactory.pollRecord(5L, TimeUnit.SECONDS);
            AbstractInteropTest.checkTags(clientRecord, false, "grpc.testing.TestService/StreamingOutputCall", Status.Code.DEADLINE_EXCEEDED);
        }
    }

    @Test(timeout=10000L)
    public void deadlineExceededServerStreaming() throws Exception {
        this.blockingStub.emptyCall(EmptyProtos.Empty.getDefaultInstance());
        Messages.ResponseParameters.Builder responseParameters = Messages.ResponseParameters.newBuilder().setSize(1).setIntervalUs(10000);
        Messages.StreamingOutputCallRequest request = Messages.StreamingOutputCallRequest.newBuilder().setResponseType(Messages.PayloadType.COMPRESSABLE).addResponseParameters(responseParameters).addResponseParameters(responseParameters).addResponseParameters(responseParameters).addResponseParameters(responseParameters).build();
        StreamRecorder recorder = StreamRecorder.create();
        ((TestServiceGrpc.TestServiceStub)this.asyncStub.withDeadlineAfter(30L, TimeUnit.MILLISECONDS)).streamingOutputCall(request, (StreamObserver<Messages.StreamingOutputCallResponse>)recorder);
        recorder.awaitCompletion();
        Assert.assertEquals((Object)Status.DEADLINE_EXCEEDED.getCode(), (Object)Status.fromThrowable((Throwable)recorder.getError()).getCode());
        if (this.metricsExpected()) {
            this.assertMetrics("grpc.testing.TestService/EmptyCall", Status.Code.OK);
            StatsTestUtils.MetricsRecord clientRecord = clientStatsCtxFactory.pollRecord(5L, TimeUnit.SECONDS);
            AbstractInteropTest.checkTags(clientRecord, false, "grpc.testing.TestService/StreamingOutputCall", Status.Code.DEADLINE_EXCEEDED);
        }
    }

    @Test(timeout=10000L)
    public void deadlineInPast() throws Exception {
        StatsTestUtils.MetricsRecord clientRecord;
        try {
            ((TestServiceGrpc.TestServiceBlockingStub)this.blockingStub.withDeadlineAfter(-10L, TimeUnit.SECONDS)).emptyCall(EmptyProtos.Empty.getDefaultInstance());
            Assert.fail((String)"Should have thrown");
        }
        catch (StatusRuntimeException ex) {
            Assert.assertEquals((Object)Status.Code.DEADLINE_EXCEEDED, (Object)ex.getStatus().getCode());
        }
        if (this.metricsExpected()) {
            clientRecord = clientStatsCtxFactory.pollRecord(5L, TimeUnit.SECONDS);
            AbstractInteropTest.checkTags(clientRecord, false, "grpc.testing.TestService/EmptyCall", Status.DEADLINE_EXCEEDED.getCode());
        }
        this.blockingStub.emptyCall(EmptyProtos.Empty.getDefaultInstance());
        try {
            ((TestServiceGrpc.TestServiceBlockingStub)this.blockingStub.withDeadlineAfter(-10L, TimeUnit.SECONDS)).emptyCall(EmptyProtos.Empty.getDefaultInstance());
            Assert.fail((String)"Should have thrown");
        }
        catch (StatusRuntimeException ex) {
            Assert.assertEquals((Object)Status.Code.DEADLINE_EXCEEDED, (Object)ex.getStatus().getCode());
        }
        if (this.metricsExpected()) {
            this.assertMetrics("grpc.testing.TestService/EmptyCall", Status.Code.OK);
            clientRecord = clientStatsCtxFactory.pollRecord(5L, TimeUnit.SECONDS);
            AbstractInteropTest.checkTags(clientRecord, false, "grpc.testing.TestService/EmptyCall", Status.DEADLINE_EXCEEDED.getCode());
        }
    }

    @Test(timeout=10000L)
    public void maxInboundSize_exact() {
        Messages.StreamingOutputCallRequest request = Messages.StreamingOutputCallRequest.newBuilder().addResponseParameters(Messages.ResponseParameters.newBuilder().setSize(1)).build();
        int size = this.blockingStub.streamingOutputCall(request).next().getSerializedSize();
        TestServiceGrpc.TestServiceBlockingStub stub = (TestServiceGrpc.TestServiceBlockingStub)this.blockingStub.withMaxInboundMessageSize(size);
        stub.streamingOutputCall(request).next();
    }

    @Test(timeout=10000L)
    public void maxInboundSize_tooBig() {
        Messages.StreamingOutputCallRequest request = Messages.StreamingOutputCallRequest.newBuilder().addResponseParameters(Messages.ResponseParameters.newBuilder().setSize(1)).build();
        int size = this.blockingStub.streamingOutputCall(request).next().getSerializedSize();
        TestServiceGrpc.TestServiceBlockingStub stub = (TestServiceGrpc.TestServiceBlockingStub)this.blockingStub.withMaxInboundMessageSize(size - 1);
        try {
            stub.streamingOutputCall(request).next();
            Assert.fail();
        }
        catch (StatusRuntimeException ex) {
            Status s = ex.getStatus();
            ((ComparableSubject)Truth.assertThat((Comparable)s.getCode()).named(s.toString())).isEqualTo((Object)Status.Code.RESOURCE_EXHAUSTED);
            Truth.assertThat((String)Throwables.getStackTraceAsString((Throwable)ex)).contains((CharSequence)"exceeds maximum");
        }
    }

    @Test(timeout=10000L)
    public void maxOutboundSize_exact() {
        this.blockingStub.emptyCall(EmptyProtos.Empty.getDefaultInstance());
        Messages.StreamingOutputCallRequest request = Messages.StreamingOutputCallRequest.newBuilder().addResponseParameters(Messages.ResponseParameters.newBuilder().setSize(1)).build();
        TestServiceGrpc.TestServiceBlockingStub stub = (TestServiceGrpc.TestServiceBlockingStub)this.blockingStub.withMaxOutboundMessageSize(request.getSerializedSize());
        stub.streamingOutputCall(request).next();
    }

    @Test(timeout=10000L)
    public void maxOutboundSize_tooBig() {
        this.blockingStub.emptyCall(EmptyProtos.Empty.getDefaultInstance());
        Messages.StreamingOutputCallRequest request = Messages.StreamingOutputCallRequest.newBuilder().addResponseParameters(Messages.ResponseParameters.newBuilder().setSize(1)).build();
        TestServiceGrpc.TestServiceBlockingStub stub = (TestServiceGrpc.TestServiceBlockingStub)this.blockingStub.withMaxOutboundMessageSize(request.getSerializedSize() - 1);
        try {
            stub.streamingOutputCall(request).next();
            Assert.fail();
        }
        catch (StatusRuntimeException ex) {
            Status s = ex.getStatus();
            ((ComparableSubject)Truth.assertThat((Comparable)s.getCode()).named(s.toString())).isEqualTo((Object)Status.Code.CANCELLED);
            Truth.assertThat((String)Throwables.getStackTraceAsString((Throwable)ex)).contains((CharSequence)"message too large");
        }
    }

    protected int unaryPayloadLength() {
        return 0xA00000;
    }

    @Test(timeout=10000L)
    public void gracefulShutdown() throws Exception {
        List<Messages.StreamingOutputCallRequest> requests = Arrays.asList(Messages.StreamingOutputCallRequest.newBuilder().addResponseParameters(Messages.ResponseParameters.newBuilder().setSize(3)).setPayload(Messages.Payload.newBuilder().setBody(ByteString.copyFrom((byte[])new byte[2]))).build(), Messages.StreamingOutputCallRequest.newBuilder().addResponseParameters(Messages.ResponseParameters.newBuilder().setSize(1)).setPayload(Messages.Payload.newBuilder().setBody(ByteString.copyFrom((byte[])new byte[7]))).build(), Messages.StreamingOutputCallRequest.newBuilder().addResponseParameters(Messages.ResponseParameters.newBuilder().setSize(4)).setPayload(Messages.Payload.newBuilder().setBody(ByteString.copyFrom((byte[])new byte[1]))).build());
        List<Messages.StreamingOutputCallResponse> goldenResponses = Arrays.asList(Messages.StreamingOutputCallResponse.newBuilder().setPayload(Messages.Payload.newBuilder().setType(Messages.PayloadType.COMPRESSABLE).setBody(ByteString.copyFrom((byte[])new byte[3]))).build(), Messages.StreamingOutputCallResponse.newBuilder().setPayload(Messages.Payload.newBuilder().setType(Messages.PayloadType.COMPRESSABLE).setBody(ByteString.copyFrom((byte[])new byte[1]))).build(), Messages.StreamingOutputCallResponse.newBuilder().setPayload(Messages.Payload.newBuilder().setType(Messages.PayloadType.COMPRESSABLE).setBody(ByteString.copyFrom((byte[])new byte[4]))).build());
        StreamObserver responseObserver = (StreamObserver)Mockito.mock(StreamObserver.class);
        StreamObserver<Messages.StreamingOutputCallRequest> requestObserver = this.asyncStub.fullDuplexCall((StreamObserver<Messages.StreamingOutputCallResponse>)responseObserver);
        requestObserver.onNext((Object)requests.get(0));
        AbstractInteropTest.verify(responseObserver, (VerificationMode)Mockito.timeout((int)this.operationTimeoutMillis())).onNext((Object)goldenResponses.get(0));
        this.channel.shutdown();
        requestObserver.onNext((Object)requests.get(1));
        AbstractInteropTest.verify(responseObserver, (VerificationMode)Mockito.timeout((int)this.operationTimeoutMillis())).onNext((Object)goldenResponses.get(1));
        requestObserver.onNext((Object)requests.get(2));
        AbstractInteropTest.verify(responseObserver, (VerificationMode)Mockito.timeout((int)this.operationTimeoutMillis())).onNext((Object)goldenResponses.get(2));
        requestObserver.onCompleted();
        AbstractInteropTest.verify(responseObserver, (VerificationMode)Mockito.timeout((int)this.operationTimeoutMillis())).onCompleted();
        AbstractInteropTest.verifyNoMoreInteractions(responseObserver);
    }

    @Test(timeout=10000L)
    public void customMetadata() throws Exception {
        int responseSize = 314159;
        int requestSize = 271828;
        Messages.SimpleRequest request = Messages.SimpleRequest.newBuilder().setResponseSize(314159).setResponseType(Messages.PayloadType.COMPRESSABLE).setPayload(Messages.Payload.newBuilder().setBody(ByteString.copyFrom((byte[])new byte[271828]))).build();
        Messages.StreamingOutputCallRequest streamingRequest = Messages.StreamingOutputCallRequest.newBuilder().addResponseParameters(Messages.ResponseParameters.newBuilder().setSize(314159)).setResponseType(Messages.PayloadType.COMPRESSABLE).setPayload(Messages.Payload.newBuilder().setBody(ByteString.copyFrom((byte[])new byte[271828]))).build();
        Messages.SimpleResponse goldenResponse = Messages.SimpleResponse.newBuilder().setPayload(Messages.Payload.newBuilder().setType(Messages.PayloadType.COMPRESSABLE).setBody(ByteString.copyFrom((byte[])new byte[314159]))).build();
        Messages.StreamingOutputCallResponse goldenStreamingResponse = Messages.StreamingOutputCallResponse.newBuilder().setPayload(Messages.Payload.newBuilder().setType(Messages.PayloadType.COMPRESSABLE).setBody(ByteString.copyFrom((byte[])new byte[314159]))).build();
        byte[] trailingBytes = new byte[]{10, 11, 10, 11, 10, 11};
        Metadata metadata = new Metadata();
        metadata.put(Util.ECHO_INITIAL_METADATA_KEY, (Object)"test_initial_metadata_value");
        metadata.put(Util.ECHO_TRAILING_METADATA_KEY, (Object)trailingBytes);
        TestServiceGrpc.TestServiceBlockingStub blockingStub = this.blockingStub;
        blockingStub = (TestServiceGrpc.TestServiceBlockingStub)MetadataUtils.attachHeaders((AbstractStub)blockingStub, (Metadata)metadata);
        AtomicReference headersCapture = new AtomicReference();
        AtomicReference trailersCapture = new AtomicReference();
        blockingStub = (TestServiceGrpc.TestServiceBlockingStub)MetadataUtils.captureMetadata((AbstractStub)blockingStub, headersCapture, trailersCapture);
        Messages.SimpleResponse response = blockingStub.unaryCall(request);
        Assert.assertEquals((Object)goldenResponse, (Object)response);
        Assert.assertEquals((Object)"test_initial_metadata_value", (Object)((Metadata)headersCapture.get()).get(Util.ECHO_INITIAL_METADATA_KEY));
        Assert.assertTrue((boolean)Arrays.equals(trailingBytes, (byte[])((Metadata)trailersCapture.get()).get(Util.ECHO_TRAILING_METADATA_KEY)));
        if (this.metricsExpected()) {
            this.assertMetrics("grpc.testing.TestService/UnaryCall", Status.Code.OK, Collections.singleton(request), Collections.singleton(goldenResponse));
        }
        metadata = new Metadata();
        metadata.put(Util.ECHO_INITIAL_METADATA_KEY, (Object)"test_initial_metadata_value");
        metadata.put(Util.ECHO_TRAILING_METADATA_KEY, (Object)trailingBytes);
        TestServiceGrpc.TestServiceStub stub = this.asyncStub;
        stub = (TestServiceGrpc.TestServiceStub)MetadataUtils.attachHeaders((AbstractStub)stub, (Metadata)metadata);
        headersCapture = new AtomicReference();
        trailersCapture = new AtomicReference();
        stub = (TestServiceGrpc.TestServiceStub)MetadataUtils.captureMetadata((AbstractStub)stub, headersCapture, trailersCapture);
        StreamRecorder recorder = StreamRecorder.create();
        StreamObserver<Messages.StreamingOutputCallRequest> requestStream = stub.fullDuplexCall((StreamObserver<Messages.StreamingOutputCallResponse>)recorder);
        requestStream.onNext((Object)streamingRequest);
        requestStream.onCompleted();
        recorder.awaitCompletion();
        AbstractInteropTest.assertSuccess(recorder);
        Assert.assertEquals((Object)goldenStreamingResponse, (Object)recorder.firstValue().get());
        Assert.assertEquals((Object)"test_initial_metadata_value", (Object)((Metadata)headersCapture.get()).get(Util.ECHO_INITIAL_METADATA_KEY));
        Assert.assertTrue((boolean)Arrays.equals(trailingBytes, (byte[])((Metadata)trailersCapture.get()).get(Util.ECHO_TRAILING_METADATA_KEY)));
        if (this.metricsExpected()) {
            this.assertMetrics("grpc.testing.TestService/FullDuplexCall", Status.Code.OK, Collections.singleton(streamingRequest), Collections.singleton(goldenStreamingResponse));
        }
    }

    @Test(timeout=10000L)
    public void statusCodeAndMessage() throws Exception {
        int errorCode = 2;
        String errorMessage = "test status message";
        Messages.EchoStatus responseStatus = Messages.EchoStatus.newBuilder().setCode(errorCode).setMessage(errorMessage).build();
        Messages.SimpleRequest simpleRequest = Messages.SimpleRequest.newBuilder().setResponseStatus(responseStatus).build();
        Messages.StreamingOutputCallRequest streamingRequest = Messages.StreamingOutputCallRequest.newBuilder().setResponseStatus(responseStatus).build();
        try {
            this.blockingStub.unaryCall(simpleRequest);
            Assert.fail();
        }
        catch (StatusRuntimeException e) {
            Assert.assertEquals((Object)Status.UNKNOWN.getCode(), (Object)e.getStatus().getCode());
            Assert.assertEquals((Object)errorMessage, (Object)e.getStatus().getDescription());
        }
        if (this.metricsExpected()) {
            this.assertMetrics("grpc.testing.TestService/UnaryCall", Status.Code.UNKNOWN);
        }
        StreamObserver responseObserver = (StreamObserver)Mockito.mock(StreamObserver.class);
        StreamObserver<Messages.StreamingOutputCallRequest> requestObserver = this.asyncStub.fullDuplexCall((StreamObserver<Messages.StreamingOutputCallResponse>)responseObserver);
        requestObserver.onNext((Object)streamingRequest);
        requestObserver.onCompleted();
        ArgumentCaptor captor = ArgumentCaptor.forClass(Throwable.class);
        AbstractInteropTest.verify(responseObserver, (VerificationMode)Mockito.timeout((int)this.operationTimeoutMillis())).onError((Throwable)captor.capture());
        Assert.assertEquals((Object)Status.UNKNOWN.getCode(), (Object)Status.fromThrowable((Throwable)((Throwable)captor.getValue())).getCode());
        Assert.assertEquals((Object)errorMessage, (Object)Status.fromThrowable((Throwable)((Throwable)captor.getValue())).getDescription());
        AbstractInteropTest.verifyNoMoreInteractions(responseObserver);
        if (this.metricsExpected()) {
            this.assertMetrics("grpc.testing.TestService/FullDuplexCall", Status.Code.UNKNOWN);
        }
    }

    @Test(timeout=10000L)
    public void unimplementedMethod() {
        try {
            this.blockingStub.unimplementedCall(EmptyProtos.Empty.getDefaultInstance());
            Assert.fail();
        }
        catch (StatusRuntimeException e) {
            Assert.assertEquals((Object)Status.UNIMPLEMENTED.getCode(), (Object)e.getStatus().getCode());
        }
        if (this.metricsExpected()) {
            this.assertClientMetrics("grpc.testing.TestService/UnimplementedCall", Status.Code.UNIMPLEMENTED);
        }
    }

    @Test(timeout=10000L)
    public void unimplementedService() {
        UnimplementedServiceGrpc.UnimplementedServiceBlockingStub stub = (UnimplementedServiceGrpc.UnimplementedServiceBlockingStub)UnimplementedServiceGrpc.newBlockingStub((Channel)this.channel).withInterceptors(new ClientInterceptor[]{this.tracerSetupInterceptor});
        try {
            stub.unimplementedCall(EmptyProtos.Empty.getDefaultInstance());
            Assert.fail();
        }
        catch (StatusRuntimeException e) {
            Assert.assertEquals((Object)Status.UNIMPLEMENTED.getCode(), (Object)e.getStatus().getCode());
        }
        if (this.metricsExpected()) {
            this.assertMetrics("grpc.testing.UnimplementedService/UnimplementedCall", Status.Code.UNIMPLEMENTED);
        }
    }

    @Test(timeout=10000L)
    public void timeoutOnSleepingServer() throws Exception {
        TestServiceGrpc.TestServiceStub stub = (TestServiceGrpc.TestServiceStub)this.asyncStub.withDeadlineAfter(1L, TimeUnit.MILLISECONDS);
        StreamRecorder responseObserver = StreamRecorder.create();
        StreamObserver<Messages.StreamingOutputCallRequest> requestObserver = stub.fullDuplexCall((StreamObserver<Messages.StreamingOutputCallResponse>)responseObserver);
        Messages.StreamingOutputCallRequest request = Messages.StreamingOutputCallRequest.newBuilder().setPayload(Messages.Payload.newBuilder().setBody(ByteString.copyFrom((byte[])new byte[27182]))).build();
        try {
            requestObserver.onNext((Object)request);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        responseObserver.awaitCompletion(this.operationTimeoutMillis(), TimeUnit.MILLISECONDS);
        Assert.assertEquals((long)0L, (long)responseObserver.getValues().size());
        Assert.assertEquals((Object)Status.DEADLINE_EXCEEDED.getCode(), (Object)Status.fromThrowable((Throwable)responseObserver.getError()).getCode());
        if (this.metricsExpected()) {
            StatsTestUtils.MetricsRecord clientRecord = clientStatsCtxFactory.pollRecord(5L, TimeUnit.SECONDS);
            AbstractInteropTest.checkTags(clientRecord, false, "grpc.testing.TestService/FullDuplexCall", Status.DEADLINE_EXCEEDED.getCode());
        }
    }

    public void serviceAccountCreds(String jsonKey, InputStream credentialsStream, String authScope) throws Exception {
        GoogleCredentials credentials = (GoogleCredentials)ServiceAccountCredentials.class.cast(GoogleCredentials.fromStream((InputStream)credentialsStream));
        credentials = credentials.createScoped(Arrays.asList(authScope));
        TestServiceGrpc.TestServiceBlockingStub stub = (TestServiceGrpc.TestServiceBlockingStub)this.blockingStub.withCallCredentials(MoreCallCredentials.from((Credentials)credentials));
        Messages.SimpleRequest request = Messages.SimpleRequest.newBuilder().setFillUsername(true).setFillOauthScope(true).setResponseSize(314159).setResponseType(Messages.PayloadType.COMPRESSABLE).setPayload(Messages.Payload.newBuilder().setBody(ByteString.copyFrom((byte[])new byte[271828]))).build();
        Messages.SimpleResponse response = stub.unaryCall(request);
        Assert.assertFalse((boolean)response.getUsername().isEmpty());
        Assert.assertTrue((String)("Received username: " + response.getUsername()), (boolean)jsonKey.contains(response.getUsername()));
        Assert.assertFalse((boolean)response.getOauthScope().isEmpty());
        Assert.assertTrue((String)("Received oauth scope: " + response.getOauthScope()), (boolean)authScope.contains(response.getOauthScope()));
        Messages.SimpleResponse goldenResponse = Messages.SimpleResponse.newBuilder().setOauthScope(response.getOauthScope()).setUsername(response.getUsername()).setPayload(Messages.Payload.newBuilder().setType(Messages.PayloadType.COMPRESSABLE).setBody(ByteString.copyFrom((byte[])new byte[314159]))).build();
        Assert.assertEquals((Object)goldenResponse, (Object)response);
    }

    public void computeEngineCreds(String serviceAccount, String oauthScope) throws Exception {
        ComputeEngineCredentials credentials = new ComputeEngineCredentials();
        TestServiceGrpc.TestServiceBlockingStub stub = (TestServiceGrpc.TestServiceBlockingStub)this.blockingStub.withCallCredentials(MoreCallCredentials.from((Credentials)credentials));
        Messages.SimpleRequest request = Messages.SimpleRequest.newBuilder().setFillUsername(true).setFillOauthScope(true).setResponseSize(314159).setResponseType(Messages.PayloadType.COMPRESSABLE).setPayload(Messages.Payload.newBuilder().setBody(ByteString.copyFrom((byte[])new byte[271828]))).build();
        Messages.SimpleResponse response = stub.unaryCall(request);
        Assert.assertEquals((Object)serviceAccount, (Object)response.getUsername());
        Assert.assertFalse((boolean)response.getOauthScope().isEmpty());
        Assert.assertTrue((String)("Received oauth scope: " + response.getOauthScope()), (boolean)oauthScope.contains(response.getOauthScope()));
        Messages.SimpleResponse goldenResponse = Messages.SimpleResponse.newBuilder().setOauthScope(response.getOauthScope()).setUsername(response.getUsername()).setPayload(Messages.Payload.newBuilder().setType(Messages.PayloadType.COMPRESSABLE).setBody(ByteString.copyFrom((byte[])new byte[314159]))).build();
        Assert.assertEquals((Object)goldenResponse, (Object)response);
    }

    public void jwtTokenCreds(InputStream serviceAccountJson) throws Exception {
        Messages.SimpleRequest request = Messages.SimpleRequest.newBuilder().setResponseType(Messages.PayloadType.COMPRESSABLE).setResponseSize(314159).setPayload(Messages.Payload.newBuilder().setBody(ByteString.copyFrom((byte[])new byte[271828]))).setFillUsername(true).build();
        ServiceAccountCredentials credentials = (ServiceAccountCredentials)GoogleCredentials.fromStream((InputStream)serviceAccountJson);
        TestServiceGrpc.TestServiceBlockingStub stub = (TestServiceGrpc.TestServiceBlockingStub)this.blockingStub.withCallCredentials(MoreCallCredentials.from((Credentials)credentials));
        Messages.SimpleResponse response = stub.unaryCall(request);
        Assert.assertEquals((Object)credentials.getClientEmail(), (Object)response.getUsername());
        Assert.assertEquals((long)314159L, (long)response.getPayload().getBody().size());
    }

    public void oauth2AuthToken(String jsonKey, InputStream credentialsStream, String authScope) throws Exception {
        GoogleCredentials utilCredentials = GoogleCredentials.fromStream((InputStream)credentialsStream);
        utilCredentials = utilCredentials.createScoped(Arrays.asList(authScope));
        AccessToken accessToken = utilCredentials.refreshAccessToken();
        OAuth2Credentials credentials = new OAuth2Credentials(accessToken){
            private static final long serialVersionUID = 0L;

            public AccessToken refreshAccessToken() throws IOException {
                throw new IOException("This credential is based on a certain AccessToken, so you can not refresh AccessToken");
            }
        };
        TestServiceGrpc.TestServiceBlockingStub stub = (TestServiceGrpc.TestServiceBlockingStub)this.blockingStub.withCallCredentials(MoreCallCredentials.from((Credentials)credentials));
        Messages.SimpleRequest request = Messages.SimpleRequest.newBuilder().setFillUsername(true).setFillOauthScope(true).build();
        Messages.SimpleResponse response = stub.unaryCall(request);
        Assert.assertFalse((boolean)response.getUsername().isEmpty());
        Assert.assertTrue((String)("Received username: " + response.getUsername()), (boolean)jsonKey.contains(response.getUsername()));
        Assert.assertFalse((boolean)response.getOauthScope().isEmpty());
        Assert.assertTrue((String)("Received oauth scope: " + response.getOauthScope()), (boolean)authScope.contains(response.getOauthScope()));
    }

    public void perRpcCreds(String jsonKey, InputStream credentialsStream, String oauthScope) throws Exception {
        this.oauth2AuthToken(jsonKey, credentialsStream, oauthScope);
    }

    protected static void assertSuccess(StreamRecorder<?> recorder) {
        if (recorder.getError() != null) {
            throw new AssertionError((Object)recorder.getError());
        }
    }

    protected void assertRemoteAddr(String expectedRemoteAddress) {
        TestServiceGrpc.TestServiceBlockingStub stub = (TestServiceGrpc.TestServiceBlockingStub)this.blockingStub.withDeadlineAfter(5L, TimeUnit.SECONDS);
        stub.unaryCall(Messages.SimpleRequest.getDefaultInstance());
        String inetSocketString = ((SocketAddress)serverCallCapture.get().getAttributes().get(Grpc.TRANSPORT_ATTR_REMOTE_ADDR)).toString();
        String host = inetSocketString.substring(0, inetSocketString.lastIndexOf(58));
        Assert.assertEquals((Object)expectedRemoteAddress, (Object)host);
    }

    protected void assertX500SubjectDn(String tlsInfo) {
        TestServiceGrpc.TestServiceBlockingStub stub = (TestServiceGrpc.TestServiceBlockingStub)this.blockingStub.withDeadlineAfter(5L, TimeUnit.SECONDS);
        stub.unaryCall(Messages.SimpleRequest.getDefaultInstance());
        List<Object> certificates = Lists.newArrayList();
        SSLSession sslSession = (SSLSession)serverCallCapture.get().getAttributes().get(Grpc.TRANSPORT_ATTR_SSL_SESSION);
        try {
            certificates = Arrays.asList(sslSession.getPeerCertificates());
        }
        catch (SSLPeerUnverifiedException e) {
            Assert.fail((String)"No cert");
        }
        X509Certificate x509cert = (X509Certificate)certificates.get(0);
        Assert.assertEquals((long)1L, (long)certificates.size());
        Assert.assertEquals((Object)tlsInfo, (Object)x509cert.getSubjectDN().toString());
    }

    protected int operationTimeoutMillis() {
        return 5000;
    }

    private static void assumeEnoughMemory() {
        Runtime r = Runtime.getRuntime();
        long usedMem = r.totalMemory() - r.freeMemory();
        long actuallyFreeMemory = r.maxMemory() - usedMem;
        Assume.assumeTrue((String)(actuallyFreeMemory + " is not sufficient to run this test"), (actuallyFreeMemory >= 0x4000000L ? 1 : 0) != 0);
    }

    private static <T> T verify(T mock, VerificationMode mode) {
        try {
            return (T)Mockito.verify(mock, (VerificationMode)mode);
        }
        catch (AssertionError e) {
            String msg = ((Throwable)((Object)e)).getMessage();
            if (msg.length() >= 256) {
                throw new AssertionError(msg.substring(0, 256), (Throwable)((Object)e));
            }
            throw e;
        }
    }

    private static <T> T verify(T mock) {
        return AbstractInteropTest.verify(mock, Mockito.times((int)1));
    }

    private static void verifyNoMoreInteractions(Object ... mocks) {
        try {
            Mockito.verifyNoMoreInteractions((Object[])mocks);
        }
        catch (AssertionError e) {
            String msg = ((Throwable)((Object)e)).getMessage();
            if (msg.length() >= 256) {
                throw new AssertionError(msg.substring(0, 256), (Throwable)((Object)e));
            }
            throw e;
        }
    }

    private void assertMetrics(String method, Status.Code status, Collection<? extends MessageLite> requests, Collection<? extends MessageLite> responses) {
        this.assertClientMetrics(method, status, requests, responses);
        this.assertServerMetrics(method, status, requests, responses);
    }

    private void assertMetrics(String method, Status.Code status) {
        this.assertMetrics(method, status, null, null);
    }

    private void assertClientMetrics(String method, Status.Code code, Collection<? extends MessageLite> requests, Collection<? extends MessageLite> responses) {
        TestClientStreamTracer tracer = this.clientStreamTracers.poll();
        Assert.assertNotNull((Object)tracer);
        Assert.assertTrue((boolean)tracer.getOutboundHeaders());
        ArgumentCaptor statusCaptor = ArgumentCaptor.forClass(Status.class);
        try {
            Assert.assertTrue((boolean)tracer.await(5L, TimeUnit.SECONDS));
        }
        catch (InterruptedException e) {
            throw new AssertionError((Object)e);
        }
        Assert.assertEquals((Object)code, (Object)tracer.getStatus().getCode());
        StatsTestUtils.MetricsRecord clientRecord = clientStatsCtxFactory.pollRecord();
        AbstractInteropTest.checkTags(clientRecord, false, method, code);
        if (requests != null && responses != null) {
            AbstractInteropTest.checkTracerMetrics((TestStreamTracer)tracer, requests, responses);
            AbstractInteropTest.checkCensusMetrics(clientRecord, false, requests, responses);
        }
    }

    private void assertClientMetrics(String method, Status.Code status) {
        this.assertClientMetrics(method, status, null, null);
    }

    private void assertServerMetrics(String method, Status.Code code, Collection<? extends MessageLite> requests, Collection<? extends MessageLite> responses) {
        ServerStreamTracerInfo tracerInfo;
        AssertionError checkFailure = null;
        boolean passed = false;
        while (true) {
            StatsTestUtils.MetricsRecord serverRecord;
            try {
                serverRecord = serverStatsCtxFactory.pollRecord(5L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            if (serverRecord == null) break;
            try {
                AbstractInteropTest.checkTags(serverRecord, true, method, code);
                if (requests != null && responses != null) {
                    AbstractInteropTest.checkCensusMetrics(serverRecord, true, requests, responses);
                }
                passed = true;
            }
            catch (AssertionError e) {
                checkFailure = e;
                continue;
            }
            break;
        }
        if (!passed) {
            if (checkFailure == null) {
                throw new AssertionError((Object)"No record found");
            }
            throw checkFailure;
        }
        passed = false;
        while ((tracerInfo = serverStreamTracers.poll()) != null) {
            try {
                Assert.assertEquals((Object)method, (Object)tracerInfo.fullMethodName);
                Assert.assertNotNull((Object)tracerInfo.tracer.contextCapture);
                ArgumentCaptor statusCaptor = ArgumentCaptor.forClass(Status.class);
                try {
                    Assert.assertTrue((boolean)tracerInfo.tracer.await(1L, TimeUnit.SECONDS));
                }
                catch (InterruptedException e) {
                    throw new AssertionError((Object)e);
                }
                Assert.assertEquals((Object)code, (Object)tracerInfo.tracer.getStatus().getCode());
                if (requests != null && responses != null) {
                    AbstractInteropTest.checkTracerMetrics((TestStreamTracer)tracerInfo.tracer, responses, requests);
                }
                passed = true;
                break;
            }
            catch (AssertionError e) {
                checkFailure = e;
            }
        }
        if (!passed) {
            if (checkFailure == null) {
                throw new AssertionError((Object)"No ServerStreamTracer found");
            }
            throw checkFailure;
        }
    }

    private static void checkTags(StatsTestUtils.MetricsRecord record, boolean server, String methodName, Status.Code status) {
        Assert.assertNotNull((String)"record is not null", (Object)record);
        TagValue methodNameTag = (TagValue)record.tags.get((Object)(server ? RpcConstants.RPC_SERVER_METHOD : RpcConstants.RPC_CLIENT_METHOD));
        Assert.assertNotNull((String)"method name tagged", (Object)methodNameTag);
        Assert.assertEquals((String)"method names match", (Object)methodName, (Object)methodNameTag.toString());
        TagValue statusTag = (TagValue)record.tags.get((Object)RpcConstants.RPC_STATUS);
        Assert.assertNotNull((String)"status tagged", (Object)statusTag);
        Assert.assertEquals((Object)status.toString(), (Object)statusTag.toString());
    }

    private static void checkTracerMetrics(TestStreamTracer tracer, Collection<? extends MessageLite> sentMessages, Collection<? extends MessageLite> receivedMessages) {
        Assert.assertEquals((long)sentMessages.size(), (long)tracer.getOutboundMessageCount());
        Assert.assertEquals((long)receivedMessages.size(), (long)tracer.getInboundMessageCount());
        long uncompressedSentSize = 0L;
        for (MessageLite messageLite : sentMessages) {
            uncompressedSentSize += (long)messageLite.getSerializedSize();
        }
        long uncompressedReceivedSize = 0L;
        for (MessageLite messageLite : receivedMessages) {
            uncompressedReceivedSize += (long)messageLite.getSerializedSize();
        }
        Assert.assertEquals((long)uncompressedSentSize, (long)tracer.getOutboundUncompressedSize());
        Assert.assertEquals((long)uncompressedReceivedSize, (long)tracer.getInboundUncompressedSize());
    }

    private static void checkCensusMetrics(StatsTestUtils.MetricsRecord record, boolean server, Collection<? extends MessageLite> requests, Collection<? extends MessageLite> responses) {
        int uncompressedRequestsSize = 0;
        for (MessageLite messageLite : requests) {
            uncompressedRequestsSize += messageLite.getSerializedSize();
        }
        int uncompressedResponsesSize = 0;
        for (MessageLite messageLite : responses) {
            uncompressedResponsesSize += messageLite.getSerializedSize();
        }
        if (server) {
            Assert.assertEquals((long)requests.size(), (long)record.getMetricAsLongOrFail(RpcConstants.RPC_SERVER_REQUEST_COUNT));
            Assert.assertEquals((long)responses.size(), (long)record.getMetricAsLongOrFail(RpcConstants.RPC_SERVER_RESPONSE_COUNT));
            Assert.assertEquals((long)uncompressedRequestsSize, (long)record.getMetricAsLongOrFail(RpcConstants.RPC_SERVER_UNCOMPRESSED_REQUEST_BYTES));
            Assert.assertEquals((long)uncompressedResponsesSize, (long)record.getMetricAsLongOrFail(RpcConstants.RPC_SERVER_UNCOMPRESSED_RESPONSE_BYTES));
            Assert.assertNotNull((Object)record.getMetric(RpcConstants.RPC_SERVER_SERVER_LATENCY));
            Assert.assertNotNull((Object)record.getMetric(RpcConstants.RPC_SERVER_REQUEST_BYTES));
            Assert.assertNotNull((Object)record.getMetric(RpcConstants.RPC_SERVER_RESPONSE_BYTES));
        } else {
            Assert.assertEquals((long)requests.size(), (long)record.getMetricAsLongOrFail(RpcConstants.RPC_CLIENT_REQUEST_COUNT));
            Assert.assertEquals((long)responses.size(), (long)record.getMetricAsLongOrFail(RpcConstants.RPC_CLIENT_RESPONSE_COUNT));
            Assert.assertEquals((long)uncompressedRequestsSize, (long)record.getMetricAsLongOrFail(RpcConstants.RPC_CLIENT_UNCOMPRESSED_REQUEST_BYTES));
            Assert.assertEquals((long)uncompressedResponsesSize, (long)record.getMetricAsLongOrFail(RpcConstants.RPC_CLIENT_UNCOMPRESSED_RESPONSE_BYTES));
            Assert.assertNotNull((Object)record.getMetric(RpcConstants.RPC_CLIENT_ROUNDTRIP_LATENCY));
            Assert.assertNotNull((Object)record.getMetric(RpcConstants.RPC_CLIENT_REQUEST_BYTES));
            Assert.assertNotNull((Object)record.getMetric(RpcConstants.RPC_CLIENT_RESPONSE_BYTES));
        }
    }

    static {
        clientStatsCtxFactory = new StatsTestUtils.FakeStatsContextFactory();
        serverStatsCtxFactory = new StatsTestUtils.FakeStatsContextFactory();
        serverStreamTracers = new LinkedBlockingQueue();
        serverStreamTracerFactory = new ServerStreamTracer.Factory(){

            public ServerStreamTracer newServerStreamTracer(String fullMethodName, Metadata headers) {
                ServerStreamTracerInfo.InteropServerStreamTracer tracer = new ServerStreamTracerInfo.InteropServerStreamTracer();
                serverStreamTracers.add(new ServerStreamTracerInfo(fullMethodName, tracer));
                return tracer;
            }
        };
        EMPTY = EmptyProtos.Empty.getDefaultInstance();
    }

    private static final class ServerStreamTracerInfo {
        final String fullMethodName;
        final InteropServerStreamTracer tracer;

        ServerStreamTracerInfo(String fullMethodName, InteropServerStreamTracer tracer) {
            this.fullMethodName = fullMethodName;
            this.tracer = tracer;
        }

        private static final class InteropServerStreamTracer
        extends TestServerStreamTracer {
            private volatile Context contextCapture;

            private InteropServerStreamTracer() {
            }

            public <ReqT, RespT> Context filterContext(Context context) {
                this.contextCapture = context;
                return super.filterContext(context);
            }
        }
    }
}

