/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.testing.integration;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.protobuf.EmptyProtos;
import com.google.protobuf.Message;
import io.grpc.BindableService;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.MethodDescriptor;
import io.grpc.ServerServiceDefinition;
import io.grpc.ServiceDescriptor;
import io.grpc.protobuf.ProtoUtils;
import io.grpc.stub.AbstractStub;
import io.grpc.stub.ClientCalls;
import io.grpc.stub.ServerCalls;
import io.grpc.stub.StreamObserver;

public class UnimplementedServiceGrpc {
    public static final String SERVICE_NAME = "grpc.testing.UnimplementedService";
    public static final MethodDescriptor<EmptyProtos.Empty, EmptyProtos.Empty> METHOD_UNIMPLEMENTED_CALL = MethodDescriptor.create((MethodDescriptor.MethodType)MethodDescriptor.MethodType.UNARY, (String)MethodDescriptor.generateFullMethodName((String)"grpc.testing.UnimplementedService", (String)"UnimplementedCall"), (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)EmptyProtos.Empty.getDefaultInstance()), (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)EmptyProtos.Empty.getDefaultInstance()));
    private static final int METHODID_UNIMPLEMENTED_CALL = 0;

    private UnimplementedServiceGrpc() {
    }

    public static UnimplementedServiceStub newStub(Channel channel) {
        return new UnimplementedServiceStub(channel);
    }

    public static UnimplementedServiceBlockingStub newBlockingStub(Channel channel) {
        return new UnimplementedServiceBlockingStub(channel);
    }

    public static UnimplementedServiceFutureStub newFutureStub(Channel channel) {
        return new UnimplementedServiceFutureStub(channel);
    }

    public static ServiceDescriptor getServiceDescriptor() {
        return new ServiceDescriptor(SERVICE_NAME, new MethodDescriptor[]{METHOD_UNIMPLEMENTED_CALL});
    }

    private static class MethodHandlers<Req, Resp>
    implements ServerCalls.UnaryMethod<Req, Resp>,
    ServerCalls.ServerStreamingMethod<Req, Resp>,
    ServerCalls.ClientStreamingMethod<Req, Resp>,
    ServerCalls.BidiStreamingMethod<Req, Resp> {
        private final UnimplementedServiceImplBase serviceImpl;
        private final int methodId;

        public MethodHandlers(UnimplementedServiceImplBase serviceImpl, int methodId) {
            this.serviceImpl = serviceImpl;
            this.methodId = methodId;
        }

        public void invoke(Req request, StreamObserver<Resp> responseObserver) {
            switch (this.methodId) {
                case 0: {
                    this.serviceImpl.unimplementedCall((EmptyProtos.Empty)request, responseObserver);
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }

        public StreamObserver<Req> invoke(StreamObserver<Resp> responseObserver) {
            switch (this.methodId) {
                default: 
            }
            throw new AssertionError();
        }
    }

    public static final class UnimplementedServiceFutureStub
    extends AbstractStub<UnimplementedServiceFutureStub> {
        private UnimplementedServiceFutureStub(Channel channel) {
            super(channel);
        }

        private UnimplementedServiceFutureStub(Channel channel, CallOptions callOptions) {
            super(channel, callOptions);
        }

        protected UnimplementedServiceFutureStub build(Channel channel, CallOptions callOptions) {
            return new UnimplementedServiceFutureStub(channel, callOptions);
        }

        public ListenableFuture<EmptyProtos.Empty> unimplementedCall(EmptyProtos.Empty request) {
            return ClientCalls.futureUnaryCall((ClientCall)this.getChannel().newCall(METHOD_UNIMPLEMENTED_CALL, this.getCallOptions()), (Object)request);
        }
    }

    public static final class UnimplementedServiceBlockingStub
    extends AbstractStub<UnimplementedServiceBlockingStub> {
        private UnimplementedServiceBlockingStub(Channel channel) {
            super(channel);
        }

        private UnimplementedServiceBlockingStub(Channel channel, CallOptions callOptions) {
            super(channel, callOptions);
        }

        protected UnimplementedServiceBlockingStub build(Channel channel, CallOptions callOptions) {
            return new UnimplementedServiceBlockingStub(channel, callOptions);
        }

        public EmptyProtos.Empty unimplementedCall(EmptyProtos.Empty request) {
            return (EmptyProtos.Empty)ClientCalls.blockingUnaryCall((Channel)this.getChannel(), METHOD_UNIMPLEMENTED_CALL, (CallOptions)this.getCallOptions(), (Object)request);
        }
    }

    public static final class UnimplementedServiceStub
    extends AbstractStub<UnimplementedServiceStub> {
        private UnimplementedServiceStub(Channel channel) {
            super(channel);
        }

        private UnimplementedServiceStub(Channel channel, CallOptions callOptions) {
            super(channel, callOptions);
        }

        protected UnimplementedServiceStub build(Channel channel, CallOptions callOptions) {
            return new UnimplementedServiceStub(channel, callOptions);
        }

        public void unimplementedCall(EmptyProtos.Empty request, StreamObserver<EmptyProtos.Empty> responseObserver) {
            ClientCalls.asyncUnaryCall((ClientCall)this.getChannel().newCall(METHOD_UNIMPLEMENTED_CALL, this.getCallOptions()), (Object)request, responseObserver);
        }
    }

    public static abstract class UnimplementedServiceImplBase
    implements BindableService {
        public void unimplementedCall(EmptyProtos.Empty request, StreamObserver<EmptyProtos.Empty> responseObserver) {
            ServerCalls.asyncUnimplementedUnaryCall(METHOD_UNIMPLEMENTED_CALL, responseObserver);
        }

        public ServerServiceDefinition bindService() {
            return ServerServiceDefinition.builder((ServiceDescriptor)UnimplementedServiceGrpc.getServiceDescriptor()).addMethod(METHOD_UNIMPLEMENTED_CALL, ServerCalls.asyncUnaryCall(new MethodHandlers(this, 0))).build();
        }
    }
}

