/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.testing.integration;

import com.google.protobuf.ByteString;
import com.google.protobuf.EmptyProtos;
import com.google.protobuf.Message;
import com.google.protobuf.MessageLite;
import io.grpc.AbstractServerBuilder;
import io.grpc.Call;
import io.grpc.Channel;
import io.grpc.ChannelImpl;
import io.grpc.Metadata;
import io.grpc.ServerImpl;
import io.grpc.ServerInterceptor;
import io.grpc.ServerInterceptors;
import io.grpc.ServerServiceDefinition;
import io.grpc.Status;
import io.grpc.protobuf.ProtoUtils;
import io.grpc.stub.AbstractStub;
import io.grpc.stub.MetadataUtils;
import io.grpc.stub.StreamObserver;
import io.grpc.stub.StreamRecorder;
import io.grpc.testing.TestUtils;
import io.grpc.testing.integration.Messages;
import io.grpc.testing.integration.TestServiceGrpc;
import io.grpc.testing.integration.TestServiceImpl;
import io.grpc.testing.integration.Util;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public abstract class AbstractTransportTest {
    public static final Metadata.Key<Messages.SimpleContext> METADATA_KEY = ProtoUtils.keyForProto((Message)Messages.SimpleContext.getDefaultInstance());
    private static ScheduledExecutorService testServiceExecutor;
    private static ServerImpl server;
    private static int OPERATION_TIMEOUT;
    protected ChannelImpl channel;
    protected TestServiceGrpc.TestServiceBlockingStub blockingStub;
    protected TestServiceGrpc.TestService asyncStub;

    protected static void startStaticServer(AbstractServerBuilder<?> builder) {
        testServiceExecutor = Executors.newScheduledThreadPool(2);
        builder.addService(ServerInterceptors.intercept((ServerServiceDefinition)TestServiceGrpc.bindService(new TestServiceImpl(testServiceExecutor)), (ServerInterceptor[])new ServerInterceptor[]{TestUtils.echoRequestHeadersInterceptor((Metadata.Key[])new Metadata.Key[]{Util.METADATA_KEY})}));
        try {
            server = builder.build().start();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    protected static void stopStaticServer() {
        server.shutdownNow();
        testServiceExecutor.shutdown();
    }

    @Before
    public void setUp() {
        this.channel = this.createChannel();
        this.blockingStub = TestServiceGrpc.newBlockingStub((Channel)this.channel);
        this.asyncStub = TestServiceGrpc.newStub((Channel)this.channel);
    }

    @After
    public void tearDown() throws Exception {
        if (this.channel != null) {
            this.channel.shutdown();
        }
    }

    protected abstract ChannelImpl createChannel();

    @Test(timeout=10000L)
    public void emptyUnary() throws Exception {
        Util.assertEquals((MessageLite)EmptyProtos.Empty.getDefaultInstance(), (MessageLite)this.blockingStub.emptyCall(EmptyProtos.Empty.getDefaultInstance()));
    }

    @Test(timeout=10000L)
    public void largeUnary() throws Exception {
        Messages.SimpleRequest request = Messages.SimpleRequest.newBuilder().setResponseSize(314159).setResponseType(Messages.PayloadType.COMPRESSABLE).setPayload(Messages.Payload.newBuilder().setBody(ByteString.copyFrom((byte[])new byte[271828]))).build();
        Messages.SimpleResponse goldenResponse = Messages.SimpleResponse.newBuilder().setPayload(Messages.Payload.newBuilder().setType(Messages.PayloadType.COMPRESSABLE).setBody(ByteString.copyFrom((byte[])new byte[314159]))).build();
        Util.assertEquals((MessageLite)goldenResponse, (MessageLite)this.blockingStub.unaryCall(request));
    }

    @Test(timeout=10000L)
    public void serverStreaming() throws Exception {
        Messages.StreamingOutputCallRequest request = Messages.StreamingOutputCallRequest.newBuilder().setResponseType(Messages.PayloadType.COMPRESSABLE).addResponseParameters(Messages.ResponseParameters.newBuilder().setSize(31415)).addResponseParameters(Messages.ResponseParameters.newBuilder().setSize(9)).addResponseParameters(Messages.ResponseParameters.newBuilder().setSize(2653)).addResponseParameters(Messages.ResponseParameters.newBuilder().setSize(58979)).build();
        List<Messages.StreamingOutputCallResponse> goldenResponses = Arrays.asList(Messages.StreamingOutputCallResponse.newBuilder().setPayload(Messages.Payload.newBuilder().setType(Messages.PayloadType.COMPRESSABLE).setBody(ByteString.copyFrom((byte[])new byte[31415]))).build(), Messages.StreamingOutputCallResponse.newBuilder().setPayload(Messages.Payload.newBuilder().setType(Messages.PayloadType.COMPRESSABLE).setBody(ByteString.copyFrom((byte[])new byte[9]))).build(), Messages.StreamingOutputCallResponse.newBuilder().setPayload(Messages.Payload.newBuilder().setType(Messages.PayloadType.COMPRESSABLE).setBody(ByteString.copyFrom((byte[])new byte[2653]))).build(), Messages.StreamingOutputCallResponse.newBuilder().setPayload(Messages.Payload.newBuilder().setType(Messages.PayloadType.COMPRESSABLE).setBody(ByteString.copyFrom((byte[])new byte[58979]))).build());
        StreamRecorder recorder = StreamRecorder.create();
        this.asyncStub.streamingOutputCall(request, (StreamObserver<Messages.StreamingOutputCallResponse>)recorder);
        recorder.awaitCompletion();
        AbstractTransportTest.assertSuccess(recorder);
        Util.assertEquals(goldenResponses, recorder.getValues());
    }

    @Test(timeout=10000L)
    public void clientStreaming() throws Exception {
        List<Messages.StreamingInputCallRequest> requests = Arrays.asList(Messages.StreamingInputCallRequest.newBuilder().setPayload(Messages.Payload.newBuilder().setBody(ByteString.copyFrom((byte[])new byte[27182]))).build(), Messages.StreamingInputCallRequest.newBuilder().setPayload(Messages.Payload.newBuilder().setBody(ByteString.copyFrom((byte[])new byte[8]))).build(), Messages.StreamingInputCallRequest.newBuilder().setPayload(Messages.Payload.newBuilder().setBody(ByteString.copyFrom((byte[])new byte[1828]))).build(), Messages.StreamingInputCallRequest.newBuilder().setPayload(Messages.Payload.newBuilder().setBody(ByteString.copyFrom((byte[])new byte[45904]))).build());
        Messages.StreamingInputCallResponse goldenResponse = Messages.StreamingInputCallResponse.newBuilder().setAggregatedPayloadSize(74922).build();
        StreamRecorder responseObserver = StreamRecorder.create();
        StreamObserver<Messages.StreamingInputCallRequest> requestObserver = this.asyncStub.streamingInputCall((StreamObserver<Messages.StreamingInputCallResponse>)responseObserver);
        for (Messages.StreamingInputCallRequest request : requests) {
            requestObserver.onValue((Object)request);
        }
        requestObserver.onCompleted();
        Util.assertEquals((MessageLite)goldenResponse, (MessageLite)responseObserver.firstValue().get());
    }

    @Test(timeout=10000L)
    public void pingPong() throws Exception {
        List<Messages.StreamingOutputCallRequest> requests = Arrays.asList(Messages.StreamingOutputCallRequest.newBuilder().addResponseParameters(Messages.ResponseParameters.newBuilder().setSize(31415)).setPayload(Messages.Payload.newBuilder().setBody(ByteString.copyFrom((byte[])new byte[27182]))).build(), Messages.StreamingOutputCallRequest.newBuilder().addResponseParameters(Messages.ResponseParameters.newBuilder().setSize(9)).setPayload(Messages.Payload.newBuilder().setBody(ByteString.copyFrom((byte[])new byte[8]))).build(), Messages.StreamingOutputCallRequest.newBuilder().addResponseParameters(Messages.ResponseParameters.newBuilder().setSize(2653)).setPayload(Messages.Payload.newBuilder().setBody(ByteString.copyFrom((byte[])new byte[1828]))).build(), Messages.StreamingOutputCallRequest.newBuilder().addResponseParameters(Messages.ResponseParameters.newBuilder().setSize(58979)).setPayload(Messages.Payload.newBuilder().setBody(ByteString.copyFrom((byte[])new byte[45904]))).build());
        List<Messages.StreamingOutputCallResponse> goldenResponses = Arrays.asList(Messages.StreamingOutputCallResponse.newBuilder().setPayload(Messages.Payload.newBuilder().setType(Messages.PayloadType.COMPRESSABLE).setBody(ByteString.copyFrom((byte[])new byte[31415]))).build(), Messages.StreamingOutputCallResponse.newBuilder().setPayload(Messages.Payload.newBuilder().setType(Messages.PayloadType.COMPRESSABLE).setBody(ByteString.copyFrom((byte[])new byte[9]))).build(), Messages.StreamingOutputCallResponse.newBuilder().setPayload(Messages.Payload.newBuilder().setType(Messages.PayloadType.COMPRESSABLE).setBody(ByteString.copyFrom((byte[])new byte[2653]))).build(), Messages.StreamingOutputCallResponse.newBuilder().setPayload(Messages.Payload.newBuilder().setType(Messages.PayloadType.COMPRESSABLE).setBody(ByteString.copyFrom((byte[])new byte[58979]))).build());
        StreamObserver responseObserver = (StreamObserver)Mockito.mock(StreamObserver.class);
        StreamObserver<Messages.StreamingOutputCallRequest> requestObserver = this.asyncStub.fullDuplexCall((StreamObserver<Messages.StreamingOutputCallResponse>)responseObserver);
        for (int i = 0; i < requests.size(); ++i) {
            requestObserver.onValue((Object)requests.get(i));
            ((StreamObserver)Mockito.verify((Object)responseObserver, (VerificationMode)Mockito.timeout((long)OPERATION_TIMEOUT))).onValue((Object)goldenResponses.get(i));
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{responseObserver});
        }
        requestObserver.onCompleted();
        ((StreamObserver)Mockito.verify((Object)responseObserver, (VerificationMode)Mockito.timeout((long)OPERATION_TIMEOUT))).onCompleted();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{responseObserver});
    }

    @Test(timeout=10000L)
    public void emptyStream() throws Exception {
        StreamObserver responseObserver = (StreamObserver)Mockito.mock(StreamObserver.class);
        StreamObserver<Messages.StreamingOutputCallRequest> requestObserver = this.asyncStub.fullDuplexCall((StreamObserver<Messages.StreamingOutputCallResponse>)responseObserver);
        requestObserver.onCompleted();
        ((StreamObserver)Mockito.verify((Object)responseObserver, (VerificationMode)Mockito.timeout((long)OPERATION_TIMEOUT))).onCompleted();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{responseObserver});
    }

    @Test(timeout=10000L)
    public void cancelAfterBegin() throws Exception {
        StreamRecorder responseObserver = StreamRecorder.create();
        StreamObserver<Messages.StreamingInputCallRequest> requestObserver = this.asyncStub.streamingInputCall((StreamObserver<Messages.StreamingInputCallResponse>)responseObserver);
        requestObserver.onError((Throwable)new RuntimeException());
        responseObserver.awaitCompletion();
        Util.assertEquals(Arrays.asList(new Messages.StreamingInputCallResponse[0]), responseObserver.getValues());
        Assert.assertEquals((Object)Status.CANCELLED, (Object)Status.fromThrowable((Throwable)responseObserver.getError()));
    }

    @Test(timeout=10000L)
    public void cancelAfterFirstResponse() throws Exception {
        Messages.StreamingOutputCallRequest request = Messages.StreamingOutputCallRequest.newBuilder().addResponseParameters(Messages.ResponseParameters.newBuilder().setSize(31415)).setPayload(Messages.Payload.newBuilder().setBody(ByteString.copyFrom((byte[])new byte[27182]))).build();
        Messages.StreamingOutputCallResponse goldenResponse = Messages.StreamingOutputCallResponse.newBuilder().setPayload(Messages.Payload.newBuilder().setType(Messages.PayloadType.COMPRESSABLE).setBody(ByteString.copyFrom((byte[])new byte[31415]))).build();
        StreamObserver responseObserver = (StreamObserver)Mockito.mock(StreamObserver.class);
        StreamObserver<Messages.StreamingOutputCallRequest> requestObserver = this.asyncStub.fullDuplexCall((StreamObserver<Messages.StreamingOutputCallResponse>)responseObserver);
        requestObserver.onValue((Object)request);
        ((StreamObserver)Mockito.verify((Object)responseObserver, (VerificationMode)Mockito.timeout((long)OPERATION_TIMEOUT))).onValue((Object)goldenResponse);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{responseObserver});
        requestObserver.onError((Throwable)new RuntimeException());
        ArgumentCaptor captor = ArgumentCaptor.forClass(Throwable.class);
        ((StreamObserver)Mockito.verify((Object)responseObserver, (VerificationMode)Mockito.timeout((long)OPERATION_TIMEOUT))).onError((Throwable)captor.capture());
        Assert.assertEquals((Object)Status.CANCELLED, (Object)Status.fromThrowable((Throwable)((Throwable)captor.getValue())));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{responseObserver});
    }

    @Test(timeout=10000L)
    public void fullDuplexCallShouldSucceed() throws Exception {
        int ix;
        List<Integer> responseSizes = Arrays.asList(50, 100, 150, 200);
        Messages.StreamingOutputCallRequest.Builder streamingOutputBuilder = Messages.StreamingOutputCallRequest.newBuilder();
        streamingOutputBuilder.setResponseType(Messages.PayloadType.COMPRESSABLE);
        for (Integer size : responseSizes) {
            streamingOutputBuilder.addResponseParametersBuilder().setSize(size).setIntervalUs(0);
        }
        Messages.StreamingOutputCallRequest request = streamingOutputBuilder.build();
        StreamRecorder recorder = StreamRecorder.create();
        StreamObserver<Messages.StreamingOutputCallRequest> requestStream = this.asyncStub.fullDuplexCall((StreamObserver<Messages.StreamingOutputCallResponse>)recorder);
        int numRequests = 10;
        for (ix = 10; ix > 0; --ix) {
            requestStream.onValue((Object)request);
        }
        requestStream.onCompleted();
        recorder.awaitCompletion();
        AbstractTransportTest.assertSuccess(recorder);
        Assert.assertEquals((long)(responseSizes.size() * 10), (long)recorder.getValues().size());
        for (ix = 0; ix < recorder.getValues().size(); ++ix) {
            Messages.StreamingOutputCallResponse response = (Messages.StreamingOutputCallResponse)recorder.getValues().get(ix);
            Assert.assertEquals((Object)((Object)Messages.PayloadType.COMPRESSABLE), (Object)((Object)response.getPayload().getType()));
            int length = response.getPayload().getBody().size();
            int expectedSize = responseSizes.get(ix % responseSizes.size());
            Assert.assertEquals((String)("comparison failed at index " + ix), (long)expectedSize, (long)length);
        }
    }

    @Test(timeout=10000L)
    public void halfDuplexCallShouldSucceed() throws Exception {
        int ix;
        List<Integer> responseSizes = Arrays.asList(50, 100, 150, 200);
        Messages.StreamingOutputCallRequest.Builder streamingOutputBuilder = Messages.StreamingOutputCallRequest.newBuilder();
        streamingOutputBuilder.setResponseType(Messages.PayloadType.COMPRESSABLE);
        for (Integer size : responseSizes) {
            streamingOutputBuilder.addResponseParametersBuilder().setSize(size).setIntervalUs(0);
        }
        Messages.StreamingOutputCallRequest request = streamingOutputBuilder.build();
        StreamRecorder recorder = StreamRecorder.create();
        StreamObserver<Messages.StreamingOutputCallRequest> requestStream = this.asyncStub.halfDuplexCall((StreamObserver<Messages.StreamingOutputCallResponse>)recorder);
        int numRequests = 10;
        for (ix = 10; ix > 0; --ix) {
            requestStream.onValue((Object)request);
        }
        requestStream.onCompleted();
        recorder.awaitCompletion();
        AbstractTransportTest.assertSuccess(recorder);
        Assert.assertEquals((long)(responseSizes.size() * 10), (long)recorder.getValues().size());
        for (ix = 0; ix < recorder.getValues().size(); ++ix) {
            Messages.StreamingOutputCallResponse response = (Messages.StreamingOutputCallResponse)recorder.getValues().get(ix);
            Assert.assertEquals((Object)((Object)Messages.PayloadType.COMPRESSABLE), (Object)((Object)response.getPayload().getType()));
            int length = response.getPayload().getBody().size();
            int expectedSize = responseSizes.get(ix % responseSizes.size());
            Assert.assertEquals((String)("comparison failed at index " + ix), (long)expectedSize, (long)length);
        }
    }

    @Test(timeout=10000L)
    public void serverStreamingShouldBeFlowControlled() throws Exception {
        Messages.StreamingOutputCallRequest request = Messages.StreamingOutputCallRequest.newBuilder().setResponseType(Messages.PayloadType.COMPRESSABLE).addResponseParameters(Messages.ResponseParameters.newBuilder().setSize(100000)).addResponseParameters(Messages.ResponseParameters.newBuilder().setSize(100001)).build();
        List<Messages.StreamingOutputCallResponse> goldenResponses = Arrays.asList(Messages.StreamingOutputCallResponse.newBuilder().setPayload(Messages.Payload.newBuilder().setType(Messages.PayloadType.COMPRESSABLE).setBody(ByteString.copyFrom((byte[])new byte[100000]))).build(), Messages.StreamingOutputCallResponse.newBuilder().setPayload(Messages.Payload.newBuilder().setType(Messages.PayloadType.COMPRESSABLE).setBody(ByteString.copyFrom((byte[])new byte[100001]))).build());
        long start = System.nanoTime();
        final ArrayBlockingQueue queue = new ArrayBlockingQueue(10);
        Call call = this.channel.newCall(TestServiceGrpc.CONFIG.streamingOutputCall);
        call.start((Call.Listener)new Call.Listener<Messages.StreamingOutputCallResponse>(){

            public void onHeaders(Metadata.Headers headers) {
            }

            public void onPayload(Messages.StreamingOutputCallResponse payload) {
                queue.add(payload);
            }

            public void onClose(Status status, Metadata.Trailers trailers) {
                queue.add(status);
            }
        }, new Metadata.Headers());
        call.sendPayload((Object)request);
        call.halfClose();
        call.request(1);
        Assert.assertEquals((Object)goldenResponses.get(0), queue.poll(OPERATION_TIMEOUT, TimeUnit.MILLISECONDS));
        long firstCallDuration = System.nanoTime() - start;
        Assert.assertNull(queue.poll(Math.max(firstCallDuration * 4L, 1000000L), TimeUnit.NANOSECONDS));
        call.request(1);
        Assert.assertEquals((Object)goldenResponses.get(1), queue.poll(OPERATION_TIMEOUT, TimeUnit.MILLISECONDS));
        Assert.assertEquals((Object)Status.OK, queue.poll(OPERATION_TIMEOUT, TimeUnit.MILLISECONDS));
    }

    @Test(timeout=30000L)
    public void veryLargeRequest() throws Exception {
        Messages.SimpleRequest request = Messages.SimpleRequest.newBuilder().setPayload(Messages.Payload.newBuilder().setType(Messages.PayloadType.COMPRESSABLE).setBody(ByteString.copyFrom((byte[])new byte[this.unaryPayloadLength()]))).setResponseSize(10).setResponseType(Messages.PayloadType.COMPRESSABLE).build();
        Messages.SimpleResponse goldenResponse = Messages.SimpleResponse.newBuilder().setPayload(Messages.Payload.newBuilder().setType(Messages.PayloadType.COMPRESSABLE).setBody(ByteString.copyFrom((byte[])new byte[10]))).build();
        Util.assertEquals((MessageLite)goldenResponse, (MessageLite)this.blockingStub.unaryCall(request));
    }

    @Test(timeout=30000L)
    public void veryLargeResponse() throws Exception {
        Messages.SimpleRequest request = Messages.SimpleRequest.newBuilder().setResponseSize(this.unaryPayloadLength()).setResponseType(Messages.PayloadType.COMPRESSABLE).build();
        Messages.SimpleResponse goldenResponse = Messages.SimpleResponse.newBuilder().setPayload(Messages.Payload.newBuilder().setType(Messages.PayloadType.COMPRESSABLE).setBody(ByteString.copyFrom((byte[])new byte[this.unaryPayloadLength()]))).build();
        Util.assertEquals((MessageLite)goldenResponse, (MessageLite)this.blockingStub.unaryCall(request));
    }

    @Test(timeout=10000L)
    public void exchangeContextUnaryCall() throws Exception {
        TestServiceGrpc.TestServiceBlockingStub stub = TestServiceGrpc.newBlockingStub((Channel)this.channel);
        Metadata.Headers fixedHeaders = new Metadata.Headers();
        Messages.SimpleContext contextValue = Messages.SimpleContext.newBuilder().setValue("dog").build();
        fixedHeaders.put(METADATA_KEY, (Object)contextValue);
        stub = (TestServiceGrpc.TestServiceBlockingStub)MetadataUtils.attachHeaders((AbstractStub)stub, (Metadata.Headers)fixedHeaders);
        AtomicReference trailersCapture = new AtomicReference();
        AtomicReference headersCapture = new AtomicReference();
        stub = (TestServiceGrpc.TestServiceBlockingStub)MetadataUtils.captureMetadata((AbstractStub)stub, headersCapture, trailersCapture);
        Assert.assertNotNull((Object)stub.emptyCall(EmptyProtos.Empty.getDefaultInstance()));
        Assert.assertEquals((Object)contextValue, (Object)((Metadata.Headers)headersCapture.get()).get(METADATA_KEY));
        Assert.assertEquals((Object)contextValue, (Object)((Metadata.Trailers)trailersCapture.get()).get(METADATA_KEY));
    }

    @Test(timeout=10000L)
    public void exchangeContextStreamingCall() throws Exception {
        TestServiceGrpc.TestServiceStub stub = TestServiceGrpc.newStub((Channel)this.channel);
        Metadata.Headers fixedHeaders = new Metadata.Headers();
        Messages.SimpleContext contextValue = Messages.SimpleContext.newBuilder().setValue("dog").build();
        fixedHeaders.put(METADATA_KEY, (Object)contextValue);
        stub = (TestServiceGrpc.TestServiceStub)MetadataUtils.attachHeaders((AbstractStub)stub, (Metadata.Headers)fixedHeaders);
        AtomicReference trailersCapture = new AtomicReference();
        AtomicReference headersCapture = new AtomicReference();
        stub = (TestServiceGrpc.TestServiceStub)MetadataUtils.captureMetadata((AbstractStub)stub, headersCapture, trailersCapture);
        List<Integer> responseSizes = Arrays.asList(50, 100, 150, 200);
        Messages.StreamingOutputCallRequest.Builder streamingOutputBuilder = Messages.StreamingOutputCallRequest.newBuilder();
        streamingOutputBuilder.setResponseType(Messages.PayloadType.COMPRESSABLE);
        for (Integer size : responseSizes) {
            streamingOutputBuilder.addResponseParametersBuilder().setSize(size).setIntervalUs(0);
        }
        Messages.StreamingOutputCallRequest request = streamingOutputBuilder.build();
        StreamRecorder recorder = StreamRecorder.create();
        StreamObserver<Messages.StreamingOutputCallRequest> requestStream = stub.fullDuplexCall((StreamObserver<Messages.StreamingOutputCallResponse>)recorder);
        int numRequests = 10;
        for (int ix = 10; ix > 0; --ix) {
            requestStream.onValue((Object)request);
        }
        requestStream.onCompleted();
        recorder.awaitCompletion();
        AbstractTransportTest.assertSuccess(recorder);
        Assert.assertEquals((long)(responseSizes.size() * 10), (long)recorder.getValues().size());
        Assert.assertEquals((Object)contextValue, (Object)((Metadata.Headers)headersCapture.get()).get(METADATA_KEY));
        Assert.assertEquals((Object)contextValue, (Object)((Metadata.Trailers)trailersCapture.get()).get(METADATA_KEY));
    }

    protected int unaryPayloadLength() {
        return 0xA00000;
    }

    @Test(timeout=10000L)
    public void gracefulShutdown() throws Exception {
        List<Messages.StreamingOutputCallRequest> requests = Arrays.asList(Messages.StreamingOutputCallRequest.newBuilder().addResponseParameters(Messages.ResponseParameters.newBuilder().setSize(3)).setPayload(Messages.Payload.newBuilder().setBody(ByteString.copyFrom((byte[])new byte[2]))).build(), Messages.StreamingOutputCallRequest.newBuilder().addResponseParameters(Messages.ResponseParameters.newBuilder().setSize(1)).setPayload(Messages.Payload.newBuilder().setBody(ByteString.copyFrom((byte[])new byte[7]))).build(), Messages.StreamingOutputCallRequest.newBuilder().addResponseParameters(Messages.ResponseParameters.newBuilder().setSize(4)).setPayload(Messages.Payload.newBuilder().setBody(ByteString.copyFrom((byte[])new byte[1]))).build());
        List<Messages.StreamingOutputCallResponse> goldenResponses = Arrays.asList(Messages.StreamingOutputCallResponse.newBuilder().setPayload(Messages.Payload.newBuilder().setType(Messages.PayloadType.COMPRESSABLE).setBody(ByteString.copyFrom((byte[])new byte[3]))).build(), Messages.StreamingOutputCallResponse.newBuilder().setPayload(Messages.Payload.newBuilder().setType(Messages.PayloadType.COMPRESSABLE).setBody(ByteString.copyFrom((byte[])new byte[1]))).build(), Messages.StreamingOutputCallResponse.newBuilder().setPayload(Messages.Payload.newBuilder().setType(Messages.PayloadType.COMPRESSABLE).setBody(ByteString.copyFrom((byte[])new byte[4]))).build());
        StreamObserver responseObserver = (StreamObserver)Mockito.mock(StreamObserver.class);
        StreamObserver<Messages.StreamingOutputCallRequest> requestObserver = this.asyncStub.fullDuplexCall((StreamObserver<Messages.StreamingOutputCallResponse>)responseObserver);
        requestObserver.onValue((Object)requests.get(0));
        ((StreamObserver)Mockito.verify((Object)responseObserver, (VerificationMode)Mockito.timeout((long)OPERATION_TIMEOUT))).onValue((Object)goldenResponses.get(0));
        this.channel.shutdown();
        requestObserver.onValue((Object)requests.get(1));
        ((StreamObserver)Mockito.verify((Object)responseObserver, (VerificationMode)Mockito.timeout((long)OPERATION_TIMEOUT))).onValue((Object)goldenResponses.get(1));
        requestObserver.onValue((Object)requests.get(2));
        ((StreamObserver)Mockito.verify((Object)responseObserver, (VerificationMode)Mockito.timeout((long)OPERATION_TIMEOUT))).onValue((Object)goldenResponses.get(2));
        requestObserver.onCompleted();
        ((StreamObserver)Mockito.verify((Object)responseObserver, (VerificationMode)Mockito.timeout((long)OPERATION_TIMEOUT))).onCompleted();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{responseObserver});
    }

    protected static void assertSuccess(StreamRecorder<?> recorder) {
        if (recorder.getError() != null) {
            throw new AssertionError((Object)recorder.getError());
        }
    }

    static {
        OPERATION_TIMEOUT = 5000;
    }
}

