/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.testing.integration;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.MoreExecutors;
import io.grpc.Metadata;
import io.grpc.Server;
import io.grpc.ServerInterceptor;
import io.grpc.ServerInterceptors;
import io.grpc.ServerServiceDefinition;
import io.grpc.netty.GrpcSslContexts;
import io.grpc.netty.NettyServerBuilder;
import io.grpc.testing.TestUtils;
import io.grpc.testing.integration.TestServiceGrpc;
import io.grpc.testing.integration.TestServiceImpl;
import io.grpc.testing.integration.Util;
import io.netty.handler.ssl.SslContext;
import java.io.File;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class TestServiceServer {
    private int port = 8080;
    private boolean useTls = true;
    private ScheduledExecutorService executor;
    private Server server;

    public static void main(String[] args) throws Exception {
        final TestServiceServer server = new TestServiceServer();
        server.parseArgs(args);
        if (server.useTls) {
            System.out.println("\nUsing fake CA for TLS certificate. Test clients should expect host\n*.test.google.fr and our test CA. For the Java test client binary, use:\n--server_host_override=foo.test.google.fr --use_test_ca=true\n");
        }
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                try {
                    System.out.println("Shutting down");
                    server.stop();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        server.start();
        System.out.println("Server started on port " + server.port);
        server.blockUntilShutdown();
    }

    @VisibleForTesting
    void parseArgs(String[] args) {
        boolean usage = false;
        for (String arg : args) {
            if (!arg.startsWith("--")) {
                System.err.println("All arguments must start with '--': " + arg);
                usage = true;
                break;
            }
            String[] parts = arg.substring(2).split("=", 2);
            String key = parts[0];
            if ("help".equals(key)) {
                usage = true;
                break;
            }
            if (parts.length != 2) {
                System.err.println("All arguments must be of the form --arg=value");
                usage = true;
                break;
            }
            String value = parts[1];
            if ("port".equals(key)) {
                this.port = Integer.parseInt(value);
                continue;
            }
            if ("use_tls".equals(key)) {
                this.useTls = Boolean.parseBoolean(value);
                continue;
            }
            if ("grpc_version".equals(key)) {
                if ("2".equals(value)) continue;
                System.err.println("Only grpc version 2 is supported");
                usage = true;
                break;
            }
            System.err.println("Unknown argument: " + key);
            usage = true;
            break;
        }
        if (usage) {
            TestServiceServer s = new TestServiceServer();
            System.out.println("Usage: [ARGS...]\n\n  --port=PORT           Port to connect to. Default " + s.port + "\n  --use_tls=true|false  Whether to use TLS. Default " + s.useTls);
            System.exit(1);
        }
    }

    @VisibleForTesting
    void start() throws Exception {
        this.executor = Executors.newSingleThreadScheduledExecutor();
        SslContext sslContext = null;
        if (this.useTls) {
            sslContext = GrpcSslContexts.forServer((File)TestUtils.loadCert((String)"server1.pem"), (File)TestUtils.loadCert((String)"server1.key")).build();
        }
        this.server = ((NettyServerBuilder)NettyServerBuilder.forPort((int)this.port).sslContext(sslContext).addService(ServerInterceptors.intercept((ServerServiceDefinition)TestServiceGrpc.bindService(new TestServiceImpl(this.executor)), (ServerInterceptor[])new ServerInterceptor[]{TestUtils.echoRequestHeadersInterceptor((Metadata.Key[])new Metadata.Key[]{Util.METADATA_KEY})}))).build().start();
    }

    @VisibleForTesting
    void stop() throws Exception {
        this.server.shutdownNow();
        if (!this.server.awaitTermination(5L, TimeUnit.SECONDS)) {
            System.err.println("Timed out waiting for server shutdown");
        }
        MoreExecutors.shutdownAndAwaitTermination((ExecutorService)this.executor, (long)5L, (TimeUnit)TimeUnit.SECONDS);
    }

    private void blockUntilShutdown() throws InterruptedException {
        if (this.server != null) {
            this.server.awaitTermination();
        }
    }
}

