/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.plugin.repository.internal;

import io.gravitee.platform.repository.api.RepositoryProvider;
import io.gravitee.platform.repository.api.RepositoryScopeProvider;
import io.gravitee.platform.repository.api.Scope;
import io.gravitee.plugin.core.api.AbstractPluginHandler;
import io.gravitee.plugin.core.api.Plugin;
import io.gravitee.plugin.core.api.PluginClassLoaderFactory;
import io.gravitee.plugin.core.api.PluginContextConfigurer;
import io.gravitee.plugin.core.api.PluginContextFactory;
import io.gravitee.plugin.core.internal.AnnotationBasedPluginContextConfigurer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.Environment;
import org.springframework.util.Assert;

public class RepositoryPluginHandler
extends AbstractPluginHandler
implements InitializingBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(RepositoryPluginHandler.class);
    public static final int RETRY_DELAY_MS = 5000;
    private static final String PLUGIN_TYPE = "repository";
    @Autowired
    private Environment environment;
    @Autowired
    private PluginContextFactory pluginContextFactory;
    @Autowired
    private PluginClassLoaderFactory<Plugin> pluginClassLoaderFactory;
    @Autowired
    private ApplicationContext applicationContext;
    private final Map<Scope, RepositoryProvider> repositories = new HashMap<Scope, RepositoryProvider>();

    public void afterPropertiesSet() {
        RepositoryScopeProvider scopeProvider = (RepositoryScopeProvider)this.applicationContext.getBean(RepositoryScopeProvider.class);
        for (Scope scope : scopeProvider.getHandledScopes()) {
            this.checkRepositoryConfig(scope, true);
        }
        for (Scope scope : scopeProvider.getOptionalHandledScopes()) {
            this.checkRepositoryConfig(scope, false);
        }
    }

    public boolean canHandle(Plugin plugin) {
        return PLUGIN_TYPE.equalsIgnoreCase(plugin.type());
    }

    protected String type() {
        return PLUGIN_TYPE;
    }

    protected ClassLoader getClassLoader(Plugin plugin) {
        return this.pluginClassLoaderFactory.getOrCreateClassLoader(plugin, ((Object)((Object)this)).getClass().getClassLoader());
    }

    protected void handle(Plugin plugin, Class<?> repositoryClass) {
        if (plugin.deployed()) {
            try {
                Scope[] scopes;
                LOGGER.info("Register a new repository: {} [{}]", (Object)plugin.id(), (Object)plugin.clazz());
                Assert.isAssignable(RepositoryProvider.class, repositoryClass);
                RepositoryProvider repository = (RepositoryProvider)this.createInstance(repositoryClass);
                for (Scope scope : scopes = repository.scopes()) {
                    if (!repository.type().equals(this.getRepositoryType(scope))) continue;
                    if (!this.repositories.containsKey(scope)) {
                        boolean loaded = false;
                        int tries = 0;
                        while (!loaded) {
                            if (tries > 0) {
                                Thread.sleep(5000L);
                            }
                            loaded = this.loadRepository(scope, repository, plugin);
                            ++tries;
                            if (loaded) continue;
                            LOGGER.error("Unable to load repository {} for scope {}. Retry in {} ms...", new Object[]{plugin.id(), scope, 5000});
                        }
                        continue;
                    }
                    LOGGER.warn("Repository scope {} already loaded by {}", (Object)scope, (Object)this.repositories.get(scope));
                }
            }
            catch (Exception iae) {
                LOGGER.error("Unexpected error while create repository instance", (Throwable)iae);
            }
        }
    }

    private boolean loadRepository(final Scope scope, final RepositoryProvider repository, Plugin plugin) {
        LOGGER.info("Repository [{}] loaded by {}", (Object)scope, (Object)repository.type());
        try {
            ApplicationContext repoApplicationContext = this.pluginContextFactory.create((PluginContextConfigurer)new AnnotationBasedPluginContextConfigurer(plugin){

                public Set<Class<?>> configurations() {
                    return Collections.singleton(repository.configuration(scope));
                }
            });
            this.registerRepositoryDefinitions(repository, repoApplicationContext);
            this.repositories.put(scope, repository);
            return true;
        }
        catch (Exception iae) {
            LOGGER.error("Unexpected error while creating context for repository instance", (Throwable)iae);
            this.pluginContextFactory.remove(plugin);
            return false;
        }
    }

    private void registerRepositoryDefinitions(RepositoryProvider repository, ApplicationContext repoApplicationContext) {
        String[] beanNames;
        DefaultListableBeanFactory beanFactory = (DefaultListableBeanFactory)((ConfigurableApplicationContext)this.applicationContext).getBeanFactory();
        for (String beanName : beanNames = repoApplicationContext.getBeanDefinitionNames()) {
            Object repositoryClassInstance = repoApplicationContext.getBean(beanName);
            Class<?> repositoryObjectClass = repositoryClassInstance.getClass();
            if (!beanName.endsWith("Repository") && (!beanName.endsWith("TransactionManager") || repository.getClass().equals(repositoryClassInstance.getClass())) || repositoryObjectClass.getInterfaces().length <= 0) continue;
            beanFactory.registerSingleton(beanName, repositoryClassInstance);
        }
    }

    private void checkRepositoryConfig(Scope scope, boolean failOnMissing) throws IllegalStateException {
        String repositoryType = this.getRepositoryType(scope);
        LOGGER.info("Loading repository for scope {}: {}", (Object)scope, (Object)repositoryType);
        if (repositoryType == null || repositoryType.isEmpty()) {
            if (failOnMissing) {
                LOGGER.error("No repository type defined in configuration for {}", (Object)scope.getName());
                throw new IllegalStateException("No repository type defined in configuration for " + scope.getName());
            }
            LOGGER.warn("No repository type defined in configuration for {}", (Object)scope.getName());
        }
    }

    private String getRepositoryType(Scope scope) {
        return this.environment.getProperty(scope.getName() + ".type");
    }

    private <T> T createInstance(Class<T> clazz) throws Exception {
        try {
            return clazz.newInstance();
        }
        catch (IllegalAccessException | InstantiationException ex) {
            LOGGER.error("Unable to instantiate class: {}", (Object)clazz.getName());
            throw ex;
        }
    }
}

