/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.plugin.policy.internal;

import com.google.common.base.Predicate;
import io.gravitee.plugin.core.api.AbstractSimplePluginHandler;
import io.gravitee.plugin.core.api.ConfigurablePluginManager;
import io.gravitee.plugin.core.api.Plugin;
import io.gravitee.plugin.policy.PolicyPlugin;
import io.gravitee.plugin.policy.internal.PolicyConfigurationClassFinder;
import io.gravitee.plugin.policy.internal.PolicyContextClassFinder;
import io.gravitee.plugin.policy.internal.PolicyPluginImpl;
import io.gravitee.policy.api.annotations.OnRequest;
import io.gravitee.policy.api.annotations.OnRequestContent;
import io.gravitee.policy.api.annotations.OnResponse;
import io.gravitee.policy.api.annotations.OnResponseContent;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.net.URLClassLoader;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.reflections.ReflectionUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class PolicyPluginHandler
extends AbstractSimplePluginHandler<PolicyPlugin> {
    @Autowired
    private ConfigurablePluginManager<PolicyPlugin> policyPluginManager;
    private static final Class<? extends Annotation>[] REQUEST_ANNOTATIONS = new Class[]{OnRequest.class, OnRequestContent.class};
    private static final Class<? extends Annotation>[] RESPONSE_ANNOTATIONS = new Class[]{OnResponse.class, OnResponseContent.class};

    public boolean canHandle(Plugin plugin) {
        return "policy".equalsIgnoreCase(plugin.type());
    }

    protected String type() {
        return "policies";
    }

    protected PolicyPlugin create(Plugin plugin, Class<?> pluginClass) {
        PolicyPluginImpl policyPlugin = new PolicyPluginImpl(plugin, pluginClass);
        policyPlugin.setConfiguration(new PolicyConfigurationClassFinder().lookupFirst(pluginClass));
        policyPlugin.setContext(new PolicyContextClassFinder().lookupFirst(pluginClass, policyPlugin.policy().getClassLoader()));
        this.determineProxyPhases(pluginClass, policyPlugin);
        return policyPlugin;
    }

    private void determineProxyPhases(Class policyClass, PolicyPluginImpl entity) {
        if (!entity.manifest().properties().containsKey("proxy") && !entity.manifest().properties().containsKey("message")) {
            try {
                HashSet<String> proxyPhases = new HashSet<String>();
                if (this.methodFoundFor(REQUEST_ANNOTATIONS, policyClass)) {
                    proxyPhases.add("REQUEST");
                }
                if (this.methodFoundFor(RESPONSE_ANNOTATIONS, policyClass)) {
                    proxyPhases.add("RESPONSE");
                }
                entity.manifest().properties().put("proxy", proxyPhases.stream().collect(Collectors.joining(",")));
            }
            catch (NoClassDefFoundError e) {
                this.logger.debug("Unable to autodetect the execution phases for the plugin {}.", (Object)entity.id(), (Object)e);
            }
        }
    }

    private boolean methodFoundFor(Class<? extends Annotation>[] annotations, Class policyClass) {
        for (Class<? extends Annotation> annot : annotations) {
            Set resolved = ReflectionUtils.getAllMethods((Class)policyClass, (Predicate[])new Predicate[]{ReflectionUtils.withModifier((int)1), ReflectionUtils.withAnnotation(annot)});
            if (resolved.isEmpty()) continue;
            return true;
        }
        return false;
    }

    protected void register(PolicyPlugin policyPlugin) {
        this.policyPluginManager.register((Plugin)policyPlugin);
        ClassLoader policyClassLoader = policyPlugin.policy().getClassLoader();
        if (policyClassLoader instanceof URLClassLoader) {
            URLClassLoader classLoader = (URLClassLoader)policyClassLoader;
            try {
                classLoader.close();
            }
            catch (IOException e) {
                this.logger.error("Unexpected exception while trying to release the policy classloader");
            }
        }
    }

    protected ClassLoader getClassLoader(Plugin plugin) {
        return new URLClassLoader(plugin.dependencies(), ((Object)((Object)this)).getClass().getClassLoader());
    }
}

