/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.node.vertx.server;

import io.gravitee.common.utils.UUID;
import io.gravitee.node.api.certificate.CertificateOptions;
import io.gravitee.node.api.certificate.KeyStoreLoader;
import io.gravitee.node.api.certificate.KeyStoreLoaderOptions;
import io.gravitee.node.api.server.ServerOptions;
import io.gravitee.node.certificates.KeyStoreLoaderManager;
import io.gravitee.node.vertx.cert.VertxKeyStoreManager;
import io.gravitee.node.vertx.server.http.VertxHttpServerOptions;
import io.gravitee.node.vertx.server.tcp.VertxTcpServerOptions;
import io.vertx.core.http.ClientAuth;
import io.vertx.core.net.JksOptions;
import io.vertx.core.net.OpenSSLEngineOptions;
import io.vertx.core.net.PemTrustOptions;
import io.vertx.core.net.PfxOptions;
import io.vertx.core.net.SSLEngineOptions;
import io.vertx.core.net.TCPSSLOptions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.core.env.Environment;

public class VertxServerOptions
implements ServerOptions {
    public static final boolean DEFAULT_SECURED = false;
    public static final boolean DEFAULT_SNI = false;
    public static final boolean DEFAULT_OPENSSL = false;
    public static final boolean DEFAULT_TCP_KEEP_ALIVE = true;
    public static final String CERTIFICATE_FORMAT_JKS = "JKS";
    public static final String CERTIFICATE_FORMAT_PEM = "PEM";
    public static final String CERTIFICATE_FORMAT_PKCS12 = "PKCS12";
    public static final String CERTIFICATE_FORMAT_SELF_SIGNED = "SELF-SIGNED";
    public static final String DEFAULT_STORE_TYPE = "JKS";
    public static final boolean DEFAULT_STORE_WATCH = true;
    public static final String DEFAULT_LISTENING_HOST = "0.0.0.0";
    public static final int DEFAULT_PORT = 8080;
    public static final int TCP_DEFAULT_PORT = 4080;
    public static final int DEFAULT_IDLE_TIMEOUT = 0;
    public static final String DEFAULT_CLIENT_AUTH = ClientAuth.NONE.name();
    public static final boolean DEFAULT_HAPROXY_PROTOCOL = false;
    public static final long DEFAULT_HAPROXY_PROTOCOL_TIMEOUT = 10L;
    protected int port;
    protected String host;
    protected boolean secured;
    protected boolean sni;
    protected boolean openssl;
    protected int idleTimeout;
    protected boolean tcpKeepAlive;
    protected String tlsProtocols;
    protected String keyStorePath;
    protected List<String> keyStoreKubernetes;
    protected String keyStoreSecret;
    protected String keyStoreDefaultAlias;
    protected String keyStorePassword;
    protected String keyStoreType;
    protected List<CertificateOptions> keyStoreCertificates;
    protected boolean keyStoreWatch;
    protected String trustStorePath;
    protected String trustStorePassword;
    protected String trustStoreType;
    protected List<String> trustStorePaths;
    protected String clientAuth;
    protected List<String> authorizedTlsCipherSuites;
    protected KeyStoreLoaderManager keyStoreLoaderManager;
    protected boolean haProxyProtocol;
    protected long haProxyProtocolTimeout;
    protected String id;
    protected String prefix;
    protected Environment environment;

    public static VertxServerOptionsBuilder<?, ?> builder() {
        return VertxHttpServerOptions.builder();
    }

    public static VertxServerOptionsBuilder<?, ?> builder(Environment environment, String prefix, KeyStoreLoaderManager keyStoreLoaderManager) {
        String type = environment.getProperty(prefix + ".type");
        if (type == null || "http".equals(type)) {
            return ((VertxHttpServerOptions.VertxHttpServerOptionsBuilder)VertxHttpServerOptions.builder().prefix(prefix)).environment(environment).keyStoreLoaderManager(keyStoreLoaderManager);
        }
        if ("tcp".equals(type)) {
            return ((VertxTcpServerOptions.VertxTcpServerOptionsBuilder)((VertxTcpServerOptions.VertxTcpServerOptionsBuilder)((VertxTcpServerOptions.VertxTcpServerOptionsBuilder)VertxTcpServerOptions.builder().prefix(prefix)).environment(environment)).keyStoreLoaderManager(keyStoreLoaderManager)).defaultPort(4080);
        }
        throw new IllegalArgumentException("Server type [" + type + "] is not supported");
    }

    protected final void setupTcp(TCPSSLOptions options) {
        if (this.secured) {
            if (this.keyStoreLoaderManager == null) {
                throw new IllegalArgumentException("You must provide a KeyStoreLoaderManager when 'secured' is enabled.");
            }
            if (this.openssl) {
                options.setSslEngineOptions((SSLEngineOptions)new OpenSSLEngineOptions());
            }
            options.setSsl(this.secured);
            if (this.tlsProtocols != null) {
                options.setEnabledSecureTransportProtocols(Arrays.stream(this.tlsProtocols.split(",")).map(String::trim).collect(Collectors.toSet()));
            }
            if (this.authorizedTlsCipherSuites != null) {
                this.authorizedTlsCipherSuites.stream().map(String::trim).forEach(arg_0 -> ((TCPSSLOptions)options).addEnabledCipherSuite(arg_0));
            }
            if (this.trustStorePaths != null && !this.trustStorePaths.isEmpty()) {
                if (this.trustStoreType == null || this.trustStoreType.isEmpty() || this.trustStoreType.equalsIgnoreCase("JKS")) {
                    options.setTrustStoreOptions(new JksOptions().setPath(this.trustStorePaths.get(0)).setPassword(this.trustStorePassword));
                } else if (this.trustStoreType.equalsIgnoreCase(CERTIFICATE_FORMAT_PEM)) {
                    PemTrustOptions pemTrustOptions = new PemTrustOptions();
                    this.trustStorePaths.forEach(arg_0 -> ((PemTrustOptions)pemTrustOptions).addCertPath(arg_0));
                    options.setPemTrustOptions(pemTrustOptions);
                } else if (this.trustStoreType.equalsIgnoreCase(CERTIFICATE_FORMAT_PKCS12)) {
                    options.setPfxTrustOptions(new PfxOptions().setPath(this.trustStorePaths.get(0)).setPassword(this.trustStorePassword));
                }
            }
            KeyStoreLoaderOptions keyStoreLoaderOptions = KeyStoreLoaderOptions.builder().withKeyStorePath(this.keyStorePath).withKeyStorePassword(this.keyStorePassword).withKeyStoreType(this.keyStoreType).withKeyStoreCertificates(this.keyStoreCertificates).withKubernetesLocations(this.keyStoreKubernetes).withSecretLocation(this.keyStoreSecret).withWatch(this.keyStoreWatch).withDefaultAlias(this.keyStoreDefaultAlias).build();
            VertxKeyStoreManager keyStoreManager = new VertxKeyStoreManager(this.sni);
            KeyStoreLoader keyStoreLoader = this.keyStoreLoaderManager.create(keyStoreLoaderOptions);
            keyStoreManager.registerLoader(keyStoreLoader);
            options.setKeyCertOptions(keyStoreManager.getKeyCertOptions());
        }
        options.setIdleTimeout(this.idleTimeout);
        options.setTcpKeepAlive(this.tcpKeepAlive);
    }

    private static int $default$port() {
        return 8080;
    }

    private static String $default$host() {
        return DEFAULT_LISTENING_HOST;
    }

    private static boolean $default$secured() {
        return false;
    }

    private static boolean $default$sni() {
        return false;
    }

    private static boolean $default$openssl() {
        return false;
    }

    private static int $default$idleTimeout() {
        return 0;
    }

    private static boolean $default$tcpKeepAlive() {
        return true;
    }

    private static String $default$keyStoreType() {
        return "JKS";
    }

    private static boolean $default$keyStoreWatch() {
        return true;
    }

    private static String $default$trustStoreType() {
        return "JKS";
    }

    private static String $default$clientAuth() {
        return DEFAULT_CLIENT_AUTH;
    }

    private static boolean $default$haProxyProtocol() {
        return false;
    }

    private static long $default$haProxyProtocolTimeout() {
        return 10L;
    }

    protected VertxServerOptions(VertxServerOptionsBuilder<?, ?> b) {
        this.port = b.port$set ? b.port$value : VertxServerOptions.$default$port();
        this.host = b.host$set ? b.host$value : VertxServerOptions.$default$host();
        this.secured = b.secured$set ? b.secured$value : VertxServerOptions.$default$secured();
        this.sni = b.sni$set ? b.sni$value : VertxServerOptions.$default$sni();
        this.openssl = b.openssl$set ? b.openssl$value : VertxServerOptions.$default$openssl();
        this.idleTimeout = b.idleTimeout$set ? b.idleTimeout$value : VertxServerOptions.$default$idleTimeout();
        this.tcpKeepAlive = b.tcpKeepAlive$set ? b.tcpKeepAlive$value : VertxServerOptions.$default$tcpKeepAlive();
        this.tlsProtocols = b.tlsProtocols;
        this.keyStorePath = b.keyStorePath;
        this.keyStoreKubernetes = b.keyStoreKubernetes;
        this.keyStoreSecret = b.keyStoreSecret;
        this.keyStoreDefaultAlias = b.keyStoreDefaultAlias;
        this.keyStorePassword = b.keyStorePassword;
        this.keyStoreType = b.keyStoreType$set ? b.keyStoreType$value : VertxServerOptions.$default$keyStoreType();
        this.keyStoreCertificates = b.keyStoreCertificates;
        this.keyStoreWatch = b.keyStoreWatch$set ? b.keyStoreWatch$value : VertxServerOptions.$default$keyStoreWatch();
        this.trustStorePath = b.trustStorePath;
        this.trustStorePassword = b.trustStorePassword;
        this.trustStoreType = b.trustStoreType$set ? b.trustStoreType$value : VertxServerOptions.$default$trustStoreType();
        this.trustStorePaths = b.trustStorePaths;
        this.clientAuth = b.clientAuth$set ? b.clientAuth$value : VertxServerOptions.$default$clientAuth();
        this.authorizedTlsCipherSuites = b.authorizedTlsCipherSuites;
        this.keyStoreLoaderManager = b.keyStoreLoaderManager;
        this.haProxyProtocol = b.haProxyProtocol$set ? b.haProxyProtocol$value : VertxServerOptions.$default$haProxyProtocol();
        this.haProxyProtocolTimeout = b.haProxyProtocolTimeout$set ? b.haProxyProtocolTimeout$value : VertxServerOptions.$default$haProxyProtocolTimeout();
        this.id = b.id;
        this.prefix = b.prefix;
        this.environment = b.environment;
    }

    public int getPort() {
        return this.port;
    }

    public String getHost() {
        return this.host;
    }

    public boolean isSecured() {
        return this.secured;
    }

    public boolean isSni() {
        return this.sni;
    }

    public boolean isOpenssl() {
        return this.openssl;
    }

    public int getIdleTimeout() {
        return this.idleTimeout;
    }

    public boolean isTcpKeepAlive() {
        return this.tcpKeepAlive;
    }

    public String getTlsProtocols() {
        return this.tlsProtocols;
    }

    public String getKeyStorePath() {
        return this.keyStorePath;
    }

    public List<String> getKeyStoreKubernetes() {
        return this.keyStoreKubernetes;
    }

    public String getKeyStoreSecret() {
        return this.keyStoreSecret;
    }

    public String getKeyStoreDefaultAlias() {
        return this.keyStoreDefaultAlias;
    }

    public String getKeyStorePassword() {
        return this.keyStorePassword;
    }

    public String getKeyStoreType() {
        return this.keyStoreType;
    }

    public List<CertificateOptions> getKeyStoreCertificates() {
        return this.keyStoreCertificates;
    }

    public boolean isKeyStoreWatch() {
        return this.keyStoreWatch;
    }

    public String getTrustStorePath() {
        return this.trustStorePath;
    }

    public String getTrustStorePassword() {
        return this.trustStorePassword;
    }

    public String getTrustStoreType() {
        return this.trustStoreType;
    }

    public List<String> getTrustStorePaths() {
        return this.trustStorePaths;
    }

    public String getClientAuth() {
        return this.clientAuth;
    }

    public List<String> getAuthorizedTlsCipherSuites() {
        return this.authorizedTlsCipherSuites;
    }

    public KeyStoreLoaderManager getKeyStoreLoaderManager() {
        return this.keyStoreLoaderManager;
    }

    public boolean isHaProxyProtocol() {
        return this.haProxyProtocol;
    }

    public long getHaProxyProtocolTimeout() {
        return this.haProxyProtocolTimeout;
    }

    public String getId() {
        return this.id;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    public VertxServerOptions(int port, String host, boolean secured, boolean sni, boolean openssl, int idleTimeout, boolean tcpKeepAlive, String tlsProtocols, String keyStorePath, List<String> keyStoreKubernetes, String keyStoreSecret, String keyStoreDefaultAlias, String keyStorePassword, String keyStoreType, List<CertificateOptions> keyStoreCertificates, boolean keyStoreWatch, String trustStorePath, String trustStorePassword, String trustStoreType, List<String> trustStorePaths, String clientAuth, List<String> authorizedTlsCipherSuites, KeyStoreLoaderManager keyStoreLoaderManager, boolean haProxyProtocol, long haProxyProtocolTimeout, String id, String prefix, Environment environment) {
        this.port = port;
        this.host = host;
        this.secured = secured;
        this.sni = sni;
        this.openssl = openssl;
        this.idleTimeout = idleTimeout;
        this.tcpKeepAlive = tcpKeepAlive;
        this.tlsProtocols = tlsProtocols;
        this.keyStorePath = keyStorePath;
        this.keyStoreKubernetes = keyStoreKubernetes;
        this.keyStoreSecret = keyStoreSecret;
        this.keyStoreDefaultAlias = keyStoreDefaultAlias;
        this.keyStorePassword = keyStorePassword;
        this.keyStoreType = keyStoreType;
        this.keyStoreCertificates = keyStoreCertificates;
        this.keyStoreWatch = keyStoreWatch;
        this.trustStorePath = trustStorePath;
        this.trustStorePassword = trustStorePassword;
        this.trustStoreType = trustStoreType;
        this.trustStorePaths = trustStorePaths;
        this.clientAuth = clientAuth;
        this.authorizedTlsCipherSuites = authorizedTlsCipherSuites;
        this.keyStoreLoaderManager = keyStoreLoaderManager;
        this.haProxyProtocol = haProxyProtocol;
        this.haProxyProtocolTimeout = haProxyProtocolTimeout;
        this.id = id;
        this.prefix = prefix;
        this.environment = environment;
    }

    protected VertxServerOptions() {
        this.port = VertxServerOptions.$default$port();
        this.host = VertxServerOptions.$default$host();
        this.secured = VertxServerOptions.$default$secured();
        this.sni = VertxServerOptions.$default$sni();
        this.openssl = VertxServerOptions.$default$openssl();
        this.idleTimeout = VertxServerOptions.$default$idleTimeout();
        this.tcpKeepAlive = VertxServerOptions.$default$tcpKeepAlive();
        this.keyStoreType = VertxServerOptions.$default$keyStoreType();
        this.keyStoreWatch = VertxServerOptions.$default$keyStoreWatch();
        this.trustStoreType = VertxServerOptions.$default$trustStoreType();
        this.clientAuth = VertxServerOptions.$default$clientAuth();
        this.haProxyProtocol = VertxServerOptions.$default$haProxyProtocol();
        this.haProxyProtocolTimeout = VertxServerOptions.$default$haProxyProtocolTimeout();
    }

    public static abstract class VertxServerOptionsBuilder<C extends VertxServerOptions, B extends VertxServerOptionsBuilder<C, B>> {
        private boolean port$set;
        private int port$value;
        private boolean host$set;
        private String host$value;
        private boolean secured$set;
        private boolean secured$value;
        private boolean sni$set;
        private boolean sni$value;
        private boolean openssl$set;
        private boolean openssl$value;
        private boolean idleTimeout$set;
        private int idleTimeout$value;
        private boolean tcpKeepAlive$set;
        private boolean tcpKeepAlive$value;
        private String tlsProtocols;
        private String keyStorePath;
        private List<String> keyStoreKubernetes;
        private String keyStoreSecret;
        private String keyStoreDefaultAlias;
        private String keyStorePassword;
        private boolean keyStoreType$set;
        private String keyStoreType$value;
        private List<CertificateOptions> keyStoreCertificates;
        private boolean keyStoreWatch$set;
        private boolean keyStoreWatch$value;
        private String trustStorePath;
        private String trustStorePassword;
        private boolean trustStoreType$set;
        private String trustStoreType$value;
        private List<String> trustStorePaths;
        private boolean clientAuth$set;
        private String clientAuth$value;
        private List<String> authorizedTlsCipherSuites;
        private KeyStoreLoaderManager keyStoreLoaderManager;
        private boolean haProxyProtocol$set;
        private boolean haProxyProtocol$value;
        private boolean haProxyProtocolTimeout$set;
        private long haProxyProtocolTimeout$value;
        private String id;
        protected int defaultPort = 8080;
        protected String prefix;
        protected Environment environment;

        public B defaultPort(int defaultPort) {
            this.defaultPort = defaultPort;
            if (!this.port$set || this.port$value == 8080) {
                this.port(defaultPort);
            }
            return this.self();
        }

        public B prefix(String prefix) {
            this.prefix = prefix;
            return this.self();
        }

        public B environment(Environment environment) {
            if (this.prefix == null) {
                throw new IllegalArgumentException("Prefix must be set before environment");
            }
            this.environment = environment;
            this.id(environment.getProperty(this.prefix + ".id", UUID.random().toString()));
            this.port(Integer.parseInt(environment.getProperty(this.prefix + ".port", String.valueOf(this.defaultPort))));
            this.host(environment.getProperty(this.prefix + ".host", VertxServerOptions.DEFAULT_LISTENING_HOST));
            this.idleTimeout((Integer)environment.getProperty(this.prefix + ".idleTimeout", Integer.class, (Object)0));
            this.tcpKeepAlive((Boolean)environment.getProperty(this.prefix + ".tcpKeepAlive", Boolean.class, (Object)true));
            this.secured((Boolean)environment.getProperty(this.prefix + ".secured", Boolean.class, (Object)false));
            this.sni((Boolean)environment.getProperty(this.prefix + ".ssl.sni", Boolean.class, (Object)false));
            this.openssl((Boolean)environment.getProperty(this.prefix + ".ssl.openssl", Boolean.class, (Object)false));
            this.tlsProtocols(environment.getProperty(this.prefix + ".ssl.tlsProtocols"));
            this.authorizedTlsCipherSuites((List)environment.getProperty(this.prefix + ".ssl.tlsCiphers", List.class));
            String clientAuthValue = environment.getProperty(this.prefix + ".ssl.clientAuth", DEFAULT_CLIENT_AUTH).toUpperCase();
            if (clientAuthValue.equalsIgnoreCase(Boolean.TRUE.toString())) {
                this.clientAuth(ClientAuth.REQUIRED.name());
            } else if (clientAuthValue.equalsIgnoreCase(Boolean.FALSE.toString())) {
                this.clientAuth(ClientAuth.NONE.name());
            } else {
                this.clientAuth(ClientAuth.valueOf((String)clientAuthValue.toUpperCase()).name());
            }
            this.keyStoreType(environment.getProperty(this.prefix + ".ssl.keystore.type", "JKS"));
            this.keyStorePath(environment.getProperty(this.prefix + ".ssl.keystore.path"));
            this.keyStoreCertificates(this.getCertificateValues(this.prefix + ".ssl.keystore.certificates"));
            this.keyStoreKubernetes(this.getArrayValues(this.prefix + ".ssl.keystore.kubernetes"));
            this.keyStoreSecret(environment.getProperty(this.prefix + ".ssl.keystore.secret"));
            this.keyStoreDefaultAlias(environment.getProperty(this.prefix + ".ssl.keystore.defaultAlias"));
            this.keyStorePassword(environment.getProperty(this.prefix + ".ssl.keystore.password"));
            this.keyStoreWatch((Boolean)environment.getProperty(this.prefix + ".ssl.keystore.watch", Boolean.class, (Object)true));
            this.trustStoreType(environment.getProperty(this.prefix + ".ssl.truststore.type", "JKS"));
            this.trustStorePath(environment.getProperty(this.prefix + ".ssl.truststore.path"));
            this.trustStorePaths(this.getArrayValues(this.prefix + ".ssl.truststore.path"));
            this.trustStorePassword(environment.getProperty(this.prefix + ".ssl.truststore.password"));
            this.haProxyProtocol((Boolean)environment.getProperty(this.prefix + ".haproxy.proxyProtocol", Boolean.class, (Object)false));
            this.haProxyProtocolTimeout((Long)environment.getProperty(this.prefix + ".haproxy.proxyProtocolTimeout", Long.class, (Object)10L));
            return this.self();
        }

        protected List<CertificateOptions> getCertificateValues(String prefix) {
            ArrayList<CertificateOptions> certificates = new ArrayList<CertificateOptions>();
            boolean found = true;
            int idx = 0;
            while (found) {
                String cert = this.environment.getProperty(prefix + "[" + idx + "].cert");
                boolean bl = found = cert != null && !cert.isEmpty();
                if (found) {
                    certificates.add(new CertificateOptions(cert, this.environment.getProperty(prefix + "[" + idx + "].key")));
                }
                ++idx;
            }
            return certificates;
        }

        protected List<String> getArrayValues(String prefix) {
            String single;
            ArrayList<String> values = new ArrayList<String>();
            boolean found = true;
            int idx = 0;
            while (found) {
                String value;
                if (!(found = (value = this.environment.getProperty(prefix + "[" + idx++ + "]")) != null && !value.isEmpty())) continue;
                values.add(value);
            }
            if (values.isEmpty() && (single = this.environment.getProperty(prefix)) != null && !single.isEmpty()) {
                values.add(single);
            }
            return values;
        }

        public B port(int port) {
            this.port$value = port;
            this.port$set = true;
            return this.self();
        }

        public B host(String host) {
            this.host$value = host;
            this.host$set = true;
            return this.self();
        }

        public B secured(boolean secured) {
            this.secured$value = secured;
            this.secured$set = true;
            return this.self();
        }

        public B sni(boolean sni) {
            this.sni$value = sni;
            this.sni$set = true;
            return this.self();
        }

        public B openssl(boolean openssl) {
            this.openssl$value = openssl;
            this.openssl$set = true;
            return this.self();
        }

        public B idleTimeout(int idleTimeout) {
            this.idleTimeout$value = idleTimeout;
            this.idleTimeout$set = true;
            return this.self();
        }

        public B tcpKeepAlive(boolean tcpKeepAlive) {
            this.tcpKeepAlive$value = tcpKeepAlive;
            this.tcpKeepAlive$set = true;
            return this.self();
        }

        public B tlsProtocols(String tlsProtocols) {
            this.tlsProtocols = tlsProtocols;
            return this.self();
        }

        public B keyStorePath(String keyStorePath) {
            this.keyStorePath = keyStorePath;
            return this.self();
        }

        public B keyStoreKubernetes(List<String> keyStoreKubernetes) {
            this.keyStoreKubernetes = keyStoreKubernetes;
            return this.self();
        }

        public B keyStoreSecret(String keyStoreSecret) {
            this.keyStoreSecret = keyStoreSecret;
            return this.self();
        }

        public B keyStoreDefaultAlias(String keyStoreDefaultAlias) {
            this.keyStoreDefaultAlias = keyStoreDefaultAlias;
            return this.self();
        }

        public B keyStorePassword(String keyStorePassword) {
            this.keyStorePassword = keyStorePassword;
            return this.self();
        }

        public B keyStoreType(String keyStoreType) {
            this.keyStoreType$value = keyStoreType;
            this.keyStoreType$set = true;
            return this.self();
        }

        public B keyStoreCertificates(List<CertificateOptions> keyStoreCertificates) {
            this.keyStoreCertificates = keyStoreCertificates;
            return this.self();
        }

        public B keyStoreWatch(boolean keyStoreWatch) {
            this.keyStoreWatch$value = keyStoreWatch;
            this.keyStoreWatch$set = true;
            return this.self();
        }

        public B trustStorePath(String trustStorePath) {
            this.trustStorePath = trustStorePath;
            return this.self();
        }

        public B trustStorePassword(String trustStorePassword) {
            this.trustStorePassword = trustStorePassword;
            return this.self();
        }

        public B trustStoreType(String trustStoreType) {
            this.trustStoreType$value = trustStoreType;
            this.trustStoreType$set = true;
            return this.self();
        }

        public B trustStorePaths(List<String> trustStorePaths) {
            this.trustStorePaths = trustStorePaths;
            return this.self();
        }

        public B clientAuth(String clientAuth) {
            this.clientAuth$value = clientAuth;
            this.clientAuth$set = true;
            return this.self();
        }

        public B authorizedTlsCipherSuites(List<String> authorizedTlsCipherSuites) {
            this.authorizedTlsCipherSuites = authorizedTlsCipherSuites;
            return this.self();
        }

        public B keyStoreLoaderManager(KeyStoreLoaderManager keyStoreLoaderManager) {
            this.keyStoreLoaderManager = keyStoreLoaderManager;
            return this.self();
        }

        public B haProxyProtocol(boolean haProxyProtocol) {
            this.haProxyProtocol$value = haProxyProtocol;
            this.haProxyProtocol$set = true;
            return this.self();
        }

        public B haProxyProtocolTimeout(long haProxyProtocolTimeout) {
            this.haProxyProtocolTimeout$value = haProxyProtocolTimeout;
            this.haProxyProtocolTimeout$set = true;
            return this.self();
        }

        public B id(String id) {
            this.id = id;
            return this.self();
        }

        protected abstract B self();

        public abstract C build();

        public String toString() {
            return "VertxServerOptions.VertxServerOptionsBuilder(port$value=" + this.port$value + ", host$value=" + this.host$value + ", secured$value=" + this.secured$value + ", sni$value=" + this.sni$value + ", openssl$value=" + this.openssl$value + ", idleTimeout$value=" + this.idleTimeout$value + ", tcpKeepAlive$value=" + this.tcpKeepAlive$value + ", tlsProtocols=" + this.tlsProtocols + ", keyStorePath=" + this.keyStorePath + ", keyStoreKubernetes=" + this.keyStoreKubernetes + ", keyStoreSecret=" + this.keyStoreSecret + ", keyStoreDefaultAlias=" + this.keyStoreDefaultAlias + ", keyStorePassword=" + this.keyStorePassword + ", keyStoreType$value=" + this.keyStoreType$value + ", keyStoreCertificates=" + this.keyStoreCertificates + ", keyStoreWatch$value=" + this.keyStoreWatch$value + ", trustStorePath=" + this.trustStorePath + ", trustStorePassword=" + this.trustStorePassword + ", trustStoreType$value=" + this.trustStoreType$value + ", trustStorePaths=" + this.trustStorePaths + ", clientAuth$value=" + this.clientAuth$value + ", authorizedTlsCipherSuites=" + this.authorizedTlsCipherSuites + ", keyStoreLoaderManager=" + this.keyStoreLoaderManager + ", haProxyProtocol$value=" + this.haProxyProtocol$value + ", haProxyProtocolTimeout$value=" + this.haProxyProtocolTimeout$value + ", id=" + this.id + ", prefix=" + this.prefix + ", environment=" + this.environment + ")";
        }
    }

    private static final class VertxServerOptionsBuilderImpl
    extends VertxServerOptionsBuilder<VertxServerOptions, VertxServerOptionsBuilderImpl> {
        private VertxServerOptionsBuilderImpl() {
        }

        @Override
        protected VertxServerOptionsBuilderImpl self() {
            return this;
        }

        @Override
        public VertxServerOptions build() {
            return new VertxServerOptions(this);
        }
    }
}

