/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.node.vertx.server;

import io.gravitee.node.api.server.ServerFactory;
import io.gravitee.node.vertx.server.VertxServer;
import io.gravitee.node.vertx.server.VertxServerOptions;
import io.gravitee.node.vertx.server.http.VertxHttpServerFactory;
import io.gravitee.node.vertx.server.http.VertxHttpServerOptions;
import io.gravitee.node.vertx.server.tcp.VertxTcpServerFactory;
import io.gravitee.node.vertx.server.tcp.VertxTcpServerOptions;
import io.vertx.rxjava3.core.Vertx;

public class VertxServerFactory<T extends VertxServer<?, C>, C extends VertxServerOptions>
implements ServerFactory<T, C> {
    private final VertxHttpServerFactory httpServerFactory;
    private final VertxTcpServerFactory tcpServerFactory;

    public VertxServerFactory(Vertx vertx) {
        this.httpServerFactory = new VertxHttpServerFactory(vertx);
        this.tcpServerFactory = new VertxTcpServerFactory(vertx);
    }

    public T create(C options) {
        if (options instanceof VertxHttpServerOptions) {
            VertxHttpServerOptions http = (VertxHttpServerOptions)options;
            return (T)this.httpServerFactory.create(http);
        }
        if (options instanceof VertxTcpServerOptions) {
            VertxTcpServerOptions tcp = (VertxTcpServerOptions)options;
            return (T)this.tcpServerFactory.create(tcp);
        }
        throw new IllegalArgumentException("Server type is not a supported vertx server (option class=[" + options.getClass().getSimpleName() + "])");
    }
}

