/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.node.vertx.metrics;

import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.config.MeterFilter;
import io.reactivex.rxjava3.annotations.NonNull;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ExcludeTagsFilter
implements MeterFilter {
    private final String category;
    private final List<String> excludedLabels;

    public ExcludeTagsFilter(String category, List<String> excludedLabels) {
        this.category = category;
        this.excludedLabels = excludedLabels;
    }

    @NonNull
    public Meter.Id map(@NonNull Meter.Id id) {
        if (!this.excludedLabels.isEmpty() && id.getName().startsWith(this.category)) {
            ArrayList<Tag> tags = new ArrayList<Tag>();
            Iterator iter = id.getTagsAsIterable().iterator();
            int processedTags = 0;
            while (iter.hasNext()) {
                Tag t = (Tag)iter.next();
                if (!this.excludedLabels.contains(t.getKey())) {
                    tags.add(t);
                }
                ++processedTags;
            }
            return processedTags > tags.size() ? id.replaceTags(tags) : id;
        }
        return id;
    }

    public String getCategory() {
        return this.category;
    }

    public List<String> getExcludedLabels() {
        return this.excludedLabels;
    }
}

