/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.node.vertx.cert;

import io.gravitee.node.vertx.cert.VertxKeyManagerFactory;
import io.vertx.core.Vertx;
import io.vertx.core.net.KeyCertOptions;
import java.util.function.Function;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.X509KeyManager;

class VertxKeyCertOptions
implements KeyCertOptions {
    public static final Function<String, X509KeyManager> NULL_MAPPER_FUNCTION = s -> null;
    private final KeyManagerFactory keyManagerFactory;

    VertxKeyCertOptions(KeyManagerFactory keyManagerFactory) {
        if (keyManagerFactory == null || keyManagerFactory.getKeyManagers() == null || keyManagerFactory.getKeyManagers().length == 0) {
            throw new IllegalArgumentException("KeyManagerFactory is not present or is not initialized yet");
        }
        this.keyManagerFactory = keyManagerFactory;
    }

    VertxKeyCertOptions(X509KeyManager keyManager) {
        this(new VertxKeyManagerFactory(keyManager));
    }

    private VertxKeyCertOptions(VertxKeyCertOptions other) {
        this.keyManagerFactory = other.keyManagerFactory;
    }

    public KeyCertOptions copy() {
        return new VertxKeyCertOptions(this);
    }

    public KeyManagerFactory getKeyManagerFactory(Vertx vertx) {
        return this.keyManagerFactory;
    }

    public Function<String, X509KeyManager> keyManagerMapper(Vertx vertx) {
        return NULL_MAPPER_FUNCTION;
    }
}

