/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.node.vertx.configuration;

import io.gravitee.node.api.certificate.CertificateOptions;
import io.vertx.core.http.ClientAuth;
import io.vertx.core.tracing.TracingPolicy;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class HttpServerConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(HttpServerConfiguration.class);
    private static final String CERTIFICATE_FORMAT_JKS = "JKS";
    private static final String CERTIFICATE_FORMAT_PEM = "PEM";
    private static final String CERTIFICATE_FORMAT_PKCS12 = "PKCS12";
    private static final String CERTIFICATE_FORMAT_SELF_SIGNED = "SELF-SIGNED";
    private final TracingPolicy tracingPolicy;
    private final int port;
    private final String host;
    private final String authenticationType;
    private final boolean secured;
    private final boolean alpn;
    private final boolean sni;
    private final boolean openssl;
    private final String tlsProtocols;
    private final String keyStorePath;
    private final List<String> keyStoreKubernetes;
    private final String keyStoreDefaultAlias;
    private final String keyStorePassword;
    private final String keyStoreType;
    private final List<CertificateOptions> keyStoreCertificates;
    private final String trustStorePath;
    private final String trustStorePassword;
    private final String trustStoreType;
    private final List<String> trustStorePaths;
    private final boolean handle100Continue;
    private final boolean compressionSupported;
    private final int idleTimeout;
    private final boolean tcpKeepAlive;
    private final int maxHeaderSize;
    private final int maxChunkSize;
    private final int maxInitialLineLength;
    private final int maxFormAttributeSize;
    private final boolean websocketEnabled;
    private final String websocketSubProtocols;
    private final boolean perMessageWebSocketCompressionSupported;
    private final boolean perFrameWebSocketCompressionSupported;
    private final boolean proxyProtocol;
    private final long proxyProtocolTimeout;
    private final ClientAuth clientAuth;
    private final List<String> authorizedTlsCipherSuites;
    private final int maxWebSocketFrameSize;
    private final int maxWebSocketMessageSize;

    private HttpServerConfiguration(HttpServerConfigurationBuilder builder) {
        this.tracingPolicy = builder.tracingPolicy;
        this.port = builder.port;
        this.host = builder.host;
        this.authenticationType = builder.authenticationType;
        this.secured = builder.secured;
        this.alpn = builder.alpn;
        this.sni = builder.sni;
        this.openssl = builder.openssl;
        this.tlsProtocols = builder.tlsProtocols;
        this.keyStorePath = builder.keyStorePath;
        this.keyStoreKubernetes = builder.keyStoreKubernetes;
        this.keyStoreDefaultAlias = builder.keyStoreDefaultAlias;
        this.keyStorePassword = builder.keyStorePassword;
        this.keyStoreType = builder.keyStoreType;
        this.keyStoreCertificates = builder.keyStoreCertificates;
        this.trustStorePath = builder.trustStorePath;
        this.trustStorePassword = builder.trustStorePassword;
        this.trustStoreType = builder.trustStoreType;
        this.trustStorePaths = builder.trustStorePaths;
        this.handle100Continue = builder.handle100Continue;
        this.compressionSupported = builder.compressionSupported;
        this.idleTimeout = builder.idleTimeout;
        this.tcpKeepAlive = builder.tcpKeepAlive;
        this.maxHeaderSize = builder.maxHeaderSize;
        this.maxChunkSize = builder.maxChunkSize;
        this.maxInitialLineLength = builder.maxInitialLineLength;
        this.maxFormAttributeSize = builder.maxFormAttributeSize;
        this.websocketEnabled = builder.websocketEnabled;
        this.websocketSubProtocols = builder.websocketSubProtocols;
        this.perMessageWebSocketCompressionSupported = builder.perMessageWebSocketCompressionSupported;
        this.perFrameWebSocketCompressionSupported = builder.perFrameWebSocketCompressionSupported;
        this.proxyProtocol = builder.proxyProtocol;
        this.proxyProtocolTimeout = builder.proxyProtocolTimeout;
        this.clientAuth = builder.clientAuth;
        this.authorizedTlsCipherSuites = builder.authorizedTlsCipherSuites;
        this.maxWebSocketFrameSize = builder.maxWebSocketFrameSize;
        this.maxWebSocketMessageSize = builder.maxWebSocketMessageSize;
    }

    public static HttpServerConfigurationBuilder builder() {
        return new HttpServerConfigurationBuilder();
    }

    public TracingPolicy getTracingPolicy() {
        return this.tracingPolicy;
    }

    public int getPort() {
        return this.port;
    }

    public String getHost() {
        return this.host;
    }

    public String getAuthenticationType() {
        return this.authenticationType;
    }

    public boolean isSecured() {
        return this.secured;
    }

    public boolean isAlpn() {
        return this.alpn;
    }

    public boolean isSni() {
        return this.sni;
    }

    public boolean isOpenssl() {
        return this.openssl;
    }

    public String getTlsProtocols() {
        return this.tlsProtocols;
    }

    public String getKeyStorePath() {
        return this.keyStorePath;
    }

    public List<String> getKeystoreKubernetes() {
        return this.keyStoreKubernetes;
    }

    public String getKeyStoreDefaultAlias() {
        return this.keyStoreDefaultAlias;
    }

    public String getKeyStorePassword() {
        return this.keyStorePassword;
    }

    public String getKeyStoreType() {
        return this.keyStoreType;
    }

    public List<CertificateOptions> getKeyStoreCertificates() {
        return this.keyStoreCertificates;
    }

    public String getTrustStorePath() {
        return this.trustStorePath;
    }

    public String getTrustStorePassword() {
        return this.trustStorePassword;
    }

    public String getTrustStoreType() {
        return this.trustStoreType;
    }

    public List<String> getTrustStorePaths() {
        return this.trustStorePaths;
    }

    public boolean isHandle100Continue() {
        return this.handle100Continue;
    }

    public boolean isCompressionSupported() {
        return this.compressionSupported;
    }

    public int getIdleTimeout() {
        return this.idleTimeout;
    }

    public boolean isTcpKeepAlive() {
        return this.tcpKeepAlive;
    }

    public int getMaxHeaderSize() {
        return this.maxHeaderSize;
    }

    public int getMaxChunkSize() {
        return this.maxChunkSize;
    }

    public int getMaxInitialLineLength() {
        return this.maxInitialLineLength;
    }

    public int getMaxFormAttributeSize() {
        return this.maxFormAttributeSize;
    }

    public boolean isWebsocketEnabled() {
        return this.websocketEnabled;
    }

    public String getWebsocketSubProtocols() {
        return this.websocketSubProtocols;
    }

    public boolean isPerMessageWebSocketCompressionSupported() {
        return this.perMessageWebSocketCompressionSupported;
    }

    public boolean isPerFrameWebSocketCompressionSupported() {
        return this.perFrameWebSocketCompressionSupported;
    }

    public boolean isProxyProtocol() {
        return this.proxyProtocol;
    }

    public long getProxyProtocolTimeout() {
        return this.proxyProtocolTimeout;
    }

    public ClientAuth getClientAuth() {
        return this.clientAuth;
    }

    public List<String> getAuthorizedTlsCipherSuites() {
        return this.authorizedTlsCipherSuites;
    }

    public int getMaxWebSocketMessageSize() {
        return this.maxWebSocketMessageSize;
    }

    public int getMaxWebSocketFrameSize() {
        return this.maxWebSocketFrameSize;
    }

    public static class HttpServerConfigurationBuilder {
        private TracingPolicy tracingPolicy;
        private int port = 8080;
        private int predefinedPort = 0;
        private String host = "0.0.0.0";
        private String predefinedHost = null;
        private String authenticationType;
        private boolean secured;
        private boolean alpn;
        private boolean sni;
        private boolean openssl;
        private String tlsProtocols;
        private String keyStorePath;
        private List<String> keyStoreKubernetes;
        private String keyStoreDefaultAlias;
        private String keyStorePassword;
        private String keyStoreType = "JKS";
        private List<CertificateOptions> keyStoreCertificates;
        private String trustStorePath;
        private String trustStorePassword;
        private String trustStoreType = "JKS";
        private List<String> trustStorePaths;
        private boolean handle100Continue;
        private boolean compressionSupported = false;
        private int idleTimeout = 0;
        private boolean tcpKeepAlive = true;
        private int maxHeaderSize = 8192;
        private int maxChunkSize = 8192;
        private int maxInitialLineLength = 4096;
        private int maxFormAttributeSize;
        private boolean websocketEnabled;
        private String websocketSubProtocols;
        private boolean perMessageWebSocketCompressionSupported = true;
        private boolean perFrameWebSocketCompressionSupported = true;
        private boolean proxyProtocol;
        private long proxyProtocolTimeout = 10000L;
        private ClientAuth clientAuth = ClientAuth.NONE;
        private List<String> authorizedTlsCipherSuites;
        private Environment environment;
        private String prefix = "http.";
        private int maxWebSocketFrameSize = 65536;
        private int maxWebSocketMessageSize = 262144;

        private HttpServerConfigurationBuilder() {
        }

        public HttpServerConfigurationBuilder withDefaultPort(int port) {
            Assert.isTrue((port > 0 ? 1 : 0) != 0, (String)"Port should be bigger than 0");
            this.port = port;
            return this;
        }

        public HttpServerConfigurationBuilder withPort(int port) {
            Assert.isTrue((port > 0 ? 1 : 0) != 0, (String)"Port should be bigger than 0");
            this.predefinedPort = port;
            return this;
        }

        public HttpServerConfigurationBuilder withDefaultHost(String host) {
            Assert.hasText((String)host, (String)"Host can't be null or empty");
            this.host = host;
            return this;
        }

        public HttpServerConfigurationBuilder withHost(String host) {
            Assert.hasText((String)host, (String)"Host can't be null or empty");
            this.predefinedHost = host;
            return this;
        }

        public HttpServerConfigurationBuilder withDefaultAuthenticationType(String authenticationType) {
            this.authenticationType = authenticationType;
            return this;
        }

        public HttpServerConfigurationBuilder withDefaultSecured(boolean secured) {
            this.secured = secured;
            return this;
        }

        public HttpServerConfigurationBuilder withDefaultAlpn(boolean alpn) {
            this.alpn = alpn;
            return this;
        }

        public HttpServerConfigurationBuilder withDefaultSni(boolean sni) {
            this.sni = sni;
            return this;
        }

        public HttpServerConfigurationBuilder withDefaultOpenssl(boolean openssl) {
            this.openssl = openssl;
            return this;
        }

        public HttpServerConfigurationBuilder withDefaultTlsProtocols(String tlsProtocols) {
            this.tlsProtocols = tlsProtocols;
            return this;
        }

        public HttpServerConfigurationBuilder withDefaultKeyStorePath(String keyStorePath) {
            this.keyStorePath = keyStorePath;
            return this;
        }

        public HttpServerConfigurationBuilder withDefaultKeyStoreKubernetes(List<String> keyStoreKubernetes) {
            this.keyStoreKubernetes = keyStoreKubernetes;
            return this;
        }

        public HttpServerConfigurationBuilder withDefaultKeyStorePassword(String keyStorePassword) {
            this.keyStorePassword = keyStorePassword;
            return this;
        }

        public HttpServerConfigurationBuilder withDefaultKeyStoreType(String keyStoreType) {
            this.keyStoreType = keyStoreType;
            return this;
        }

        public HttpServerConfigurationBuilder withDefaultKeyStoreCertificates(List<CertificateOptions> keyStoreCertificates) {
            this.keyStoreCertificates = keyStoreCertificates;
            return this;
        }

        public HttpServerConfigurationBuilder withDefaultTrustStorePath(String trustStorePath) {
            this.trustStorePath = trustStorePath;
            return this;
        }

        public HttpServerConfigurationBuilder withDefaultTrustStorePassword(String trustStorePassword) {
            this.trustStorePassword = trustStorePassword;
            return this;
        }

        public HttpServerConfigurationBuilder withDefaultTrustStoreType(String trustStoreType) {
            this.trustStoreType = trustStoreType;
            return this;
        }

        public HttpServerConfigurationBuilder withDefaultTrustStorePaths(List<String> trustStorePaths) {
            this.trustStorePaths = trustStorePaths;
            return this;
        }

        public HttpServerConfigurationBuilder withDefaultHandle100Continue(boolean handle100Continue) {
            this.handle100Continue = handle100Continue;
            return this;
        }

        public HttpServerConfigurationBuilder withDefaultCompressionSupported(boolean compressionSupported) {
            this.compressionSupported = compressionSupported;
            return this;
        }

        public HttpServerConfigurationBuilder withDefaultIdleTimeout(int idleTimeout) {
            this.idleTimeout = idleTimeout;
            return this;
        }

        public HttpServerConfigurationBuilder withDefaultTcpKeepAlive(boolean tcpKeepAlive) {
            this.tcpKeepAlive = tcpKeepAlive;
            return this;
        }

        public HttpServerConfigurationBuilder withDefaultMaxHeaderSize(int maxHeaderSize) {
            this.maxHeaderSize = maxHeaderSize;
            return this;
        }

        public HttpServerConfigurationBuilder withDefaultMaxChunkSize(int maxChunkSize) {
            this.maxChunkSize = maxChunkSize;
            return this;
        }

        public HttpServerConfigurationBuilder withDefaultMaxInitialLineLength(int maxInitialLineLength) {
            this.maxInitialLineLength = maxInitialLineLength;
            return this;
        }

        public HttpServerConfigurationBuilder withDefaultMaxFormAttributeSize(int maxFormAttributeSize) {
            this.maxFormAttributeSize = maxFormAttributeSize;
            return this;
        }

        public HttpServerConfigurationBuilder withDefaultWebsocketEnabled(boolean websocketEnabled) {
            this.websocketEnabled = websocketEnabled;
            return this;
        }

        public HttpServerConfigurationBuilder withDefaultWebsocketSubProtocols(String websocketSubProtocols) {
            this.websocketSubProtocols = websocketSubProtocols;
            return this;
        }

        public HttpServerConfigurationBuilder withDefaultPerMessageWebSocketCompressionSupported(boolean perMessageWebSocketCompressionSupported) {
            this.perMessageWebSocketCompressionSupported = perMessageWebSocketCompressionSupported;
            return this;
        }

        public HttpServerConfigurationBuilder withDefaultPerFrameWebSocketCompressionSupported(boolean perFrameWebSocketCompressionSupported) {
            this.perFrameWebSocketCompressionSupported = perFrameWebSocketCompressionSupported;
            return this;
        }

        public HttpServerConfigurationBuilder withDefaultProxyProtocol(boolean proxyProtocol) {
            this.proxyProtocol = proxyProtocol;
            return this;
        }

        public HttpServerConfigurationBuilder withDefaultProxyProtocolTimeout(long proxyProtocolTimeout) {
            this.proxyProtocolTimeout = proxyProtocolTimeout;
            return this;
        }

        public HttpServerConfigurationBuilder withDefaultClientAuth(ClientAuth clientAuth) {
            this.clientAuth = clientAuth;
            return this;
        }

        public HttpServerConfigurationBuilder withDefaultAuthorizedTlsCipherSuites(List<String> authorizedTlsCipherSuites) {
            this.authorizedTlsCipherSuites = authorizedTlsCipherSuites;
            return this;
        }

        public HttpServerConfigurationBuilder withEnvironment(Environment environment) {
            this.environment = environment;
            return this;
        }

        public HttpServerConfigurationBuilder withPrefix(String prefix) {
            Assert.notNull((Object)prefix, (String)"Prefix can't be null");
            if (StringUtils.hasText((String)prefix) && !((String)prefix).endsWith(".")) {
                prefix = (String)prefix + ".";
            }
            this.prefix = prefix;
            return this;
        }

        public HttpServerConfigurationBuilder withDefaultMaxWebSocketFrameSize(int maxWebSocketFrameSize) {
            this.maxWebSocketFrameSize = maxWebSocketFrameSize;
            return this;
        }

        public HttpServerConfigurationBuilder withDefaultMaxWebSocketMessageSize(int maxWebSocketMessageSize) {
            this.maxWebSocketMessageSize = maxWebSocketMessageSize;
            return this;
        }

        private List<CertificateOptions> getCertificateValues(String prefix) {
            ArrayList<CertificateOptions> certificates = new ArrayList<CertificateOptions>();
            boolean found = true;
            int idx = 0;
            while (found) {
                String cert = this.environment.getProperty(prefix + "[" + idx + "].cert");
                boolean bl = found = cert != null && !cert.isEmpty();
                if (found) {
                    certificates.add(new CertificateOptions(cert, this.environment.getProperty(prefix + "[" + idx + "].key")));
                }
                ++idx;
            }
            return certificates;
        }

        private List<String> getArrayValues(String prefix, List<String> defaultValue) {
            String single;
            ArrayList<String> values = new ArrayList<String>();
            boolean found = true;
            int idx = 0;
            while (found) {
                String value;
                if (!(found = (value = this.environment.getProperty(prefix + "[" + idx++ + "]")) != null && !value.isEmpty())) continue;
                values.add(value);
            }
            if (values.isEmpty() && (single = this.environment.getProperty(prefix)) != null && !single.isEmpty()) {
                values.add(single);
            }
            if (values.isEmpty() && defaultValue != null) {
                return defaultValue;
            }
            return values;
        }

        public HttpServerConfiguration build() {
            Assert.notNull((Object)this.environment, (String)"Environment can not be null. Call withEnvironment method first to configured it");
            this.port = this.predefinedPort > 0 ? this.predefinedPort : Integer.parseInt(this.environment.getProperty(this.prefix + "port", String.valueOf(this.port)));
            this.host = this.predefinedHost != null ? this.predefinedHost : this.environment.getProperty(this.prefix + "host", this.host);
            this.authenticationType = this.environment.getProperty(this.prefix + "authentication", this.authenticationType);
            this.secured = Boolean.parseBoolean(this.environment.getProperty(this.prefix + "secured", String.valueOf(this.secured)));
            this.alpn = Boolean.parseBoolean(this.environment.getProperty(this.prefix + "alpn", String.valueOf(this.alpn)));
            this.sni = Boolean.parseBoolean(this.environment.getProperty(this.prefix + "ssl.sni", String.valueOf(this.sni)));
            this.openssl = Boolean.parseBoolean(this.environment.getProperty(this.prefix + "ssl.openssl", String.valueOf(this.openssl)));
            this.tlsProtocols = this.environment.getProperty(this.prefix + "ssl.tlsProtocols", this.tlsProtocols);
            this.authorizedTlsCipherSuites = (List)this.environment.getProperty(this.prefix + "ssl.tlsCiphers", List.class, this.authorizedTlsCipherSuites);
            String sClientAuthMode = this.environment.getProperty(this.prefix + "ssl.clientAuth", this.clientAuth.name());
            this.clientAuth = sClientAuthMode.equalsIgnoreCase(Boolean.TRUE.toString()) ? ClientAuth.REQUIRED : (sClientAuthMode.equalsIgnoreCase(Boolean.FALSE.toString()) ? ClientAuth.NONE : ClientAuth.valueOf((String)sClientAuthMode.toUpperCase()));
            this.keyStoreType = this.environment.getProperty(this.prefix + "ssl.keystore.type", this.keyStoreType);
            this.keyStorePath = this.environment.getProperty(this.prefix + "ssl.keystore.path", this.keyStorePath);
            this.keyStoreCertificates = this.getCertificateValues(this.prefix + "ssl.keystore.certificates");
            this.keyStoreKubernetes = this.getArrayValues(this.prefix + "ssl.keystore.kubernetes", this.keyStoreKubernetes);
            this.keyStoreDefaultAlias = this.environment.getProperty(this.prefix + "ssl.keystore.defaultAlias");
            this.keyStorePassword = this.environment.getProperty(this.prefix + "ssl.keystore.password", this.keyStorePassword);
            this.trustStoreType = this.environment.getProperty(this.prefix + "ssl.truststore.type", this.trustStoreType);
            this.trustStorePath = this.environment.getProperty(this.prefix + "ssl.truststore.path", this.trustStorePath);
            this.trustStorePaths = this.getArrayValues(this.prefix + "ssl.truststore.path", this.trustStorePaths);
            this.trustStorePassword = this.environment.getProperty(this.prefix + "ssl.truststore.password", this.trustStorePassword);
            this.compressionSupported = Boolean.parseBoolean(this.environment.getProperty(this.prefix + "compressionSupported", String.valueOf(this.compressionSupported)));
            this.idleTimeout = Integer.parseInt(this.environment.getProperty(this.prefix + "idleTimeout", String.valueOf(this.idleTimeout)));
            this.tcpKeepAlive = Boolean.parseBoolean(this.environment.getProperty(this.prefix + "tcpKeepAlive", String.valueOf(this.tcpKeepAlive)));
            this.maxHeaderSize = Integer.parseInt(this.environment.getProperty(this.prefix + "maxHeaderSize", String.valueOf(this.maxHeaderSize)));
            this.maxChunkSize = Integer.parseInt(this.environment.getProperty(this.prefix + "maxChunkSize", String.valueOf(this.maxChunkSize)));
            this.maxInitialLineLength = Integer.parseInt(this.environment.getProperty(this.prefix + "maxInitialLineLength", String.valueOf(this.maxInitialLineLength)));
            this.maxFormAttributeSize = Integer.parseInt(this.environment.getProperty(this.prefix + "maxFormAttributeSize", String.valueOf(this.maxFormAttributeSize)));
            this.websocketEnabled = Boolean.parseBoolean(this.environment.getProperty(this.prefix + "websocket.enabled", String.valueOf(this.websocketEnabled)));
            this.websocketSubProtocols = this.environment.getProperty(this.prefix + "websocket.subProtocols", this.websocketSubProtocols);
            this.perMessageWebSocketCompressionSupported = Boolean.parseBoolean(this.environment.getProperty(this.prefix + "websocket.perMessageWebSocketCompressionSupported", String.valueOf(this.perMessageWebSocketCompressionSupported)));
            this.perFrameWebSocketCompressionSupported = Boolean.parseBoolean(this.environment.getProperty(this.prefix + "websocket.perFrameWebSocketCompressionSupported", String.valueOf(this.perFrameWebSocketCompressionSupported)));
            this.proxyProtocol = Boolean.parseBoolean(this.environment.getProperty(this.prefix + "haproxy.proxyProtocol", String.valueOf(this.proxyProtocol)));
            this.proxyProtocolTimeout = Long.parseLong(this.environment.getProperty(this.prefix + "haproxy.proxyProtocolTimeout", String.valueOf(this.proxyProtocolTimeout)));
            this.maxWebSocketFrameSize = Integer.parseInt(this.environment.getProperty(this.prefix + "websocket.maxWebSocketFrameSize", String.valueOf(this.maxWebSocketFrameSize)));
            this.maxWebSocketMessageSize = Integer.parseInt(this.environment.getProperty(this.prefix + "websocket.maxWebSocketMessageSize", String.valueOf(this.maxWebSocketMessageSize)));
            return new HttpServerConfiguration(this);
        }
    }
}

