/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.node.secrets.service.resolver;

import io.gravitee.node.api.secrets.model.Secret;
import io.gravitee.node.api.secrets.model.SecretEvent;
import io.gravitee.node.api.secrets.model.SecretURL;
import io.gravitee.node.api.secrets.resolver.WatchablePropertyResolver;
import io.gravitee.node.secrets.service.conf.GraviteeConfigurationSecretResolverDispatcher;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.Maybe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class GraviteeConfigurationSecretPropertyResolver
implements WatchablePropertyResolver<Secret> {
    private static final Logger log = LoggerFactory.getLogger(GraviteeConfigurationSecretPropertyResolver.class);
    @Autowired
    private GraviteeConfigurationSecretResolverDispatcher dispatcher;

    public GraviteeConfigurationSecretPropertyResolver(GraviteeConfigurationSecretResolverDispatcher dispatcher) {
        this.dispatcher = dispatcher;
    }

    public boolean supports(String value) {
        if (value == null) {
            return false;
        }
        return this.dispatcher.canResolveSingleValue(value);
    }

    public Maybe<Secret> resolve(String location) {
        return this.dispatcher.resolveKey(this.dispatcher.toSecretMount(location));
    }

    public boolean isWatchable(String value) {
        return SecretURL.from((String)value).isWatchable();
    }

    public Flowable<Secret> watch(String location) {
        return this.dispatcher.watchKey(this.dispatcher.toSecretMount(location), new SecretEvent.Type[0]);
    }

    public GraviteeConfigurationSecretPropertyResolver() {
    }
}

