/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.node.secrets.service;

import io.gravitee.node.api.secrets.SecretManagerConfiguration;
import io.gravitee.node.api.secrets.SecretProvider;
import io.gravitee.node.api.secrets.SecretProviderDispatcher;
import io.gravitee.node.api.secrets.SecretProviderFactory;
import io.gravitee.node.api.secrets.errors.SecretManagerException;
import io.gravitee.node.api.secrets.errors.SecretProviderNotFoundException;
import io.gravitee.node.api.secrets.model.Secret;
import io.gravitee.node.api.secrets.model.SecretEvent;
import io.gravitee.node.api.secrets.model.SecretMap;
import io.gravitee.node.api.secrets.model.SecretMount;
import io.gravitee.node.api.secrets.model.SecretURL;
import io.gravitee.node.secrets.plugins.SecretProviderPlugin;
import io.gravitee.node.secrets.plugins.SecretProviderPluginManager;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.Maybe;
import io.reactivex.rxjava3.schedulers.Schedulers;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSecretProviderDispatcher
implements SecretProviderDispatcher {
    private static final Logger log = LoggerFactory.getLogger(AbstractSecretProviderDispatcher.class);
    public static final String SECRET_PROVIDER_NOT_FOUND_FOR_ID = "No secret-provider plugin found for provider id: '%s'";
    private final SecretProviderPluginManager secretProviderPluginManager;
    private final Map<String, SecretProvider> secretProviders = new HashMap<String, SecretProvider>();

    protected AbstractSecretProviderDispatcher(SecretProviderPluginManager secretProviderPluginManager) {
        this.secretProviderPluginManager = secretProviderPluginManager;
    }

    protected final void createAndRegister(String id) {
        try {
            SecretProviderPlugin secretProviderPlugin = (SecretProviderPlugin)this.secretProviderPluginManager.get(id);
            Class configurationClass = secretProviderPlugin.configuration();
            SecretProviderFactory factory = this.secretProviderPluginManager.getFactoryById(id);
            if (configurationClass == null || factory == null) {
                throw new SecretProviderNotFoundException(SECRET_PROVIDER_NOT_FOUND_FOR_ID.formatted(id));
            }
            SecretManagerConfiguration config = this.readConfiguration(id, factory.getClass().getClassLoader().loadClass(configurationClass.getName()));
            this.secretProviders.put(id, factory.create(config).start());
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("cannot load plugin %s properly: ".formatted(id));
        }
    }

    public Maybe<SecretMap> resolve(SecretMount secretMount) throws SecretProviderNotFoundException, SecretManagerException {
        return this.secretProviders.getOrDefault(secretMount.provider(), new ErrorSecretProvider()).resolve(secretMount).subscribeOn(Schedulers.io());
    }

    public Maybe<Secret> resolveKey(SecretMount secretMount) throws SecretProviderNotFoundException, SecretManagerException {
        if (secretMount.isKeyEmpty()) {
            return Maybe.error((Throwable)new IllegalArgumentException("cannot request secret key, no key provided"));
        }
        return this.resolve(secretMount).flatMap(secretMap -> Maybe.fromOptional((Optional)secretMap.getSecret(secretMount)));
    }

    public Flowable<SecretMap> watch(SecretMount secretMount, SecretEvent.Type ... events) {
        SecretProvider provider = this.secretProviders.getOrDefault(secretMount.provider(), new ErrorSecretProvider());
        return provider.watch(secretMount).filter(secretEvent -> events == null || events.length == 0 || Arrays.asList(events).contains(secretEvent.type())).subscribeOn(Schedulers.io()).map(SecretEvent::secretMap).doFinally(() -> ((SecretProvider)provider).stop());
    }

    public Flowable<Secret> watchKey(SecretMount secretMount, SecretEvent.Type ... events) {
        if (secretMount.isKeyEmpty()) {
            return Flowable.error((Throwable)new IllegalArgumentException("cannot request secret key, no key provided"));
        }
        return this.watch(secretMount, events).flatMapMaybe(secretMap -> Maybe.fromOptional((Optional)secretMap.getSecret(secretMount)));
    }

    public Optional<SecretProvider> findSecretProvider(String id) {
        return Optional.ofNullable(this.secretProviders.get(id));
    }

    public abstract boolean isEnabled(String var1);

    static class ErrorSecretProvider
    implements SecretProvider {
        ErrorSecretProvider() {
        }

        public Maybe<SecretMap> resolve(SecretMount secretMount) {
            return Maybe.error((Throwable)new SecretProviderNotFoundException(AbstractSecretProviderDispatcher.SECRET_PROVIDER_NOT_FOUND_FOR_ID.formatted(secretMount.provider())));
        }

        public Flowable<SecretEvent> watch(SecretMount secretMount) {
            return Flowable.error((Throwable)new SecretProviderNotFoundException(AbstractSecretProviderDispatcher.SECRET_PROVIDER_NOT_FOUND_FOR_ID.formatted(secretMount.provider())));
        }

        public SecretMount fromURL(SecretURL url) {
            throw new SecretProviderNotFoundException("No secret provider plugin found for url: " + url);
        }
    }
}

