/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.node.secrets.plugins.internal;

import io.gravitee.node.secrets.plugins.SecretProviderPlugin;
import io.gravitee.node.secrets.plugins.internal.DefaultSecretProviderPlugin;
import io.gravitee.node.secrets.plugins.internal.DefaultSecretProviderPluginManager;
import io.gravitee.node.secrets.plugins.internal.SecretManagerConfigurationClassFinder;
import io.gravitee.plugin.core.api.AbstractSimplePluginHandler;
import io.gravitee.plugin.core.api.Plugin;
import java.io.IOException;
import java.net.URLClassLoader;
import org.springframework.beans.factory.annotation.Autowired;

public class SecretProviderPluginHandler
extends AbstractSimplePluginHandler<SecretProviderPlugin<?, ?>> {
    @Autowired
    private DefaultSecretProviderPluginManager secretProviderPluginManager;

    SecretProviderPluginHandler(DefaultSecretProviderPluginManager secretProviderPluginManager) {
        this.secretProviderPluginManager = secretProviderPluginManager;
    }

    public boolean canHandle(Plugin plugin) {
        return "secret-provider".equalsIgnoreCase(plugin.type());
    }

    protected String type() {
        return "secret-provider";
    }

    protected SecretProviderPlugin<?, ?> create(Plugin plugin, Class<?> pluginClass) {
        Class configurationClass = new SecretManagerConfigurationClassFinder().lookupFirst(pluginClass);
        return new DefaultSecretProviderPlugin(plugin, pluginClass, configurationClass);
    }

    protected void register(SecretProviderPlugin<?, ?> secretProviderPlugin) {
        this.secretProviderPluginManager.register(secretProviderPlugin);
        ClassLoader classLoader = secretProviderPlugin.secretProviderFactory().getClassLoader();
        if (classLoader instanceof URLClassLoader) {
            URLClassLoader urlClassLoader = (URLClassLoader)classLoader;
            try {
                urlClassLoader.close();
            }
            catch (IOException e) {
                this.logger.error("Unexpected exception while trying to release the policy classloader");
            }
        }
    }

    protected ClassLoader getClassLoader(Plugin plugin) {
        return new URLClassLoader(plugin.dependencies(), ((Object)((Object)this)).getClass().getClassLoader());
    }

    public SecretProviderPluginHandler() {
    }
}

