/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.node.secrets.plugins.internal;

import io.gravitee.node.api.secrets.SecretProviderFactory;
import io.gravitee.node.secrets.plugins.SecretProviderClassLoaderFactory;
import io.gravitee.node.secrets.plugins.SecretProviderPlugin;
import io.gravitee.node.secrets.plugins.SecretProviderPluginManager;
import io.gravitee.plugin.core.api.AbstractConfigurablePluginManager;
import io.gravitee.plugin.core.api.PluginClassLoader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSecretProviderPluginManager
extends AbstractConfigurablePluginManager<SecretProviderPlugin<?, ?>>
implements SecretProviderPluginManager {
    private static final Logger log = LoggerFactory.getLogger(DefaultSecretProviderPluginManager.class);
    private final SecretProviderClassLoaderFactory classLoaderFactory;
    private final Map<String, SecretProviderFactory> factories = new HashMap<String, SecretProviderFactory>();
    private final Map<String, SecretProviderFactory> notDeployedPluginFactories = new HashMap<String, SecretProviderFactory>();
    private Consumer<String> onNewPluginCallback;

    public DefaultSecretProviderPluginManager(SecretProviderClassLoaderFactory classLoaderFactory) {
        this.classLoaderFactory = classLoaderFactory;
    }

    @Override
    public void setOnNewPluginCallback(Consumer<String> callback) {
        this.onNewPluginCallback = callback;
    }

    public void register(SecretProviderPlugin<?, ?> plugin) {
        super.register(plugin);
        PluginClassLoader pluginClassLoader = this.classLoaderFactory.getOrCreateClassLoader(plugin);
        try {
            Class secretProviderFactoryClass = pluginClassLoader.loadClass(plugin.clazz());
            SecretProviderFactory factory = this.createFactory(secretProviderFactoryClass);
            if (plugin.deployed()) {
                this.factories.put(plugin.id(), factory);
            } else {
                this.notDeployedPluginFactories.put(plugin.id(), factory);
            }
            if (this.onNewPluginCallback != null) {
                this.onNewPluginCallback.accept(plugin.id());
            }
        }
        catch (Exception ex) {
            log.error("Unexpected error while loading secret provider plugin: {}", (Object)plugin.clazz(), (Object)ex);
        }
    }

    private SecretProviderFactory createFactory(Class<SecretProviderFactory> factoryClass) throws InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Constructor<SecretProviderFactory> emptyConstructor = factoryClass.getDeclaredConstructor(new Class[0]);
        return emptyConstructor.newInstance(new Object[0]);
    }

    public SecretProviderFactory getFactoryById(String secretProviderPluginId, boolean includeNotDeployed) {
        SecretProviderFactory factory = this.factories.get(secretProviderPluginId);
        if (factory == null && includeNotDeployed) {
            return this.notDeployedPluginFactories.get(secretProviderPluginId);
        }
        return factory;
    }
}

