/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.node.management.http;

import io.gravitee.common.service.AbstractService;
import io.gravitee.node.management.http.vertx.verticle.ManagementVerticle;
import io.vertx.core.Vertx;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class ManagementService
extends AbstractService<ManagementService> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ManagementService.class);
    @Autowired
    private Vertx vertx;
    private String deploymentId;

    protected void doStart() throws Exception {
        super.doStart();
        this.vertx.deployVerticle("spring:" + ManagementVerticle.class.getName(), event -> {
            if (event.failed()) {
                LOGGER.error("Node Management API service can not be started", event.cause());
            }
            this.deploymentId = (String)event.result();
        });
    }

    protected void doStop() throws Exception {
        super.doStop();
        if (this.deploymentId != null) {
            this.vertx.undeploy(this.deploymentId);
        }
    }

    protected String name() {
        return "Node Management API service";
    }
}

