/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.node.kubernetes.keystoreloader;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.gravitee.common.util.KeyStoreUtils;
import io.gravitee.kubernetes.client.KubernetesClient;
import io.gravitee.kubernetes.client.api.LabelSelector;
import io.gravitee.kubernetes.client.api.ResourceQuery;
import io.gravitee.kubernetes.client.api.WatchQuery;
import io.gravitee.kubernetes.client.config.KubernetesConfig;
import io.gravitee.kubernetes.client.model.v1.ConfigMap;
import io.gravitee.kubernetes.client.model.v1.Event;
import io.gravitee.kubernetes.client.model.v1.Secret;
import io.gravitee.node.api.certificate.KeyStoreLoaderOptions;
import io.gravitee.node.kubernetes.keystoreloader.AbstractKubernetesKeyStoreLoader;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.CompletableSource;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.Maybe;
import io.reactivex.rxjava3.schedulers.Schedulers;
import java.security.KeyStore;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.springframework.util.StringUtils;

public class KubernetesPemRegistryKeyStoreLoader
extends AbstractKubernetesKeyStoreLoader<ConfigMap> {
    public static final String GRAVITEEIO_PEM_REGISTRY_LABEL = "gravitee.io/component";
    private final ObjectMapper objectMapper = new ObjectMapper();

    public KubernetesPemRegistryKeyStoreLoader(KeyStoreLoaderOptions options, KubernetesClient kubernetesClient) {
        super(options, kubernetesClient);
        this.prepareLocations();
    }

    private void prepareLocations() {
        if (this.options.getKeyStoreType().equalsIgnoreCase("KUBERNETES-PEM-REGISTRY")) {
            this.resources.put("KUBERNETES-PEM-REGISTRY", null);
        }
    }

    public static boolean canHandle(KeyStoreLoaderOptions options) {
        return options.getKeyStoreType().equalsIgnoreCase("KUBERNETES-PEM-REGISTRY");
    }

    @Override
    protected Completable init() {
        return Flowable.fromIterable(this.resources.keySet()).flatMapCompletable(location -> {
            if ("KUBERNETES-PEM-REGISTRY".equals(location)) {
                String currentNamespace = KubernetesConfig.getInstance().getCurrentNamespace();
                return this.kubernetesClient.get(ResourceQuery.configMaps((String)currentNamespace).labelSelector(LabelSelector.equals((String)GRAVITEEIO_PEM_REGISTRY_LABEL, (String)"KUBERNETES-PEM-REGISTRY".toLowerCase())).build()).flatMapCompletable(configMapList -> {
                    List items = configMapList.getItems();
                    if (items.isEmpty()) {
                        return Completable.error((Throwable)new RuntimeException("No pem registry found in the current namespace"));
                    }
                    if (items.size() > 1) {
                        return Completable.error((Throwable)new RuntimeException("multiple pem registry is not supported"));
                    }
                    String newLocation = String.format("/%s/configmaps/%s", currentNamespace, ((ConfigMap)items.get(0)).getMetadata().getName());
                    this.resources.put(newLocation, ResourceQuery.from((String)newLocation).build());
                    return this.loadKeyStore((ConfigMap)items.get(0));
                }).doOnComplete(() -> this.resources.remove("KUBERNETES-PEM-REGISTRY"));
            }
            return Completable.error((Throwable)new RuntimeException(String.format("unsupported keystore locations %s", location)));
        }).andThen((CompletableSource)Completable.fromRunnable(this::refreshKeyStoreBundle));
    }

    @Override
    protected Flowable<ConfigMap> watch() {
        return Flowable.fromIterable(this.resources.keySet()).flatMap(location -> this.kubernetesClient.watch(WatchQuery.from((String)location).build()).observeOn(Schedulers.computation()).repeat().retryWhen(errors -> errors.delay(10000L, TimeUnit.MILLISECONDS))).filter(event -> event.getType().equalsIgnoreCase("MODIFIED")).map(Event::getObject);
    }

    @Override
    protected Completable loadKeyStore(ConfigMap configMap) {
        if (this.options.getKeyStoreType().equalsIgnoreCase("KUBERNETES-PEM-REGISTRY")) {
            if (configMap.getMetadata().getLabels() != null && "KUBERNETES-PEM-REGISTRY".equalsIgnoreCase((String)configMap.getMetadata().getLabels().get(GRAVITEEIO_PEM_REGISTRY_LABEL)) && configMap.getData() != null) {
                return this.generateKeystoreFromPemRegistry(configMap);
            }
            this.keyStoresByLocation.put(GRAVITEEIO_PEM_REGISTRY_LABEL, this.initKeyStore());
            return Completable.complete();
        }
        return Completable.error((Throwable)new RuntimeException(String.format("unsupported keystore type %s", this.options.getKeyStoreType())));
    }

    private Completable generateKeystoreFromPemRegistry(ConfigMap configMap) {
        return Flowable.fromIterable(configMap.getData().values()).map(arg_0 -> ((ObjectMapper)this.objectMapper).readTree(arg_0)).filter(JsonNode::isArray).flatMap(Flowable::fromIterable).map(JsonNode::asText).distinct().filter(StringUtils::hasLength).flatMapMaybe(reference -> {
            String[] namespaceName = reference.split("/");
            if (namespaceName.length != 2) {
                return Maybe.error((Throwable)new IllegalArgumentException("Wrong or missing namespace or name of the TLS Secret"));
            }
            return this.kubernetesClient.get(ResourceQuery.secret((String)namespaceName[0], (String)namespaceName[1]).build()).map(this::secretToKeyStore);
        }).toList().map(keyStoreList -> KeyStoreUtils.merge((List)keyStoreList, (String)this.options.getKeyStorePassword())).doOnSuccess(keyStore -> this.keyStoresByLocation.put(GRAVITEEIO_PEM_REGISTRY_LABEL, keyStore)).ignoreElement();
    }

    private KeyStore initKeyStore() {
        try {
            KeyStore keyStore = KeyStore.getInstance("PKCS12");
            keyStore.load(null, KeyStoreUtils.passwordToCharArray((String)this.options.getKeyStorePassword()));
            return keyStore;
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Unable to reset the %s keystore", GRAVITEEIO_PEM_REGISTRY_LABEL), e);
        }
    }

    private KeyStore secretToKeyStore(Secret secret) {
        Map data = secret.getData();
        if (data == null || data.isEmpty()) {
            throw new RuntimeException(String.format("No data has been found in the secret %s", secret.getMetadata().getName()));
        }
        return KeyStoreUtils.initFromPem((String)new String(Base64.getDecoder().decode((String)data.get("tls.crt"))), (String)new String(Base64.getDecoder().decode((String)data.get("tls.key"))), (String)this.options.getKeyStorePassword(), (String)secret.getMetadata().getName());
    }
}

