/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.node.kubernetes.keystoreloader;

import io.gravitee.common.util.KeyStoreUtils;
import io.gravitee.kubernetes.client.KubernetesClient;
import io.gravitee.kubernetes.client.api.ResourceQuery;
import io.gravitee.kubernetes.client.api.WatchQuery;
import io.gravitee.kubernetes.client.model.v1.ConfigMap;
import io.gravitee.kubernetes.client.model.v1.Event;
import io.gravitee.node.api.certificate.KeyStoreLoaderOptions;
import io.gravitee.node.kubernetes.keystoreloader.AbstractKubernetesKeyStoreLoader;
import io.reactivex.Completable;
import io.reactivex.CompletableSource;
import io.reactivex.Flowable;
import io.reactivex.schedulers.Schedulers;
import java.security.KeyStore;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class KubernetesConfigMapKeyStoreLoader
extends AbstractKubernetesKeyStoreLoader<ConfigMap> {
    private static final List<String> SUPPORTED_TYPES = Arrays.asList("JKS".toLowerCase(), "PKCS12".toLowerCase());
    private static final Pattern CONFIGMAP_PATTERN = Pattern.compile("^(.*/configmaps/.*)/.*$");

    public KubernetesConfigMapKeyStoreLoader(KeyStoreLoaderOptions options, KubernetesClient kubernetesClient) {
        super(options, kubernetesClient);
        this.prepareLocations();
    }

    private void prepareLocations() {
        this.options.getKubernetesLocations().forEach(location -> {
            Matcher matcher = CONFIGMAP_PATTERN.matcher((CharSequence)location);
            if (!matcher.matches()) {
                throw new IllegalArgumentException("You must specify a data when using configmap (ex: /my-namespace/configmaps/my-configmap/my-keystore).");
            }
            this.resources.put(matcher.group(1), ResourceQuery.from((String)location).build());
        });
    }

    public static boolean canHandle(KeyStoreLoaderOptions options) {
        List kubernetesLocations = options.getKubernetesLocations();
        return kubernetesLocations != null && !kubernetesLocations.isEmpty() && SUPPORTED_TYPES.contains(options.getKeyStoreType().toLowerCase()) && kubernetesLocations.stream().allMatch(location -> CONFIGMAP_PATTERN.matcher((CharSequence)location).matches());
    }

    @Override
    protected Completable init() {
        List locationObs = this.resources.keySet().stream().map(location -> this.kubernetesClient.get(ResourceQuery.from((String)location).build()).observeOn(Schedulers.computation()).flatMapCompletable(this::loadKeyStore)).collect(Collectors.toList());
        return Completable.merge(locationObs).observeOn(Schedulers.computation()).andThen((CompletableSource)Completable.fromRunnable(this::refreshKeyStoreBundle));
    }

    @Override
    protected Flowable<ConfigMap> watch() {
        List toWatch = this.resources.keySet().stream().map(location -> this.kubernetesClient.watch(WatchQuery.from((String)location).build()).observeOn(Schedulers.computation()).repeat().retryWhen(errors -> errors.delay(10000L, TimeUnit.MILLISECONDS))).collect(Collectors.toList());
        return Flowable.merge(toWatch).filter(event -> event.getType().equalsIgnoreCase("MODIFIED")).map(Event::getObject);
    }

    @Override
    protected Completable loadKeyStore(ConfigMap configMap) {
        Map data;
        Optional<ResourceQuery> optResource = this.resources.values().stream().filter(r -> r.getNamespace().equalsIgnoreCase(configMap.getMetadata().getNamespace()) && r.getResource().equalsIgnoreCase(configMap.getMetadata().getName())).findFirst();
        if (optResource.isEmpty()) {
            return Completable.error((Throwable)new IllegalArgumentException("Unable to load keystore: unknown configmap."));
        }
        Map map = data = configMap.getBinaryData() == null ? configMap.getData() : configMap.getBinaryData();
        if (configMap.getBinaryData() != null) {
            data = configMap.getBinaryData();
        } else if (configMap.getData() != null) {
            data = configMap.getData();
        }
        String dataKey = optResource.get().getResourceKey();
        if (data == null || data.get(dataKey) == null) {
            return Completable.error((Throwable)new IllegalArgumentException(String.format("No data has been found in the configmap for the specified key [%s].", dataKey)));
        }
        KeyStore keyStore = KeyStoreUtils.initFromContent((String)this.options.getKeyStoreType(), (String)((String)data.get(dataKey)), (String)this.options.getKeyStorePassword());
        this.keyStoresByLocation.put(configMap.getMetadata().getUid(), keyStore);
        return Completable.complete();
    }
}

