/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.node.container.spring.env;

import io.gravitee.node.api.secrets.resolver.PropertyResolverFactoriesLoader;
import java.io.IOException;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.YamlPropertiesFactoryBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

@Configuration
public class PropertiesConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(PropertiesConfiguration.class);
    public static final String GRAVITEE_CONFIGURATION = "gravitee.conf";

    @Bean(name={"graviteeProperties"})
    public Properties graviteeProperties() throws IOException {
        LOGGER.info("Loading Gravitee configuration.");
        YamlPropertiesFactoryBean yaml = new YamlPropertiesFactoryBean();
        String yamlConfiguration = System.getProperty(GRAVITEE_CONFIGURATION);
        FileSystemResource yamlResource = new FileSystemResource(yamlConfiguration);
        LOGGER.info("\tGravitee configuration loaded from {}", (Object)yamlResource.getURL().getPath());
        yaml.setResources(new Resource[]{yamlResource});
        Properties properties = yaml.getObject();
        LOGGER.info("Loading Gravitee configuration. DONE");
        return properties;
    }

    @Bean
    public PropertyResolverFactoriesLoader propertyResolverFactoriesLoader() {
        return new PropertyResolverFactoriesLoader();
    }
}

