/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.node.cluster.standalone;

import io.gravitee.node.api.message.Message;
import io.gravitee.node.api.message.MessageConsumer;
import io.gravitee.node.api.message.Topic;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.eventbus.DeliveryOptions;
import io.vertx.core.eventbus.MessageCodec;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;

public class StandaloneTopic<T>
implements Topic<T> {
    private final Vertx vertx;
    private final String topicName;
    Map<UUID, io.vertx.core.eventbus.MessageConsumer<T>> consumerMap = new ConcurrentHashMap<UUID, io.vertx.core.eventbus.MessageConsumer<T>>();
    private static final List<String> messageCodecs = new ArrayList<String>();

    public StandaloneTopic(Vertx vertx, final String topicName) {
        this.vertx = vertx;
        this.topicName = topicName;
        if (!messageCodecs.contains(topicName)) {
            messageCodecs.add(topicName);
            vertx.eventBus().registerCodec(new MessageCodec<T, T>(){

                public void encodeToWire(Buffer buffer, T o) {
                }

                public T decodeFromWire(int pos, Buffer buffer) {
                    return null;
                }

                public T transform(T o) {
                    return o;
                }

                public String name() {
                    return topicName;
                }

                public byte systemCodecID() {
                    return -1;
                }
            });
        }
    }

    public void publish(T event) {
        DeliveryOptions deliveryOptions = new DeliveryOptions();
        deliveryOptions.setCodecName(this.topicName);
        this.vertx.eventBus().publish(this.topicName, event, deliveryOptions);
    }

    public UUID addMessageConsumer(MessageConsumer<T> messageConsumer) {
        UUID uuid = io.gravitee.common.utils.UUID.random();
        io.vertx.core.eventbus.MessageConsumer vertxConsumer = this.vertx.eventBus().consumer(this.topicName);
        this.consumerMap.put(uuid, vertxConsumer);
        vertxConsumer.handler(event -> this.vertx.executeBlocking(promise -> {
            messageConsumer.onMessage(new Message(this.topicName, event.body()));
            promise.handle(null);
        }));
        return uuid;
    }

    public boolean removeMessageConsumer(UUID uuid) {
        if (!this.consumerMap.containsKey(uuid)) {
            return false;
        }
        Future unregister = this.consumerMap.get(uuid).unregister();
        if (unregister.succeeded()) {
            this.consumerMap.remove(uuid);
            return true;
        }
        return false;
    }
}

