/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.node.cluster.spring;

import io.gravitee.node.api.cache.CacheManager;
import io.gravitee.node.api.cluster.ClusterManager;
import io.gravitee.node.api.message.MessageProducer;
import io.gravitee.node.cache.standalone.StandaloneCacheManager;
import io.gravitee.node.cluster.standalone.StandaloneClusterManager;
import io.gravitee.node.cluster.standalone.StandaloneMessageProducer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ConfigurationCondition;
import org.springframework.core.type.AnnotatedTypeMetadata;

@Configuration
@Conditional(value={StandaloneModeEnabled.class})
public class StandaloneClusterConfiguration {
    @Bean(value={"standaloneClusterManager"})
    public ClusterManager standaloneClusterManager() {
        return new StandaloneClusterManager();
    }

    @Bean(value={"standaloneCacheManager"})
    public CacheManager standaloneCacheManager() {
        return new StandaloneCacheManager();
    }

    @Bean(value={"standaloneMessageProducer"})
    public MessageProducer standaloneMessageProducer() {
        return new StandaloneMessageProducer();
    }

    public static class StandaloneModeEnabled
    implements ConfigurationCondition {
        public boolean matches(ConditionContext conditionContext, AnnotatedTypeMetadata annotatedTypeMetadata) {
            return (Boolean)conditionContext.getEnvironment().getProperty("gravitee.cluster.enabled", Boolean.class, (Object)false) == false;
        }

        public ConfigurationCondition.ConfigurationPhase getConfigurationPhase() {
            return ConfigurationCondition.ConfigurationPhase.REGISTER_BEAN;
        }
    }
}

