/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.node.cluster.hazelcast;

import com.hazelcast.cluster.MembershipEvent;
import com.hazelcast.cluster.MembershipListener;
import com.hazelcast.core.HazelcastInstance;
import io.gravitee.node.api.cluster.ClusterManager;
import io.gravitee.node.api.cluster.Member;
import io.gravitee.node.api.cluster.MemberListener;
import io.gravitee.node.cluster.member.NodeMember;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;

public class HazelcastClusterManager
implements InitializingBean,
ClusterManager,
MembershipListener {
    private final Logger LOGGER = LoggerFactory.getLogger(HazelcastClusterManager.class);
    @Autowired
    private HazelcastInstance hazelcastInstance;
    private final Set<MemberListener> memberListeners = new HashSet<MemberListener>();

    public void afterPropertiesSet() throws Exception {
        this.hazelcastInstance.getCluster().addMembershipListener((MembershipListener)this);
    }

    private boolean isMaster(com.hazelcast.cluster.Member member) {
        com.hazelcast.cluster.Member master = (com.hazelcast.cluster.Member)this.hazelcastInstance.getCluster().getMembers().iterator().next();
        return member.equals(master);
    }

    public Collection<Member> getMembers() {
        return this.hazelcastInstance.getCluster().getMembers().stream().map(new Function<com.hazelcast.cluster.Member, Member>(){

            @Override
            public Member apply(com.hazelcast.cluster.Member member) {
                return new NodeMember(member, HazelcastClusterManager.this.isMaster(member));
            }
        }).collect(Collectors.toSet());
    }

    public Member getLocalMember() {
        return new NodeMember(this.hazelcastInstance.getCluster().getLocalMember(), this.isMaster(this.hazelcastInstance.getCluster().getLocalMember()));
    }

    public boolean isMasterNode() {
        return this.isMaster(this.hazelcastInstance.getCluster().getLocalMember());
    }

    public void addMemberListener(MemberListener listener) {
        this.memberListeners.add(listener);
    }

    public void stop() {
        this.hazelcastInstance.shutdown();
    }

    public void memberAdded(MembershipEvent event) {
        this.LOGGER.info("A node join the cluster: {}", (Object)event);
        com.hazelcast.cluster.Member master = (com.hazelcast.cluster.Member)this.hazelcastInstance.getCluster().getMembers().iterator().next();
        NodeMember newMember = new NodeMember(event.getMember(), master.equals(event.getMember()));
        this.memberListeners.forEach(listener -> listener.memberAdded(newMember));
    }

    public void memberRemoved(MembershipEvent event) {
        this.LOGGER.info("A node leave the cluster: {}", (Object)event);
        com.hazelcast.cluster.Member master = (com.hazelcast.cluster.Member)this.hazelcastInstance.getCluster().getMembers().iterator().next();
        NodeMember newMember = new NodeMember(event.getMember(), master.equals(event.getMember()));
        this.memberListeners.forEach(listener -> listener.memberRemoved(newMember));
    }
}

