/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.node.plugin.cluster.standalone.messaging;

import io.gravitee.common.utils.UUID;
import io.gravitee.node.api.cluster.messaging.Message;
import io.gravitee.node.api.cluster.messaging.MessageListener;
import io.gravitee.node.api.cluster.messaging.Topic;
import io.vertx.core.Vertx;
import io.vertx.core.eventbus.DeliveryOptions;
import io.vertx.core.eventbus.MessageConsumer;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class StandaloneTopic<T>
implements Topic<T> {
    private final Map<String, MessageConsumer<T>> consumerMap = new ConcurrentHashMap<String, MessageConsumer<T>>();
    private final Vertx vertx;
    private final String topicName;
    private final DeliveryOptions deliveryOptions;

    public StandaloneTopic(Vertx vertx, String topicName) {
        this.vertx = vertx;
        this.topicName = topicName;
        this.deliveryOptions = new DeliveryOptions().setCodecName("standalone-codec");
    }

    public void publish(T event) {
        this.vertx.eventBus().publish(this.topicName, event, this.deliveryOptions);
    }

    public String addMessageListener(MessageListener<T> messageListener) {
        String subscriptionId = UUID.random().toString();
        MessageConsumer vertxConsumer = this.vertx.eventBus().localConsumer(this.topicName).handler(event -> this.vertx.executeBlocking(promise -> {
            messageListener.onMessage(new Message(this.topicName, event.body()));
            promise.handle(null);
        }));
        this.consumerMap.put(subscriptionId, vertxConsumer);
        return subscriptionId;
    }

    public boolean removeMessageListener(String subscriptionId) {
        if (this.consumerMap.containsKey(subscriptionId)) {
            return this.consumerMap.get(subscriptionId).unregister().onSuccess(event -> this.consumerMap.remove(subscriptionId)).succeeded();
        }
        return false;
    }
}

