/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.node.certificates;

import io.gravitee.common.util.KeyStoreUtils;
import io.gravitee.node.api.certificate.KeyStoreBundle;
import io.gravitee.node.api.certificate.KeyStoreLoader;
import io.gravitee.node.api.certificate.KeyStoreLoaderOptions;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelfSignedKeyStoreLoader
implements KeyStoreLoader {
    private static final Logger logger = LoggerFactory.getLogger(SelfSignedKeyStoreLoader.class);
    private final List<Consumer<KeyStoreBundle>> listeners;
    private final KeyStoreLoaderOptions options;
    private KeyStoreBundle keyStoreBundle;

    public SelfSignedKeyStoreLoader(KeyStoreLoaderOptions options) {
        this.options = options;
        this.listeners = new ArrayList<Consumer<KeyStoreBundle>>();
    }

    public void start() {
        logger.debug("Initializing self-signed keystore certificate.");
        String password = UUID.randomUUID().toString();
        KeyStore keyStore = KeyStoreUtils.initSelfSigned((String)"localhost", (String)password);
        this.keyStoreBundle = new KeyStoreBundle(keyStore, password, this.options.getDefaultAlias());
        this.notifyListeners();
    }

    public void stop() {
    }

    public void addListener(Consumer<KeyStoreBundle> listener) {
        this.listeners.add(listener);
    }

    private void notifyListeners() {
        this.listeners.forEach(consumer -> consumer.accept(this.keyStoreBundle));
    }
}

