/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.node.cache.plugin;

import io.gravitee.node.api.cache.CacheManager;
import io.gravitee.node.api.configuration.Configuration;
import io.gravitee.plugin.core.api.AbstractPluginHandler;
import io.gravitee.plugin.core.api.Plugin;
import io.gravitee.plugin.core.api.PluginClassLoaderFactory;
import io.gravitee.plugin.core.api.PluginContextFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;

public class CachePluginHandler
extends AbstractPluginHandler {
    private static final Logger log = LoggerFactory.getLogger(CachePluginHandler.class);
    private static final String PLUGIN_TYPE = "cache";
    @Autowired
    private PluginContextFactory pluginContextFactory;
    @Autowired
    private PluginClassLoaderFactory<Plugin> pluginClassLoaderFactory;
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private Configuration configuration;

    public boolean canHandle(Plugin plugin) {
        return plugin.type().equalsIgnoreCase(this.type());
    }

    protected String type() {
        return PLUGIN_TYPE;
    }

    protected void handle(Plugin plugin, Class<?> pluginClass) {
        try {
            if (this.isConfiguredCachePlugin(plugin.id())) {
                ApplicationContext context = this.pluginContextFactory.create(plugin);
                CacheManager cacheManager = (CacheManager)context.getBean(pluginClass);
                DefaultListableBeanFactory beanFactory = (DefaultListableBeanFactory)((ConfigurableApplicationContext)this.applicationContext).getBeanFactory();
                beanFactory.registerSingleton(CacheManager.class.getName(), (Object)cacheManager);
                log.info("Cache manager plugin '{}' installed.", (Object)plugin.id());
            } else {
                log.warn("Cache manager plugin '{}' is not the type configured and won't be installed.", (Object)plugin.id());
            }
        }
        catch (Exception e) {
            this.logger.error("Unexpected error while registering cache manager {}", (Object)plugin.id(), (Object)e);
            this.pluginContextFactory.remove(plugin);
        }
    }

    private boolean isConfiguredCachePlugin(String clusterPluginId) {
        String configuredClusterType = this.configuration.getProperty("cache.type", "standalone");
        String prefixedType = "cache-" + configuredClusterType;
        return configuredClusterType.equals(clusterPluginId) || prefixedType.equals(clusterPluginId);
    }

    protected ClassLoader getClassLoader(Plugin plugin) {
        return this.pluginClassLoaderFactory.getOrCreateClassLoader(plugin, ((Object)((Object)this)).getClass().getClassLoader());
    }
}

