/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.node.cache;

import io.gravitee.common.service.AbstractService;
import io.gravitee.node.api.Node;
import io.gravitee.node.api.cache.CacheManager;
import io.gravitee.node.cache.NoCacheManagerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;

public class NodeCacheService
extends AbstractService<NodeCacheService> {
    private static final Logger log = LoggerFactory.getLogger(NodeCacheService.class);
    @Autowired
    private Node node;
    @Autowired
    @Lazy
    private CacheManager cacheManager;

    public void doStart() throws Exception {
        super.doStart();
        try {
            this.cacheManager.start();
        }
        catch (NoSuchBeanDefinitionException e) {
            log.error("No Cache manager has been registered.");
            throw new NoCacheManagerException();
        }
    }

    protected void doStop() throws Exception {
        super.doStop();
        if (this.cacheManager != null) {
            this.cacheManager.stop();
        }
    }
}

