/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.node.api.secrets.model;

import com.google.common.base.Splitter;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import io.gravitee.node.api.secrets.model.SecretMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public record SecretURL(String provider, String path, String key, Multimap<String, String> query) {
    public static final char URL_SEPARATOR = '/';
    private static final Splitter urlPathSplitter = Splitter.on((char)'/');
    private static final Splitter queryParamSplitter = Splitter.on((char)'&');
    private static final Splitter queryParamKeyValueSplitter = Splitter.on((char)'=');
    private static final Splitter keyMapParamValueSplitter = Splitter.on((char)':');
    public static final String SCHEME = "secret://";

    public static SecretURL from(String url) {
        String key;
        Multimap<String, String> query;
        String path;
        String schemeLess;
        int firstSlash;
        if (!(url = Objects.requireNonNull(url).trim()).startsWith(SCHEME)) {
            SecretURL.throwFormatError(url);
        }
        if ((firstSlash = (schemeLess = url.substring(SCHEME.length())).indexOf(47)) < 0 || firstSlash == schemeLess.length() - 1) {
            SecretURL.throwFormatError(url);
        }
        String provider = schemeLess.substring(0, firstSlash).trim();
        int questionMarkPos = schemeLess.indexOf(63);
        if (questionMarkPos == firstSlash + 1) {
            SecretURL.throwFormatError(url);
        }
        if (questionMarkPos > 0) {
            path = schemeLess.substring(provider.length() + 1, questionMarkPos).trim();
            query = SecretURL.parseQuery(schemeLess.substring(questionMarkPos + 1));
        } else {
            path = schemeLess.substring(provider.length() + 1).trim();
            query = MultimapBuilder.hashKeys().arrayListValues().build();
        }
        int columnIndex = path.lastIndexOf(58);
        if (columnIndex > path.lastIndexOf(47)) {
            key = path.substring(columnIndex + 1);
            path = path.substring(0, columnIndex);
        } else {
            key = null;
        }
        while (!path.isEmpty() && path.charAt(path.length() - 1) == '/') {
            path = path.substring(0, path.length() - 1);
        }
        if (path.isBlank()) {
            SecretURL.throwFormatError(url);
        }
        if (urlPathSplitter.splitToList((CharSequence)path).stream().anyMatch(String::isBlank)) {
            SecretURL.throwFormatError(url);
        }
        return new SecretURL(provider, path, key, query);
    }

    private static void throwFormatError(String url) {
        throw new IllegalArgumentException("Secret URL '%s' should have the following format %s<provider>/<path or name>[:<key>][?option=value1&option=value2]".formatted(url, SCHEME));
    }

    private static Multimap<String, String> parseQuery(String substring) {
        ListMultimap query = MultimapBuilder.hashKeys().arrayListValues().build();
        queryParamSplitter.split((CharSequence)substring).forEach(arg_0 -> SecretURL.lambda$parseQuery$0((Multimap)query, arg_0));
        return query;
    }

    public boolean isWatchable() {
        return this.query().entries().stream().anyMatch(e -> Objects.equals(e.getKey(), "watch") && Boolean.parseBoolean((String)e.getValue()));
    }

    public Map<String, SecretMap.WellKnownSecretKey> wellKnowKeyMap() {
        record Mapping(String secretKey, SecretMap.WellKnownSecretKey wellKnow) {
        }
        return this.query().get((Object)"keymap").stream().map(keyMap -> {
            List mapping = keyMapParamValueSplitter.splitToList((CharSequence)keyMap);
            if (mapping.size() == 2) {
                String wellKnown = ((String)mapping.get(0)).trim().toUpperCase();
                String secretKey = ((String)mapping.get(1)).trim();
                if (wellKnown.isEmpty() || secretKey.isEmpty()) {
                    throw new IllegalArgumentException("keymap '%s' is not valid".formatted(keyMap));
                }
                try {
                    return new Mapping(secretKey, SecretMap.WellKnownSecretKey.valueOf(wellKnown));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            return new Mapping(null, null);
        }).filter(mapping -> mapping.wellKnow() != null).collect(Collectors.toMap(Mapping::secretKey, Mapping::wellKnow));
    }

    private static /* synthetic */ void lambda$parseQuery$0(Multimap query, String pair) {
        Iterable parts = queryParamKeyValueSplitter.split((CharSequence)pair);
        Iterator iterator = parts.iterator();
        if (iterator.hasNext()) {
            String key = (String)iterator.next();
            if (iterator.hasNext()) {
                query.put((Object)key, (Object)((String)iterator.next()));
            } else {
                query.put((Object)key, (Object)"true");
            }
        }
    }

    public static class WellKnownQueryParam {
        public static final String WATCH = "watch";
        public static final String KEYMAP = "keymap";
        public static final String NAMESPACE = "namespace";

        private WellKnownQueryParam() {
        }
    }
}

